/* ============================================================================================================
	Name of file: 	FL workforce Clean.do
	
	Author: 		Adam Leive - leive@wharton.upenn.edu
					Michael Richards - michael.r.richards@vanderbilt.edu
					Sebastian Tello - daniel.s.tello@vanderbilt.edu				
					
	Project: 		Unamed Florida Project
	
	Introduction:	This file will clean NIS Data 
	
	Last Edited: 	- TTA 12/18/2015 11:19 AM
	
	Files Used:		Raw data from FL Workforce		
				
	Files Created:  		
	
	============================================================================================================ */
	set more off 
	* ======================================================
					* Calling the directory.
	* ======================================================
	 di "Enter user name: adam,michael,sebastian, tello"
	 di "Enter word: " _request(user)

	while ("$user" != "adam" & "$user" != "michael" & "$user" != "sebastian" & "$user" != "tello")  {

	display ">>>>Not an acceptable responde. Please Try again<<<<"
	di "Enter user name: adam,michael,sebastian"
	di "Enter word: " _request(user)

}

	else {

	if "$user" == "adam" {
	do ".../Dropbox/Florida Project/Dofiles/FL Directory.do"
	}
	
	if "$user" == "michael" {
	do "~/Dropbox/Vanderbilt/Research/Florida Project/Dofiles/FL Directory.do"
	}
	
	if "$user" == "sebastian" {
	do "C:/Users/Daniel/Dropbox/Florida Project/Dofiles/FL Directory.do"
	}
	
	if "$user" == "tello" {
	do "D:/Dropbox/Florida Project/Dofiles/FL Directory.do"
	}
	
	}
	

	* ======================================================
					* Activate Helpful Programs
	* ======================================================
	* I get really lazy with typing up the labels, so this program helps me with that so I just have to copypast
	cap program drop qlabel
	program define qlabel
		args string
		tempfile temp1
		save `temp1'
		keep if v4=="`string'"
		duplicates drop v7, force
		cap destring v7, replace
		sort v7
		list v7 v8, clean noob
		clear
		use `temp1'
	end

	
	* Importing Data
	
	forvalues year=2006/2015 {
	clear
	
	capture  insheet using WKFRC-`year'//addr.wkfrc-`year'.dat, delimiter("|")
	ren v1 docid1 
	ren v2 docid2
	ren v3 mlplvaraddre
	ren v4 addr1
	ren v5 addr2
	ren v6 city
	ren v7 state
	ren v8 zip
	ren v9 county
	drop v*
	gen year=`year'
	order doc* year
	save WKFRC-`year'//addr.wkfrc-`year'.dta, replace
	save "$wkfrc/WKFRC-`year'//addr.wkfrc-`year'.dta", replace
	clear
	
	capture  insheet using WKFRC-`year'//certifications.wkfrc-`year'.dat, delimiter("|")
	ren v1 docid1
	ren v2 docid2
	ren v3 specialty
	ren v4 specboard
	drop v*
	gen year=`year'
	order doc* year
	save WKFRC-`year'//certifications.wkfrc-`year'.dta, replace
	save "$wkfrc/WKFRC-`year'//certifications.wkfrc-`year'.dta", replace
	clear
	
	capture  insheet using WKFRC-`year'//education_hist.wkfrc-`year'.dat, delimiter("|")
	ren v1 docid1 
	ren v2 docid2
	ren v3 college
	ren v4 dateed1
	ren v5 degree
	ren v6 dateed2
	ren v7 dateed3
	drop v*
	gen year=`year'
	order doc* year
	save WKFRC-`year'//education_hist.wkfrc-`year'.dta, replace
	save "$wkfrc/WKFRC-`year'//education_hist.wkfrc-`year'.dta", replace
	clear
	
	capture  insheet using WKFRC-`year'//lic.wkfrc-`year'.dat, delimiter("|")
	ren v1 docid1
	ren v2 docid2
	ren v3 licnum
	*ren v4 status
	*ren v5 active
	ren v6 doctype
	ren v7 lic_enddate
	ren v8 sex
	ren v9 dob
	*ren v10 ??
	ren v11 lic_issuedate
	*ren v12 ??
	*ren v13 ??
	drop v*
	gen year=`year'
	order doc* year
	save WKFRC-`year'//lic.wkfrc-`year'.dta, replace
	save "$wkfrc/WKFRC-`year'//lic.wkfrc-`year'.dta", replace
	clear
	
	capture  insheet using WKFRC-`year'//residency_info.wkfrc-`year'.dat, delimiter("|")
	ren v1 docid1
	ren v2 docid2
	ren v3 residpt
	ren v4 resicity	
	ren v5 resistate
	ren v6 resstart
	ren v7 resend
	ren v8 reshospital
	ren v9 restype
	gen year=`year'
	order doc* year
	capture ren v10 resaddinfo
	drop v*
	save WKFRC-`year'//residency_info.wkfrc-`year'.dta, replace
	save "$wkfrc/WKFRC-`year'//residency_info.wkfrc-`year'.dta", replace
	clear
	
	capture insheet using WKFRC-`year'//survey.wkfrc-`year'.dat, delimiter("|")
	capture save WKFRC-`year'//survey.wkfrc-`year'.dta, replace
	clear
	}


* ==============2006 Survey file======================
* ==============2006 Survey file======================
* ==============2006 Survey file======================

use WKFRC-2006/survey.wkfrc-2006.dta, clear
* Q1
bys v1 v2: gen workinfl=v7 if v3=="Q1"
replace workinfl="1" if workinfl=="A"
replace workinfl="0" if workinfl=="B"
destring workinfl, replace
label define yesno 1 "Yes" 0 "No"
label values workinfl yesno


* Q2
bys v1 v2: gen howmanymonths=v7 if v3=="Q2"

replace howmanymonths="0" if howmanymonths=="A"
replace howmanymonths="1" if howmanymonths=="B"
replace howmanymonths="2" if howmanymonths=="C"
destring howmanymonths, replace
label define q2 0 "1-4 Months" 1 "5-8 Months" 2 "9-12 Months"
label values howmanymonths q2

* Q3

bys v1 v2 v6: gen counties=v7 if v4=="Q3-Resp-Cnty"
destring counties, replace
bys v1 v2 v6: egen countiesx=max(counties)

label define countyfl ///
11 "Alachua" ///
12 "Baker" ///
13 "Bay" ///
14 "Bradford" ///
15 "Brevard" ///
16 "Broward" ///
17 "Calhoun" ///
18 "Charlotte" ///
19 "Citrus" ///
20 "Clay" ///
21 "Collier" ///
22 "Columbia" ///
23 "Dade" ///
24 "Desoto" ///
25 "Dixie" ///
26 "Duval" ///
27 "Escambia" ///
28 "Flagler" ///
29 "Franklin" ///
30 "Gadsden" ///
31 "Gilchrist" ///
32 "Glades" ///
33 "Gulf" ///
34 "Halmiton" ///
35 "Hardee" ///
36 "Hendry" ///
37 "Hernando" ///
38 "Highlands" ///
39 "Hillsborough" ///
40 "Holmes" /// 
41 "Indian River"   ///
42 "Jackson" ///
43 "Jefferson" ///
44 "LaFayette" ///
45 "Lake" ///
46 "Lee" ///
47 "Leon" ///
48 "Levy" ///
49 "Liberty" ///
50 "Madison" ///
51 "Manatee" ///
52 "Marion" ///
53 "Martin" /// 
54 "Monroe" ///
55 "Nassau" ///
56 "Okaloosa" ///
57 "Okeechobee" ///
58 "Orange" ///
59 "Osceola" ///
60 "Palm Beach" ///
61 "Pasco" ///
62 "Pinellas" ///
63 "Polk" ///
64 "Putnam" ///
65 "St. Johns" ///
66 "St. Lucie" ///
67 "Santa Rosa" ///
68 "Sarasota" ///
69 "Seminole" ///
70 "Sumter" ///
71 "Suwannee" ///
72 "Taylor" ///
73 "Union" ///
74 "Volusia" ///
75 "Wakulla" ///
76 "Walton" ///
77 "Washington" ///
78 "Unkonwn" ///
79 "Out of State" ///
80 "Foregin"
label values countiesx countyfl
  
bys v1 v2 v6: gen hoursincty=v7 if v4=="Q3-Resp-Hours"
destring hoursincty, replace
bys v1 v2 v6: egen hoursinctyx=max(hoursincty)
drop counties hoursincty
label define q31 1 "1-20 Hrs/Wk" 2 "21-40 Hrs/Wk" 3 "More than 40 Hrs/Wk"
label values hoursincty q31

* Q4
bys v1 v2: gen morethan20=v7 if v3=="Q4"
replace morethan20="1" if morethan20=="A"
replace morethan20="0" if morethan20=="B"
destring morethan20, replace
label values morethan20 yesno

*Q5
bys v1 v2: gen resfellow=v7 if v3=="Q5"
replace resfellow="1" if resfellow=="A"
replace resfellow="0" if resfellow=="B"
destring resfellow, replace
label values resfellow yesno

* Q6


bys v1 v2 v6: gen specialty=v7 if v4=="Q6-Resp-Spec"
destring specialty, replace
bys v1 v2 v6: egen specialtyx=max(specialty)
drop specialty

bys v1 v2 v6: gen specialtypct=v7 if v4=="Q6-Resp-Pct"
destring specialtypct, replace
bys v1 v2 v6: egen specialtypctx=max(specialtypct)
label define q72 1 "1-20%" 2 "21-40%" 3 "41-60%" 4 "61-80%" 5 "81-100%"
label values specialtypctx q72
drop specialtypct

* Q7
bys v1 v2: gen retireish=v7 if v3=="Q7"
replace retireish="1" if retireish=="A"
replace retireish="0" if retireish=="B"
destring retireish, replace
label values retireish yesno

* Q8
bys v1 v2: gen takeERcalls=v7 if v3=="Q8"
replace takeERcalls="1" if takeERcalls=="A"
replace takeERcalls="0" if takeERcalls=="B"
destring takeERcalls, replace
label values takeERcalls yesno

duplicates drop v1 v2 v3 v6, force
keep v1 v2 v3 v4 v6 workinfl - takeERcalls
tempfile temp1
save `temp1'

keep v1 v2 countiesx hoursinctyx
drop if countiesx==.
duplicates drop v1 v2 countiesx, force
bys v1 v2: gen h=_n
reshape wide countiesx hoursinctyx, i(v1 v2) j(h)
tempfile  temp2
save `temp2'

use `temp1'
keep v1 v2  specialtyx  specialtypctx
drop if specialtyx==.
duplicates drop v1 v2 specialtyx, force
bys v1 v2: gen h=_n
reshape wide specialtyx specialtypctx, i(v1 v2) j(h)
tempfile  temp3
save `temp3'

use `temp1'
drop countiesx  hoursinctyx specialtyx  specialtypctx

	* pick up labels before collapse
	foreach v of var * {
		local l`v' : variable label `v'
		if `"`l`v''"' == "" {
 		local l`v' "`v'"
		}
	}

*"

collapse workinfl - takeERcalls, by(v1 v2)

* lay down labels after collapse
foreach v of var * {
	label var `v' "`l`v''"
}



label values retireish yesno
label values takeERcalls yesno
label values resfellow yesno
label values morethan20 yesno
label values howmanymonths q2
label values workinfl yesno

merge 1:1 v1 v2 using `temp2'
drop _merge
merge 1:1 v1 v2 using `temp3'
drop _merge
label values hoursinctyx1 q31
label values countiesx1 countyfl
label values hoursinctyx2 q31
label values countiesx2 countyfl
label values hoursinctyx3 q31
label values countiesx3 countyfl
label values hoursinctyx4 q31
label values countiesx4 countyfl
label values hoursinctyx5 q31
label values countiesx5 countyfl
label values specialtypctx1 q72
label values specialtypctx2 q72
label values specialtypctx3 q72
label values specialtypctx4 q72
label values specialtypctx5 q72
ren v1 docid1 
ren v2 docid2
gen year=2006
order doc* year


save "$wkfrc/WKFRC-2006/survey.wkfrc-2006clean.dta", replace


* =============  2008 Survey file================
* =============  2008 Survey file================
* =============  2008 Survey file================

use WKFRC-2008/survey.wkfrc-2008.dta, clear

* Q1
bys v1 v2: gen workinfl=v7 if v3=="Q1"
replace workinfl="1" if workinfl=="A"
replace workinfl="0" if workinfl=="B"
destring workinfl, replace
label define yesno 1 "Yes" 0 "No"
label values workinfl yesno


* Q2
bys v1 v2: gen howmanymonths=v7 if v3=="Q2"

replace howmanymonths="0" if howmanymonths=="A"
replace howmanymonths="1" if howmanymonths=="B"
replace howmanymonths="2" if howmanymonths=="C"
destring howmanymonths, replace
label define q2 0 "1-4 Months" 1 "5-8 Months" 2 "9-12 Months"
label values howmanymonths q2


* Q3

bys v1 v2 v6: gen counties=v7 if v4=="Q3-Resp-Cnty"
destring counties, replace
bys v1 v2 v6: egen countiesx=max(counties)

label define countyfl ///
11 "Alachua" ///
12 "Baker" ///
13 "Bay" ///
14 "Bradford" ///
15 "Brevard" ///
16 "Broward" ///
17 "Calhoun" ///
18 "Charlotte" ///
19 "Citrus" ///
20 "Clay" ///
21 "Collier" ///
22 "Columbia" ///
23 "Dade" ///
24 "Desoto" ///
25 "Dixie" ///
26 "Duval" ///
27 "Escambia" ///
28 "Flagler" ///
29 "Franklin" ///
30 "Gadsden" ///
31 "Gilchrist" ///
32 "Glades" ///
33 "Gulf" ///
34 "Halmiton" ///
35 "Hardee" ///
36 "Hendry" ///
37 "Hernando" ///
38 "Highlands" ///
39 "Hillsborough" ///
40 "Holmes" /// 
41 "Indian River"   ///
42 "Jackson" ///
43 "Jefferson" ///
44 "LaFayette" ///
45 "Lake" ///
46 "Lee" ///
47 "Leon" ///
48 "Levy" ///
49 "Liberty" ///
50 "Madison" ///
51 "Manatee" ///
52 "Marion" ///
53 "Martin" /// 
54 "Monroe" ///
55 "Nassau" ///
56 "Okaloosa" ///
57 "Okeechobee" ///
58 "Orange" ///
59 "Osceola" ///
60 "Palm Beach" ///
61 "Pasco" ///
62 "Pinellas" ///
63 "Polk" ///
64 "Putnam" ///
65 "St. Johns" ///
66 "St. Lucie" ///
67 "Santa Rosa" ///
68 "Sarasota" ///
69 "Seminole" ///
70 "Sumter" ///
71 "Suwannee" ///
72 "Taylor" ///
73 "Union" ///
74 "Volusia" ///
75 "Wakulla" ///
76 "Walton" ///
77 "Washington" ///
78 "Unkonwn" ///
79 "Out of State" ///
80 "Foregin"
label values countiesx countyfl
  
bys v1 v2 v6: gen hoursincty=v7 if v4=="Q3-Resp-Hours"
destring hoursincty, replace
bys v1 v2 v6: egen hoursinctyx=max(hoursincty)
drop counties hoursincty
label define q31 1 "1-20 Hrs/Wk" 2 "21-40 Hrs/Wk" 3 "More than 40 Hrs/Wk"
label values hoursincty q31

* Q4
bys v1 v2: gen solopractice=v7 if v3=="Q4"
replace solopractice="1" if solopractice=="A"
replace solopractice="0" if solopractice=="B"
destring solopractice, replace
label values solopractice yesno

* Q5
bys v1 v2: gen mainpractice=v7 if v3=="Q5"
replace mainpractice="1" if mainpractice=="A"
replace mainpractice="2" if mainpractice=="B"
replace mainpractice="3" if mainpractice=="C"
replace mainpractice="4" if mainpractice=="D"
replace mainpractice="5" if mainpractice=="E"
replace mainpractice="6" if mainpractice=="F"
replace mainpractice="7" if mainpractice=="G"
replace mainpractice="8" if mainpractice=="H"
replace mainpractice="9" if mainpractice=="I"
replace mainpractice="10" if mainpractice=="J"
replace mainpractice="11" if mainpractice=="K"
destring mainpractice, replace
label define q52008 ///
 1 "Private Office Setting" ///
 2 "Federaly Qualified Health Center" ///
 3 "Governmental Clinical Setting" ///
 4 "Federal Healthcare Facilty" ///
 5 "Hospital-Outpatient Department/Service" ///
 6 "Hospital-Inpatient" ///
 7 "Hospital Emergency Department" ///
 8 "Hospital Other" ///
 9 "Nursing Home/Extended Care Facility" ///
 10 "Ambulatory Surgery Center" ///
 11 "Other Setting"
 label values mainpractice q52008 
 
 * Q6
bys v1 v2: gen resfellow=v7 if v3=="Q6"
replace resfellow="1" if resfellow=="A"
replace resfellow="0" if resfellow=="B"
destring resfellow, replace
label values resfellow yesno

* Q7
bys v1 v2: gen morethan20=v7 if v3=="Q7"
replace morethan20="1" if morethan20=="A"
replace morethan20="0" if morethan20=="B"
destring morethan20, replace
label values morethan20 yesno

* Q8
bys v1 v2 v6: gen specialty=v7 if v4=="Q8-Resp-Spec"
destring specialty, replace
bys v1 v2 v6: egen specialtyx=max(specialty)
drop specialty

bys v1 v2 v6: gen specialtypct=v7 if v4=="Q8-Resp-Pct"
destring specialtypct, replace
bys v1 v2 v6: egen specialtypctx=max(specialtypct)
label define q72 1 "1-20%" 2 "21-40%" 3 "41-60%" 4 "61-80%" 5 "81-100%"
label values specialtypctx q72
drop specialtypct

* Q9
bys v1 v2: gen retireish=v7 if v3=="Q9"
replace retireish="1" if retireish=="A"
replace retireish="0" if retireish=="B"
destring retireish, replace
label values retireish yesno

* Q10
bys v1 v2: gen changescope=v7 if v3=="Q10"
replace changescope="1" if changescope=="A"
replace changescope="2" if changescope=="B"
replace changescope="3" if changescope=="C"
replace changescope="4" if changescope=="D"
replace changescope="5" if changescope=="E"
replace changescope="6" if changescope=="F"
destring changescope, replace
label define q102008 ///
1 "Liability" ///
2 "Rimbursement" ///
3 "Regulatory and Administrative Burden" /// 
4 "Retirement" ///
5 "Lifestyle Considerations, Other than Retirement" ///
6 "Other"

* Q11
bys v1 v2: gen takeERcalls=v7 if v3=="Q11"
replace takeERcalls="1" if takeERcalls=="A"
replace takeERcalls="0" if takeERcalls=="B"
replace takeERcalls="2" if takeERcalls=="C"
destring takeERcalls, replace
label define takeERcalls 1 "Yes" 0 "No" 2 "Exempt Due to Medical Staff Bylaws."
label values takeERcalls takeERcalls


* Q12
bys v1 v2: gen ERcalls2=v7 if v3=="Q12"
replace ERcalls2="1" if ERcalls2=="A"
replace ERcalls2="0" if ERcalls2=="B"
destring ERcalls2, replace
label define ERcalls2 1 "Full Time" 0 "On-Call Specialty"
label var ERcalls2 "If you Take emergency Call or work in an ER, are you...?"

* Q13
bys v1 v2: gen ERcalls3=v7 if v3=="Q13"
replace ERcalls3="1" if ERcalls3=="A"
replace ERcalls3="2" if ERcalls3=="B"
replace ERcalls3="3" if ERcalls3=="C"
destring ERcalls3, replace
label define ERcalls3 1 "One" 2 "Two" 3 "Three or greater"
label values ERcalls3 ERcalls3
label var ERcalls3 "At how many hospitals do you currently take emergency call?"

* Q14
bys v1 v2: gen ERcalls4=v7 if v3=="Q14"
replace ERcalls4="1" if ERcalls4=="A"
replace ERcalls4="2" if ERcalls4=="B"
replace ERcalls4="3" if ERcalls4=="C"
destring ERcalls4, replace
label define ERcalls4 1 "1-4" 2 "5-9" 3 "10 or Greater"
label values ERcalls4 ERcalls4
label var ERcalls3 "How many days per month do you take call?"

* Q15
bys v1 v2: gen ERcalls5=v7 if v3=="Q15"
replace ERcalls5="1" if ERcalls5=="A"
replace ERcalls5="2" if ERcalls5=="B"
replace ERcalls5="3" if ERcalls5=="C"
destring ERcalls5, replace
label define ERcalls5 1 "Increased" 2 "Decreased" 3 "Stayed the Same"
label values ERcalls5 ERcalls5
label var ERcalls5 "Has the number of emergency on-call hours that you work.... if taken a call in past 2 yrs"

* Q16
bys v1 v2: gen ERcalls6=v7 if v3=="Q16"
replace ERcalls6="1" if ERcalls6=="A"
replace ERcalls6="2" if ERcalls6=="B"
replace ERcalls6="3" if ERcalls6=="C"
replace ERcalls6="4" if ERcalls6=="D"
replace ERcalls6="5" if ERcalls6=="E"
replace ERcalls6="6" if ERcalls6=="F"
replace ERcalls6="7" if ERcalls6=="G"
destring ERcalls6, replace
label define ERcalls6 1 "Liability" 2 "Reimbursement" 3 "Lifestyle Considerations" 4 "Impact to Private Practice" 5 "Changing Practice Patterns" 6 "Exemption" 7 "Other"
label values ERcalls6 ERcalls6
label var ERcalls6 "Has the number of emergency on-call hours that you work.... if taken a call in past 2 yrs"

* Q17
bys v1 v2: gen RADonly1=v7 if v3=="Q17"
replace RADonly1="1" if RADonly1=="A"
replace RADonly1="0" if RADonly1=="B"
destring RADonly1, replace
label values RADonly1 yesno
label var RADonly1 "Do you read mammograms or other breast imaging exams"

* Q18
bys v1 v2: gen RADonly2=v7 if v3=="Q18"
replace RADonly2="1" if RADonly2=="A"
replace RADonly2="2" if RADonly2=="B"
replace RADonly2="3" if RADonly2=="C"
replace RADonly2="4" if RADonly2=="D"
replace RADonly2="5" if RADonly2=="E"
replace RADonly2="6" if RADonly2=="F"
destring RADonly2, replace
label define RADonly2 1 "Liability" 2 "Reimbursement" 3 "Uninteresting Field" 4 "Too Stressful" 5 "Too Much Regulation" 6 "Other"
label values RADonly2 RADonly2
label var RADonly2 "If you do not read mammograms or other BIE, why?"


* Q19
bys v1 v2: gen RADonly3=v7 if v3=="Q19"
replace RADonly3="1" if RADonly3=="A"
replace RADonly3="0" if RADonly3=="B"
destring RADonly3, replace
label values RADonly3 yesno
label var RADonly3 "Do you read screening mammograms?"


* Q20
bys v1 v2: gen RADonly4=v7 if v3=="Q20"
replace RADonly4="1" if RADonly4=="A"
replace RADonly4="0" if RADonly4=="B"
destring RADonly4, replace
label values RADonly4 yesno
label var RADonly4 "Do you read diagnostic mammograms and sonograms?"


* Q21
bys v1 v2: gen RADonly5=v7 if v3=="Q21"
replace RADonly5="1" if RADonly5=="A"
replace RADonly5="0" if RADonly5=="B"
destring RADonly5, replace
label values RADonly5 yesno
label var RADonly5 "Do you perform Both ultrasound and stereotactic guided core biopsies"


* Q22
bys v1 v2: gen RADonly6=v7 if v3=="Q22"
replace RADonly6="1" if RADonly6=="A"
replace RADonly6="0" if RADonly6=="B"
destring RADonly6, replace
label values RADonly6 yesno
label var RADonly6 "Do you read breast MRIs"


* Q23
bys v1 v2: gen RADonly7=v7 if v3=="Q23"
replace RADonly7="1" if RADonly7=="A"
replace RADonly7="0" if RADonly7=="B"
destring RADonly7, replace
label values RADonly7 yesno
label var RADonly7 "Do you read brast MRIs and perform MRI guided core biopsies?"

* Q24
bys v1 v2: gen RADonly8=v7 if v3=="Q24"
replace RADonly8="1" if RADonly8=="A"
replace RADonly8="2" if RADonly8=="B"
replace RADonly8="3" if RADonly8=="C"
replace RADonly8="4" if RADonly8=="D"
destring RADonly8, replace
label define RADonly8 1 "Increase" 2 "Decrease" 3 "Stay the Same" 4 "Discontinue"
label var RADonly8 "In the next two years, will the number of mammograms you read change for any reason, including retirement"

* Q25
bys v1 v2: gen RADonly9=v7 if v3=="Q25"
replace RADonly9="1" if RADonly9=="A"
replace RADonly9="0" if RADonly9=="B"
destring RADonly9, replace
label values RADonly9 yesno
label var RADonly9 "Have you done a 6-month or greater breast imaging fellowship"


* Q26
bys v1 v2: gen OBSonly1=v7 if v3=="Q26"
replace OBSonly1="1" if OBSonly1=="A"
replace OBSonly1="0" if OBSonly1=="B"
destring OBSonly1, replace
label values OBSonly1 yesno
label var OBSonly1 "Do you practice obstetric care, inclduing delivering of babies?"

* Q27
bys v1 v2: gen OBSonly2=v7 if v3=="Q27"
replace OBSonly2="1" if OBSonly2=="A"
replace OBSonly2="2" if OBSonly2=="B"
replace OBSonly2="3" if OBSonly2=="C"
replace OBSonly2="4" if OBSonly2=="D"
destring OBSonly2, replace
label define OBSonly2 1 "None" 2 "Low, <10 per month" 3 "Medium, 10-30 per month" 4 "High, >30 per month"
label var OBSonly2 "How many routine deliveries per month"

* Q28
bys v1 v2: gen OBSonly3=v7 if v3=="Q28"
replace OBSonly3="1" if OBSonly3=="A"
replace OBSonly3="2" if OBSonly3=="B"
replace OBSonly3="3" if OBSonly3=="C"
replace OBSonly3="4" if OBSonly3=="D"
destring OBSonly3, replace
label define OBSonly3 1 "None" 2 "Low, <10 per month" 3 "Medium, 10-30 per month" 4 "High, >30 per month"
label var OBSonly3 "How many high risk deliveries per month"


* Q29
bys v1 v2: gen OBSonly4=v7 if v3=="Q29"
replace OBSonly4="1" if OBSonly4=="A"
replace OBSonly4="2" if OBSonly4=="B"
replace OBSonly4="3" if OBSonly4=="C"
replace OBSonly4="4" if OBSonly4=="D"
destring OBSonly4, replace
label define OBSonly4 1 "None" 2 "Low, <10 per month" 3 "Medium, 10-30 per month" 4 "High, >30 per month"
label var OBSonly4 "How many c-sections per month"


* Q30
bys v1 v2: gen OBSonly5=v7 if v3=="Q30"
replace OBSonly5="1" if OBSonly5=="A"
replace OBSonly5="2" if OBSonly5=="B"
replace OBSonly5="3" if OBSonly5=="C"
replace OBSonly5="4" if OBSonly5=="D"
destring OBSonly5, replace
label define OBSonly5 1 "None" 2 "Low, <10 per month" 3 "Medium, 10-30 per month" 4 "High, >30 per month"
label var OBSonly5 "How many emergency room deliveris per month"


* Q31
bys v1 v2: gen OBSonly6=v7 if v3=="Q31"
replace OBSonly6="1" if OBSonly6=="A"
replace OBSonly6="2" if OBSonly6=="B"
replace OBSonly6="3" if OBSonly6=="C"
replace OBSonly6="4" if OBSonly6=="D"
destring OBSonly6, replace
label define OBSonly6 1 "None" 2 "Low, <10 per month" 3 "Medium, 10-30 per month" 4 "High, >30 per month"
label var OBSonly6 "How many assists or consultative services per month"


* Q32
bys v1 v2: gen OBSonly7=v7 if v3=="Q32"
replace OBSonly7="1" if OBSonly7=="A"
replace OBSonly7="0" if OBSonly7=="B"
destring OBSonly7, replace
label values OBSonly7 yesno
label var OBSonly7 "Are you planning doing obstetric care for any reason, inclduing retirement, in the next two years?"


duplicates drop v1 v2 v3 v6, force
keep v1 v2 v3 v4 v6 workinfl - OBSonly7
tempfile temp1
save `temp1'

keep v1 v2 countiesx hoursinctyx
drop if countiesx==.
duplicates drop v1 v2 countiesx, force
bys v1 v2: gen h=_n
reshape wide countiesx hoursinctyx, i(v1 v2) j(h)
tempfile  temp2
save `temp2'

use `temp1'
keep v1 v2  specialtyx  specialtypctx
drop if specialtyx==.
duplicates drop v1 v2 specialtyx, force
bys v1 v2: gen h=_n
reshape wide specialtyx specialtypctx, i(v1 v2) j(h)
tempfile  temp3
save `temp3'


use `temp1'
keep v1 v2  changescope
drop if changescope==.
duplicates drop v1 v2 changescope, force
bys v1 v2: gen h=_n
reshape wide changescope, i(v1 v2) j(h)
tempfile  temp4
save `temp4'



use `temp1'
drop countiesx  hoursinctyx specialtyx  specialtypctx changescope


* pick up labels before collapse
foreach v of var * {
	local l`v' : variable label `v'
    if `"`l`v''"' == "" {
 		local l`v' "`v'"
 	}
 }

*"
collapse workinfl - OBSonly7, by(v1 v2)

* lay down labels after collapse
foreach v of var * {
	label var `v' "`l`v''"
}


label values retireish yesno
label values takeERcalls yesno
label values resfellow yesno
label values morethan20 yesno
label values howmanymonths q2
label values workinfl yesno
label values solopractice yesno
label values mainpractice q52008

merge 1:1 v1 v2 using `temp2'
drop _merge
merge 1:1 v1 v2 using `temp3'
drop _merge
merge 1:1 v1 v2 using `temp4'
drop _merge

label define q102008 ///
1 "Liability" ///
2 "Reimbursement" ///
3 "Regulatory and Administrative Burden" /// 
4 "Retirement" ///
5 "Lifestyle Considerations, Other than Retirement" ///
6 "Other"


label values hoursinctyx1 q31
label values countiesx1 countyfl
label values hoursinctyx2 q31
label values countiesx2 countyfl
label values hoursinctyx3 q31
label values countiesx3 countyfl
label values hoursinctyx4 q31
label values countiesx4 countyfl
label values hoursinctyx5 q31
label values countiesx5 countyfl
label values specialtypctx1 q72
label values specialtypctx2 q72
label values specialtypctx3 q72
label values specialtypctx4 q72
label values specialtypctx5 q72

label values OBSonly7 yesno
label values  OBSonly6 OBSonly6
label values OBSonly5 OBSonly5
label values OBSonly4 OBSonly4
label values OBSonly3 OBSonly3
label values OBSonly2 OBSonly2
label values OBSonly1 yesno
label values RADonly9 yesno
label values RADonly8 RADonly8
label values RADonly7 yesno
label values RADonly6 yesno
label values RADonly5 yesno
label values RADonly4 yesno
label values RADonly3 yesno
label values RADonly2 RADonly2
label values RADonly1 yesno
label values ERcalls6 ERcalls6
label values ERcalls5 ERcalls5
label values ERcalls4 ERcalls4
label values ERcalls3 ERcalls3
label values ERcalls2 ERcalls2
label values changescope1 q102008
label values changescope2 q102008
label values changescope3 q102008
label values changescope4 q102008
label values changescope5 q102008
label values changescope6 q102008
ren v1 docid1 
ren v2 docid2
gen year=2008
order doc* year
save "$wkfrc/WKFRC-2008/survey.wkfrc-2008clean.dta", replace

* =============  2009 Survey file================
* =============  2009 Survey file================
* =============  2009 Survey file================

use WKFRC-2009/survey.wkfrc-2009.dta, clear
* Q1
bys v1 v2: gen workinfl=v7 if v4=="Intro 1"
replace workinfl="1" if workinfl=="Y"
replace workinfl="0" if workinfl=="N"
destring workinfl, replace
label define yesno 1 "Yes" 0 "No"
label values workinfl yesno

* Q1a
bys v1 v2: gen whynotworkinfl=v7 if v4=="Intro 1a"
replace whynotworkinfl="1" if whynotworkinfl=="A"
replace whynotworkinfl="2" if whynotworkinfl=="B"
replace whynotworkinfl="3" if whynotworkinfl=="C"
replace whynotworkinfl="4" if whynotworkinfl=="D"
replace whynotworkinfl="5" if whynotworkinfl=="E"
replace whynotworkinfl="6" if whynotworkinfl=="F"
destring whynotworkinfl, replace
label define whynotworkinfl 1 "Retired" 2 "Liability" 3 "Reimbursement" 4 "Planning to move to Florida" 5 "Do not maintain a full-time residence in Florida" 6 "Other"
label values whynotworkinfl whynotworkinfl

* Q1b
bys v1 v2: gen relocatetofl=v7 if v4=="Intro 1b"
replace relocatetofl="1" if relocatetofl=="A"
replace relocatetofl="2" if relocatetofl=="B"
replace relocatetofl="3" if relocatetofl=="C"
destring relocatetofl, replace
label define relocatetofl 1 "In 1-2 years" 2 "In 3-4 years" 3 "Do not plan to relocate"
label values relocatetofl relocatetofl


* Q1c
bys v1 v2: gen speciality=v7 if v4=="Intro 1c Spec"
destring speciality, replace



* Q2
bys v1 v2: gen howmanymonths09=v7 if v4=="Question 2"
replace howmanymonths09="1" if howmanymonths09=="A"
replace howmanymonths09="2" if howmanymonths09=="B"
replace howmanymonths09="3" if howmanymonths09=="C"
replace howmanymonths09="4" if howmanymonths09=="D"
replace howmanymonths09="5" if howmanymonths09=="E"
replace howmanymonths09="6" if howmanymonths09=="F"
destring howmanymonths09, replace
label define q22009 ///
1 "1-2 Months" ///
2 "3-4 Months" ///
3 "5-6 Months" ///
4 "7-8 Month" ///
5 "9-10 Months" ///
6 "11-12 Months"
label values howmanymonths09 q2q22009

* Q3a
bys v1 v2: gen timespent1=v7 if v4=="Question 3a"
destring timespent1, replace
label var timespent1 "Time spend in Patient Care"
label define timespent ///
1 "0-5" ///
2 "6-10" ///
3 "11-15" ///
4 "16-20" ///
5 "21-25" ///
6 "26-30" ///
7 "31-35" ///
8 "36-40" ///
9 "41-45" ///
10 "46-50" ///
11 "51-54" ///
12 "55-60" ///
13 "61 or more" 
label values timespent1 timespent

* Q3b
bys v1 v2: gen timespent2=v7 if v4=="Question 3b"
destring timespent2, replace
label var timespent2 "Time spend in Administrative Matter"
label values timespent2 timespent

* Q3c
bys v1 v2: gen timespent3=v7 if v4=="Question 3c"
destring timespent3, replace
label var timespent3 "Time spend in Research and Teaching"
label values timespent3 timespent

* Q4
bys v1 v2: gen howmanypatients=v7 if v4=="Question 4"
destring howmanypatients, replace
label var howmanypatients "How many patients do you see per week?"
label define howmanypatients ///
1 "0-25" ///
2 "26-50" ///
3 "51-75" ///
4 "76-100" ///
5 "101-125" ///
6 "126-150" ///
7 "151-175" ///
8 "176-200" ///
9 "201 or more" 
label values howmanypatients howmanypatients

* Q5s
bys v1 v2: gen mainpractice09=v7 if v4=="Question 5"
destring mainpractice09, replace
label var mainpractice09 "Majority of you practice occurs in?"
label define q52009 ///
1 "Office Practice-Solo Practice" ///
2 "Office Practice Group Practice – Single specialty" ///
3 "Office Practice Group Practice – Multi‐specialty" ///
4 "Federally Qualified Community Health Center" ///
5 "Nursing Home / Extended Care Facility" ///
6 "Medical School or Parent University" ///
7 "Hospital – Hospital Based Physician (Non-Emergency)" ///
8 "Hospital – Other" ///
9 "Volunteer Free Clinic" ///
10 "County Health Department" ///
11 "Urgent Care Center" /// 
12 "Ambulatory Surgery Center" ///
13 "Hospital Emergency Room" ///
14 "Hospital Outpatient Dept" ///
15 "Hospital – Hospitalist" ///
16 "Other"

bys v1 v2: gen employer09=v7 if v4=="Question 5a"
destring employer09, replace
label var employer09 "If you are an employed physician, is your employer:"
label define q5a2009 ///
1 "Medical School or Parent University" ///
2 "Government Agency" ///
3 "Staff or Group HMO" ///
4 "None of the Above"
label values employer09  q5a2009

* Q6
bys v1 v2 v6: gen counties=v7 if v4=="P8-Resp-CtyZip"
destring counties, replace
bys v1 v2 v6: egen countiesx=max(counties)

label define countyfl ///
11 "Alachua" ///
12 "Baker" ///
13 "Bay" ///
14 "Bradford" ///
15 "Brevard" ///
16 "Broward" ///
17 "Calhoun" ///
18 "Charlotte" ///
19 "Citrus" ///
20 "Clay" ///
21 "Collier" ///
22 "Columbia" ///
23 "Dade" ///
24 "Desoto" ///
25 "Dixie" ///
26 "Duval" ///
27 "Escambia" ///
28 "Flagler" ///
29 "Franklin" ///
30 "Gadsden" ///
31 "Gilchrist" ///
32 "Glades" ///
33 "Gulf" ///
34 "Halmiton" ///
35 "Hardee" ///
36 "Hendry" ///
37 "Hernando" ///
38 "Highlands" ///
39 "Hillsborough" ///
40 "Holmes" /// 
41 "Indian River"   ///
42 "Jackson" ///
43 "Jefferson" ///
44 "LaFayette" ///
45 "Lake" ///
46 "Lee" ///
47 "Leon" ///
48 "Levy" ///
49 "Liberty" ///
50 "Madison" ///
51 "Manatee" ///
52 "Marion" ///
53 "Martin" /// 
54 "Monroe" ///
55 "Nassau" ///
56 "Okaloosa" ///
57 "Okeechobee" ///
58 "Orange" ///
59 "Osceola" ///
60 "Palm Beach" ///
61 "Pasco" ///
62 "Pinellas" ///
63 "Polk" ///
64 "Putnam" ///
65 "St. Johns" ///
66 "St. Lucie" ///
67 "Santa Rosa" ///
68 "Sarasota" ///
69 "Seminole" ///
70 "Sumter" ///
71 "Suwannee" ///
72 "Taylor" ///
73 "Union" ///
74 "Volusia" ///
75 "Wakulla" ///
76 "Walton" ///
77 "Washington" ///
78 "Unkonwn" ///
79 "Out of State" ///
80 "Foregin"
label values countiesx countyfl
  
 
bys v1 v2 v6: gen hoursincty=v7 if v4=="P8-Resp-Hrs"
destring hoursincty, replace
bys v1 v2 v6: egen hoursinctyx=max(hoursincty)
drop counties hoursincty
label define q62009 1 "1-10 Hrs/Wk" 2 "11-20 Hrs/Wk" 3 "21-29 Hrs/Wk" 4 " 30-39 Hrs/Wk" 5 "40-49 Hrs/Wk" 6 "50 or More Hrs/Wk"


* Q7 I'm skipping the second part of the question)
bys v1 v2: gen resfellow=v7 if v4=="Question 7 - RB"
replace resfellow="0" if resfellow=="N"
replace resfellow="1" if resfellow=="Y"
destring resfellow, replace
label values resfellow yesno

* Q8
bys v1 v2: gen medschooldebt=v7 if v4=="Question 8"
destring medschooldebt, replace
label var  medschooldebt "What was your total debt at the time of graduation from Medical School?"
label define q82009 ////
1 "No Debt" ///
2 "Less than 25K" ///
3 "More than 25K less  than 50K" /// 
4 "More than 50k less than 75K" ///
5 "More than 75K less than 100K" ///
6 "More than 100k less htan 125K" ///
7 "More than 125K less than 150K" ///
8 "150K or more"
label values medschooldebt q82009

* Q9
bys v1 v2: gen postspeciality1=v7 if v4=="Question 9 - RB"
replace postspeciality1="1" if postspeciality1=="N"
replace postspeciality1="0" if postspeciality1=="Y"
destring postspeciality1, replace
label values postspeciality1 yesno
label var postspeciality1 "Did you Complete a post residency or sub speciality fellowship?" 

bys v1 v2: gen postspeciality2=v7 if v4=="W2R-Specialty"
destring postspeciality2, replace
label var postspeciality2 "Did you Complete a post residency or sub speciality fellowship, which speciality?" 

* Q10
bys v1 v2: gen hosppriv1=v7 if v4=="Question 10"
replace hosppriv1="1" if hosppriv1=="N"
replace hosppriv1="0" if hosppriv1=="Y"
destring hosppriv1, replace
label values hosppriv1 yesno
label var hosppriv1 "Do you have hospital privileges?"

bys v1 v2: gen hosppriv2=v7 if v4=="Question 10a"
destring hosppriv2, replace
label var hosppriv2 "If you have hospital privileges, how many hospitals?"

* Q11
bys v1 v2: gen takeERcalls=v7 if v4=="Question 11"
replace takeERcalls="1" if takeERcalls=="A"
replace takeERcalls="0" if takeERcalls=="B"
replace takeERcalls="2" if takeERcalls=="C"
destring takeERcalls, replace
label define takeERcalls 1 "Yes" 0 "No" 2 "Exempt Due to Medical Staff Bylaws"
label values takeERcalls takeERcalls
label var takeERcalls "Do you provide on-call emergency room coverage (NOT Emergency Department Physician)?"

* Q11y
bys v1 v2: gen ERcalls2=v7 if v4=="Question 11 - Y"
replace ERcalls2="1" if ERcalls2=="A"
replace ERcalls2="0" if ERcalls2=="B"
destring ERcalls2, replace
label define ERcalls2 1 "Full Time" 0 "On-Call Specialty"
label var ERcalls2 "If you Take emergency Call or work in an ER, are you...?"

* Q11a
bys v1 v2: gen ERcalls309=v7 if v4=="Question 11a"
replace ERcalls309="1" if ERcalls309=="A"
replace ERcalls309="2" if ERcalls309=="B"
replace ERcalls309="3" if ERcalls309=="C"
replace ERcalls309="3" if ERcalls309=="D"
destring ERcalls3, replace
label define ERcalls3b 1 "One" 2 "Two" 3 "Three or greater" 4 "4 or more"
label values ERcalls3 ERcalls3b
label var ERcalls3 "At how many hospitals do you currently take emergency call?"

* Q11b
bys v1 v2: gen ERcalls409=v7 if v4=="Question 11b"
destring ERcalls409, replace
label define ERcalls409 1 "1-2" 2 "3-4" 3 "5-6" 4 "7-8" 5 "9-10" 6 "11 or more"
label values ERcalls409 ERcalls409
label var ERcalls409 "How many days per month do you take call?"

* Q11c
bys v1 v2: gen ERcalls5=v7 if v4=="Question 11c"
replace ERcalls5="1" if ERcalls5=="A"
replace ERcalls5="2" if ERcalls5=="B"
replace ERcalls5="3" if ERcalls5=="C"
destring ERcalls5, replace
label define ERcalls5 1 "Increased" 2 "Decreased" 3 "Stayed the Same"
label values ERcalls5 ERcalls5
label var ERcalls5 "Has the number of emergency on-call hours that you work.... if taken a call in past 2 yrs"

* Q12
bys v1 v2: gen traumacalls1=v7 if v4=="Question 12"
replace traumacalls1="0" if traumacalls1=="N"
replace traumacalls1="1" if traumacalls1=="Y"
destring traumacalls1, replace
label values traumacalls1 yesno
label var traumacalls1 "Do you take trauma call, or attend to trauma patients, at a verified trauma center?"

bys v1 v2: gen traumacalls2=v7 if v4=="Question 12a"
replace traumacalls2="1" if traumacalls2=="A"
replace traumacalls2="2" if traumacalls2=="B"
replace traumacalls2="3" if traumacalls2=="C"
destring traumacalls2, replace
label var traumacalls2 "If yes, which type?"
label define q12a2009 1 "Level I" 2 "Level II" 3 "Pediatric"

* Q13 
bys v1 v2: gen newmedicare=v7 if v4=="Question 13"
replace newmedicare="0" if newmedicare=="N"
replace newmedicare="1" if newmedicare=="Y"
destring newmedicare, replace
label values newmedicare yesno
label var newmedicare "Are you currently accepting new pateints covered by Medicare?"

* Q14
bys v1 v2: gen newmedicaid=v7 if v4=="Question 14"
replace newmedicaid="0" if newmedicaid=="N"
replace newmedicaid="1" if newmedicaid=="Y"
destring newmedicaid, replace
label values newmedicaid yesno
label var newmedicaid "Are you currently accepting new pateints covered by Medicaid?"

*Q15
bys v1 v2: gen retireish=v7 if v4=="Question 15"
replace retireish="1" if retireish=="Y"
replace retireish="0" if retireish=="N"
destring retireish, replace
label values retireish yesno
label var retireish "Do you plan to retire in the next 5 years?"

*Q15a
bys v1 v2: gen retirewhy=v7 if v4=="Question 15a"
destring retirewhy, replace
label var retirewhy "If yes, the main reason for retiring?"
label define Q15a2009 ///
1 "Time to Retire" ///
2 "Family" ///
3 "Medical liability risk and/or associated costs" ///
4 "Reimbursement" ///
5 "Looking for a change" ///
6 "Other"
label values retirewhy Q15a2009

* Q16
bys v1 v2: gen movein5yrs=v7 if v4=="Question 16"
replace movein5yrs="1" if movein5yrs=="Y"
replace movein5yrs="0" if movein5yrs=="N"
destring movein5yrs, replace
label values movein5yrs yesno
label var movein5yrs "Do you plan to move to work in another state in the next 5 years?"

* Q16a
bys v1 v2: gen whymovein5yrs=v7 if v4=="Question 16a"
destring whymovein5yrs, replace
label var whymovein5yrs "Reason to move?"
label define q16a2009 1 "Family" 2 "Medical liability risk ans/or assocuated costs" 3 "Reimbursement" 4 "Looking for a change" 5 "Education/Training in another state" 6 "Other"
label values whymovein5yrs  q16a2009

* Q17 
bys v1 v2: gen changespec=v7 if v4=="Question 17"
replace changespec="1" if changespec=="Y"
replace changespec="0" if changespec=="N"
destring changespec, replace
label values changespec yesno
label var changespec "Do you plan to change your speciality in the next 5 years?"

* Q17a
bys v1 v2: gen changespec_why=v7 if v4=="Question 17a"
destring changespec_why, replace
label var changespec_why "If yes, the main reason for changing your speciality"
label values changespec_why q16a2009 


* Q18
bys v1 v2 v6: gen specialty=v7 if v5=="W20R-SPC-MS2"
destring specialty, replace
bys v1 v2 v6: egen specialtyx=max(specialty)
drop specialty

bys v1 v2 v6: gen specialtypct=v7 if v5=="W20R-HRS-MS2"
replace specialtypct="1" if specialtypct=="A"
replace specialtypct="2" if specialtypct=="B"
replace specialtypct="3" if specialtypct=="C"
replace specialtypct="4" if specialtypct=="D"
replace specialtypct="5" if specialtypct=="E"
replace specialtypct="6" if specialtypct=="F"
destring specialtypct, replace
bys v1 v2 v6: egen specialtypctx=max(specialtypct)
label define q18b2009 ///
1 "0-10 Hrs/Wk" ///
2 "11-20 Hrs/Wk" ///
3 "21-29 Hrs/Wk" ///
4 "30-39 Hrs/Wk" ///
5 "40-49 Hrs/Wk" ///
6 "50 or More Hrs/Wk"
label values specialtypctx q18b2009
drop specialtypct

* Q19 
bys v1 v2: gen boardcerti=v7 if v4=="C420 Q19"
replace boardcerti="0" if boardcerti=="N"
replace boardcerti="1" if boardcerti=="Y"
replace boardcerti="2" if boardcerti=="R"
destring boardcerti, replace 
label define boardcerti  ///
0 "No" ///
1 "Yes" ///
2 "Renew"
label values boardcerti boardcerti


* Q19a
bys v1 v2: gen boardyear=v8 if v4=="C420 Q19a"
destring boardyear, replace

* Q20
bys v1 v2: gen subcerti=v7 if v4=="C420 Q20"
replace subcerti="0" if subcerti=="N"
replace subcerti="1" if subcerti=="Y"
destring subcerti, replace

* Q20a
bys v1 v2: gen subcertiyear=v8 if v4=="C420 Q20a"
destring subcertiyear, replace

* Q21
bys v1 v2: gen caqcerti=v7 if v4=="C420 Q21"
replace caqcerti="0" if caqcerti=="N"
replace caqcerti="1" if caqcerti=="Y"
destring caqcerti, replace

* Q21a
bys v1 v2: gen caqcertiyear=v8 if v4=="C420 Q21a"
destring caqcertiyear, replace

* Q22
	tempfile addq22
	save `addq22' 
	keep if v4=="C420 Q22"
	keep v1 v2 v7
	bys v1 v2: gen h=_n
	ren v7 answerq22_
	destring answerq22_, replace
	reshape wide answerq22_, i(v1 v2) j(h)
	tempfile addq22merge
	save `addq22merge', replace
	
	use `addq22', clear
	keep if v4=="C420 Q22a"
	keep v1 v2 v7
	bys v1 v2: gen h=_n
	ren v7 answerq22_a_
	replace answerq22_a_="1" if answerq22_a_=="A"
	replace answerq22_a_="2" if answerq22_a_=="B"
	replace answerq22_a_="3" if answerq22_a_=="C"
	replace answerq22_a_="4" if answerq22_a_=="D"
	replace answerq22_a_="5" if answerq22_a_=="E"
	destring answerq22_a_, replace
	reshape wide answerq22_a_, i(v1 v2) j(h)
	tempfile addq22mergea
	save `addq22mergea', replace
	
	use `addq22', clear
	keep if v4=="C420 Q22b"
	keep v1 v2 v7
	bys v1 v2: gen h=_n
	ren v7 answerq22_b_
	replace answerq22_b_="1" if answerq22_b_=="A"
	replace answerq22_b_="2" if answerq22_b_=="B"
	replace answerq22_b_="3" if answerq22_b_=="C"
	replace answerq22_b_="4" if answerq22_b_=="D"
	replace answerq22_b_="5" if answerq22_b_=="E"
	replace answerq22_b_="6" if answerq22_b_=="F"
	destring answerq22_b_, replace
	reshape wide answerq22_b_, i(v1 v2) j(h)
	tempfile addq22mergeb
	save `addq22mergeb', replace

use `addq22', clear

* q23


bys v1 v2: gen pedradiologist=v7 if v4=="C420 Q23"
replace pedradiologist="0" if pedradiologist=="N"
replace pedradiologist="1" if pedradiologist=="Y"
destring pedradiologist, replace

bys v1 v2: gen pedradiologistA=v7 if v4=="C420 Q23a"
replace pedradiologistA="1" if pedradiologistA=="A"
replace pedradiologistA="2" if pedradiologistA=="B"
replace pedradiologistA="3" if pedradiologistA=="C"
replace pedradiologistA="4" if pedradiologistA=="D"
replace pedradiologistA="5" if pedradiologistA=="E"
destring pedradiologistA, replace
label define pedradiologistA ///
1 "Musculoskeletal" ///
2 "Neuroradiology" ///
3 "Nuclear Medicine" ///
4 "Interventional Radiology" ///
5 "General" 
label values pedradiologistA pedradiologistA

* Q24

	tempfile addq24
	save `addq24' 
	keep if v4=="C420 Q24"
	keep v1 v2 v7
	bys v1 v2: gen h=_n
	ren v7 answerq24_
	replace answerq24_= "1" if answerq24_=="A" 
	replace answerq24_= "2" if answerq24_=="B" 
	replace answerq24_= "3" if answerq24_=="C" 
	replace answerq24_= "4" if answerq24_=="D" 
	replace answerq24_= "5" if answerq24_=="E" 
	replace answerq24_= "6" if answerq24_=="F" 
	destring answerq24_, replace
	reshape wide answerq24_, i(v1 v2) j(h)
	tempfile addq24merge
	save `addq24merge', replace
	
use `addq24', clear

* Q25 
bys v1 v2: gen q25useteleradiology=v7 if v4=="C420 Q25"
replace q25useteleradiology="0" if q25useteleradiology=="N"
replace q25useteleradiology="1" if q25useteleradiology=="Y"
destring q25useteleradiology, replace

	* Q25a
	tempfile addq25a
	save `addq25a' 
	keep if v4=="C420 Q25a"
	keep v1 v2 v7
	bys v1 v2: gen h=_n
	ren v7 answerq25a_
	replace answerq25a_= "1" if answerq25a_=="A" 
	replace answerq25a_= "2" if answerq25a_=="B" 
	replace answerq25a_= "3" if answerq25a_=="C" 
	replace answerq25a_= "4" if answerq25a_=="D" 
	replace answerq25a_= "5" if answerq25a_=="E" 
	replace answerq25a_= "6" if answerq25a_=="F" 
	replace answerq25a_= "7" if answerq25a_=="G" 
	destring answerq25a_, replace
	reshape wide answerq25a_, i(v1 v2) j(h)
	tempfile addq25amerge
	save `addq25amerge', replace
	
	use `addq25a', clear

* Q26
bys v1 v2: gen q26treatunderinsurepat=v7 if v4=="C420 Q26"
replace q26treatunderinsurepat="0" if q26treatunderinsurepat=="N"
replace q26treatunderinsurepat="1" if q26treatunderinsurepat=="Y"
destring q26treatunderinsurepat, replace

* Q27
bys v1 v2: gen q27treatuninsurepat=v7 if v4=="C420 Q27"
replace q27treatuninsurepat="0" if q27treatuninsurepat=="N"
replace q27treatuninsurepat="1" if q27treatuninsurepat=="Y"
destring q27treatuninsurepat, replace

* Q28
bys v1 v2: gen q28radiationonco=v7 if v4=="C420 Q28"
replace q28radiationonco="0" if q28radiationonco=="N"
replace q28radiationonco="1" if q28radiationonco=="Y"
destring q28radiationonco, replace

* Q28a
bys v1 v2: gen q28radiationoncoACerti=v7 if v4=="C420 Q28"
replace q28radiationoncoACerti="0" if q28radiationoncoACerti=="N"
replace q28radiationoncoACerti="1" if q28radiationoncoACerti=="Y"
destring q28radiationoncoACerti, replace
label var q28radiationoncoACerti "If yes, are you certified by the American Board of Therapeutic Radiology?"


*==== The next set of questions are only For Physicians that provide obstetric services or deliver babies, please answer questions 29 - 35

* Q29
bys v1 v2: gen q29DeliverBabies=v7 if v4=="C230 Q29"
replace q29DeliverBabies="0" if q29DeliverBabies=="N"
replace q29DeliverBabies="1" if q29DeliverBabies=="Y"
destring q29DeliverBabies, replace
label var q29DeliverBabies "Do you deliver babies?"

* Q30
bys v1 v2: gen q30HowManyDelivers=v7 if v4=="C230 Q30"
replace q30HowManyDelivers="1" if q30HowManyDelivers=="A"
replace q30HowManyDelivers="2" if q30HowManyDelivers=="B"
replace q30HowManyDelivers="3" if q30HowManyDelivers=="C"
replace q30HowManyDelivers="4" if q30HowManyDelivers=="D"
label var q30HowManyDelivers "How many routine deliveries do you perform per month?"
destring q30HowManyDelivers, replace 
label define q30HowManyDelivers ///
1 "None" ///
2 "Low, < 10 per month" /// 
3 "Medium, 10 - 30 month" ///
4 "High, > 30 per month"

label values q30HowManyDelivers q30HowManyDelivers

* Q31
bys v1 v2: gen q31HowManyRiskDelivers=v7 if v4=="C230 Q31"
replace q31HowManyRiskDelivers="1" if q31HowManyRiskDelivers=="A"
replace q31HowManyRiskDelivers="2" if q31HowManyRiskDelivers=="B"
replace q31HowManyRiskDelivers="3" if q31HowManyRiskDelivers=="C"
replace q31HowManyRiskDelivers="4" if q31HowManyRiskDelivers=="D"
label var q31HowManyRiskDelivers "How many high risk deliveries do you perform per month?"
destring q31HowManyRiskDelivers, replace 
label define q31HowManyRiskDelivers ///
1 "None" ///
2 "Low, < 10 per month" /// 
3 "Medium, 10 - 30 month" ///
4 "High, > 30 per month"

label values q31HowManyRiskDelivers q31HowManyRiskDelivers

* Q32
bys v1 v2: gen q32HowManyCSecs=v7 if v4=="C230 Q32"
replace q32HowManyCSecs="1" if q32HowManyCSecs=="A"
replace q32HowManyCSecs="2" if q32HowManyCSecs=="B"
replace q32HowManyCSecs="3" if q32HowManyCSecs=="C"
replace q32HowManyCSecs="4" if q32HowManyCSecs=="D"
label var q32HowManyCSecs "How many CSections do you perform per month?"
destring q32HowManyCSecs, replace 
label define q32HowManyCSecs ///
1 "None" ///
2 "Low, < 10 per month" /// 
3 "Medium, 10 - 30 month" ///
4 "High, > 30 per month"

label values q32HowManyCSecs q32HowManyCSecs

* Q33
bys v1 v2: gen q33ERDeliveries=v7 if v4=="C230 Q33"
replace q33ERDeliveries="1" if q33ERDeliveries=="A"
replace q33ERDeliveries="2" if q33ERDeliveries=="B"
replace q33ERDeliveries="3" if q33ERDeliveries=="C"
replace q33ERDeliveries="4" if q33ERDeliveries=="D"
label var q33ERDeliveries "How many emergency room deliveries do you perform per month for patients having minimal or no “known” prenatal care?"
destring q33ERDeliveries, replace
label define q33ERDeliveries ///
1 "None" ///
2 "Low, < 10 per month" /// 
3 "Medium, 10 - 30 month" ///
4 "High, > 30 per month"

label values q33ERDeliveries q33ERDeliveries

* Q34
bys v1 v2: gen q34AssistDeliveries=v7 if v4=="C230 Q34"
replace q34AssistDeliveries="1" if q34AssistDeliveries=="A"
replace q34AssistDeliveries="2" if q34AssistDeliveries=="B"
replace q34AssistDeliveries="3" if q34AssistDeliveries=="C"
replace q34AssistDeliveries="4" if q34AssistDeliveries=="D"
label var q34AssistDeliveries "How many assists or consultative services do you perform per month?"
destring q34AssistDeliveries, replace
label define q34AssistDeliveries ///
1 "None" ///
2 "Low, < 10 per month" /// 
3 "Medium, 10 - 30 month" ///
4 "High, > 30 per month"

label values q34AssistDeliveries q34AssistDeliveries
	
* Q35
bys v1 v2: gen q35Discontinue=v7 if v4=="C230 Q35"
replace q35Discontinue="0" if q35Discontinue=="N"
replace q35Discontinue="1" if q35Discontinue=="Y"
destring q35Discontinue, replace
label var q35Discontinue "Are you planning to discontinue doing obstetric care for any reason, including retirement, in the next two years?"

	
/* Now we need to convert the data into individual level observation, so
we need to drop duplicates and make sure we are not losing information
and putting it all horizontally */

duplicates drop v1 v2 v3 v6, force
keep v1 v2 v3 v4 v6 workinfl - q35Discontinue
tempfile temp1
save `temp1'

keep v1 v2 countiesx hoursinctyx
drop if countiesx==.
duplicates drop v1 v2 countiesx, force
bys v1 v2: gen h=_n
reshape wide countiesx hoursinctyx, i(v1 v2) j(h)
tempfile  temp2
save `temp2'

use `temp1'
keep v1 v2  specialtyx  specialtypctx
drop if specialtyx==.
duplicates drop v1 v2 specialtyx, force
bys v1 v2: gen h=_n
reshape wide specialtyx specialtypctx, i(v1 v2) j(h)
tempfile  temp3
save `temp3'


use `temp1'
drop countiesx  hoursinctyx specialtyx  specialtypctx 

* pick up labels before collapse
foreach v of var * {
	local l`v' : variable label `v'
    if `"`l`v''"' == "" {
 		local l`v' "`v'"
 	}
 }

*"

collapse workinfl - q35Discontinue, by(v1 v2)

* lay down labels after collapse
foreach v of var * {
	label var `v' "`l`v''"
}



merge 1:1 v1 v2 using `temp2'
drop _merge
merge 1:1 v1 v2 using `temp3'
drop _merge
merge 1:1 v1 v2 using `addq22merge'
drop _merge
merge 1:1 v1 v2 using `addq22mergea'
drop _merge
merge 1:1 v1 v2 using `addq22mergeb'
drop _merge
merge 1:1 v1 v2 using `addq24merge'
drop _merge
merge 1:1 v1 v2 using `addq25amerge'
drop _merge

label define q52009 ///
1 "Office Practice-Solo Practice" ///
2 "Office Practice Group Practice – Single specialty" ///
3 "Office Practice Group Practice – Multi‐specialty" ///
4 "Federally Qualified Community Health Center" ///
5 "Nursing Home / Extended Care Facility" ///
6 "Medical School or Parent University" ///
7 "Hospital – Hospital Based Physician (Non-Emergency)" ///
8 "Hospital – Other" ///
9 "Volunteer Free Clinic" ///
10 "County Health Department" ///
11 "Urgent Care Center" /// 
12 "Ambulatory Surgery Center" ///
13 "Hospital Emergency Room" ///
14 "Hospital Outpatient Dept" ///
15 "Hospital – Hospitalist" ///
16 "Other"


label define ERcalls2 1 "Full Time" 0 "On-Call Specialty"


label values workinfl yesno
label values whynotworkinfl whynotworkinfl
label values relocatetofl relocatetofl
label values timespent1 timespent
label values timespent2 timespent
label values timespent3 timespent
label values howmanymonths09 q2q22009
label values howmanypatients howmanypatients
label values mainpractice09 q52009
label values employer09  q5a2009
label values countiesx1 countyfl
label values countiesx2 countyfl
label values countiesx3 countyfl
label values countiesx4 countyfl
label values countiesx5 countyfl
label values hoursinctyx1 q62009
label values hoursinctyx2 q62009
label values hoursinctyx3 q62009
label values hoursinctyx4 q62009
label values hoursinctyx5 q62009
label values resfellow yesno
label values medschooldebt q82009
label values postspeciality1 yesno
label values postspeciality2 yesno
label values hosppriv1 yesno
label values takeERcalls takeERcalls
label values ERcalls2 ERcalls2
label values ERcalls3 ERcalls3b
label values ERcalls409 ERcalls409
label values ERcalls5 ERcalls5
label values traumacalls1 yesno
label values traumacalls2 q12a2009
label values newmedicare yesno
label values newmedicaid yesno
label values retireish yesno
label values retirewhy Q15a2009
label values movein5yrs yesno
label values whymovein5yrs  q16a2009
label values changespec yesno
label values changespec_why q16a2009 
label values specialtypctx1 q18b2009
label values specialtypctx2 q18b2009
label values specialtypctx3 q18b2009
label values specialtypctx4 q18b2009
label values specialtypctx5 q18b2009
label values boardcerti boardcerti
label values subcerti yesno
label values caqcerti yesno
label values pedradiologistA pedradiologistA
label values pedradiologist yesno
label values q25useteleradiology
label values q26treatunderinsurepat
label values q27treatuninsurepat
label values q28radiationonco
label values q28radiationoncoACerti
label values q29DeliverBabies
label values q30HowManyDelivers q30HowManyDelivers
label values q31HowManyRiskDelivers q31HowManyRiskDelivers
label values q32HowManyCSecs q32HowManyCSecs
label values q33ERDeliveries q33ERDeliveries
label values q34AssistDeliveries q34AssistDeliveries
label values q35Discontinue yesno


label define categorypat ///
1 "Mammography" ///
2 "GI Radiology" ///
4 "GU Radiology" ///
3 "Neuroradiology" ///
5 "Pediatric Radiology" ///
6 "General Radiology" ///
7 "Nuclear Medicine" ///
8 "Cardiothoracic Radiology" ///
9 "Musculoskeletal Radiology" ///
10 "Interventional Radiology" ///
11 "ALL"

label values answerq22_1 categorypat
label values answerq22_2 categorypat
label values answerq22_3 categorypat
label values answerq22_4 categorypat
label values answerq22_5 categorypat
label values answerq22_6 categorypat
label values answerq22_7 categorypat
label values answerq22_8 categorypat

label define q22a ///
1 "Read screening mammograms" ///
2 "Read diagnostic mammograms and sonograms" ///
3 "Read breast MRIs" ///
4 "Read MRI guided core biopsies" ///
5 "Perform ultrasound & stereotactic guided core biopsies"

label define q22b ///
1 "Liability" ///
2 "Reimbursement" ///
3 "Too stressful" ///
4 "Too much regulation" ///
5 "Not interested" ///
6 "Other"

label values answerq22_a_1 q22a
label values answerq22_a_2 q22a
label values answerq22_a_3 q22a
label values answerq22_a_4 q22a
label values answerq22_a_5 q22a

label values answerq22_b_1 q22b

  


label define answerq24 ///
1 "Hospital" ///
2 "Stand alone Imaging Center" ///
3 "Hospital-based Imaging Center" ///
4 "Off site (Internet-based) Radiology" ///
5 "Multispecialty Group Imaging Center" ///
6 "Other"
label values answerq24_1 answerq24
label values answerq24_2 answerq24
label values answerq24_3 answerq24
label values answerq24_4 answerq24
label values answerq24_5 answerq24


label define answerq25a ///
1 "Day coverage" ///
2 "In-state physicians" ///
3 "Night coverage" ///
4 "Out-of-state physicians" ///
5 "Subspecialty consultations" ///
6 "Out-of-country physicians" ///
7 "Other" 

label values answerq25a_1 answerq25a
label values answerq25a_2 answerq25a
label values answerq25a_3 answerq25a
label values answerq25a_4 answerq25a
label values answerq25a_5 answerq25a

ren v1 docid1 
ren v2 docid2

gen year=2009
order doc* year

save "$wkfrc/WKFRC-2009/survey.wkfrc-2009clean.dta", replace

* =============  2010 Survey file================
* =============  2010 Survey file================
* =============  2010 Survey file================

use WKFRC-2010/survey.wkfrc-2010.dta, clear

* Q1
bys v1 v2: gen workinfl=v7 if v4=="Intro 1"
replace workinfl="1" if workinfl=="Y"
replace workinfl="0" if workinfl=="N"
destring workinfl, replace
label define yesno 1 "Yes" 0 "No"
label values workinfl yesno

* Q1a
bys v1 v2: gen whynotworkinfl10=v7 if v4=="Intro 1a"
replace whynotworkinfl10="1" if whynotworkinfl10=="A"
replace whynotworkinfl10="2" if whynotworkinfl10=="C"
replace whynotworkinfl10="3" if whynotworkinfl10=="D"
replace whynotworkinfl10="4" if whynotworkinfl10=="E"
replace whynotworkinfl10="5" if whynotworkinfl10=="F"
replace whynotworkinfl10="6" if whynotworkinfl10=="H"
replace whynotworkinfl10="7" if whynotworkinfl10=="I"
replace whynotworkinfl10="8" if whynotworkinfl10=="J"
destring whynotworkinfl10, replace
label define whynotworkinfl10 ///
1 "Retired" ///
2 "Malpractice Insurance Rate" ///
3 "Liability Exposure"  ///
4 "Medicare/Medicaid Reimbursement Rates" ///
5 "Private Health Plan Reimbursment Rates" ///
6 "Planning to move to Florida" ///
7 "Do not maintain a full-time residence in Florida" ///
8 "Other"
label values whynotworkinfl10 whynotworkinfl10

* Q1b
bys v1 v2: gen relocatetofl=v7 if v4=="Intro 1b"
replace relocatetofl="1" if relocatetofl=="A"
replace relocatetofl="2" if relocatetofl=="B"
replace relocatetofl="3" if relocatetofl=="C"
destring relocatetofl, replace
label define relocatetofl ///
1 "In 1-2 years" ///
2 "In 3-4 years" ///
3 "Do not plan to relocate" 
label values relocatetofl relocatetofl

* Q1c
bys v1 v2: gen speciality=v7 if v4=="Intro 1c Spec"
destring speciality, replace

* Q2
bys v1 v2: gen howmanymonths10=v7 if v4=="Question 2"
destring howmanymonths10, replace
label define q22010 ///
1 "1-2 Months" ///
2 "3-4 Months" ///
3 "5-6 Months" ///
4 "7-8 Month" ///
5 "9-10 Months" ///
6 "11-12 Months" 
label values howmanymonths10 q22010


* Q3

bys v1 v2 : gen specialty=v7 if v4=="Q3 - Specialty"
destring specialty, replace
bys v1 v2 : egen specialtyx=max(specialty)
drop specialty
label var specialtyx "Primary Speciality"

bys v1 v2 v6: gen specialtypct=v7 if v4=="Q3 - Hours"
replace specialtypct="1" if specialtypct=="A"
replace specialtypct="2" if specialtypct=="B"
replace specialtypct="3" if specialtypct=="C"
replace specialtypct="4" if specialtypct=="D"
replace specialtypct="5" if specialtypct=="E"
replace specialtypct="6" if specialtypct=="F"
destring specialtypct, replace
bys v1 v2 v6: egen specialtypctx=max(specialtypct)
label define q18b2009 ///
1 "0-10 Hrs/Wk" ///
2 "11-20 Hrs/Wk" ///
3 "21-29 Hrs/Wk" ///
4 "30-39 Hrs/Wk" ///
5 "40-49 Hrs/Wk" ///
6 "50 or More Hrs/Wk"
label values specialtypctx q18b2009
drop specialtypct
label var specialtypctx "Primary Speciality"

tempfile temp1
save `temp1'
keep v1 v2  specialtyx  specialtypctx
drop if specialtyx==.
duplicates drop v1 v2 specialtyx, force
bys v1 v2: gen h=_n
reshape wide specialtyx specialtypctx, i(v1 v2) j(h)
tempfile  q3speciality
save `q3speciality'

clear
use `temp1'

*Q4

bys v1 v2 v6: gen specialty2=v7 if v4=="Q4 - Specialty"
destring specialty2, replace
bys v1 v2 v6: egen specialtyx2=max(specialty2)
drop specialty2


bys v1 v2 v6: gen specialtypct2=v7 if v4=="Q4 - Hours"
replace specialtypct2="1" if specialtypct2=="A"
replace specialtypct2="2" if specialtypct2=="B"
replace specialtypct2="3" if specialtypct2=="C"
replace specialtypct2="4" if specialtypct2=="D"
replace specialtypct2="5" if specialtypct2=="E"
replace specialtypct2="6" if specialtypct2=="F"
destring specialtypct2, replace
bys v1 v2 v6: egen specialtypctx2=max(specialtypct2)
label values specialtypctx2 q18b2009
drop specialtypct2
label var specialtypctx2 "Secondary Speciality"


tempfile temp2
save `temp2'
keep v1 v2  specialtyx2  specialtypctx2
drop if specialtyx2==.
duplicates drop v1 v2 specialtyx2, force
bys v1 v2: gen h=_n
reshape wide specialtyx2 specialtypctx2, i(v1 v2) j(h)
tempfile  q4speciality
save `q4speciality'

clear
use `temp2'

drop specialtyx2

*Q5 
bys v1 v2: gen counties=v7 if v4=="Q5 - CountyZip"
destring counties, replace
bys v1 v2: egen countiesx=max(counties)
label var countiesx "Primary County"

label define countyfl ///
11 "Alachua" ///
12 "Baker" ///
13 "Bay" ///
14 "Bradford" ///
15 "Brevard" ///
16 "Broward" ///
17 "Calhoun" ///
18 "Charlotte" ///
19 "Citrus" ///
20 "Clay" ///
21 "Collier" ///
22 "Columbia" ///
23 "Dade" ///
24 "Desoto" ///
25 "Dixie" ///
26 "Duval" ///
27 "Escambia" ///
28 "Flagler" ///
29 "Franklin" ///
30 "Gadsden" ///
31 "Gilchrist" ///
32 "Glades" ///
33 "Gulf" ///
34 "Halmiton" ///
35 "Hardee" ///
36 "Hendry" ///
37 "Hernando" ///
38 "Highlands" ///
39 "Hillsborough" ///
40 "Holmes" /// 
41 "Indian River"   ///
42 "Jackson" ///
43 "Jefferson" ///
44 "LaFayette" ///
45 "Lake" ///
46 "Lee" ///
47 "Leon" ///
48 "Levy" ///
49 "Liberty" ///
50 "Madison" ///
51 "Manatee" ///
52 "Marion" ///
53 "Martin" /// 
54 "Monroe" ///
55 "Nassau" ///
56 "Okaloosa" ///
57 "Okeechobee" ///
58 "Orange" ///
59 "Osceola" ///
60 "Palm Beach" ///
61 "Pasco" ///
62 "Pinellas" ///
63 "Polk" ///
64 "Putnam" ///
65 "St. Johns" ///
66 "St. Lucie" ///
67 "Santa Rosa" ///
68 "Sarasota" ///
69 "Seminole" ///
70 "Sumter" ///
71 "Suwannee" ///
72 "Taylor" ///
73 "Union" ///
74 "Volusia" ///
75 "Wakulla" ///
76 "Walton" ///
77 "Washington" ///
78 "Unkonwn" ///
79 "Out of State" ///
80 "Foregin"
label values countiesx countyfl
  
 
bys v1 v2: gen hoursincty=v7 if v4=="Q5 - Hours"
destring hoursincty, replace
bys v1 v2: egen hoursinctyx=max(hoursincty)
drop counties hoursincty
label define q62009  ///
1 "1-10 Hrs/Wk" ///
2 "11-20 Hrs/Wk" ///
3 "21-29 Hrs/Wk" ///
4 " 30-39 Hrs/Wk" ///
5 "40-49 Hrs/Wk" ///
6 "50 or More Hrs/Wk"
label var hoursinctyx "Primary County Hours of Work"


* Q6
bys v1 v2 v6: gen counties2=v7 if v4=="Q6 - CountyZip"
destring counties2, replace
bys v1 v2 v6: egen countiesx2=max(counties2)
label var countiesx2 "Secondary Counties"
label values countiesx2 countyfl

bys v1 v2 v6: gen hoursincty2=v7 if v4=="Q6 - Hours"
destring hoursincty2, replace
bys v1 v2 v6: egen hoursinctyx2=max(hoursincty2)
drop counties2 hoursincty2
label var hoursinctyx2 "Primary County Hours of Work"

tempfile temp3
save `temp3'
keep v1 v2  countiesx2  hoursinctyx2
drop if countiesx2==.
duplicates drop v1 v2 countiesx2, force
bys v1 v2: gen h=_n
reshape wide countiesx2 hoursinctyx2, i(v1 v2) j(h)
tempfile  q6county2
save `q6county2'

clear
use `temp3'
drop countiesx2

* Q7

label define timespent ///
1 "0-5" ///
2 "6-10" ///
3 "11-15" ///
4 "16-20" ///
5 "21-25" ///
6 "26-30" ///
7 "31-35" ///
8 "36-40" ///
9 "41-45" ///
10 "46-50" ///
11 "51-54" ///
12 "55-60" ///
13 "61 or more" 


bys v1 v2: gen timespent1=v7 if v4=="Question 7a"
destring timespent1, replace
label var timespent1 "Time spend in Patient Care"
label values timespent1 timespent

* Q3b
bys v1 v2: gen timespent2=v7 if v4=="Question 7b"
destring timespent2, replace
label var timespent2 "Time spend in Administrative Matter"
label values timespent2 timespent

* Q3c
bys v1 v2: gen timespent3=v7 if v4=="Question 7c"
destring timespent3, replace
label var timespent3 "Time spend in Research and Teaching"
label values timespent3 timespent

*  Q8

label define howmanypatients ///
1 "0-25" ///
2 "26-50" ///
3 "51-75" ///
4 "76-100" ///
5 "101-125" ///
6 "126-150" ///
7 "151-175" ///
8 "176-200" ///
9 "201 or more" 


bys v1 v2: gen howmanypatients=v7 if v4=="Question 8"
destring howmanypatients, replace
label var howmanypatients "How many patients do you see per week?"

* Q9
label define q92010 ///
1 "Office Practice - Solo Practice" ///
2 "Office Practice - Group Practice - Single Specialty" ///
3 "Office Practice - Group Practice - Multi-Specialty" ///
4 "Federally Qualified Community Health Center" ///
5 "Nursing Home / Extended Care Facility" /// 
6 "Volunteer Free Clinic" ///
7 "Hospital - Hospital Based Physician (Non-Emergency)" ///
8 "Hospital - Other" ///
10 "County Health Department" ///
11 "Urgent Care Center"  ///
12 "Ambulatory Surgery Center" ///
13 "Hospital Emergency Room" ///
14 "Hospital - Outpatient Dept" ///
15 "Hospital - Hospitalist" ///
16 "Other"


bys v1 v2: gen mainpractice10=v7 if v4=="Question 9"
destring mainpractice10, replace
label var mainpractice10 "Majority of you practice occurs in?"

* Q10
bys v1 v2: gen employer10=v7 if v4=="Question 10"
destring employer10, replace
label var employer10 "If you are an employed physician, is your employer:"
label define q5a2010 ///
1 "Medical School or Parent University" ///
2 "Government Agency" ///
3 "Staff or Group HMO" ///
4 "None of the Above"
label values employer10  q5a2010

* Q11 (I'm skipping the second part of the question)
bys v1 v2: gen resfellow=v7 if v4=="Question 11"
replace resfellow="0" if resfellow=="N"
replace resfellow="1" if resfellow=="Y"
destring resfellow, replace
label values resfellow yesno

*Q12
label define q122010 ////
1 "No Debt" ///
2 "Less than 25K" ///
3 "More than 25K less  than 50K" /// 
4 "More than 50k less than 75K" ///
5 "More than 75K less than 100K" ///
6 "More than 100k less htan 125K" ///
7 "More than 125K less than 150K" ///
8 "150K or more"

bys v1 v2: gen medschooldebt=v7 if v4=="Question 12"
destring medschooldebt, replace
label var  medschooldebt "What was your total debt at the time of graduation from Medical School?"
label values medschooldebt q122010

* Q13

bys v1 v2: gen hosppriv1=v7 if v4=="Question 13"
replace hosppriv1="1" if hosppriv1=="N"
replace hosppriv1="0" if hosppriv1=="Y"
destring hosppriv1, replace
label values hosppriv1 yesno
label var hosppriv1 "Do you have hospital privileges?"

bys v1 v2: gen hosppriv2=v7 if v4=="Question 13a"
destring hosppriv2, replace
label var hosppriv2 "If you have hospital privileges, how many hospitals?"

bys v1 v2: gen hosppriv3=v7 if v4=="Question 13b"
replace hosppriv3="1" if hosppriv3=="N"
replace hosppriv3="0" if hosppriv3=="Y"
destring hosppriv3, replace
label values hosppriv3 yesno
label var hosppriv3 "If no, is the decision to not have hospital privileges voluntary?"

* Q14 (I am going to ignore subquestions by q14)
bys v1 v2: gen takeERcalls10=v7 if v4=="Question 14"
replace takeERcalls10="1" if takeERcalls10=="A"
replace takeERcalls10="0" if takeERcalls10=="B"
destring takeERcalls10, replace
label define takeERcalls10  1 "Yes" 0 "No" 
label values takeERcalls10 takeERcalls10
label var takeERcalls10 "Do you provide on-call emergency room coverage (NOT Emergency Department Physician)?"

* Q15
bys v1 v2: gen traumacalls1=v7 if v4=="Question 15"
replace traumacalls1="0" if traumacalls1=="N"
replace traumacalls1="1" if traumacalls1=="Y"
destring traumacalls1, replace
label values traumacalls1 yesno
label var traumacalls1 "Do you take trauma call, or attend to trauma patients, at a verified trauma center?"

*Q15a
label define q15a2010 ///
1 "Level I" ///
2 "Level II" ///
3 "Pediatric" ///
4 "More than one of the above"

bys v1 v2: gen traumacalls2=v7 if v4=="Question 15a"
replace traumacalls2="1" if traumacalls2=="A"
replace traumacalls2="2" if traumacalls2=="B"
replace traumacalls2="3" if traumacalls2=="C"
replace traumacalls2="4" if traumacalls2=="D"
destring traumacalls2, replace
label var traumacalls2 "If yes, which type?"

*Q16
bys v1 v2: gen newmedicare=v7 if v4=="Question 16"
replace newmedicare="0" if newmedicare=="N"
replace newmedicare="1" if newmedicare=="Y"
destring newmedicare, replace
label values newmedicare yesno
label var newmedicare "Are you currently accepting new Medicare patients in your practice?"

*Q16a
bys v1 v2: gen newmedicare_q16a=v7 if v4=="Question 16a"
replace newmedicare_q16a="1" if newmedicare_q16a=="A"
replace newmedicare_q16a="2" if newmedicare_q16a=="B"
replace newmedicare_q16a="3" if newmedicare_q16a=="C"
replace newmedicare_q16a="4" if newmedicare_q16a=="D"
replace newmedicare_q16a="5" if newmedicare_q16a=="E"
replace newmedicare_q16a="6" if newmedicare_q16a=="F"
destring newmedicare_q16a, replace
label define newmedicare_q16a ///
1 "Low Compensation" ///
2 "Billing Requirements" ///
3 "Too Much Paperwork" ///
4 "Practice is at full capacity" ///
5 "Concerned about Fraud Issues" ///
6 "Other" 
label values newmedicare_q16a newmedicare_q16a

*Q17 
bys v1 v2: gen newmedicaid=v7 if v4=="Question 17"
replace newmedicaid="0" if newmedicaid=="N"
replace newmedicaid="1" if newmedicaid=="Y"
destring newmedicaid, replace
label values newmedicaid yesno
label var newmedicaid "Are you currently accepting new pateints covered by Medicaid?"

bys v1 v2: gen newmedicaid_q17a=v7 if v4=="Question 17a"
replace newmedicaid_q17a="1" if newmedicaid_q17a=="A"
replace newmedicaid_q17a="2" if newmedicaid_q17a=="B"
replace newmedicaid_q17a="3" if newmedicaid_q17a=="C"
replace newmedicaid_q17a="4" if newmedicaid_q17a=="D"
replace newmedicaid_q17a="5" if newmedicaid_q17a=="E"
replace newmedicaid_q17a="6" if newmedicaid_q17a=="F"
destring newmedicaid_q17a, replace

label define newmedicaid_q17a ///
1 "Low Compensation" ///
2 "Billing Requirements" ///
3 "Too Much Paperwork" ///
4 "Practice is at full capacity" ///
5 "Concerned about Fraud Issues" ///
6 "Other" 
label values newmedicaid_q17a newmedicaid_q17a

*Q18
bys v1 v2: gen retireish=v7 if v4=="Question 18"
replace retireish="1" if retireish=="Y"
replace retireish="0" if retireish=="N"
destring retireish, replace
label values retireish yesno
label var retireish "Do you plan to retire in the next 5 years?"

*Q18a
bys v1 v2: gen retirewhy=v7 if v4=="Question 18a"
destring retirewhy, replace
label var retirewhy "If yes, the main reason for retiring?"
replace retirewhy="1" if retirewhy=="A"
replace retirewhy="2" if retirewhy=="B"
replace retirewhy="3" if retirewhy=="C"
replace retirewhy="4" if retirewhy=="D"
replace retirewhy="5" if retirewhy=="E"
replace retirewhy="6" if retirewhy=="F"
replace retirewhy="7" if retirewhy=="H"
replace retirewhy="8" if retirewhy=="J"
destring retirewhy, replace
label define Q18a2010 ///
1 "Time to retire" ///
2 "Family" /// 
3 "Compensation" ///
4 "Malpractice Insurance Rates" ///
5 "Liability Exposure" ///
6 "Medicare/Medicaid Reimbursement Rates" ///
7 "Private Health Plan Reimbursement Rates" ///
8 "Other" 
label values retirewhy Q18a2010

* Q18b
bys v1 v2: gen retirewhy_q18b=v7 if v4=="Question 18b"
label var retirewhy_q18b "If yes, do you plan to have a limited license for volunteering?"
replace retirewhy_q18b="1" if retirewhy_q18b=="Y"
replace retirewhy_q18b="0" if retirewhy_q18b=="N"
destring retirewhy_q18b, replace
label values retirewhy_q18b yesno

*Q19
bys v1 v2: gen movein5yrs=v7 if v4=="Question 19"
replace movein5yrs="1" if movein5yrs=="Y"
replace movein5yrs="0" if movein5yrs=="N"
destring movein5yrs, replace
label values movein5yrs yesno
label var movein5yrs "Do you plan to move to work in another state in the next 5 years?"

* Q19a
bys v1 v2: gen whymovein5yrs=v7 if v4=="Question 19a"
label var whymovein5yrs "Main Reason to move?"
replace whymovein5yrs="1" if whymovein5yrs=="A"
replace whymovein5yrs="2" if whymovein5yrs=="B"
replace whymovein5yrs="3" if whymovein5yrs=="C"
replace whymovein5yrs="4" if whymovein5yrs=="D"
replace whymovein5yrs="5" if whymovein5yrs=="E"
replace whymovein5yrs="6" if whymovein5yrs=="G"
replace whymovein5yrs="7" if whymovein5yrs=="H"
replace whymovein5yrs="8" if whymovein5yrs=="I"
replace whymovein5yrs="9" if whymovein5yrs=="J"
destring whymovein5yrs, replace
label define q19a2009 ///
1 "Family" ///
2 "Compensation" ///
3 "Malpractice Insurance Rate" ///
4 "Liability Exposure" ///
5 "Medicare/Medicaid Reimbursement Rates" ///
6 "Private Health Plan Reimbursement Rates" ///
7 "Looking for a change" ///
8 "Education-training in another state" ///
9 "Other"
label values whymovein5yrs  q19a2009

* Q20
bys v1 v2: gen changespec=v7 if v4=="Question 20"
replace changespec="1" if changespec=="Y"
replace changespec="0" if changespec=="N"
destring changespec, replace
label values changespec yesno
label var changespec "Do you plan to change your speciality in the next 5 years?"

* Q20a
bys v1 v2: gen changespec_why=v7 if v4=="Question 20a"
label var changespec_why "If yes, the main reason for changing your speciality"
replace changespec_why="1" if changespec_why=="A"
replace changespec_why="2" if changespec_why=="B"
replace changespec_why="3" if changespec_why=="C"
replace changespec_why="4" if changespec_why=="D"
replace changespec_why="5" if changespec_why=="E"
replace changespec_why="6" if changespec_why=="F"
replace changespec_why="7" if changespec_why=="G"
replace changespec_why="8" if changespec_why=="H"
replace changespec_why="9" if changespec_why=="I"
destring changespec_why, replace
  
label define q20a2009 ///
1 "Family" ///
2 "Malpractice Insurance Rates" ///
3 "Liability Exposure" ///
4 "Medicare/Medicaid Reimbursement Rates" ///
5 "Private Health Plan Reimbursement Rates" ///
6 "Compensation" ///
7 "Education/training in another state" ///
8 "Potential for Higher Compensation" ///
9 "Other"

* ---End of Core Questionnarie --- Now onto speciality questions

*Q General Internal Medicine
bys v1 v2: gen postresidfellow=v7 if v4=="Gen IM 1"
label var postresidfellow "Did you do a post-residency fellowship? For General Internal Medicine Only"
replace postresidfellow="1" if postresidfellow=="Y"
replace postresidfellow="0" if postresidfellow=="N"
destring postresidfellow, replace
label values postresidfellow yesno

bys v1 v2: gen postresidfellow_state=v7 if v4=="Gen IM 1a"
label var postresidfellow_state "If yes to post-residency Fellow, what state (GEN.I.M Only)"
destring postresidfellow_state, replace

						// NOTE: placing in STT code for program "labelstates", otherwise code breaks here //
						
capture program drop labelstates 
program define labelstates 

 args statevariable
 capture label drop fips

# delimit ;
 
 label define fips
 0 "United States"
 1 "Alabama"
 2 "Alaska"
 4 "Arizona"
 5 "Arkansas"
 6 "California"
 8 "Colorado"
 9 "Connecticut"
 10 "Delaware"
 11 "District of Columbia"
 12 "Florida"
 13 "Georgia"
 15 "Hawaii"
 16 "Idaho"
 17 "Illinois"
 18 "Indiana"
 19 "Iowa"
 20 "Kansas"
 21 "Kentucky"
 22 "Louisiana"
 23 "Maine"
 24 "Maryland"
 25 "Massachusetts"
 26 "Michigan"
 27 "Minnesota"
 28 "Mississippi"
 29 "Missouri"
 30 "Montana"
 31 "Nebraska"
 32 "Nevada"
 33 "New Hampshire"
 34 "New Jersey"
 35 "New Mexico"
 36 "New York"
 37 "North Carolina"
 38 "North Dakota"
 39 "Ohio"
 40 "Oklahoma"
 41 "Oregon"
 42 "Pennsylvania"
 44 "Rhode Island"
 45 "South Carolina"
 46 "South Dakota"
 47 "Tennessee"
 48 "Texas"
 49 "Utah"
 50 "Vermont"
 51 "Virginia"
 53 "Washington"
 54 "West Virginia"
 55 "Wisconsin"
 56 "Wyoming"
 72 "Puerto Rico"
 52 "Virgin Islands";

 # delimit cr
 
 label values `statevariable' fips
 
 end
 						

labelstates postresidfellow_state

bys v1 v2: gen postresidfellow_cat=v7 if v4=="Gen IM 2"
label var postresidfellow_cat "Check which category of patient you'll see (GEN.I.M Only)"
destring postresidfellow_cat, replace
label define postresidfellow_cat ///
1 "Internal Medicine" ///
2 "Geriatrics" ///
3 "Women's Health" ///
4 "Pediatrics Care" ///
5 "In-Hospital Care" ///
6 "Your sub-specialty" ///
7 "All of the Above"
label values postresidfellow_cat postresidfellow_cat

* Allergy Immunology
bys v1 v2: gen postresid_allergy=v7 if v4=="Allergy/Imm 1"
label var postresid_allergy "Did you do a post-residency Allergy/Immunology fellowship?"
replace postresid_allergy="1" if postresid_allergy=="Y"
replace postresid_allergy="0" if postresid_allergy=="N"
destring postresid_allergy, replace
label values postresid_allergy yesno

bys v1 v2: gen postresid_allergy_state=v7 if v4=="Allergy/Imm 1a"
label var postresid_allergy_state "If yes to post-residency, what state (GEN.I.M Only)"
destring postresid_allergy_state, replace
labelstates postresid_allergy_state

bys v1 v2: gen postresid_allergy_cat=v7 if v4=="Allergy/Imm 2"
label var postresid_allergy_cat "Check which category of patient you'll see (GEN.I.M Only)"
destring postresid_allergy_cat, replace
label define postresid_allergy_cat ///
1 "Internal Medicine" ///
2 "Adult Asthma" ///
3 "Childhood Asthma" ///
4 "Allergic Rhinitis" ///
5 "Allergic Skin Disease" ///
6 "Immune Deficiency" ///
7 "Food/Insect/Drug Allergy" ///
8 "All of the Above"
label values postresid_allergy_cat postresid_allergy_cat

bys v1 v2: gen postresid_cardio=v7 if v4=="Cardio 1"
label var postresid_cardio "Did you do a post-residency Cardiology fellowship?"
replace postresid_cardio="1" if postresid_cardio=="Y"
replace postresid_cardio="0" if postresid_cardio=="N"
destring postresid_cardio, replace
label values postresid_cardio yesno

bys v1 v2: gen postresid_cardio_state=v7 if v4=="Cardio 1a"
label var postresid_cardio_state "If yes to post-residency, what state (GEN.I.M Only)"
destring postresid_cardio_state, replace
labelstates postresid_cardio_state

bys v1 v2: gen postresid_cardio_sub=v7 if v4=="Cardio 2"
label var postresid_cardio_sub "Did you do a Cardiology Sub-specialty fellowship?"
replace postresid_cardio_sub="1" if postresid_cardio_sub=="Y"
replace postresid_cardio_sub="0" if postresid_cardio_sub=="N"
destring postresid_cardio_sub, replace
label values postresid_cardio_sub yesno

bys v1 v2: gen postresid_cardio_area=v7 if v4=="Cardio 2a"
label var postresid_cardio_area "Yes, In which area (please check only one)"
destring postresid_cardio_area, replace
label define postresid_cardio_area ///
1 "General Clinical Cardiologist" ///
2 "Interventional Cardiologist" ///
3 "Echocardiologist (Echocardiographer)"   ///
4 "Electrophysiologist" ///
5 "Nuclear Cardiologist"   ///
6 "MR / CT Cardiologist"   ///
7 "Heart Failure & Transplant Cardiologist" ///
8 "Preventive Cardiologist"   ///
9 "Vascular Medicine Specialist"  /// 
10 "Cardiovascular Investigator"  ///
11 "Other"  
label values postresid_cardio_area postresid_cardio_area

bys v1 v2: gen postresid_cardio_areast=v7 if v4=="Cardio 2b"
label var postresid_cardio_areast "If yes to post-residency, what state (GEN.I.M Only)"
destring postresid_cardio_areast, replace
labelstates postresid_cardio_areast

bys v1 v2: gen postresid_cardio_cat=v7 if v4=="Cardio 3"
label var postresid_cardio_cat "Check which category of patient you'll see (GEN.I.M Only)"
destring postresid_cardio_cat, replace
label define postresid_cardio_cat ///
1 "Internal Medicine" ///
2 "General Cardiology" ///
3 "Interventional Cardiology" ///
4 "ECHO" ///
5 "Electrophysiology" ///
6 "Heart Failure & Transplant" ///
7 "Nuclear Cardiologist"   ///
8 "Pediatric Cardiology"   ///
9 "Vascular Medicine"   ///
10 "MR / CT Cardiologist"   ///
11 "All of the Above"
label values postresid_cardio_cat postresid_cardio_cat

* Endocrinology
bys v1 v2: gen postresid_endo=v7 if v4=="Endoc 1"
label var postresid_endo "Did you do a post-residency Endocrinology?"
replace postresid_endo="1" if postresid_endo=="Y"
replace postresid_endo="0" if postresid_endo=="N"
destring postresid_endo, replace
label values postresid_endo yesno

bys v1 v2: gen postresid_endo_state=v7 if v4=="Endoc 1a"
label var postresid_endo_state "If yes to post-residency, what state (GEN.I.M Only)"
destring postresid_endo_state, replace
labelstates postresid_endo_state

bys v1 v2: gen postresid_endo_cat=v7 if v4=="Endoc 2"
label var postresid_endo_cat "Check which category of patient you'll see (GEN.I.M Only)"
destring postresid_endo_cat, replace
label define postresid_endo_cat ///
 1         "Internal Medicine"   ///
     2       "Adult Endocrinology"  /// 
     3         "Diabetes Mellitus"  ///
     4           "Thyroid Disease"  ///
     5   "Pediatric Endocrinology"  ///
     6          "All of the Above"  
label values postresid_endo_cat postresid_endo_cat

* Gastroenterology

bys v1 v2: gen postresid_gastro=v7 if v4=="Gastro 1"
label var postresid_gastro "Did you do a post-residency Endocrinology?"
replace postresid_gastro="1" if postresid_gastro=="Y"
replace postresid_gastro="0" if postresid_gastro=="N"
destring postresid_gastro, replace
label values postresid_gastro yesno

bys v1 v2: gen postresid_gastro_state=v7 if v4=="Gastro 1a"
label var postresid_gastro_state "If yes to post-residency, what state (GEN.I.M Only)"
destring postresid_gastro_state, replace
labelstates postresid_gastro_state

bys v1 v2: gen postresid_gastro_cat=v7 if v4=="Gastro 2"
label var postresid_gastro_cat "Check which category of patient you'll see (GEN.I.M Only)"
destring postresid_gastro_cat, replace
label define postresid_gastro_cat ///
 1       "Internal Medicine"  ///
     2        "Gastroenterology"   ///
     3                    "ERCP"   ///
     4              "Hepatology"   ///
     5              "Pediatrics"   ///
     6   "Endoscopic Ultrasound"  ///
     7        "All of the Above"  

 label values postresid_gastro_cat postresid_gastro_cat

* Genetics

bys v1 v2: gen postresid_gene=v7 if v4=="Genetic 1"
label var postresid_gene "Did you do a post-residency Endocrinology?"
replace postresid_gene="1" if postresid_gene=="Y"
replace postresid_gene="0" if postresid_gene=="N"
destring postresid_gene, replace
label values postresid_gene yesno

bys v1 v2: gen postresid_gene2=v7 if v4=="Genetic 1a"
label var postresid_gene2 "If yes, Which one?"
label define postresid_gene2 ///
1 "Clinical Genetics" ///
2 "Biochemical Genetics" ///
5 "Other"  
destring postresid_gene2, replace
label values postresid_gene2 postresid_gene2
* DOTHIS


bys v1 v2: gen postresid_gene_state=v7 if v4=="Genetic 1b"
label var postresid_gene_state "If yes to post-residency, what state (GEN.I.M Only)"
destring postresid_gene_state, replace
labelstates postresid_gene_state

bys v1 v2: gen postresid_gene_cat=v7 if v4=="Genetic 2"
label var postresid_gene_cat "Check which category of patient you'll see (GEN.I.M Only)"
destring postresid_gene_cat, replace
label define postresid_gene_cat ///
   1            "Prenatal Genetics"  /// 
     2               "Adult Genetics" ///  
     3              "Cancer Genetics" ///
     4         "Biochemical Genetics" ///  
     5           "Molecular Genetics" ///  
     6            "Internal Medicine" ///  
     7         "Chromosome Disorders" ///  
     8      "Neuromuscular Disorders" ///  
     9   "Developmental Delay/Autism" ///   
    10                "Dysmorphology" ///  
    11                 "Cytogenetics" ///  
    12                   "Pediatrics" ///  
    13             "All of the Above"
 label values postresid_gene_cat postresid_gene_cat

 
 
/* Now we need to convert the data into individual level observation, so
we need to drop duplicates and make sure we are not losing information
and putting it all horizontally */

duplicates drop v1 v2 v3 v6, force
keep v1 v2 v3 v4 v6 workinfl - postresid_gene_cat
tempfile temp1
save `temp1'

keep v1 v2 countiesx hoursinctyx
drop if countiesx==.
duplicates drop v1 v2 countiesx, force
bys v1 v2: gen h=_n
reshape wide countiesx hoursinctyx, i(v1 v2) j(h)
tempfile  temp2

save `temp2'

/*
use `temp1'
keep v1 v2  specialtyx  specialtypctx
drop if specialtyx==.
duplicates drop v1 v2 specialtyx, force
bys v1 v2: gen h=_n
reshape wide specialtyx specialtypctx, i(v1 v2) j(h)
tempfile  temp3
save `temp3'
*/
 

use `temp1'
drop countiesx  hoursinctyx specialtyx  specialtypctx 

* pick up labels before collapse
foreach v of var * {
	local l`v' : variable label `v'
    if `"`l`v''"' == "" {
 		local l`v' "`v'"
 	}
 }

*"
collapse workinfl - postresid_gene_cat, by(v1 v2) fast

* lay down labels after collapse
foreach v of var * {
	label var `v' "`l`v''"
}



merge 1:1 v1 v2 using `temp2'
drop _merge
merge 1:1 v1 v2 using `q6county2'
drop _merge
merge 1:1 v1 v2 using `q3speciality'
drop _merge
merge 1:1 v1 v2 using `q4speciality'
drop _merge

ren v1 docid1 
ren v2 docid2

gen year=2010
order doc* year
save "$wkfrc/WKFRC-2010/survey.wkfrc-2010clean.dta", replace

* =============  2011 Survey file================
* =============  2011 Survey file================
* =============  2011 Survey file================

use WKFRC-2011/survey.wkfrc-2011.dta, clear

* Q1
bys v1 v2: gen workinfl=v7 if v4=="Intro 1"
replace workinfl="1" if workinfl=="Y"
replace workinfl="0" if workinfl=="N"
destring workinfl, replace
label define yesno 1 "Yes" 0 "No"
label values workinfl yesno

* Q1a
bys v1 v2: gen whynotworkinfl10=v7 if v4=="Intro 1a"
replace whynotworkinfl10="1" if whynotworkinfl10=="A"
replace whynotworkinfl10="2" if whynotworkinfl10=="C"
replace whynotworkinfl10="3" if whynotworkinfl10=="D"
replace whynotworkinfl10="4" if whynotworkinfl10=="E"
replace whynotworkinfl10="5" if whynotworkinfl10=="F"
replace whynotworkinfl10="6" if whynotworkinfl10=="H"
replace whynotworkinfl10="7" if whynotworkinfl10=="I"
replace whynotworkinfl10="8" if whynotworkinfl10=="J"
destring whynotworkinfl10, replace
label define whynotworkinfl10 ///
1 "Retired" ///
2 "Malpractice Insurance Rate" ///
3 "Liability Exposure"  ///
4 "Medicare/Medicaid Reimbursement Rates" ///
5 "Private Health Plan Reimbursment Rates" ///
6 "Planning to move to Florida" ///
7 "Do not maintain a full-time residence in Florida" ///
8 "Other"
label values whynotworkinfl10 whynotworkinfl10

* Q1b
bys v1 v2: gen relocatetofl=v7 if v4=="Intro 1b"
replace relocatetofl="1" if relocatetofl=="A"
replace relocatetofl="2" if relocatetofl=="B"
replace relocatetofl="3" if relocatetofl=="C"
destring relocatetofl, replace
label define relocatetofl ///
1 "In 1-2 years" ///
2 "In 3-4 years" ///
3 "Do not plan to relocate" 
label values relocatetofl relocatetofl

* Q1c
bys v1 v2: gen speciality=v7 if v4=="Intro 1c Spec"
destring speciality, replace

* Q2

bys v1 v2: gen howmanymonths10=v7 if v4=="Question 2"
destring howmanymonths10, replace
label define q22010 ///
1 "1-2 Months" ///
2 "3-4 Months" ///
3 "5-6 Months" ///
4 "7-8 Month" ///
5 "9-10 Months" ///
6 "11-12 Months" 
label values howmanymonths10 q22010

* Q3

bys v1 v2: gen specialty=v7 if v4=="Q3 - Specialty"
destring specialty, replace
bys v1 v2: egen specialtyx=max(specialty)
drop specialty
label var specialtyx "Primary Speciality"

bys v1 v2 v6: gen specialtypct=v7 if v4=="Q3 - Hours"
replace specialtypct="1" if specialtypct=="A"
replace specialtypct="2" if specialtypct=="B"
replace specialtypct="3" if specialtypct=="C"
replace specialtypct="4" if specialtypct=="D"
replace specialtypct="5" if specialtypct=="E"
replace specialtypct="6" if specialtypct=="F"
destring specialtypct, replace
bys v1 v2 v6: egen specialtypctx=max(specialtypct)
label define q18b2009 ///
1 "0-10 Hrs/Wk" ///
2 "11-20 Hrs/Wk" ///
3 "21-29 Hrs/Wk" ///
4 "30-39 Hrs/Wk" ///
5 "40-49 Hrs/Wk" ///
6 "50 or More Hrs/Wk"
label values specialtypctx q18b2009
drop specialtypct
label var specialtypctx "Primary Speciality"

tempfile temp1
save `temp1'
keep v1 v2  specialtyx  specialtypctx
drop if specialtyx==.
duplicates drop v1 v2 specialtyx, force
bys v1 v2: gen h=_n
reshape wide specialtyx specialtypctx, i(v1 v2) j(h)
tempfile  q3speciality
save `q3speciality'

clear
use `temp1'

*Q4

bys v1 v2 v6: gen specialty2=v7 if v4=="Q4 - Specialty"
destring specialty2, replace
bys v1 v2 v6: egen specialtyx2=max(specialty2)
drop specialty2
label var specialtyx2 "Secondary Speciality"

bys v1 v2 v6: gen specialtypct2=v7 if v4=="Q4 - Hours"
replace specialtypct2="1" if specialtypct2=="A"
replace specialtypct2="2" if specialtypct2=="B"
replace specialtypct2="3" if specialtypct2=="C"
replace specialtypct2="4" if specialtypct2=="D"
replace specialtypct2="5" if specialtypct2=="E"
replace specialtypct2="6" if specialtypct2=="F"
destring specialtypct2, replace
bys v1 v2 v6: egen specialtypctx2=max(specialtypct2)
label values specialtypctx2 q18b2009
drop specialtypct2
label var specialtypctx2 "Secondary Speciality"

tempfile temp2
save `temp2'
keep v1 v2  specialtyx2  specialtypctx2
drop if specialtyx2==.
duplicates drop v1 v2 specialtyx2, force
bys v1 v2: gen h=_n
reshape wide specialtyx2 specialtypctx2, i(v1 v2) j(h)
tempfile  q4speciality
save `q4speciality'

clear
use `temp2'

drop specialtyx2

*Q5 
bys v1 v2: gen counties=v7 if v4=="Q5 - CountyZip"
destring counties, replace
bys v1 v2: egen countiesx=max(counties)
label var countiesx "Primary County"

label define countyfl ///
11 "Alachua" ///
12 "Baker" ///
13 "Bay" ///
14 "Bradford" ///
15 "Brevard" ///
16 "Broward" ///
17 "Calhoun" ///
18 "Charlotte" ///
19 "Citrus" ///
20 "Clay" ///
21 "Collier" ///
22 "Columbia" ///
23 "Dade" ///
24 "Desoto" ///
25 "Dixie" ///
26 "Duval" ///
27 "Escambia" ///
28 "Flagler" ///
29 "Franklin" ///
30 "Gadsden" ///
31 "Gilchrist" ///
32 "Glades" ///
33 "Gulf" ///
34 "Halmiton" ///
35 "Hardee" ///
36 "Hendry" ///
37 "Hernando" ///
38 "Highlands" ///
39 "Hillsborough" ///
40 "Holmes" /// 
41 "Indian River"   ///
42 "Jackson" ///
43 "Jefferson" ///
44 "LaFayette" ///
45 "Lake" ///
46 "Lee" ///
47 "Leon" ///
48 "Levy" ///
49 "Liberty" ///
50 "Madison" ///
51 "Manatee" ///
52 "Marion" ///
53 "Martin" /// 
54 "Monroe" ///
55 "Nassau" ///
56 "Okaloosa" ///
57 "Okeechobee" ///
58 "Orange" ///
59 "Osceola" ///
60 "Palm Beach" ///
61 "Pasco" ///
62 "Pinellas" ///
63 "Polk" ///
64 "Putnam" ///
65 "St. Johns" ///
66 "St. Lucie" ///
67 "Santa Rosa" ///
68 "Sarasota" ///
69 "Seminole" ///
70 "Sumter" ///
71 "Suwannee" ///
72 "Taylor" ///
73 "Union" ///
74 "Volusia" ///
75 "Wakulla" ///
76 "Walton" ///
77 "Washington" ///
78 "Unkonwn" ///
79 "Out of State" ///
80 "Foregin"
label values countiesx countyfl
  
 
bys v1 v2: gen hoursincty=v7 if v4=="Q5 - Hours"
destring hoursincty, replace
bys v1 v2: egen hoursinctyx=max(hoursincty)
drop counties hoursincty
label define q62009  ///
1 "1-10 Hrs/Wk" ///
2 "11-20 Hrs/Wk" ///
3 "21-29 Hrs/Wk" ///
4 " 30-39 Hrs/Wk" ///
5 "40-49 Hrs/Wk" ///
6 "50 or More Hrs/Wk"
label var hoursinctyx "Primary County Hours of Work"


* Q6
bys v1 v2 v6: gen counties2=v7 if v4=="Q6 - CountyZip"
destring counties2, replace
bys v1 v2 v6: egen countiesx2=max(counties2)
label var countiesx2 "Secondary Counties"
label values countiesx2 countyfl

bys v1 v2 v6: gen hoursincty2=v7 if v4=="Q6 - Hours"
destring hoursincty2, replace
bys v1 v2 v6: egen hoursinctyx2=max(hoursincty2)
drop counties2 hoursincty2
label var hoursinctyx2 "Primary County Hours of Work"

tempfile temp3
save `temp3'
keep v1 v2  countiesx2  hoursinctyx2
drop if countiesx2==.
duplicates drop v1 v2 countiesx2, force
bys v1 v2: gen h=_n
reshape wide countiesx2 hoursinctyx2, i(v1 v2) j(h)
tempfile  q6county2
save `q6county2'

clear
use `temp3'
drop countiesx2

* Q7

label define timespent ///
1 "0-5" ///
2 "6-10" ///
3 "11-15" ///
4 "16-20" ///
5 "21-25" ///
6 "26-30" ///
7 "31-35" ///
8 "36-40" ///
9 "41-45" ///
10 "46-50" ///
11 "51-54" ///
12 "55-60" ///
13 "61 or more" 


bys v1 v2: gen timespent1=v7 if v4=="Question 7a"
destring timespent1, replace
label var timespent1 "Time spend in Patient Care"
label values timespent1 timespent

* Q3b
bys v1 v2: gen timespent2=v7 if v4=="Question 7b"
destring timespent2, replace
label var timespent2 "Time spend in Administrative Matter"
label values timespent2 timespent

* Q3c
bys v1 v2: gen timespent3=v7 if v4=="Question 7c"
destring timespent3, replace
label var timespent3 "Time spend in Research and Teaching"
label values timespent3 timespent

*  Q8

label define howmanypatients ///
1 "0-25" ///
2 "26-50" ///
3 "51-75" ///
4 "76-100" ///
5 "101-125" ///
6 "126-150" ///
7 "151-175" ///
8 "176-200" ///
9 "201 or more" 


bys v1 v2: gen howmanypatients=v7 if v4=="Question 8"
destring howmanypatients, replace
label var howmanypatients "How many patients do you see per week?"

* Q9
label define q92011 ///
1 "Office Practice - Solo Practice" ///
2 "Office Practice - Group Practice - Single Specialty" ///
3 "Office Practice - Group Practice - Multi-Specialty" ///
4 "Federally Qualified Community Health Center" ///
5 "Nursing Home / Extended Care Facility" /// 
6 "Volunteer Free Clinic" ///
7 "Hospital - Hospital Based Physician (Non-Emergency)" ///
8 "Hospital - Other" ///
10 "County Health Department" ///
11 "Urgent Care Center"  ///
12 "Ambulatory Surgery Center" ///
13 "Hospital Emergency Room" ///
14 "Hospital - Outpatient Dept" ///
15 "Hospital - Hospitalist" ///
16 "Other"


bys v1 v2: gen mainpractice10=v7 if v4=="Question 9"
destring mainpractice10, replace
label var mainpractice10 "Majority of you practice occurs in?"

* Q10
bys v1 v2: gen employer10=v7 if v4=="Question 10"
destring employer10, replace
label var employer10 "If you are an employed physician, is your employer:"
label define q5a2011 ///
1 "Medical School or Parent University" ///
2 "Government Agency" ///
3 "Staff or Group HMO" ///
4 "None of the Above"
label values employer10  q5a2011

* Q11 (I'm skipping the second part of the question)
bys v1 v2: gen resfellow=v7 if v4=="Question 11"
replace resfellow="0" if resfellow=="N"
replace resfellow="1" if resfellow=="Y"
destring resfellow, replace
label values resfellow yesno

*Q12
label define q122011 ////
1 "No Debt" ///
2 "Less than 25K" ///
3 "More than 25K less  than 50K" /// 
4 "More than 50k less than 75K" ///
5 "More than 75K less than 100K" ///
6 "More than 100k less htan 125K" ///
7 "More than 125K less than 150K" ///
8 "150K or more"

bys v1 v2: gen medschooldebt=v7 if v4=="Question 12"
destring medschooldebt, replace
label var  medschooldebt "What was your total debt at the time of graduation from Medical School?"
label values medschooldebt q122011

* Q13

bys v1 v2: gen hosppriv1=v7 if v4=="Question 13"
replace hosppriv1="1" if hosppriv1=="N"
replace hosppriv1="0" if hosppriv1=="Y"
destring hosppriv1, replace
label values hosppriv1 yesno
label var hosppriv1 "Do you have hospital privileges?"

bys v1 v2: gen hosppriv2=v7 if v4=="Question 13a"
destring hosppriv2, replace
label var hosppriv2 "If you have hospital privileges, how many hospitals?"

bys v1 v2: gen hosppriv3=v7 if v4=="Question 13b"
replace hosppriv3="1" if hosppriv3=="N"
replace hosppriv3="0" if hosppriv3=="Y"
destring hosppriv3, replace
label values hosppriv3 yesno
label var hosppriv3 "If no, is the decision to not have hospital privileges voluntary?"

* Q14 (I am going to ignore subquestions by q14)
bys v1 v2: gen takeERcalls10=v7 if v4=="Question 14"
replace takeERcalls10="1" if takeERcalls10=="A"
replace takeERcalls10="0" if takeERcalls10=="B"
destring takeERcalls10, replace
label define takeERcalls10  1 "Yes" 0 "No" 
label values takeERcalls10 takeERcalls10
label var takeERcalls10 "Do you provide on-call emergency room coverage (NOT Emergency Department Physician)?"

* Q15
bys v1 v2: gen traumacalls1=v7 if v4=="Question 15"
replace traumacalls1="0" if traumacalls1=="N"
replace traumacalls1="1" if traumacalls1=="Y"
destring traumacalls1, replace
label values traumacalls1 yesno
label var traumacalls1 "Do you take trauma call, or attend to trauma patients, at a verified trauma center?"

*Q15a
label define q15a2011 ///
1 "Level I" ///
2 "Level II" ///
3 "Pediatric" ///
4 "More than one of the above"

bys v1 v2: gen traumacalls2=v7 if v4=="Question 15a"
replace traumacalls2="1" if traumacalls2=="A"
replace traumacalls2="2" if traumacalls2=="B"
replace traumacalls2="3" if traumacalls2=="C"
replace traumacalls2="4" if traumacalls2=="D"
destring traumacalls2, replace
label var traumacalls2 "If yes, which type?"

*Q16
bys v1 v2: gen newmedicare=v7 if v4=="Question 16"
replace newmedicare="0" if newmedicare=="N"
replace newmedicare="1" if newmedicare=="Y"
destring newmedicare, replace
label values newmedicare yesno
label var newmedicare "Are you currently accepting new Medicare patients in your practice?"

*Q16a
bys v1 v2: gen newmedicare_q16a=v7 if v4=="Question 16a"
replace newmedicare_q16a="1" if newmedicare_q16a=="A"
replace newmedicare_q16a="2" if newmedicare_q16a=="B"
replace newmedicare_q16a="3" if newmedicare_q16a=="C"
replace newmedicare_q16a="4" if newmedicare_q16a=="D"
replace newmedicare_q16a="5" if newmedicare_q16a=="E"
replace newmedicare_q16a="6" if newmedicare_q16a=="F"
destring newmedicare_q16a, replace
label define newmedicare_q16a ///
1 "Low Compensation" ///
2 "Billing Requirements" ///
3 "Too Much Paperwork" ///
4 "Practice is at full capacity" ///
5 "Concerned about Fraud Issues" ///
6 "Other" 
label values newmedicare_q16a newmedicare_q16a

*Q17 
bys v1 v2: gen newmedicaid=v7 if v4=="Question 17"
replace newmedicaid="0" if newmedicaid=="N"
replace newmedicaid="1" if newmedicaid=="Y"
destring newmedicaid, replace
label values newmedicaid yesno
label var newmedicaid "Are you currently accepting new pateints covered by Medicaid?"

bys v1 v2: gen newmedicaid_q17a=v7 if v4=="Question 17a"
replace newmedicaid_q17a="1" if newmedicaid_q17a=="A"
replace newmedicaid_q17a="2" if newmedicaid_q17a=="B"
replace newmedicaid_q17a="3" if newmedicaid_q17a=="C"
replace newmedicaid_q17a="4" if newmedicaid_q17a=="D"
replace newmedicaid_q17a="5" if newmedicaid_q17a=="E"
replace newmedicaid_q17a="6" if newmedicaid_q17a=="F"
destring newmedicaid_q17a, replace

label define newmedicaid_q17a ///
1 "Low Compensation" ///
2 "Billing Requirements" ///
3 "Too Much Paperwork" ///
4 "Practice is at full capacity" ///
5 "Concerned about Fraud Issues" ///
6 "Other" 
label values newmedicaid_q17a newmedicaid_q17a

*Q18
bys v1 v2: gen retireish=v7 if v4=="Question 18"
replace retireish="1" if retireish=="Y"
replace retireish="0" if retireish=="N"
destring retireish, replace
label values retireish yesno
label var retireish "Do you plan to retire in the next 5 years?"

*Q18a
bys v1 v2: gen retirewhy=v7 if v4=="Question 18a"
destring retirewhy, replace
label var retirewhy "If yes, the main reason for retiring?"
replace retirewhy="1" if retirewhy=="A"
replace retirewhy="2" if retirewhy=="B"
replace retirewhy="3" if retirewhy=="C"
replace retirewhy="4" if retirewhy=="D"
replace retirewhy="5" if retirewhy=="E"
replace retirewhy="6" if retirewhy=="F"
replace retirewhy="7" if retirewhy=="H"
replace retirewhy="8" if retirewhy=="J"
destring retirewhy, replace
label define Q18a2011 ///
1 "Time to retire" ///
2 "Family" /// 
3 "Compensation" ///
4 "Malpractice Insurance Rates" ///
5 "Liability Exposure" ///
6 "Medicare/Medicaid Reimbursement Rates" ///
7 "Private Health Plan Reimbursement Rates" ///
8 "Other" 
label values retirewhy Q18a2011

* Q18b
bys v1 v2: gen retirewhy_q18b=v7 if v4=="Question 18b"
label var retirewhy_q18b "If yes, do you plan to have a limited license for volunteering?"
replace retirewhy_q18b="1" if retirewhy_q18b=="Y"
replace retirewhy_q18b="0" if retirewhy_q18b=="N"
destring retirewhy_q18b, replace
label values retirewhy_q18b yesno

*Q19
bys v1 v2: gen movein5yrs=v7 if v4=="Question 19"
replace movein5yrs="1" if movein5yrs=="Y"
replace movein5yrs="0" if movein5yrs=="N"
destring movein5yrs, replace
label values movein5yrs yesno
label var movein5yrs "Do you plan to move to work in another state in the next 5 years?"

* Q19a
bys v1 v2: gen whymovein5yrs=v7 if v4=="Question 19a"
label var whymovein5yrs "Main Reason to move?"
replace whymovein5yrs="1" if whymovein5yrs=="A"
replace whymovein5yrs="2" if whymovein5yrs=="B"
replace whymovein5yrs="3" if whymovein5yrs=="C"
replace whymovein5yrs="4" if whymovein5yrs=="D"
replace whymovein5yrs="5" if whymovein5yrs=="E"
replace whymovein5yrs="6" if whymovein5yrs=="G"
replace whymovein5yrs="7" if whymovein5yrs=="H"
replace whymovein5yrs="8" if whymovein5yrs=="I"
replace whymovein5yrs="9" if whymovein5yrs=="J"
destring whymovein5yrs, replace
label define q19a2009 ///
1 "Family" ///
2 "Compensation" ///
3 "Malpractice Insurance Rate" ///
4 "Liability Exposure" ///
5 "Medicare/Medicaid Reimbursement Rates" ///
6 "Private Health Plan Reimbursement Rates" ///
7 "Looking for a change" ///
8 "Education-training in another state" ///
9 "Other"
label values whymovein5yrs  q19a2009

* Q20
bys v1 v2: gen changespec=v7 if v4=="Question 20"
replace changespec="1" if changespec=="Y"
replace changespec="0" if changespec=="N"
destring changespec, replace
label values changespec yesno
label var changespec "Do you plan to change your speciality in the next 5 years?"

* Q20a
bys v1 v2: gen changespec_why=v7 if v4=="Question 20a"
label var changespec_why "If yes, the main reason for changing your speciality"
replace changespec_why="1" if changespec_why=="A"
replace changespec_why="2" if changespec_why=="B"
replace changespec_why="3" if changespec_why=="C"
replace changespec_why="4" if changespec_why=="D"
replace changespec_why="5" if changespec_why=="E"
replace changespec_why="6" if changespec_why=="F"
replace changespec_why="7" if changespec_why=="G"
replace changespec_why="8" if changespec_why=="H"
replace changespec_why="9" if changespec_why=="I"
destring changespec_why, replace
  
label define q20a2009 ///
1 "Family" ///
2 "Malpractice Insurance Rates" ///
3 "Liability Exposure" ///
4 "Medicare/Medicaid Reimbursement Rates" ///
5 "Private Health Plan Reimbursement Rates" ///
6 "Compensation" ///
7 "Education/training in another state" ///
8 "Potential for Higher Compensation" ///
9 "Other"

* ---End of Core Questionnarie --- Now onto speciality questions

*Q General Internal Medicine
bys v1 v2: gen postresidfellow=v7 if v4=="Gen IM 1"
label var postresidfellow "Did you do a post-residency fellowship? For General Internal Medicine Only"
replace postresidfellow="1" if postresidfellow=="Y"
replace postresidfellow="0" if postresidfellow=="N"
destring postresidfellow, replace
label values postresidfellow yesno

bys v1 v2: gen postresidfellow_state=v7 if v4=="Gen IM 1a"
label var postresidfellow_state "If yes to post-residency Fellow, what state (GEN.I.M Only)"
destring postresidfellow_state, replace
labelstates postresidfellow_state

bys v1 v2: gen postresidfellow_cat=v7 if v4=="Gen IM 2"
label var postresidfellow_cat "Check which category of patient you'll see (GEN.I.M Only)"
destring postresidfellow_cat, replace
label define postresidfellow_cat ///
1 "Internal Medicine" ///
2 "Geriatrics" ///
3 "Women's Health" ///
4 "Pediatrics Care" ///
5 "In-Hospital Care" ///
6 "Your sub-specialty" ///
7 "All of the Above"
label values postresidfellow_cat postresidfellow_cat

* Allergy Immunology
bys v1 v2: gen postresid_allergy=v7 if v4=="Allergy/Imm 1"
label var postresid_allergy "Did you do a post-residency Allergy/Immunology fellowship?"
replace postresid_allergy="1" if postresid_allergy=="Y"
replace postresid_allergy="0" if postresid_allergy=="N"
destring postresid_allergy, replace
label values postresid_allergy yesno

bys v1 v2: gen postresid_allergy_state=v7 if v4=="Allergy/Imm 1a"
label var postresid_allergy_state "If yes to post-residency, what state (GEN.I.M Only)"
destring postresid_allergy_state, replace
labelstates postresid_allergy_state

bys v1 v2: gen postresid_allergy_cat=v7 if v4=="Allergy/Imm 2"
label var postresid_allergy_cat "Check which category of patient you'll see (GEN.I.M Only)"
destring postresid_allergy_cat, replace
label define postresid_allergy_cat ///
1 "Internal Medicine" ///
2 "Adult Asthma" ///
3 "Childhood Asthma" ///
4 "Allergic Rhinitis" ///
5 "Allergic Skin Disease" ///
6 "Immune Deficiency" ///
7 "Food/Insect/Drug Allergy" ///
8 "All of the Above"
label values postresid_allergy_cat postresid_allergy_cat

bys v1 v2: gen postresid_cardio=v7 if v4=="Cardio 1"
label var postresid_cardio "Did you do a post-residency Cardiology fellowship?"
replace postresid_cardio="1" if postresid_cardio=="Y"
replace postresid_cardio="0" if postresid_cardio=="N"
destring postresid_cardio, replace
label values postresid_cardio yesno

bys v1 v2: gen postresid_cardio_state=v7 if v4=="Cardio 1a"
label var postresid_cardio_state "If yes to post-residency, what state (GEN.I.M Only)"
destring postresid_cardio_state, replace
labelstates postresid_cardio_state

bys v1 v2: gen postresid_cardio_sub=v7 if v4=="Cardio 2"
label var postresid_cardio_sub "Did you do a Cardiology Sub-specialty fellowship?"
replace postresid_cardio_sub="1" if postresid_cardio_sub=="Y"
replace postresid_cardio_sub="0" if postresid_cardio_sub=="N"
destring postresid_cardio_sub, replace
label values postresid_cardio_sub yesno

bys v1 v2: gen postresid_cardio_area=v7 if v4=="Cardio 2a"
label var postresid_cardio_area "Yes, In which area (please check only one)"
destring postresid_cardio_area, replace
label define postresid_cardio_area ///
1 "General Clinical Cardiologist" ///
2 "Interventional Cardiologist" ///
3 "Echocardiologist (Echocardiographer)"   ///
4 "Electrophysiologist" ///
5 "Nuclear Cardiologist"   ///
6 "MR / CT Cardiologist"   ///
7 "Heart Failure & Transplant Cardiologist" ///
8 "Preventive Cardiologist"   ///
9 "Vascular Medicine Specialist"  /// 
10 "Cardiovascular Investigator"  ///
11 "Other"  
label values postresid_cardio_area postresid_cardio_area

bys v1 v2: gen postresid_cardio_areast=v7 if v4=="Cardio 2b"
label var postresid_cardio_areast "If yes to post-residency, what state (GEN.I.M Only)"
destring postresid_cardio_areast, replace
labelstates postresid_cardio_areast

bys v1 v2: gen postresid_cardio_cat=v7 if v4=="Cardio 3"
label var postresid_cardio_cat "Check which category of patient you'll see (GEN.I.M Only)"
destring postresid_cardio_cat, replace
label define postresid_cardio_cat ///
1 "Internal Medicine" ///
2 "General Cardiology" ///
3 "Interventional Cardiology" ///
4 "ECHO" ///
5 "Electrophysiology" ///
6 "Heart Failure & Transplant" ///
7 "Nuclear Cardiologist"   ///
8 "Pediatric Cardiology"   ///
9 "Vascular Medicine"   ///
10 "MR / CT Cardiologist"   ///
11 "All of the Above"
label values postresid_cardio_cat postresid_cardio_cat

* Endocrinology
bys v1 v2: gen postresid_endo=v7 if v4=="Endoc 1"
label var postresid_endo "Did you do a post-residency Endocrinology?"
replace postresid_endo="1" if postresid_endo=="Y"
replace postresid_endo="0" if postresid_endo=="N"
destring postresid_endo, replace
label values postresid_endo yesno

bys v1 v2: gen postresid_endo_state=v7 if v4=="Endoc 1a"
label var postresid_endo_state "If yes to post-residency, what state (GEN.I.M Only)"
destring postresid_endo_state, replace
labelstates postresid_endo_state

bys v1 v2: gen postresid_endo_cat=v7 if v4=="Endoc 2"
label var postresid_endo_cat "Check which category of patient you'll see (GEN.I.M Only)"
destring postresid_endo_cat, replace
label define postresid_endo_cat ///
 1         "Internal Medicine"   ///
     2       "Adult Endocrinology"  /// 
     3         "Diabetes Mellitus"  ///
     4           "Thyroid Disease"  ///
     5   "Pediatric Endocrinology"  ///
     6          "All of the Above"  
label values postresid_endo_cat postresid_endo_cat

* Gastroenterology

bys v1 v2: gen postresid_gastro=v7 if v4=="Gastro 1"
label var postresid_gastro "Did you do a post-residency Endocrinology?"
replace postresid_gastro="1" if postresid_gastro=="Y"
replace postresid_gastro="0" if postresid_gastro=="N"
destring postresid_gastro, replace
label values postresid_gastro yesno

bys v1 v2: gen postresid_gastro_state=v7 if v4=="Gastro 1a"
label var postresid_gastro_state "If yes to post-residency, what state (GEN.I.M Only)"
destring postresid_gastro_state, replace
labelstates postresid_gastro_state

bys v1 v2: gen postresid_gastro_cat=v7 if v4=="Gastro 2"
label var postresid_gastro_cat "Check which category of patient you'll see (GEN.I.M Only)"
destring postresid_gastro_cat, replace
label define postresid_gastro_cat ///
 1       "Internal Medicine"  ///
     2        "Gastroenterology"   ///
     3                    "ERCP"   ///
     4              "Hepatology"   ///
     5              "Pediatrics"   ///
     6   "Endoscopic Ultrasound"  ///
     7        "All of the Above"  

 label values postresid_gastro_cat postresid_gastro_cat

* Genetics

bys v1 v2: gen postresid_gene=v7 if v4=="Genetic 1"
label var postresid_gene "Did you do a post-residency Endocrinology?"
replace postresid_gene="1" if postresid_gene=="Y"
replace postresid_gene="0" if postresid_gene=="N"
destring postresid_gene, replace
label values postresid_gene yesno

bys v1 v2: gen postresid_gene2=v7 if v4=="Genetic 1a"
label var postresid_gene2 "If yes, Which one?"
label define postresid_gene2 ///
1 "Clinical Genetics" ///
2 "Biochemical Genetics" ///
5 "Other"  
destring postresid_gene2, replace
label values postresid_gene2 postresid_gene2
* DOTHIS


bys v1 v2: gen postresid_gene_state=v7 if v4=="Genetic 1b"
label var postresid_gene_state "If yes to post-residency, what state (GEN.I.M Only)"
destring postresid_gene_state, replace
labelstates postresid_gene_state

bys v1 v2: gen postresid_gene_cat=v7 if v4=="Genetic 2"
label var postresid_gene_cat "Check which category of patient you'll see (GEN.I.M Only)"
destring postresid_gene_cat, replace
label define postresid_gene_cat ///
   1            "Prenatal Genetics"  /// 
     2               "Adult Genetics" ///  
     3              "Cancer Genetics" ///
     4         "Biochemical Genetics" ///  
     5           "Molecular Genetics" ///  
     6            "Internal Medicine" ///  
     7         "Chromosome Disorders" ///  
     8      "Neuromuscular Disorders" ///  
     9   "Developmental Delay/Autism" ///   
    10                "Dysmorphology" ///  
    11                 "Cytogenetics" ///  
    12                   "Pediatrics" ///  
    13             "All of the Above"
 label values postresid_gene_cat postresid_gene_cat

 
 
/* Now we need to convert the data into individual level observation, so
we need to drop duplicates and make sure we are not losing information
and putting it all horizontally */

duplicates drop v1 v2 v3 v6, force
keep v1 v2 v3 v4 v6 workinfl - postresid_gene_cat
tempfile temp1
save `temp1'

keep v1 v2 countiesx hoursinctyx
drop if countiesx==.
duplicates drop v1 v2 countiesx, force
bys v1 v2: gen h=_n
reshape wide countiesx hoursinctyx, i(v1 v2) j(h)
tempfile  temp2

save `temp2'

/*
use `temp1'
keep v1 v2  specialtyx  specialtypctx
drop if specialtyx==.
duplicates drop v1 v2 specialtyx, force
bys v1 v2: gen h=_n
reshape wide specialtyx specialtypctx, i(v1 v2) j(h)
tempfile  temp3
save `temp3'
*/
 

use `temp1'
drop countiesx  hoursinctyx specialtyx  specialtypctx 

* pick up labels before collapse
foreach v of var * {
	local l`v' : variable label `v'
    if `"`l`v''"' == "" {
 		local l`v' "`v'"
 	}
 }

*"
collapse workinfl - postresid_gene_cat, by(v1 v2)

* lay down labels after collapse
foreach v of var * {
	label var `v' "`l`v''"
}



merge 1:1 v1 v2 using `temp2'
drop _merge
merge 1:1 v1 v2 using `q6county2'
drop _merge
merge 1:1 v1 v2 using `q3speciality'
drop _merge
merge 1:1 v1 v2 using `q4speciality'
drop _merge

ren v1 docid1 
ren v2 docid2

gen year=2011
order doc* year
save "$wkfrc/WKFRC-2011/survey.wkfrc-2011clean.dta", replace

* =============  2012 Survey file================
* =============  2012 Survey file================
* =============  2012 Survey file================

use WKFRC-2012/survey.wkfrc-2012.dta, clear

* Q1
bys v1 v2: gen workinfl=v7 if v4=="Intro 1"
replace workinfl="1" if workinfl=="Y"
replace workinfl="0" if workinfl=="N"
destring workinfl, replace
label define yesno 1 "Yes" 0 "No"
label values workinfl yesno

* Q1a
bys v1 v2: gen whynotworkinfl10=v7 if v4=="Intro 1a"
replace whynotworkinfl10="1" if whynotworkinfl10=="A"
replace whynotworkinfl10="2" if whynotworkinfl10=="C"
replace whynotworkinfl10="3" if whynotworkinfl10=="D"
replace whynotworkinfl10="4" if whynotworkinfl10=="E"
replace whynotworkinfl10="5" if whynotworkinfl10=="F"
replace whynotworkinfl10="6" if whynotworkinfl10=="H"
replace whynotworkinfl10="7" if whynotworkinfl10=="I"
replace whynotworkinfl10="8" if whynotworkinfl10=="J"
destring whynotworkinfl10, replace
label define whynotworkinfl10 ///
1 "Retired" ///
2 "Malpractice Insurance Rate" ///
3 "Liability Exposure"  ///
4 "Medicare/Medicaid Reimbursement Rates" ///
5 "Private Health Plan Reimbursment Rates" ///
6 "Planning to move to Florida" ///
7 "Do not maintain a full-time residence in Florida" ///
8 "Other"
label values whynotworkinfl10 whynotworkinfl10

* Q1b
bys v1 v2: gen relocatetofl=v7 if v4=="Intro 1b"
replace relocatetofl="1" if relocatetofl=="A"
replace relocatetofl="2" if relocatetofl=="B"
replace relocatetofl="3" if relocatetofl=="C"
destring relocatetofl, replace
label define relocatetofl ///
1 "In 1-2 years" ///
2 "In 3-4 years" ///
3 "Do not plan to relocate" 
label values relocatetofl relocatetofl

* Q1c
bys v1 v2: gen speciality=v7 if v4=="Intro 1c Spec"
destring speciality, replace

* Q2
bys v1 v2: gen howmanymonths10=v7 if v4=="Question 2"
destring howmanymonths10, replace
label define q22010 ///
1 "1-2 Months" ///
2 "3-4 Months" ///
3 "5-6 Months" ///
4 "7-8 Month" ///
5 "9-10 Months" ///
6 "11-12 Months" 
label values howmanymonths10 q22010


* Q3

bys v1 v2: gen specialty=v7 if v4=="Q3 - Specialty"
destring specialty, replace
bys v1 v2: egen specialtyx=max(specialty)
drop specialty
label var specialtyx "Primary Speciality"

bys v1 v2 v6: gen specialtypct=v7 if v4=="Q3 - Hours"
replace specialtypct="1" if specialtypct=="A"
replace specialtypct="2" if specialtypct=="B"
replace specialtypct="3" if specialtypct=="C"
replace specialtypct="4" if specialtypct=="D"
replace specialtypct="5" if specialtypct=="E"
replace specialtypct="6" if specialtypct=="F"
destring specialtypct, replace
bys v1 v2 v6: egen specialtypctx=max(specialtypct)
label define q18b2009 ///
1 "0-10 Hrs/Wk" ///
2 "11-20 Hrs/Wk" ///
3 "21-29 Hrs/Wk" ///
4 "30-39 Hrs/Wk" ///
5 "40-49 Hrs/Wk" ///
6 "50 or More Hrs/Wk"
label values specialtypctx q18b2009
drop specialtypct
label var specialtypctx "Primary Speciality"

tempfile temp1
save `temp1'
keep v1 v2  specialtyx  specialtypctx
drop if specialtyx==.
duplicates drop v1 v2 specialtyx, force
bys v1 v2: gen h=_n
reshape wide specialtyx specialtypctx, i(v1 v2) j(h)
tempfile  q3speciality
save `q3speciality'

clear
use `temp1'

*Q4

bys v1 v2 v6: gen specialty2=v7 if v4=="Q4 - Specialty"
destring specialty2, replace
bys v1 v2 v6: egen specialtyx2=max(specialty2)
drop specialty2
label var specialtyx2 "Secondary Speciality"

bys v1 v2 v6: gen specialtypct2=v7 if v4=="Q4 - Hours"
replace specialtypct2="1" if specialtypct2=="A"
replace specialtypct2="2" if specialtypct2=="B"
replace specialtypct2="3" if specialtypct2=="C"
replace specialtypct2="4" if specialtypct2=="D"
replace specialtypct2="5" if specialtypct2=="E"
replace specialtypct2="6" if specialtypct2=="F"
destring specialtypct2, replace
bys v1 v2 v6: egen specialtypctx2=max(specialtypct2)
label values specialtypctx2 q18b2009
drop specialtypct2
label var specialtypctx2 "Secondary Speciality"

tempfile temp2
save `temp2'
keep v1 v2  specialtyx2  specialtypctx2
drop if specialtyx2==.
duplicates drop v1 v2 specialtyx2, force
bys v1 v2: gen h=_n
reshape wide specialtyx2 specialtypctx2, i(v1 v2) j(h)
tempfile  q4speciality
save `q4speciality'

clear
use `temp2'
drop specialtyx2

*Q5 
bys v1 v2: gen counties=v7 if v4=="Q5 - CountyZip"
destring counties, replace
bys v1 v2: egen countiesx=max(counties)
label var countiesx "Primary County"

label define countyfl ///
11 "Alachua" ///
12 "Baker" ///
13 "Bay" ///
14 "Bradford" ///
15 "Brevard" ///
16 "Broward" ///
17 "Calhoun" ///
18 "Charlotte" ///
19 "Citrus" ///
20 "Clay" ///
21 "Collier" ///
22 "Columbia" ///
23 "Dade" ///
24 "Desoto" ///
25 "Dixie" ///
26 "Duval" ///
27 "Escambia" ///
28 "Flagler" ///
29 "Franklin" ///
30 "Gadsden" ///
31 "Gilchrist" ///
32 "Glades" ///
33 "Gulf" ///
34 "Halmiton" ///
35 "Hardee" ///
36 "Hendry" ///
37 "Hernando" ///
38 "Highlands" ///
39 "Hillsborough" ///
40 "Holmes" /// 
41 "Indian River"   ///
42 "Jackson" ///
43 "Jefferson" ///
44 "LaFayette" ///
45 "Lake" ///
46 "Lee" ///
47 "Leon" ///
48 "Levy" ///
49 "Liberty" ///
50 "Madison" ///
51 "Manatee" ///
52 "Marion" ///
53 "Martin" /// 
54 "Monroe" ///
55 "Nassau" ///
56 "Okaloosa" ///
57 "Okeechobee" ///
58 "Orange" ///
59 "Osceola" ///
60 "Palm Beach" ///
61 "Pasco" ///
62 "Pinellas" ///
63 "Polk" ///
64 "Putnam" ///
65 "St. Johns" ///
66 "St. Lucie" ///
67 "Santa Rosa" ///
68 "Sarasota" ///
69 "Seminole" ///
70 "Sumter" ///
71 "Suwannee" ///
72 "Taylor" ///
73 "Union" ///
74 "Volusia" ///
75 "Wakulla" ///
76 "Walton" ///
77 "Washington" ///
78 "Unkonwn" ///
79 "Out of State" ///
80 "Foregin"
label values countiesx countyfl
  
 
bys v1 v2: gen hoursincty=v7 if v4=="Q5 - Hours"
destring hoursincty, replace
bys v1 v2: egen hoursinctyx=max(hoursincty)
drop counties hoursincty
label define q62009  ///
1 "1-10 Hrs/Wk" ///
2 "11-20 Hrs/Wk" ///
3 "21-29 Hrs/Wk" ///
4 " 30-39 Hrs/Wk" ///
5 "40-49 Hrs/Wk" ///
6 "50 or More Hrs/Wk"
label var hoursinctyx "Primary County Hours of Work"


* Q6
bys v1 v2 v6: gen counties2=v7 if v4=="Q6 - CountyZip"
destring counties2, replace
bys v1 v2 v6: egen countiesx2=max(counties2)
label var countiesx2 "Secondary Counties"
label values countiesx2 countyfl

bys v1 v2 v6: gen hoursincty2=v7 if v4=="Q6 - Hours"
destring hoursincty2, replace
bys v1 v2 v6: egen hoursinctyx2=max(hoursincty2)
drop counties2 hoursincty2
label var hoursinctyx2 "Primary County Hours of Work"

tempfile temp3
save `temp3'
keep v1 v2  countiesx2  hoursinctyx2
drop if countiesx2==.
duplicates drop v1 v2 countiesx2, force
bys v1 v2: gen h=_n
reshape wide countiesx2 hoursinctyx2, i(v1 v2) j(h)
tempfile  q6county2
save `q6county2'

clear
use `temp3'
drop countiesx2

* Q7

label define timespent ///
1 "0-5" ///
2 "6-10" ///
3 "11-15" ///
4 "16-20" ///
5 "21-25" ///
6 "26-30" ///
7 "31-35" ///
8 "36-40" ///
9 "41-45" ///
10 "46-50" ///
11 "51-54" ///
12 "55-60" ///
13 "61 or more" 


bys v1 v2: gen timespent1=v7 if v4=="Question 7a"
destring timespent1, replace
label var timespent1 "Time spend in Patient Care"
label values timespent1 timespent

* Q3b
bys v1 v2: gen timespent2=v7 if v4=="Question 7b"
destring timespent2, replace
label var timespent2 "Time spend in Administrative Matter"
label values timespent2 timespent

* Q3c
bys v1 v2: gen timespent3=v7 if v4=="Question 7c"
destring timespent3, replace
label var timespent3 "Time spend in Research and Teaching"
label values timespent3 timespent

*  Q8

label define howmanypatients ///
1 "0-25" ///
2 "26-50" ///
3 "51-75" ///
4 "76-100" ///
5 "101-125" ///
6 "126-150" ///
7 "151-175" ///
8 "176-200" ///
9 "201 or more" 


bys v1 v2: gen howmanypatients=v7 if v4=="Question 8"
destring howmanypatients, replace
label var howmanypatients "How many patients do you see per week?"

* Q9
label define q92012 ///
1 "Office Practice - Solo Practice" ///
2 "Office Practice - Group Practice - Single Specialty" ///
3 "Office Practice - Group Practice - Multi-Specialty" ///
4 "Federally Qualified Community Health Center" ///
5 "Nursing Home / Extended Care Facility" /// 
6 "Volunteer Free Clinic" ///
7 "Hospital - Hospital Based Physician (Non-Emergency)" ///
8 "Hospital - Other" ///
10 "County Health Department" ///
11 "Urgent Care Center"  ///
12 "Ambulatory Surgery Center" ///
13 "Hospital Emergency Room" ///
14 "Hospital - Outpatient Dept" ///
15 "Hospital - Hospitalist" ///
16 "Other"


bys v1 v2: gen mainpractice10=v7 if v4=="Question 9"
destring mainpractice10, replace
label var mainpractice10 "Majority of you practice occurs in?"

* Q10
bys v1 v2: gen employer10=v7 if v4=="Question 10"
destring employer10, replace
label var employer10 "If you are an employed physician, is your employer:"
label define q5a2012 ///
1 "Medical School or Parent University" ///
2 "Government Agency" ///
3 "Staff or Group HMO" ///
4 "None of the Above"
label values employer10  q5a2012

* Q11 (I'm skipping the second part of the question)
bys v1 v2: gen resfellow=v7 if v4=="Question 11"
replace resfellow="0" if resfellow=="N"
replace resfellow="1" if resfellow=="Y"
destring resfellow, replace
label values resfellow yesno

*Q12
label define q122012 ////
1 "No Debt" ///
2 "Less than 25K" ///
3 "More than 25K less  than 50K" /// 
4 "More than 50k less than 75K" ///
5 "More than 75K less than 100K" ///
6 "More than 100k less htan 125K" ///
7 "More than 125K less than 150K" ///
8 "150K or more"

bys v1 v2: gen medschooldebt=v7 if v4=="Question 12"
destring medschooldebt, replace
label var  medschooldebt "What was your total debt at the time of graduation from Medical School?"
label values medschooldebt q122012

* Q13

bys v1 v2: gen hosppriv1=v7 if v4=="Question 13"
replace hosppriv1="1" if hosppriv1=="N"
replace hosppriv1="0" if hosppriv1=="Y"
destring hosppriv1, replace
label values hosppriv1 yesno
label var hosppriv1 "Do you have hospital privileges?"

bys v1 v2: gen hosppriv2=v7 if v4=="Question 13a"
destring hosppriv2, replace
label var hosppriv2 "If you have hospital privileges, how many hospitals?"

bys v1 v2: gen hosppriv3=v7 if v4=="Question 13b"
replace hosppriv3="1" if hosppriv3=="N"
replace hosppriv3="0" if hosppriv3=="Y"
destring hosppriv3, replace
label values hosppriv3 yesno
label var hosppriv3 "If no, is the decision to not have hospital privileges voluntary?"

* Q14 (I am going to ignore subquestions by q14)
bys v1 v2: gen takeERcalls10=v7 if v4=="Question 14"
replace takeERcalls10="1" if takeERcalls10=="A"
replace takeERcalls10="0" if takeERcalls10=="B"
destring takeERcalls10, replace
label define takeERcalls10  1 "Yes" 0 "No" 
label values takeERcalls10 takeERcalls10
label var takeERcalls10 "Do you provide on-call emergency room coverage (NOT Emergency Department Physician)?"

* Q15
bys v1 v2: gen traumacalls1=v7 if v4=="Question 15"
replace traumacalls1="0" if traumacalls1=="N"
replace traumacalls1="1" if traumacalls1=="Y"
destring traumacalls1, replace
label values traumacalls1 yesno
label var traumacalls1 "Do you take trauma call, or attend to trauma patients, at a verified trauma center?"

*Q15a
label define q15a2012 ///
1 "Level I" ///
2 "Level II" ///
3 "Pediatric" ///
4 "More than one of the above"

bys v1 v2: gen traumacalls2=v7 if v4=="Question 15a"
replace traumacalls2="1" if traumacalls2=="A"
replace traumacalls2="2" if traumacalls2=="B"
replace traumacalls2="3" if traumacalls2=="C"
replace traumacalls2="4" if traumacalls2=="D"
destring traumacalls2, replace
label var traumacalls2 "If yes, which type?"

*Q16
bys v1 v2: gen newmedicare=v7 if v4=="Question 16"
replace newmedicare="0" if newmedicare=="N"
replace newmedicare="1" if newmedicare=="Y"
destring newmedicare, replace
label values newmedicare yesno
label var newmedicare "Are you currently accepting new Medicare patients in your practice?"

*Q16a
bys v1 v2: gen newmedicare_q16a=v7 if v4=="Question 16a"
replace newmedicare_q16a="1" if newmedicare_q16a=="A"
replace newmedicare_q16a="2" if newmedicare_q16a=="B"
replace newmedicare_q16a="3" if newmedicare_q16a=="C"
replace newmedicare_q16a="4" if newmedicare_q16a=="D"
replace newmedicare_q16a="5" if newmedicare_q16a=="E"
replace newmedicare_q16a="6" if newmedicare_q16a=="F"
destring newmedicare_q16a, replace
label define newmedicare_q16a ///
1 "Low Compensation" ///
2 "Billing Requirements" ///
3 "Too Much Paperwork" ///
4 "Practice is at full capacity" ///
5 "Concerned about Fraud Issues" ///
6 "Other" 
label values newmedicare_q16a newmedicare_q16a

*Q17 
bys v1 v2: gen newmedicaid=v7 if v4=="Question 17"
replace newmedicaid="0" if newmedicaid=="N"
replace newmedicaid="1" if newmedicaid=="Y"
destring newmedicaid, replace
label values newmedicaid yesno
label var newmedicaid "Are you currently accepting new pateints covered by Medicaid?"

bys v1 v2: gen newmedicaid_q17a=v7 if v4=="Question 17a"
replace newmedicaid_q17a="1" if newmedicaid_q17a=="A"
replace newmedicaid_q17a="2" if newmedicaid_q17a=="B"
replace newmedicaid_q17a="3" if newmedicaid_q17a=="C"
replace newmedicaid_q17a="4" if newmedicaid_q17a=="D"
replace newmedicaid_q17a="5" if newmedicaid_q17a=="E"
replace newmedicaid_q17a="6" if newmedicaid_q17a=="F"
destring newmedicaid_q17a, replace

label define newmedicaid_q17a ///
1 "Low Compensation" ///
2 "Billing Requirements" ///
3 "Too Much Paperwork" ///
4 "Practice is at full capacity" ///
5 "Concerned about Fraud Issues" ///
6 "Other" 
label values newmedicaid_q17a newmedicaid_q17a

*Q18
bys v1 v2: gen retireish=v7 if v4=="Question 18"
replace retireish="1" if retireish=="Y"
replace retireish="0" if retireish=="N"
destring retireish, replace
label values retireish yesno
label var retireish "Do you plan to retire in the next 5 years?"

*Q18a
bys v1 v2: gen retirewhy=v7 if v4=="Question 18a"
destring retirewhy, replace
label var retirewhy "If yes, the main reason for retiring?"
replace retirewhy="1" if retirewhy=="A"
replace retirewhy="2" if retirewhy=="B"
replace retirewhy="3" if retirewhy=="C"
replace retirewhy="4" if retirewhy=="D"
replace retirewhy="5" if retirewhy=="E"
replace retirewhy="6" if retirewhy=="F"
replace retirewhy="7" if retirewhy=="H"
replace retirewhy="8" if retirewhy=="J"
destring retirewhy, replace
label define Q18a2012 ///
1 "Time to retire" ///
2 "Family" /// 
3 "Compensation" ///
4 "Malpractice Insurance Rates" ///
5 "Liability Exposure" ///
6 "Medicare/Medicaid Reimbursement Rates" ///
7 "Private Health Plan Reimbursement Rates" ///
8 "Other" 
label values retirewhy Q18a2012

* Q18b
bys v1 v2: gen retirewhy_q18b=v7 if v4=="Question 18b"
label var retirewhy_q18b "If yes, do you plan to have a limited license for volunteering?"
replace retirewhy_q18b="1" if retirewhy_q18b=="Y"
replace retirewhy_q18b="0" if retirewhy_q18b=="N"
destring retirewhy_q18b, replace
label values retirewhy_q18b yesno

*Q19
bys v1 v2: gen movein5yrs=v7 if v4=="Question 19"
replace movein5yrs="1" if movein5yrs=="Y"
replace movein5yrs="0" if movein5yrs=="N"
destring movein5yrs, replace
label values movein5yrs yesno
label var movein5yrs "Do you plan to move to work in another state in the next 5 years?"

* Q19a
bys v1 v2: gen whymovein5yrs=v7 if v4=="Question 19a"
label var whymovein5yrs "Main Reason to move?"
replace whymovein5yrs="1" if whymovein5yrs=="A"
replace whymovein5yrs="2" if whymovein5yrs=="B"
replace whymovein5yrs="3" if whymovein5yrs=="C"
replace whymovein5yrs="4" if whymovein5yrs=="D"
replace whymovein5yrs="5" if whymovein5yrs=="E"
replace whymovein5yrs="6" if whymovein5yrs=="G"
replace whymovein5yrs="7" if whymovein5yrs=="H"
replace whymovein5yrs="8" if whymovein5yrs=="I"
replace whymovein5yrs="9" if whymovein5yrs=="J"
destring whymovein5yrs, replace
label define q19a2009 ///
1 "Family" ///
2 "Compensation" ///
3 "Malpractice Insurance Rate" ///
4 "Liability Exposure" ///
5 "Medicare/Medicaid Reimbursement Rates" ///
6 "Private Health Plan Reimbursement Rates" ///
7 "Looking for a change" ///
8 "Education-training in another state" ///
9 "Other"
label values whymovein5yrs  q19a2009

* Q20
bys v1 v2: gen changespec=v7 if v4=="Question 20"
replace changespec="1" if changespec=="Y"
replace changespec="0" if changespec=="N"
destring changespec, replace
label values changespec yesno
label var changespec "Do you plan to change your speciality in the next 5 years?"

* Q20a
bys v1 v2: gen changespec_why=v7 if v4=="Question 20a"
label var changespec_why "If yes, the main reason for changing your speciality"
replace changespec_why="1" if changespec_why=="A"
replace changespec_why="2" if changespec_why=="B"
replace changespec_why="3" if changespec_why=="C"
replace changespec_why="4" if changespec_why=="D"
replace changespec_why="5" if changespec_why=="E"
replace changespec_why="6" if changespec_why=="F"
replace changespec_why="7" if changespec_why=="G"
replace changespec_why="8" if changespec_why=="H"
replace changespec_why="9" if changespec_why=="I"
destring changespec_why, replace
  
label define q20a2009 ///
1 "Family" ///
2 "Malpractice Insurance Rates" ///
3 "Liability Exposure" ///
4 "Medicare/Medicaid Reimbursement Rates" ///
5 "Private Health Plan Reimbursement Rates" ///
6 "Compensation" ///
7 "Education/training in another state" ///
8 "Potential for Higher Compensation" ///
9 "Other"

* ---End of Core Questionnarie --- Now onto speciality questions

*Q General Internal Medicine
bys v1 v2: gen postresidfellow=v7 if v4=="Gen IM 1"
label var postresidfellow "Did you do a post-residency fellowship? For General Internal Medicine Only"
replace postresidfellow="1" if postresidfellow=="Y"
replace postresidfellow="0" if postresidfellow=="N"
destring postresidfellow, replace
label values postresidfellow yesno

bys v1 v2: gen postresidfellow_state=v7 if v4=="Gen IM 1a"
label var postresidfellow_state "If yes to post-residency Fellow, what state (GEN.I.M Only)"
destring postresidfellow_state, replace
labelstates postresidfellow_state

bys v1 v2: gen postresidfellow_cat=v7 if v4=="Gen IM 2"
label var postresidfellow_cat "Check which category of patient you'll see (GEN.I.M Only)"
destring postresidfellow_cat, replace
label define postresidfellow_cat ///
1 "Internal Medicine" ///
2 "Geriatrics" ///
3 "Women's Health" ///
4 "Pediatrics Care" ///
5 "In-Hospital Care" ///
6 "Your sub-specialty" ///
7 "All of the Above"
label values postresidfellow_cat postresidfellow_cat

* Allergy Immunology
bys v1 v2: gen postresid_allergy=v7 if v4=="Allergy/Imm 1"
label var postresid_allergy "Did you do a post-residency Allergy/Immunology fellowship?"
replace postresid_allergy="1" if postresid_allergy=="Y"
replace postresid_allergy="0" if postresid_allergy=="N"
destring postresid_allergy, replace
label values postresid_allergy yesno

bys v1 v2: gen postresid_allergy_state=v7 if v4=="Allergy/Imm 1a"
label var postresid_allergy_state "If yes to post-residency, what state (GEN.I.M Only)"
destring postresid_allergy_state, replace
labelstates postresid_allergy_state

bys v1 v2: gen postresid_allergy_cat=v7 if v4=="Allergy/Imm 2"
label var postresid_allergy_cat "Check which category of patient you'll see (GEN.I.M Only)"
destring postresid_allergy_cat, replace
label define postresid_allergy_cat ///
1 "Internal Medicine" ///
2 "Adult Asthma" ///
3 "Childhood Asthma" ///
4 "Allergic Rhinitis" ///
5 "Allergic Skin Disease" ///
6 "Immune Deficiency" ///
7 "Food/Insect/Drug Allergy" ///
8 "All of the Above"
label values postresid_allergy_cat postresid_allergy_cat

bys v1 v2: gen postresid_cardio=v7 if v4=="Cardio 1"
label var postresid_cardio "Did you do a post-residency Cardiology fellowship?"
replace postresid_cardio="1" if postresid_cardio=="Y"
replace postresid_cardio="0" if postresid_cardio=="N"
destring postresid_cardio, replace
label values postresid_cardio yesno

bys v1 v2: gen postresid_cardio_state=v7 if v4=="Cardio 1a"
label var postresid_cardio_state "If yes to post-residency, what state (GEN.I.M Only)"
destring postresid_cardio_state, replace
labelstates postresid_cardio_state

bys v1 v2: gen postresid_cardio_sub=v7 if v4=="Cardio 2"
label var postresid_cardio_sub "Did you do a Cardiology Sub-specialty fellowship?"
replace postresid_cardio_sub="1" if postresid_cardio_sub=="Y"
replace postresid_cardio_sub="0" if postresid_cardio_sub=="N"
destring postresid_cardio_sub, replace
label values postresid_cardio_sub yesno

bys v1 v2: gen postresid_cardio_area=v7 if v4=="Cardio 2a"
label var postresid_cardio_area "Yes, In which area (please check only one)"
destring postresid_cardio_area, replace
label define postresid_cardio_area ///
1 "General Clinical Cardiologist" ///
2 "Interventional Cardiologist" ///
3 "Echocardiologist (Echocardiographer)"   ///
4 "Electrophysiologist" ///
5 "Nuclear Cardiologist"   ///
6 "MR / CT Cardiologist"   ///
7 "Heart Failure & Transplant Cardiologist" ///
8 "Preventive Cardiologist"   ///
9 "Vascular Medicine Specialist"  /// 
10 "Cardiovascular Investigator"  ///
11 "Other"  
label values postresid_cardio_area postresid_cardio_area

bys v1 v2: gen postresid_cardio_areast=v7 if v4=="Cardio 2b"
label var postresid_cardio_areast "If yes to post-residency, what state (GEN.I.M Only)"
destring postresid_cardio_areast, replace
labelstates postresid_cardio_areast

bys v1 v2: gen postresid_cardio_cat=v7 if v4=="Cardio 3"
label var postresid_cardio_cat "Check which category of patient you'll see (GEN.I.M Only)"
destring postresid_cardio_cat, replace
label define postresid_cardio_cat ///
1 "Internal Medicine" ///
2 "General Cardiology" ///
3 "Interventional Cardiology" ///
4 "ECHO" ///
5 "Electrophysiology" ///
6 "Heart Failure & Transplant" ///
7 "Nuclear Cardiologist"   ///
8 "Pediatric Cardiology"   ///
9 "Vascular Medicine"   ///
10 "MR / CT Cardiologist"   ///
11 "All of the Above"
label values postresid_cardio_cat postresid_cardio_cat

* Endocrinology
bys v1 v2: gen postresid_endo=v7 if v4=="Endoc 1"
label var postresid_endo "Did you do a post-residency Endocrinology?"
replace postresid_endo="1" if postresid_endo=="Y"
replace postresid_endo="0" if postresid_endo=="N"
destring postresid_endo, replace
label values postresid_endo yesno

bys v1 v2: gen postresid_endo_state=v7 if v4=="Endoc 1a"
label var postresid_endo_state "If yes to post-residency, what state (GEN.I.M Only)"
destring postresid_endo_state, replace
labelstates postresid_endo_state

bys v1 v2: gen postresid_endo_cat=v7 if v4=="Endoc 2"
label var postresid_endo_cat "Check which category of patient you'll see (GEN.I.M Only)"
destring postresid_endo_cat, replace
label define postresid_endo_cat ///
 1         "Internal Medicine"   ///
     2       "Adult Endocrinology"  /// 
     3         "Diabetes Mellitus"  ///
     4           "Thyroid Disease"  ///
     5   "Pediatric Endocrinology"  ///
     6          "All of the Above"  
label values postresid_endo_cat postresid_endo_cat

* Gastroenterology

bys v1 v2: gen postresid_gastro=v7 if v4=="Gastro 1"
label var postresid_gastro "Did you do a post-residency Endocrinology?"
replace postresid_gastro="1" if postresid_gastro=="Y"
replace postresid_gastro="0" if postresid_gastro=="N"
destring postresid_gastro, replace
label values postresid_gastro yesno

bys v1 v2: gen postresid_gastro_state=v7 if v4=="Gastro 1a"
label var postresid_gastro_state "If yes to post-residency, what state (GEN.I.M Only)"
destring postresid_gastro_state, replace
labelstates postresid_gastro_state

bys v1 v2: gen postresid_gastro_cat=v7 if v4=="Gastro 2"
label var postresid_gastro_cat "Check which category of patient you'll see (GEN.I.M Only)"
destring postresid_gastro_cat, replace
label define postresid_gastro_cat ///
 1       "Internal Medicine"  ///
     2        "Gastroenterology"   ///
     3                    "ERCP"   ///
     4              "Hepatology"   ///
     5              "Pediatrics"   ///
     6   "Endoscopic Ultrasound"  ///
     7        "All of the Above"  

 label values postresid_gastro_cat postresid_gastro_cat

* Genetics

bys v1 v2: gen postresid_gene=v7 if v4=="Genetic 1"
label var postresid_gene "Did you do a post-residency Endocrinology?"
replace postresid_gene="1" if postresid_gene=="Y"
replace postresid_gene="0" if postresid_gene=="N"
destring postresid_gene, replace
label values postresid_gene yesno

bys v1 v2: gen postresid_gene2=v7 if v4=="Genetic 1a"
label var postresid_gene2 "If yes, Which one?"
label define postresid_gene2 ///
1 "Clinical Genetics" ///
2 "Biochemical Genetics" ///
5 "Other"  
destring postresid_gene2, replace
label values postresid_gene2 postresid_gene2
* DOTHIS


bys v1 v2: gen postresid_gene_state=v7 if v4=="Genetic 1b"
label var postresid_gene_state "If yes to post-residency, what state (GEN.I.M Only)"
destring postresid_gene_state, replace
labelstates postresid_gene_state

bys v1 v2: gen postresid_gene_cat=v7 if v4=="Genetic 2"
label var postresid_gene_cat "Check which category of patient you'll see (GEN.I.M Only)"
destring postresid_gene_cat, replace
label define postresid_gene_cat ///
   1            "Prenatal Genetics"  /// 
     2               "Adult Genetics" ///  
     3              "Cancer Genetics" ///
     4         "Biochemical Genetics" ///  
     5           "Molecular Genetics" ///  
     6            "Internal Medicine" ///  
     7         "Chromosome Disorders" ///  
     8      "Neuromuscular Disorders" ///  
     9   "Developmental Delay/Autism" ///   
    10                "Dysmorphology" ///  
    11                 "Cytogenetics" ///  
    12                   "Pediatrics" ///  
    13             "All of the Above"
 label values postresid_gene_cat postresid_gene_cat

 
 
/* Now we need to convert the data into individual level observation, so
we need to drop duplicates and make sure we are not losing information
and putting it all horizontally */

duplicates drop v1 v2 v3 v6, force
keep v1 v2 v3 v4 v6 workinfl - postresid_gene_cat
tempfile temp1
save `temp1'

keep v1 v2 countiesx hoursinctyx
drop if countiesx==.
duplicates drop v1 v2 countiesx, force
bys v1 v2: gen h=_n
reshape wide countiesx hoursinctyx, i(v1 v2) j(h)
tempfile  temp2

save `temp2'

/*
use `temp1'
keep v1 v2  specialtyx  specialtypctx
drop if specialtyx==.
duplicates drop v1 v2 specialtyx, force
bys v1 v2: gen h=_n
reshape wide specialtyx specialtypctx, i(v1 v2) j(h)
tempfile  temp3
save `temp3'
*/
 

use `temp1'
drop countiesx  hoursinctyx specialtyx  specialtypctx 

* pick up labels before collapse
foreach v of var * {
	local l`v' : variable label `v'
    if `"`l`v''"' == "" {
 		local l`v' "`v'"
 	}
 }

*"
collapse workinfl - postresid_gene_cat, by(v1 v2)

* lay down labels after collapse
foreach v of var * {
	label var `v' "`l`v''"
}



merge 1:1 v1 v2 using `temp2'
drop _merge
merge 1:1 v1 v2 using `q6county2'
drop _merge
merge 1:1 v1 v2 using `q3speciality'
drop _merge
merge 1:1 v1 v2 using `q4speciality'
drop _merge

ren v1 docid1 
ren v2 docid2

gen year=2012
order doc* year
save "$wkfrc/WKFRC-2012/survey.wkfrc-2012clean.dta", replace

* =============  2013 Survey file================
* =============  2013 Survey file================
* =============  2013 Survey file================

use "$wkfrc/WKFRC-2013/survey.wkfrc-2013.dta", clear

* Q1
bys v1 v2: gen workinfl=v7 if v4=="Intro 1"
replace workinfl="1" if workinfl=="Y"
replace workinfl="0" if workinfl=="N"
destring workinfl, replace
label define yesno 1 "Yes" 0 "No"
label values workinfl yesno

* Q1-2
bys v1 v2: gen howmanymonths13=v7 if v4=="Question 2"
destring howmanymonths13, replace
label define q22013 ///
1 "1-2 Months" ///
2 "3-4 Months" ///
3 "5-6 Months" ///
4 "7-8 Month" ///
5 "9-10 Months" ///
6 "11-12 Months" 
label values howmanymonths13 q22013


* Q1a
bys v1 v2: gen whynotworkinfl10=v7 if v4=="Intro 1a"
replace whynotworkinfl10="1" if whynotworkinfl10=="A"
replace whynotworkinfl10="2" if whynotworkinfl10=="C"
replace whynotworkinfl10="3" if whynotworkinfl10=="D"
replace whynotworkinfl10="4" if whynotworkinfl10=="E"
replace whynotworkinfl10="5" if whynotworkinfl10=="F"
replace whynotworkinfl10="6" if whynotworkinfl10=="H"
replace whynotworkinfl10="7" if whynotworkinfl10=="G"
replace whynotworkinfl10="8" if whynotworkinfl10=="I"
replace whynotworkinfl10="9" if whynotworkinfl10=="J"
destring whynotworkinfl10, replace
label define whynotworkinfl10 ///
1 "Retired" ///
2 "Malpractice Insurance Rate" ///
3 "Liability Exposure"  ///
4 "Medicare/Medicaid Reimbursement Rates" ///
5 "Private Health Plan Reimbursment Rates" ///
6 "Planning to move to Florida" ///
7 "Do not maintain a full-time residence in Florida" ///
8 "Other"
label values whynotworkinfl10 whynotworkinfl10

* Q1b
bys v1 v2: gen relocatetofl=v7 if v4=="Intro 1b"
replace relocatetofl="1" if relocatetofl=="A"
replace relocatetofl="2" if relocatetofl=="B"
replace relocatetofl="3" if relocatetofl=="C"
destring relocatetofl, replace
label define relocatetofl ///
1 "In 1-2 years" ///
2 "In 3-4 years" ///
3 "Do not plan to relocate" 
label values relocatetofl relocatetofl

* Q1c
bys v1 v2: gen speciality=v7 if v4=="Intro 1c Spec"
destring speciality, replace
label var speciality "Primary Speciality for people not working in FL"


* Q2 Are you currently enorlled in an intership, residency or fellowship program?
bys v1 v2: gen resfellow=v7 if v4=="Question 3"
replace resfellow="0" if resfellow=="N"
replace resfellow="1" if resfellow=="Y"
destring resfellow, replace
label values resfellow yesno
	
	* Q2a
	bys v1 v2: gen res_specialty=v7 if v4=="Q3a-Specialty"
	destring res_specialty, replace
	label var res_specialty "q3 Residency Primary Speciality"
	
	* Q2b
	bys v1 v2: gen res_year=v7 if v4=="Q3a-Year" 
	destring res_year, replace
	label var res_year "Post-Graduate Year? for Res/Fellow"
	label define res_year ///
	1 "PGY1" ///
	2 "PGY2" ///
	3 "PGY3" ///
	4 "PGY4" ///
	5 "PGY5" ///
	6 "PGY6" ///
	7 "PGY7"
	label values res_year res_year

* Q3 County 
bys v1 v2: gen counties=v7 if v4=="Q4 - County"
destring counties, replace
label var counties "Primary County"
	
	* Q3a Zip
	bys v1 v2: gen zipcode=v7 if v4=="Q4b - Zip"
	destring zipcode, replace
	label var zipcode "Primary Zip Code1"
	
	* Q5  on this location, how many hours do you spend on
	bys v1 v2: gen timespent1=v7 if v4=="Q5-Patient Care"
	destring timespent1, replace
	label var timespent1 "Time spend in Patient Care"
	label values timespent1 timespent
	
	* Q6
	bys v1 v2: gen timespent2=v7 if v4=="Q5b-AdminMatter"
	destring timespent2, replace
	label var timespent2 "Time spend in Administrative Matter"
	label values timespent2 timespent
	
	* Q7
	bys v1 v2: gen timespent3=v7 if v4=="Q5c-Research"
	destring timespent3, replace
	label var timespent3 "Time spend in Research and Teaching"
	label values timespent3 timespent
	
* Q8-Avg Patients
	bys v1 v2: gen howmanypatients=v7 if v4=="Q6-Avg Patients"
	destring howmanypatients, replace
	label var howmanypatients "How many patients do you see per week in this location?"

* Q9
label define q92012 ///
1 "Office Practice - Solo Practice" ///
2 "Office Practice - Group Practice - Single Specialty" ///
3 "Office Practice - Group Practice - Multi-Specialty" ///
4 "Federally Qualified Community Health Center" ///
5 "Nursing Home / Extended Care Facility" /// 
6 "Volunteer Free Clinic" ///
7 "Hospital - Hospital Based Physician (Non-Emergency)" ///
8 "Hospital - Other" ///
10 "County Health Department" ///
11 "Urgent Care Center"  ///
12 "Ambulatory Surgery Center" ///
13 "Hospital Emergency Room" ///
14 "Hospital - Outpatient Dept" ///
15 "Hospital - Hospitalist" ///
16 "Other"

bys v1 v2: gen mainpractice10=v7 if v4=="Question 7"
destring mainpractice10, replace
label var mainpractice10 "Majority of you practice occurs in?"
label values mainpractice10 q92012

* Q10
bys v1 v2: gen employer10=v7 if v4=="Question 8"
destring employer10, replace
label var employer10 "If you are an employed physician, is your employer:"
label define q5a2013 ///
1 "Medical School or Parent University" ///
2 "Government Agency" ///
3 "Staff or Group HMO" ///
4 "Other"
label values employer10  q5a2013

* Q11- Q12
bys v1 v2: gen specialty=v7 if v4=="Q9 Specialty"
destring specialty, replace
label var specialty "Primary Speciality"

bys v1 v2: gen specialtypct=v7 if v4=="Q9b-Pct Primary"
destring specialtypct, replace
label var specialtypct "percent of patient care at this primary location involving primary specialty"

* Q13-Q14 - Second Specialty
bys v1 v2: gen specialty2=v7 if v4=="Q10 - Specialty"
destring specialty2, replace
label var specialty2 "Secondary Speciality in Primary Location"

bys v1 v2: gen specialtypct2=v7 if v4=="Q10b - Pct"
destring specialtypct2, replace
label var specialtypct2 "percent of patient care at primary location involving secondary specialty"

* Q15-Q16 - Third Specialty
bys v1 v2: gen specialty3=v7 if v4=="Q11 - Specialty"
destring specialty3, replace
label var specialty3 "Third Speciality in Primary Location"

bys v1 v2: gen specialtypct3=v7 if v4=="Q11b - Pct Alt2"
destring specialtypct3, replace
label var specialtypct3 "Percent of patient care at primary location involving third specialty"

* Q17-Q21 - Other locations information: Second Location 
	bys v1 v2: gen counties2=v7 if v4=="Q13 - County"
	destring counties2, replace
	label var counties2 "Secondary County"
	
	*Zip
	bys v1 v2: gen zipcode2=v7 if v4=="Q13b - Zip"
	destring zipcode2, replace
	label var zipcode2 "Secondary Zip Code"

	* Hours with Patients 
	bys v1 v2: gen hours2=v7 if v4=="Q14 - Hours"
	destring hours2, replace
	label var hours2 "Patient Care hours per week at 2nd location"
	
	* Avg number of patients per week
	bys v1 v2: gen howmanypatients2=v7 if v4=="Q15 - Patients"
	destring howmanypatients2, replace
	label var howmanypatients2 "Average number of patients seen per week at 2nd location"
		
	* Primary Speciality at second location
	bys v1 v2: gen specialty_2ndloc=v7 if v4=="Q16 - Specialty"
	destring specialty_2ndloc, replace
	label var specialty_2ndloc "Primary Specialty in Second Location"

* Q22-Q26- Other locations informatio: Third Location 

	bys v1 v2: gen counties3=v7 if v4=="Q17 - County"
	destring counties3, replace
	label var counties3 "Third County"
	
	*Zip
	bys v1 v2: gen zipcode3=v7 if v4=="Q17b - Zip"
	destring zipcode3, replace
	label var zipcode3 "Third Zip Code"

	* Hours with Patients 
	bys v1 v2: gen hours3=v7 if v4=="Q18 - Hours"
	destring hours3, replace
	label var hours3 "Patient Care hours per week at 3rd location"
	
	* Avg number of patients per week
	bys v1 v2: gen howmanypatients3=v7 if v4=="Q19 - Patients"
	destring howmanypatients3, replace
	label var howmanypatients3 "Average number of patients seen per week at 3rd location"
		
	* Primary Speciality at Third location
	bys v1 v2: gen specialty_3ndloc=v7 if v4=="Q20 - Specialty"
	destring specialty_3ndloc, replace
	label var specialty_3ndloc "Primary Specialty in Third Location"
	
* ##Hospital Care Questions##

*Q27
	bys v1 v2: gen hosppriv2=v7 if v4=="Question 13a"
	destring hosppriv2, replace
	label define hosppriv2 ///
	1 "1" ///
	2 "2" ///
	3 "3" ///
	4 "4 or more"
	label values hosppriv2 hosppriv2	
	label var hosppriv2 "If you have hospital privileges, how many hospitals?"

*Q28 

	bys v1 v2: gen numhosp_takeERcalls=v7 if v4=="Question 14a"
	destring numhosp_takeERcalls, replace
	label define numhosp_takeERcalls ///
	1 "1" ///
	2 "2" ///
	3 "3" ///
	4 "4 or more"
	label values numhosp_takeERcalls numhosp_takeERcalls		
	label var numhosp_takeERcalls "At how many individual hospitals do you provide on-call emergency room coverage?"

*Q29
	bys v1 v2: gen days_takeERcalls=v7 if v4=="Question 14b"
	destring days_takeERcalls, replace
	label var days_takeERcalls "How many total days per month do you take emergency call?"

* Q30 
	bys v1 v2: gen ERcalls5=v7 if v4=="Question 14c"
	replace ERcalls5="1" if ERcalls5=="A"
	replace ERcalls5="2" if ERcalls5=="B"
	replace ERcalls5="3" if ERcalls5=="C"
	label define ERcalls5 1 "Increased" 2 "Decreased" 3 "Stayed the Same"
	destring ERcalls5, replace
	label values ERcalls5 ERcalls5
	label var ERcalls5 "During the past 2 years, has the number of emergency on-call days"

* Q31
	bys v1 v2: gen decrease_ERcalls5=v7 if v4=="Question 14d"
	destring decrease_ERcalls5, replace
	label define decrease_ERcalls5 ///
	1 "Retired" ///
    2 "Lifestyle Considerations"   ///
    3 "Compensation"   ///
    4 "Malpractice Insurance Rates"   ///
    5 "Liability Exposure"   ///
    6 "Work in an Urgent Care Clinic"   ///
    7 "Medicare/Medicaid Reimbursement Rates"   ///
    8 "Private Health Plan Reimbursement Rates" ///
    9 "Other"
	label values decrease_ERcalls5 decrease_ERcalls5
	label var decrease_ERcalls5 "If you are decreasing your on-call days, what is the main reason?"

* Q32
	label define q15a2012 ///
	1 "Level I" ///
	2 "Level II" ///
	3 "Pediatric" ///
	4 "More than one of the above"

	bys v1 v2: gen traumacalls2=v7 if v4=="Question 15a"
	replace traumacalls2="1" if traumacalls2=="A"
	replace traumacalls2="2" if traumacalls2=="B"
	replace traumacalls2="3" if traumacalls2=="C"
	replace traumacalls2="4" if traumacalls2=="D"
	destring traumacalls2, replace
	label var traumacalls2 "At which type of verified trauma center do you take trauma call or attend to trauma patients?"

	*Q16(New medicaid questions that is not in 2013)
bys v1 v2: gen newmedicare=v7 if v4=="Question 16"
replace newmedicare="0" if newmedicare=="N"
replace newmedicare="1" if newmedicare=="Y"
destring newmedicare, replace
label values newmedicare yesno
label var newmedicare "Are you currently accepting new Medicare patients in your practice?"


* Q33 
	bys v1 v2: gen newmedicare_q16a=v7 if v4=="Question 16a"
	replace newmedicare_q16a="1" if newmedicare_q16a=="A"
	replace newmedicare_q16a="2" if newmedicare_q16a=="B"
	replace newmedicare_q16a="3" if newmedicare_q16a=="C"
	replace newmedicare_q16a="4" if newmedicare_q16a=="D"
	replace newmedicare_q16a="5" if newmedicare_q16a=="E"
	replace newmedicare_q16a="6" if newmedicare_q16a=="F"
	destring newmedicare_q16a, replace
	label define newmedicare_q16a ///
	1 "Low Compensation" ///
	2 "Billing Requirements" ///
	3 "Too Much Paperwork" ///
	4 "Practice is at full capacity" ///
	5 "Concerned about Fraud Issues" ///
	6 "Other" 
	label values newmedicare_q16a newmedicare_q16a
	label var newmedicare_q16a "What is the main reason you are NOT currently accepting new Medicare patients in your practice?"
	notes newmedicare_q16a: If its not applicable then we don't have any information.

* Q17  (New medicaid questions that is not in 2013)
bys v1 v2: gen newmedicaid=v7 if v4=="Question 17"
replace newmedicaid="0" if newmedicaid=="N"
replace newmedicaid="1" if newmedicaid=="Y"
destring newmedicaid, replace
label values newmedicaid yesno
label var newmedicaid "Are you currently accepting new pateints covered by Medicaid?"



* Q34 

bys v1 v2: gen newmedicaid_q17a=v7 if v4=="Question 17a"
replace newmedicaid_q17a="1" if newmedicaid_q17a=="A"
replace newmedicaid_q17a="2" if newmedicaid_q17a=="B"
replace newmedicaid_q17a="3" if newmedicaid_q17a=="C"
replace newmedicaid_q17a="4" if newmedicaid_q17a=="D"
replace newmedicaid_q17a="5" if newmedicaid_q17a=="E"
replace newmedicaid_q17a="6" if newmedicaid_q17a=="F"
destring newmedicaid_q17a, replace

label define newmedicaid_q17a ///
1 "Low Compensation" ///
2 "Billing Requirements" ///
3 "Too Much Paperwork" ///
4 "Practice is at full capacity" ///
5 "Concerned about Fraud Issues" ///
6 "Other" 
label values newmedicaid_q17a newmedicaid_q17a
label var newmedicaid_q17a "What is the main reason you are NOT currently accepting new Medicaid patients in your practice?"
notes newmedicaid_q17a: If its not applicable then we don't have any information.


* Q35
bys v1 v2: gen retireish=v7 if v4=="Question 18"
replace retireish="1" if retireish=="Y"
replace retireish="0" if retireish=="N"
destring retireish, replace
label values retireish yesno
label var retireish "Do you plan to retire in the next 5 years?"


*Q36
bys v1 v2: gen retirewhy=v7 if v4=="Question 18a"
destring retirewhy, replace
label var retirewhy "If yes, the main reason for retiring?"
replace retirewhy="1" if retirewhy=="A"
replace retirewhy="2" if retirewhy=="B"
replace retirewhy="3" if retirewhy=="C"
replace retirewhy="4" if retirewhy=="D"
replace retirewhy="5" if retirewhy=="E"
replace retirewhy="6" if retirewhy=="F"
replace retirewhy="7" if retirewhy=="H"
replace retirewhy="8" if retirewhy=="J"
destring retirewhy, replace
label define Q18a2012 ///
1 "Time to retire" ///
2 "Family" /// 
3 "Compensation" ///
4 "Malpractice Insurance Rates" ///
5 "Liability Exposure" ///
6 "Medicare/Medicaid Reimbursement Rates" ///
7 "Private Health Plan Reimbursement Rates" ///
8 "Other" 
label values retirewhy Q18a2012

* Q37
bys v1 v2: gen retirewhy_q18b=v7 if v4=="Question 18b"
label var retirewhy_q18b "If yes, do you plan to have a limited license for volunteering?"
replace retirewhy_q18b="1" if retirewhy_q18b=="Y"
replace retirewhy_q18b="0" if retirewhy_q18b=="N"
destring retirewhy_q18b, replace
label values retirewhy_q18b yesno


* Q38
bys v1 v2: gen movein5yrs=v7 if v4=="Question 19"
replace movein5yrs="0" if movein5yrs=="N"
replace movein5yrs="1" if movein5yrs=="Y"
destring movein5yrs, replace
label values movein5yrs yesno
label var movein5yrs "Do you plan to move to work in another state in the next 5 years?"


* Q39
bys v1 v2: gen whymovein5yrs=v7 if v4=="Question 19a"
label var whymovein5yrs "Main Reason to move?"
replace whymovein5yrs="1" if whymovein5yrs=="A"
replace whymovein5yrs="2" if whymovein5yrs=="B"
replace whymovein5yrs="3" if whymovein5yrs=="C"
replace whymovein5yrs="4" if whymovein5yrs=="D"
replace whymovein5yrs="5" if whymovein5yrs=="E"
replace whymovein5yrs="6" if whymovein5yrs=="G"
replace whymovein5yrs="7" if whymovein5yrs=="H"
replace whymovein5yrs="8" if whymovein5yrs=="I"
replace whymovein5yrs="9" if whymovein5yrs=="J"
destring whymovein5yrs, replace
label define q19a2009 ///
1 "Family" ///
2 "Compensation" ///
3 "Malpractice Insurance Rate" ///
4 "Liability Exposure" ///
5 "Medicare/Medicaid Reimbursement Rates" ///
6 "Private Health Plan Reimbursement Rates" ///
7 "Looking for a change" ///
8 "Education-training in another state" ///
9 "Other"
label values whymovein5yrs  q19a2009


* Q40
bys v1 v2: gen changespec=v7 if v4=="Question 20"
replace changespec="1" if changespec=="Y"
replace changespec="0" if changespec=="N"
destring changespec, replace
label values changespec yesno
label var changespec "Do you plan to change your speciality in the next 5 years?"


* Q41
bys v1 v2: gen changespec_why=v7 if v4=="Question 20a"
label var changespec_why "If yes, the main reason for changing your speciality"
replace changespec_why="1" if changespec_why=="A"
replace changespec_why="2" if changespec_why=="B"
replace changespec_why="3" if changespec_why=="C"
replace changespec_why="4" if changespec_why=="D"
replace changespec_why="5" if changespec_why=="E"
replace changespec_why="6" if changespec_why=="F"
replace changespec_why="7" if changespec_why=="G"
replace changespec_why="8" if changespec_why=="H"
replace changespec_why="9" if changespec_why=="I"
destring changespec_why, replace
  
label define q20a2009 ///
1 "Family" ///
2 "Malpractice Insurance Rates" ///
3 "Liability Exposure" ///
4 "Medicare/Medicaid Reimbursement Rates" ///
5 "Private Health Plan Reimbursement Rates" ///
6 "Compensation" ///
7 "Education/training in another state" ///
8 "Potential for Higher Compensation" ///
9 "Other"

* =========End of Core Questionnarie=========
* ======== Now onto speciality questions ======

 
	/* 	
	Now we need to convert the data into individual level observation, so
	we need to drop duplicates and make sure we are not losing information
	and putting it all horizontally
	
	in 2013 - the format of asking is different and we don't need to do to much merge-adjustment
	like the previous years. 
	*/

duplicates drop v1 v2 v3 v6, force
keep v1 v2 v3 v4 v6 workinfl - changespec_why


* pick up labels before collapse
foreach v of var * {
	local l`v' : variable label `v'
    if `"`l`v''"' == "" {
 		local l`v' "`v'"
 	}
 }

*"
collapse workinfl - changespec_why, by(v1 v2)

* lay down labels after collapse
foreach v of var * {
	label var `v' "`l`v''"
}

ren v1 docid1 
ren v2 docid2

gen year=2013
order doc* year

save "$wkfrc/WKFRC-2013/survey.wkfrc-2013clean.dta", replace

* =============  2014 Survey file================
* =============  2014 Survey file================
* =============  2014 Survey file================

label drop _all
use "$wkfrc/WKFRC-2014/survey.wkfrc-2014.dta", clear

* Q1
bys v1 v2: gen workinfl=v7 if v4=="Intro 1"
replace workinfl="1" if workinfl=="Y"
replace workinfl="0" if workinfl=="N"
destring workinfl, replace
label define yesno 1 "Yes" 0 "No"
label values workinfl yesno

* Q1-2
bys v1 v2: gen howmanymonths13=v7 if v4=="Question 2"
destring howmanymonths13, replace
label define q22014 ///
1 "1-2 Months" ///
2 "3-4 Months" ///
3 "5-6 Months" ///
4 "7-8 Month" ///
5 "9-10 Months" ///
6 "11-12 Months" 
label values howmanymonths13 q22014


* Q1a
bys v1 v2: gen whynotworkinfl10=v7 if v4=="Intro 1a"
replace whynotworkinfl10="1" if whynotworkinfl10=="A"
replace whynotworkinfl10="2" if whynotworkinfl10=="C"
replace whynotworkinfl10="3" if whynotworkinfl10=="D"
replace whynotworkinfl10="4" if whynotworkinfl10=="E"
replace whynotworkinfl10="5" if whynotworkinfl10=="F"
replace whynotworkinfl10="6" if whynotworkinfl10=="H"
replace whynotworkinfl10="7" if whynotworkinfl10=="G"
replace whynotworkinfl10="8" if whynotworkinfl10=="I"
replace whynotworkinfl10="9" if whynotworkinfl10=="J"
destring whynotworkinfl10, replace
label define whynotworkinfl10 ///
1 "Retired" ///
2 "Malpractice Insurance Rate" ///
3 "Liability Exposure"  ///
4 "Medicare/Medicaid Reimbursement Rates" ///
5 "Private Health Plan Reimbursment Rates" ///
6 "Planning to move to Florida" ///
7 "Do not maintain a full-time residence in Florida" ///
8 "Other"
label values whynotworkinfl10 whynotworkinfl10

* Q1b
bys v1 v2: gen relocatetofl=v7 if v4=="Intro 1b"
replace relocatetofl="1" if relocatetofl=="A"
replace relocatetofl="2" if relocatetofl=="B"
replace relocatetofl="3" if relocatetofl=="C"
destring relocatetofl, replace
label define relocatetofl ///
1 "In 1-2 years" ///
2 "In 3-4 years" ///
3 "Do not plan to relocate" 
label values relocatetofl relocatetofl

* Q1c
bys v1 v2: gen speciality=v7 if v4=="Intro 1c Spec"
destring speciality, replace
label var speciality "Primary Speciality for people not working in FL"


* Q2 Are you currently enorlled in an intership, residency or fellowship program?
bys v1 v2: gen resfellow=v7 if v4=="Question 3"
replace resfellow="0" if resfellow=="N"
replace resfellow="1" if resfellow=="Y"
destring resfellow, replace
label values resfellow yesno
	
	* Q2a
	bys v1 v2: gen res_specialty=v7 if v4=="Q3a-Specialty"
	destring res_specialty, replace
	label var res_specialty "q3 Residency Primary Speciality"
	
	* Q2b
	bys v1 v2: gen res_year=v7 if v4=="Q3a-Year" 
	destring res_year, replace
	label var res_year "Post-Graduate Year? for Res/Fellow"
	label define res_year ///
	1 "PGY1" ///
	2 "PGY2" ///
	3 "PGY3" ///
	4 "PGY4" ///
	5 "PGY5" ///
	6 "PGY6" ///
	7 "PGY7"
	label values res_year res_year

* Q3 County 
bys v1 v2: gen counties=v7 if v4=="Q4 - County"
destring counties, replace
label var counties "Primary County"
	
	* Q3a Zip
	bys v1 v2: gen zipcode=v7 if v4=="Q4b - Zip"
	replace zipcode ="." if zipcode=="nltalpins" 
	replace zipcode="03375" if zipcode=="3375"
	destring zipcode, replace
	label var zipcode "Primary Zip Code1"
	
	* Q5  on this location, how many hours do you spend on
	bys v1 v2: gen timespent1=v7 if v4=="Q5-Patient Care"
	destring timespent1, replace
	label var timespent1 "Time spend in Patient Care"
	label values timespent1 timespent
	
	* Q6
	bys v1 v2: gen timespent2=v7 if v4=="Q5b-AdminMatter"
	destring timespent2, replace
	label var timespent2 "Time spend in Administrative Matter"
	label values timespent2 timespent
	
	* Q7
	bys v1 v2: gen timespent3=v7 if v4=="Q5c-Research"
	destring timespent3, replace
	label var timespent3 "Time spend in Research and Teaching"
	label values timespent3 timespent
	
* Q8-Avg Patients
	bys v1 v2: gen howmanypatients=v7 if v4=="Q6-Avg Patients"
	destring howmanypatients, replace
	label var howmanypatients "How many patients do you see per week in this location?"

* Q9
label define q92012 ///
1 "Office Practice - Solo Practice" ///
2 "Office Practice - Group Practice - Single Specialty" ///
3 "Office Practice - Group Practice - Multi-Specialty" ///
4 "Federally Qualified Community Health Center" ///
5 "Nursing Home / Extended Care Facility" /// 
6 "Volunteer Free Clinic" ///
7 "Hospital - Hospital Based Physician (Non-Emergency)" ///
8 "Hospital - Other" ///
10 "County Health Department" ///
11 "Urgent Care Center"  ///
12 "Ambulatory Surgery Center" ///
13 "Hospital Emergency Room" ///
14 "Hospital - Outpatient Dept" ///
15 "Hospital - Hospitalist" ///
16 "Other"

bys v1 v2: gen mainpractice10=v7 if v4=="Question 7"
destring mainpractice10, replace
label var mainpractice10 "Majority of you practice occurs in?"
label values mainpractice10 q92012

* Q10
bys v1 v2: gen employer10=v7 if v4=="Question 8"
destring employer10, replace
label var employer10 "If you are an employed physician, is your employer:"
label define q5a2014 ///
1 "Medical School or Parent University" ///
2 "Government Agency" ///
3 "Staff or Group HMO" ///
4 "Other"
label values employer10  q5a2014

* Q11- Q12
bys v1 v2: gen specialty=v7 if v4=="Q9 Specialty"
destring specialty, replace
label var specialty "Primary Speciality"

bys v1 v2: gen specialtypct=v7 if v4=="Q9b-Pct Primary"
destring specialtypct, replace
label var specialtypct "percent of patient care at this primary location involving primary specialty"

* Q13-Q14 - Second Specialty
bys v1 v2: gen specialty2=v7 if v4=="Q10 - Specialty"
destring specialty2, replace
label var specialty2 "Secondary Speciality in Primary Location"

bys v1 v2: gen specialtypct2=v7 if v4=="Q10b - Pct"
destring specialtypct2, replace
label var specialtypct2 "percent of patient care at primary location involving secondary specialty"

* Q15-Q16 - Third Specialty
bys v1 v2: gen specialty3=v7 if v4=="Q11 - Specialty"
destring specialty3, replace
label var specialty3 "Third Speciality in Primary Location"

bys v1 v2: gen specialtypct3=v7 if v4=="Q11b - Pct Alt2"
destring specialtypct3, replace
label var specialtypct3 "Percent of patient care at primary location involving third specialty"

* Q17-Q21 - Other locations information: Second Location 
	bys v1 v2: gen counties2=v7 if v4=="Q13 - County"
	destring counties2, replace
	label var counties2 "Secondary County"
	
	*Zip
	bys v1 v2: gen zipcode2=v7 if v4=="Q13b - Zip"
	destring zipcode2, replace
	label var zipcode2 "Secondary Zip Code"

	* Hours with Patients 
	bys v1 v2: gen hours2=v7 if v4=="Q14 - Hours"
	destring hours2, replace
	label var hours2 "Patient Care hours per week at 2nd location"
	
	* Avg number of patients per week
	bys v1 v2: gen howmanypatients2=v7 if v4=="Q15 - Patients"
	destring howmanypatients2, replace
	label var howmanypatients2 "Average number of patients seen per week at 2nd location"
		
	* Primary Speciality at second location
	bys v1 v2: gen specialty_2ndloc=v7 if v4=="Q16 - Specialty"
	destring specialty_2ndloc, replace
	label var specialty_2ndloc "Primary Specialty in Second Location"

* Q22-Q26- Other locations informatio: Third Location 

	bys v1 v2: gen counties3=v7 if v4=="Q17 - County"
	destring counties3, replace
	label var counties3 "Third County"
	
	*Zip
	bys v1 v2: gen zipcode3=v7 if v4=="Q17b - Zip"
	destring zipcode3, replace
	label var zipcode3 "Third Zip Code"

	* Hours with Patients 
	bys v1 v2: gen hours3=v7 if v4=="Q18 - Hours"
	destring hours3, replace
	label var hours3 "Patient Care hours per week at 3rd location"
	
	* Avg number of patients per week
	bys v1 v2: gen howmanypatients3=v7 if v4=="Q19 - Patients"
	destring howmanypatients3, replace
	label var howmanypatients3 "Average number of patients seen per week at 3rd location"
		
	* Primary Speciality at Third location
	bys v1 v2: gen specialty_3ndloc=v7 if v4=="Q20 - Specialty"
	destring specialty_3ndloc, replace
	label var specialty_3ndloc "Primary Specialty in Third Location"
	
* ##Hospital Care Questions##

*Q27
	bys v1 v2: gen hosppriv2=v7 if v4=="Question 13a"
	destring hosppriv2, replace
	label define hosppriv2 ///
	1 "1" ///
	2 "2" ///
	3 "3" ///
	4 "4 or more"
	label values hosppriv2 hosppriv2	
	label var hosppriv2 "If you have hospital privileges, how many hospitals?"

*Q28 

	bys v1 v2: gen numhosp_takeERcalls=v7 if v4=="Question 14a"
	destring numhosp_takeERcalls, replace
	label define numhosp_takeERcalls ///
	1 "1" ///
	2 "2" ///
	3 "3" ///
	4 "4 or more"
	label values numhosp_takeERcalls numhosp_takeERcalls		
	label var numhosp_takeERcalls "At how many individual hospitals do you provide on-call emergency room coverage?"

*Q29
	bys v1 v2: gen days_takeERcalls=v7 if v4=="Question 14b"
	destring days_takeERcalls, replace
	label var days_takeERcalls "How many total days per month do you take emergency call?"

* Q30 
	bys v1 v2: gen ERcalls5=v7 if v4=="Question 14c"
	replace ERcalls5="1" if ERcalls5=="A"
	replace ERcalls5="2" if ERcalls5=="B"
	replace ERcalls5="3" if ERcalls5=="C"
	label define ERcalls5 1 "Increased" 2 "Decreased" 3 "Stayed the Same"
	destring ERcalls5, replace
	label values ERcalls5 ERcalls5
	label var ERcalls5 "During the past 2 years, has the number of emergency on-call days"

* Q31
	bys v1 v2: gen decrease_ERcalls5=v7 if v4=="Question 14d"
	destring decrease_ERcalls5, replace
	label define decrease_ERcalls5 ///
	1 "Retired" ///
    2 "Lifestyle Considerations"   ///
    3 "Compensation"   ///
    4 "Malpractice Insurance Rates"   ///
    5 "Liability Exposure"   ///
    6 "Work in an Urgent Care Clinic"   ///
    7 "Medicare/Medicaid Reimbursement Rates"   ///
    8 "Private Health Plan Reimbursement Rates" ///
    9 "Other"
	label values decrease_ERcalls5 decrease_ERcalls5
	label var decrease_ERcalls5 "If you are decreasing your on-call days, what is the main reason?"

* Q32
	label define q15a2012 ///
	1 "Level I" ///
	2 "Level II" ///
	3 "Pediatric" ///
	4 "More than one of the above"

	bys v1 v2: gen traumacalls2=v7 if v4=="Question 15a"
	replace traumacalls2="1" if traumacalls2=="A"
	replace traumacalls2="2" if traumacalls2=="B"
	replace traumacalls2="3" if traumacalls2=="C"
	replace traumacalls2="4" if traumacalls2=="D"
	destring traumacalls2, replace
	label var traumacalls2 "At which type of verified trauma center do you take trauma call or attend to trauma patients?"

	*Q16 - Even thought this question doesnt appear in the survey, it is still coded
bys v1 v2: gen newmedicare=v7 if v4=="Question 16"
replace newmedicare="0" if newmedicare=="N"
replace newmedicare="1" if newmedicare=="Y"
destring newmedicare, replace
label values newmedicare yesno
label var newmedicare "Are you currently accepting new Medicare patients in your practice?"

* Q33 
	bys v1 v2: gen newmedicare_q16a=v7 if v4=="Question 16a"
	replace newmedicare_q16a="1" if newmedicare_q16a=="A"
	replace newmedicare_q16a="2" if newmedicare_q16a=="B"
	replace newmedicare_q16a="3" if newmedicare_q16a=="C"
	replace newmedicare_q16a="4" if newmedicare_q16a=="D"
	replace newmedicare_q16a="5" if newmedicare_q16a=="E"
	replace newmedicare_q16a="6" if newmedicare_q16a=="F"
	destring newmedicare_q16a, replace
	label define newmedicare_q16a ///
	1 "Low Compensation" ///
	2 "Billing Requirements" ///
	3 "Too Much Paperwork" ///
	4 "Practice is at full capacity" ///
	5 "Concerned about Fraud Issues" ///
	6 "Other" 
	label values newmedicare_q16a newmedicare_q16a
	label var newmedicare_q16a "What is the main reason you are NOT currently accepting new Medicare patients in your practice?"
	notes newmedicare_q16a: If its not applicable then we don't have any information.

	*Q17 - Even thought this question doesnt appear in the survey, it is still coded
bys v1 v2: gen newmedicaid=v7 if v4=="Question 17"
replace newmedicaid="0" if newmedicaid=="N"
replace newmedicaid="1" if newmedicaid=="Y"
destring newmedicaid, replace
label values newmedicaid yesno
label var newmedicaid "Are you currently accepting new pateints covered by Medicaid?"

* Q34 

bys v1 v2: gen newmedicaid_q17a=v7 if v4=="Question 17a"
replace newmedicaid_q17a="1" if newmedicaid_q17a=="A"
replace newmedicaid_q17a="2" if newmedicaid_q17a=="B"
replace newmedicaid_q17a="3" if newmedicaid_q17a=="C"
replace newmedicaid_q17a="4" if newmedicaid_q17a=="D"
replace newmedicaid_q17a="5" if newmedicaid_q17a=="E"
replace newmedicaid_q17a="6" if newmedicaid_q17a=="F"
destring newmedicaid_q17a, replace

label define newmedicaid_q17a ///
1 "Low Compensation" ///
2 "Billing Requirements" ///
3 "Too Much Paperwork" ///
4 "Practice is at full capacity" ///
5 "Concerned about Fraud Issues" ///
6 "Other" 
label values newmedicaid_q17a newmedicaid_q17a
label var newmedicaid_q17a "What is the main reason you are NOT currently accepting new Medicaid patients in your practice?"
notes newmedicaid_q17a: If its not applicable then we don't have any information.


* Q35
bys v1 v2: gen retireish=v7 if v4=="Question 18"
replace retireish="1" if retireish=="Y"
replace retireish="0" if retireish=="N"
destring retireish, replace
label values retireish yesno
label var retireish "Do you plan to retire in the next 5 years?"


*Q36
bys v1 v2: gen retirewhy=v7 if v4=="Question 18a"
destring retirewhy, replace
label var retirewhy "If yes, the main reason for retiring?"
replace retirewhy="1" if retirewhy=="A"
replace retirewhy="2" if retirewhy=="B"
replace retirewhy="3" if retirewhy=="C"
replace retirewhy="4" if retirewhy=="D"
replace retirewhy="6" if retirewhy=="E"
replace retirewhy="7" if retirewhy=="F"
replace retirewhy="8" if retirewhy=="H"
replace retirewhy="9" if retirewhy=="J"
destring retirewhy, replace
label define Q18a2012 ///
1 "Time to retire" ///
2 "Family" /// 
3 "Compensation" ///
4 "Malpractice Insurance Rates" ///
5 "Liability Exposure" ///
6 "Medicare/Medicaid Reimbursement Rates" ///
7 "Private Health Plan Reimbursement Rates" ///
8 "Other" 
label values retirewhy Q18a2012

* Q37
bys v1 v2: gen retirewhy_q18b=v7 if v4=="Question 18b"
label var retirewhy_q18b "If yes, do you plan to have a limited license for volunteering?"
replace retirewhy_q18b="1" if retirewhy_q18b=="Y"
replace retirewhy_q18b="0" if retirewhy_q18b=="N"
destring retirewhy_q18b, replace
label values retirewhy_q18b yesno


* Q38
bys v1 v2: gen movein5yrs=v7 if v4=="Question 19"
replace movein5yrs="0" if movein5yrs=="N"
replace movein5yrs="1" if movein5yrs=="Y"
destring movein5yrs, replace
label values movein5yrs yesno
label var movein5yrs "Do you plan to move to work in another state in the next 5 years?"


* Q39
bys v1 v2: gen whymovein5yrs=v7 if v4=="Question 19a"
label var whymovein5yrs "Main Reason to move?"
replace whymovein5yrs="1" if whymovein5yrs=="A"
replace whymovein5yrs="2" if whymovein5yrs=="B"
replace whymovein5yrs="3" if whymovein5yrs=="C"
replace whymovein5yrs="4" if whymovein5yrs=="D"
replace whymovein5yrs="5" if whymovein5yrs=="E"
replace whymovein5yrs="6" if whymovein5yrs=="G"
replace whymovein5yrs="7" if whymovein5yrs=="H"
replace whymovein5yrs="8" if whymovein5yrs=="I"
replace whymovein5yrs="9" if whymovein5yrs=="J"
destring whymovein5yrs, replace
label define q19a2009 ///
1 "Family" ///
2 "Compensation" ///
3 "Malpractice Insurance Rate" ///
4 "Liability Exposure" ///
5 "Medicare/Medicaid Reimbursement Rates" ///
6 "Private Health Plan Reimbursement Rates" ///
7 "Looking for a change" ///
8 "Education-training in another state" ///
9 "Other"
label values whymovein5yrs  q19a2009


* Q40
bys v1 v2: gen changespec=v7 if v4=="Question 20"
replace changespec="1" if changespec=="Y"
replace changespec="0" if changespec=="N"
destring changespec, replace
label values changespec yesno
label var changespec "Do you plan to change your speciality in the next 5 years?"


* Q41
bys v1 v2: gen changespec_why=v7 if v4=="Question 20a"
label var changespec_why "If yes, the main reason for changing your speciality"
replace changespec_why="1" if changespec_why=="A"
replace changespec_why="2" if changespec_why=="B"
replace changespec_why="3" if changespec_why=="C"
replace changespec_why="4" if changespec_why=="D"
replace changespec_why="5" if changespec_why=="E"
replace changespec_why="6" if changespec_why=="F"
replace changespec_why="7" if changespec_why=="G"
replace changespec_why="8" if changespec_why=="H"
replace changespec_why="9" if changespec_why=="I"
destring changespec_why, replace
  
label define q20a2009 ///
1 "Family" ///
2 "Malpractice Insurance Rates" ///
3 "Liability Exposure" ///
4 "Medicare/Medicaid Reimbursement Rates" ///
5 "Private Health Plan Reimbursement Rates" ///
6 "Compensation" ///
7 "Education/training in another state" ///
8 "Potential for Higher Compensation" ///
9 "Other"

* =========End of Core Questionnarie=========
* ======== Now onto speciality questions ======

 
	/* 	
	Now we need to convert the data into individual level observation, so
	we need to drop duplicates and make sure we are not losing information
	and putting it all horizontally
	
	in 2014 - the format of asking is different and we don't need to do to much merge-adjustment
	like the previous years. 
	*/

duplicates drop v1 v2 v3 v6, force
keep v1 v2 v3 v4 v6 workinfl - changespec_why


* pick up labels before collapse
foreach v of var * {
	local l`v' : variable label `v'
    if `"`l`v''"' == "" {
 		local l`v' "`v'"
 	}
 }

*"
collapse workinfl - changespec_why, by(v1 v2)

* lay down labels after collapse
foreach v of var * {
	label var `v' "`l`v''"
}

ren v1 docid1 
ren v2 docid2

gen year=2014
order doc* year

save "$wkfrc/WKFRC-2014/survey.wkfrc-2014clean.dta", replace


* =============  2015 Survey file================
* =============  2015 Survey file================
* =============  2015 Survey file================

use "$wkfrc/WKFRC-2015/survey.wkfrc-2015.dta", clear

* Q1
bys v1 v2: gen workinfl=v7 if v4=="Intro 1"
replace workinfl="1" if workinfl=="Y"
replace workinfl="0" if workinfl=="N"
destring workinfl, replace
label define yesno 1 "Yes" 0 "No"
label values workinfl yesno

* Q1-2
bys v1 v2: gen howmanymonths13=v7 if v4=="Question 2"
destring howmanymonths13, replace
label define q22015 ///
1 "1-2 Months" ///
2 "3-4 Months" ///
3 "5-6 Months" ///
4 "7-8 Month" ///
5 "9-10 Months" ///
6 "11-12 Months" 
label values howmanymonths13 q22015


* Q1a
bys v1 v2: gen whynotworkinfl10=v7 if v4=="Intro 1a"
replace whynotworkinfl10="1" if whynotworkinfl10=="A"
replace whynotworkinfl10="2" if whynotworkinfl10=="C"
replace whynotworkinfl10="3" if whynotworkinfl10=="D"
replace whynotworkinfl10="4" if whynotworkinfl10=="E"
replace whynotworkinfl10="5" if whynotworkinfl10=="F"
replace whynotworkinfl10="6" if whynotworkinfl10=="H"
replace whynotworkinfl10="7" if whynotworkinfl10=="G"
replace whynotworkinfl10="8" if whynotworkinfl10=="I"
replace whynotworkinfl10="9" if whynotworkinfl10=="J"
destring whynotworkinfl10, replace
label define whynotworkinfl10 ///
1 "Retired" ///
2 "Malpractice Insurance Rate" ///
3 "Liability Exposure"  ///
4 "Medicare/Medicaid Reimbursement Rates" ///
5 "Private Health Plan Reimbursment Rates" ///
6 "Planning to move to Florida" ///
7 "Do not maintain a full-time residence in Florida" ///
8 "Other"
label values whynotworkinfl10 whynotworkinfl10

* Q1b
bys v1 v2: gen relocatetofl=v7 if v4=="Intro 1b"
replace relocatetofl="1" if relocatetofl=="A"
replace relocatetofl="2" if relocatetofl=="B"
replace relocatetofl="3" if relocatetofl=="C"
destring relocatetofl, replace
label define relocatetofl ///
1 "In 1-2 years" ///
2 "In 3-4 years" ///
3 "Do not plan to relocate" 
label values relocatetofl relocatetofl

* Q1c
bys v1 v2: gen speciality=v7 if v4=="Intro 1c Spec"
destring speciality, replace
label var speciality "Primary Speciality for people not working in FL"


* Q2 Are you currently enorlled in an intership, residency or fellowship program?
bys v1 v2: gen resfellow=v7 if v4=="Question 3"
replace resfellow="0" if resfellow=="N"
replace resfellow="1" if resfellow=="Y"
destring resfellow, replace
label values resfellow yesno
	
	* Q2a
	bys v1 v2: gen res_specialty=v7 if v4=="Q3a-Specialty"
	destring res_specialty, replace
	label var res_specialty "q3 Residency Primary Speciality"
	
	* Q2b
	bys v1 v2: gen res_year=v7 if v4=="Q3a-Year" 
	destring res_year, replace
	label var res_year "Post-Graduate Year? for Res/Fellow"
	label define res_year ///
	1 "PGY1" ///
	2 "PGY2" ///
	3 "PGY3" ///
	4 "PGY4" ///
	5 "PGY5" ///
	6 "PGY6" ///
	7 "PGY7"
	label values res_year res_year

* Q3 County 
bys v1 v2: gen counties=v7 if v4=="Q4 - County"
destring counties, replace
label var counties "Primary County"
	
	* Q3a Zip
	bys v1 v2: gen zipcode=v7 if v4=="Q4b - Zip"
	replace zipcode="00427" if zipcode=="..427"
	replace zipcode="." if zipcode=="32-73"
	destring zipcode, replace	
	label var zipcode "Primary Zip Code1"
	
	* Q5  on this location, how many hours do you spend on
	bys v1 v2: gen timespent1=v7 if v4=="Q5-Patient Care"
	destring timespent1, replace
	label var timespent1 "Time spend in Patient Care"
	label values timespent1 timespent
	
	* Q6
	bys v1 v2: gen timespent2=v7 if v4=="Q5b-AdminMatter"
	destring timespent2, replace
	label var timespent2 "Time spend in Administrative Matter"
	label values timespent2 timespent
	
	* Q7
	bys v1 v2: gen timespent3=v7 if v4=="Q5c-Research"
	destring timespent3, replace
	label var timespent3 "Time spend in Research and Teaching"
	label values timespent3 timespent
	
* Q8-Avg Patients
	bys v1 v2: gen howmanypatients=v7 if v4=="Q6-Avg Patients"
	destring howmanypatients, replace
	label var howmanypatients "How many patients do you see per week in this location?"

* Q9
label define q92012 ///
1 "Office Practice - Solo Practice" ///
2 "Office Practice - Group Practice - Single Specialty" ///
3 "Office Practice - Group Practice - Multi-Specialty" ///
4 "Federally Qualified Community Health Center" ///
5 "Nursing Home / Extended Care Facility" /// 
6 "Volunteer Free Clinic" ///
7 "Hospital - Hospital Based Physician (Non-Emergency)" ///
8 "Hospital - Other" ///
10 "County Health Department" ///
11 "Urgent Care Center"  ///
12 "Ambulatory Surgery Center" ///
13 "Hospital Emergency Room" ///
14 "Hospital - Outpatient Dept" ///
15 "Hospital - Hospitalist" ///
16 "Other"

bys v1 v2: gen mainpractice10=v7 if v4=="Question 7"
destring mainpractice10, replace
label var mainpractice10 "Majority of you practice occurs in?"
label values mainpractice10 q92012

* Q10
bys v1 v2: gen employer10=v7 if v4=="Question 8"
destring employer10, replace
label var employer10 "If you are an employed physician, is your employer:"
label define q5a2015 ///
1 "Medical School or Parent University" ///
2 "Government Agency" ///
3 "Staff or Group HMO" ///
4 "Other"
label values employer10  q5a2015

* Q11- Q12
bys v1 v2: gen specialty=v7 if v4=="Q9 Specialty"
destring specialty, replace
label var specialty "Primary Speciality"

bys v1 v2: gen specialtypct=v7 if v4=="Q9b-Pct Primary"
destring specialtypct, replace
label var specialtypct "percent of patient care at this primary location involving primary specialty"

* Q13-Q14 - Second Specialty
bys v1 v2: gen specialty2=v7 if v4=="Q10 - Specialty"
destring specialty2, replace
label var specialty2 "Secondary Speciality in Primary Location"

bys v1 v2: gen specialtypct2=v7 if v4=="Q10b - Pct"
destring specialtypct2, replace
label var specialtypct2 "percent of patient care at primary location involving secondary specialty"

* Q15-Q16 - Third Specialty
bys v1 v2: gen specialty3=v7 if v4=="Q11 - Specialty"
destring specialty3, replace
label var specialty3 "Third Speciality in Primary Location"

bys v1 v2: gen specialtypct3=v7 if v4=="Q11b - Pct Alt2"
destring specialtypct3, replace
label var specialtypct3 "Percent of patient care at primary location involving third specialty"

* Q17-Q21 - Other locations information: Second Location 
	bys v1 v2: gen counties2=v7 if v4=="Q13 - County"
	destring counties2, replace
	label var counties2 "Secondary County"
	
	*Zip
	bys v1 v2: gen zipcode2=v7 if v4=="Q13b - Zip"
	destring zipcode2, replace
	label var zipcode2 "Secondary Zip Code"

	* Hours with Patients 
	bys v1 v2: gen hours2=v7 if v4=="Q14 - Hours"
	destring hours2, replace
	label var hours2 "Patient Care hours per week at 2nd location"
	
	* Avg number of patients per week
	bys v1 v2: gen howmanypatients2=v7 if v4=="Q15 - Patients"
	destring howmanypatients2, replace
	label var howmanypatients2 "Average number of patients seen per week at 2nd location"
		
	* Primary Speciality at second location
	bys v1 v2: gen specialty_2ndloc=v7 if v4=="Q16 - Specialty"
	destring specialty_2ndloc, replace
	label var specialty_2ndloc "Primary Specialty in Second Location"

* Q22-Q26- Other locations informatio: Third Location 

	bys v1 v2: gen counties3=v7 if v4=="Q17 - County"
	destring counties3, replace
	label var counties3 "Third County"
	
	*Zip
	bys v1 v2: gen zipcode3=v7 if v4=="Q17b - Zip"
	destring zipcode3, replace
	label var zipcode3 "Third Zip Code"

	* Hours with Patients 
	bys v1 v2: gen hours3=v7 if v4=="Q18 - Hours"
	destring hours3, replace
	label var hours3 "Patient Care hours per week at 3rd location"
	
	* Avg number of patients per week
	bys v1 v2: gen howmanypatients3=v7 if v4=="Q19 - Patients"
	destring howmanypatients3, replace
	label var howmanypatients3 "Average number of patients seen per week at 3rd location"
		
	* Primary Speciality at Third location
	bys v1 v2: gen specialty_3ndloc=v7 if v4=="Q20 - Specialty"
	destring specialty_3ndloc, replace
	label var specialty_3ndloc "Primary Specialty in Third Location"
	
* ##Hospital Care Questions##

*Q27
	bys v1 v2: gen hosppriv2=v7 if v4=="Question 13a"
	destring hosppriv2, replace
	label define hosppriv2 ///
	1 "1" ///
	2 "2" ///
	3 "3" ///
	4 "4 or more"
	label values hosppriv2 hosppriv2	
	label var hosppriv2 "If you have hospital privileges, how many hospitals?"

*Q28 

	bys v1 v2: gen numhosp_takeERcalls=v7 if v4=="Question 14a"
	destring numhosp_takeERcalls, replace
	label define numhosp_takeERcalls ///
	1 "1" ///
	2 "2" ///
	3 "3" ///
	4 "4 or more"
	label values numhosp_takeERcalls numhosp_takeERcalls		
	label var numhosp_takeERcalls "At how many individual hospitals do you provide on-call emergency room coverage?"

*Q29
	bys v1 v2: gen days_takeERcalls=v7 if v4=="Question 14b"
	destring days_takeERcalls, replace
	label var days_takeERcalls "How many total days per month do you take emergency call?"

* Q30 
	bys v1 v2: gen ERcalls5=v7 if v4=="Question 14c"
	replace ERcalls5="1" if ERcalls5=="A"
	replace ERcalls5="2" if ERcalls5=="B"
	replace ERcalls5="3" if ERcalls5=="C"
	label define ERcalls5 1 "Increased" 2 "Decreased" 3 "Stayed the Same"
	destring ERcalls5, replace
	label values ERcalls5 ERcalls5
	label var ERcalls5 "During the past 2 years, has the number of emergency on-call days"

* Q31
	bys v1 v2: gen decrease_ERcalls5=v7 if v4=="Question 14d"
	destring decrease_ERcalls5, replace
	label define decrease_ERcalls5 ///
	1 "Retired" ///
    2 "Lifestyle Considerations"   ///
    3 "Compensation"   ///
    4 "Malpractice Insurance Rates"   ///
    5 "Liability Exposure"   ///
    6 "Work in an Urgent Care Clinic"   ///
    7 "Medicare/Medicaid Reimbursement Rates"   ///
    8 "Private Health Plan Reimbursement Rates" ///
    9 "Other"
	label values decrease_ERcalls5 decrease_ERcalls5
	label var decrease_ERcalls5 "If you are decreasing your on-call days, what is the main reason?"

* Q32
	label define q15a2012 ///
	1 "Level I" ///
	2 "Level II" ///
	3 "Pediatric" ///
	4 "More than one of the above"

	bys v1 v2: gen traumacalls2=v7 if v4=="Question 15a"
	replace traumacalls2="1" if traumacalls2=="A"
	replace traumacalls2="2" if traumacalls2=="B"
	replace traumacalls2="3" if traumacalls2=="C"
	replace traumacalls2="4" if traumacalls2=="D"
	destring traumacalls2, replace
	label var traumacalls2 "At which type of verified trauma center do you take trauma call or attend to trauma patients?"

	*Q16 - Even thought this question doesnt appear in the survey, it is still coded
bys v1 v2: gen newmedicare=v7 if v4=="Question 16"
replace newmedicare="0" if newmedicare=="N"
replace newmedicare="1" if newmedicare=="Y"
destring newmedicare, replace
label values newmedicare yesno
label var newmedicare "Are you currently accepting new Medicare patients in your practice?"

* Q33 
	bys v1 v2: gen newmedicare_q16a=v7 if v4=="Question 16a"
	replace newmedicare_q16a="1" if newmedicare_q16a=="A"
	replace newmedicare_q16a="2" if newmedicare_q16a=="B"
	replace newmedicare_q16a="3" if newmedicare_q16a=="C"
	replace newmedicare_q16a="4" if newmedicare_q16a=="D"
	replace newmedicare_q16a="5" if newmedicare_q16a=="E"
	replace newmedicare_q16a="6" if newmedicare_q16a=="F"
	destring newmedicare_q16a, replace
	label define newmedicare_q16a ///
	1 "Low Compensation" ///
	2 "Billing Requirements" ///
	3 "Too Much Paperwork" ///
	4 "Practice is at full capacity" ///
	5 "Concerned about Fraud Issues" ///
	6 "Other" 
	label values newmedicare_q16a newmedicare_q16a
	label var newmedicare_q16a "What is the main reason you are NOT currently accepting new Medicare patients in your practice?"
	notes newmedicare_q16a: If its not applicable then we don't have any information.

	*Q17 - Even thought this question doesnt appear in the survey, it is still coded
bys v1 v2: gen newmedicaid=v7 if v4=="Question 17"
replace newmedicaid="0" if newmedicaid=="N"
replace newmedicaid="1" if newmedicaid=="Y"
destring newmedicaid, replace
label values newmedicaid yesno
label var newmedicaid "Are you currently accepting new pateints covered by Medicaid?"

* Q34 

bys v1 v2: gen newmedicaid_q17a=v7 if v4=="Question 17a"
replace newmedicaid_q17a="1" if newmedicaid_q17a=="A"
replace newmedicaid_q17a="2" if newmedicaid_q17a=="B"
replace newmedicaid_q17a="3" if newmedicaid_q17a=="C"
replace newmedicaid_q17a="4" if newmedicaid_q17a=="D"
replace newmedicaid_q17a="5" if newmedicaid_q17a=="E"
replace newmedicaid_q17a="6" if newmedicaid_q17a=="F"
destring newmedicaid_q17a, replace

label define newmedicaid_q17a ///
1 "Low Compensation" ///
2 "Billing Requirements" ///
3 "Too Much Paperwork" ///
4 "Practice is at full capacity" ///
5 "Concerned about Fraud Issues" ///
6 "Other" 
label values newmedicaid_q17a newmedicaid_q17a
label var newmedicaid_q17a "What is the main reason you are NOT currently accepting new Medicaid patients in your practice?"
notes newmedicaid_q17a: If its not applicable then we don't have any information.


* Q35
bys v1 v2: gen retireish=v7 if v4=="Question 18"
replace retireish="1" if retireish=="Y"
replace retireish="0" if retireish=="N"
destring retireish, replace
label values retireish yesno
label var retireish "Do you plan to retire in the next 5 years?"


*Q36
bys v1 v2: gen retirewhy=v7 if v4=="Question 18a"
destring retirewhy, replace
label var retirewhy "If yes, the main reason for retiring?"
replace retirewhy="1" if retirewhy=="A"
replace retirewhy="2" if retirewhy=="B"
replace retirewhy="3" if retirewhy=="C"
replace retirewhy="4" if retirewhy=="D"
replace retirewhy="5" if retirewhy=="E"
replace retirewhy="6" if retirewhy=="F"
replace retirewhy="7" if retirewhy=="H"
replace retirewhy="8" if retirewhy=="J"
destring retirewhy, replace
label define Q18a2012 ///
1 "Time to retire" ///
2 "Family" /// 
3 "Compensation" ///
4 "Malpractice Insurance Rates" ///
5 "Liability Exposure" ///
6 "Medicare/Medicaid Reimbursement Rates" ///
7 "Private Health Plan Reimbursement Rates" ///
8 "Other" 
label values retirewhy Q18a2012

* Q37
bys v1 v2: gen retirewhy_q18b=v7 if v4=="Question 18b"
label var retirewhy_q18b "If yes, do you plan to have a limited license for volunteering?"
replace retirewhy_q18b="1" if retirewhy_q18b=="Y"
replace retirewhy_q18b="0" if retirewhy_q18b=="N"
destring retirewhy_q18b, replace
label values retirewhy_q18b yesno


* Q38
bys v1 v2: gen movein5yrs=v7 if v4=="Question 19"
replace movein5yrs="0" if movein5yrs=="N"
replace movein5yrs="1" if movein5yrs=="Y"
destring movein5yrs, replace
label values movein5yrs yesno
label var movein5yrs "Do you plan to move to work in another state in the next 5 years?"


* Q39
bys v1 v2: gen whymovein5yrs=v7 if v4=="Question 19a"
label var whymovein5yrs "Main Reason to move?"
replace whymovein5yrs="1" if whymovein5yrs=="A"
replace whymovein5yrs="2" if whymovein5yrs=="B"
replace whymovein5yrs="3" if whymovein5yrs=="C"
replace whymovein5yrs="4" if whymovein5yrs=="D"
replace whymovein5yrs="5" if whymovein5yrs=="E"
replace whymovein5yrs="6" if whymovein5yrs=="G"
replace whymovein5yrs="7" if whymovein5yrs=="H"
replace whymovein5yrs="8" if whymovein5yrs=="I"
replace whymovein5yrs="9" if whymovein5yrs=="J"
destring whymovein5yrs, replace
label define q19a2009 ///
1 "Family" ///
2 "Compensation" ///
3 "Malpractice Insurance Rate" ///
4 "Liability Exposure" ///
5 "Medicare/Medicaid Reimbursement Rates" ///
6 "Private Health Plan Reimbursement Rates" ///
7 "Looking for a change" ///
8 "Education-training in another state" ///
9 "Other"
label values whymovein5yrs  q19a2009


* Q40
bys v1 v2: gen changespec=v7 if v4=="Question 20"
replace changespec="1" if changespec=="Y"
replace changespec="0" if changespec=="N"
destring changespec, replace
label values changespec yesno
label var changespec "Do you plan to change your speciality in the next 5 years?"


* Q41
bys v1 v2: gen changespec_why=v7 if v4=="Question 20a"
label var changespec_why "If yes, the main reason for changing your speciality"
replace changespec_why="1" if changespec_why=="A"
replace changespec_why="2" if changespec_why=="B"
replace changespec_why="3" if changespec_why=="C"
replace changespec_why="4" if changespec_why=="D"
replace changespec_why="5" if changespec_why=="E"
replace changespec_why="6" if changespec_why=="F"
replace changespec_why="7" if changespec_why=="G"
replace changespec_why="8" if changespec_why=="H"
replace changespec_why="9" if changespec_why=="I"
destring changespec_why, replace
  
label define q20a2009 ///
1 "Family" ///
2 "Malpractice Insurance Rates" ///
3 "Liability Exposure" ///
4 "Medicare/Medicaid Reimbursement Rates" ///
5 "Private Health Plan Reimbursement Rates" ///
6 "Compensation" ///
7 "Education/training in another state" ///
8 "Potential for Higher Compensation" ///
9 "Other"

* =========End of Core Questionnarie=========
* ======== Now onto speciality questions ======

 
	/* 	
	Now we need to convert the data into individual level observation, so
	we need to drop duplicates and make sure we are not losing information
	and putting it all horizontally
	
	in 2015 - the format of asking is different and we don't need to do to much merge-adjustment
	like the previous years. 
	*/

duplicates drop v1 v2 v3 v6, force
keep v1 v2 v3 v4 v6 workinfl - changespec_why


* pick up labels before collapse
foreach v of var * {
	local l`v' : variable label `v'
    if `"`l`v''"' == "" {
 		local l`v' "`v'"
 	}
 }

*"
collapse workinfl - changespec_why, by(v1 v2)

* lay down labels after collapse
foreach v of var * {
	label var `v' "`l`v''"
}

ren v1 docid1 
ren v2 docid2

gen year=2015
order doc* year

save "$wkfrc/WKFRC-2015/survey.wkfrc-2015clean.dta", replace















