log using contact_appendix_final.smcl, replace

clear
set more off

/***** Appendix for The Impact of College Diversity on Behavior Toward Minorities  *******/

/*************  Process Social Survey Data and Merge with Demographic Data  ************/

* Demographic Data

foreach year in 2011 2012 {
   use ..\usafa\studies\c00-14demographics, clear
   drop if cyear < `year' - 3
   drop if cyear >= `year'
   keep if black == 1
   gen sat = sat_v + sat_m
   sort cyear id
   egen fresh_bu_aca = mean(aca_cmp), by(squad3)
   egen fresh_bu_sat = mean(sat), by(squad3)
   keep squad3 cyear fresh_bu_aca fresh_bu_sat
   ren squad3 squad4
   replace cyear = `year'
   drop if squad4==.
   duplicates drop squad4, force
   save bu_`year', replace
   }
append using bu_2011
gen missing_bu_aca = fresh_bu_aca == .
replace fresh_bu_aca = 0 if fresh_bu_aca == .
gen missing_bu_sat = fresh_bu_sat == .
replace fresh_bu_sat = 0 if fresh_bu_sat == .  
drop if squad4 == 41 
sort cyear squad4
save bu, replace

use ..\usafa\studies\c00-14demographics, clear
keep sat_v sat_m leadership_cmp cft_score aca_cmp rathlete pschool black hispanic asian female cyear squad4 squad3 id
sort id
drop if cyear < 2011
drop if cyear > 2012
drop if squad4==.
drop if squad4>40

sort id
egen sq4_cyear=group(squad4 cyear)
egen sq3_cyear=group(squad3 cyear)
gen sat=(sat_m + sat_v)
gen white = black ==0 & hispanic == 0 & asian == 0
gen wm = white & female == 0
egen aca_66pctile=pctile(aca_cmp), p(66.67) by(cyear) 
egen aca_33pctile=pctile(aca_cmp), p(33.33) by(cyear) 

egen w4a = mean(aca_cmp) if wm == 1, by(cyear squad4)
egen w4s = mean(sat) if wm == 1, by(cyear squad4)
egen b4a = mean(aca_cmp) if black == 1, by(cyear squad4)
egen b4s = mean(sat) if black == 1, by(cyear squad4)
egen b4sm = mean(sat_m) if black == 1, by(cyear squad4)
egen b4sv = mean(sat_v) if black == 1, by(cyear squad4)
egen b4l = mean(leadership_cmp) if black == 1, by(cyear squad4)
egen b4c = mean(cft_score) if black == 1, by(cyear squad4)

egen w4aca = max(w4a), by(cyear squad4)
egen w4sat = max(w4s), by(cyear squad4)
egen b4aca = max(b4a), by(cyear squad4)
egen b4sat = max(b4s), by(cyear squad4)
egen b4satm = max(b4sm), by(cyear squad4)
egen b4satv = max(b4sv), by(cyear squad4)
egen b4ldr = max(b4l), by(cyear squad4)
egen b4cft = max(b4c), by(cyear squad4)
egen b4num = sum(black), by(cyear squad4)

sort cyear id

by cyear: center w4aca w4sat b4aca b4sat b4satm b4satv b4ldr b4cft , standardize 

drop w4a w4s b4a b4s b4sm b4sv b4l b4c w4aca w4sat 

ren c_w4aca fresh_wm_aca
ren c_w4sat fresh_wm_sat
ren c_b4aca fresh_black_aca
ren c_b4sat fresh_black_sat
ren c_b4satm fresh_black_sat_m
ren c_b4satv fresh_black_sat_v
ren c_b4ldr fresh_black_lead
ren c_b4cft fresh_black_cft
ren b4num fresh_num_black


foreach var in aca sat lead cft {
  replace fresh_black_`var' = 0 if fresh_black_`var' == .
  }
 
  
gen no_blacks_fresh = fresh_num_black == 0

egen w3a = mean(aca_cmp) if wm, by(cyear squad3)
egen w3s = mean(sat) if wm, by(cyear squad3)
egen b3a = mean(aca_cmp) if black == 1 & female==0, by(cyear squad3)
egen b3s = mean(sat) if black == 1 & female==0, by(cyear squad3)
egen b3l = mean(leadership_cmp) if black == 1 & female==0, by(cyear squad3)
egen b3c = mean(cft_score) if black == 1 & female==0, by(cyear squad3)

egen soph_black_aca = max(b3a), by(cyear squad3)
egen soph_black_sat = max(b3s), by(cyear squad3)
egen soph_black_lead = max(b3l), by(cyear squad3)
egen soph_black_cft = max(b3c), by(cyear squad3)
egen soph_num_black = sum(black) if female==0, by(cyear squad3)

gen no_blacks_soph = soph_num_black == 0

drop w3a w3s b3a b3s b3l b3c 

foreach var in aca sat lead cft {
  replace soph_black_`var' = 0 if soph_black_`var' == .
  }
  
foreach var in sat_v sat_m aca_cmp sat leadership_cmp cft_score rathlete {
  gen missing_`var' = `var' == .
  replace `var' = 0 if `var' == .
  }


sort cyear squad4
merge m:1 cyear squad4 using bu
drop if _merge == 2
drop _merge

sort cyear squad4
duplicates drop cyear squad4, force
sort cyear squad4

save demo, replace


* Friends

forvalues degree = 3/4 {
use ..\usafa\socialsurvey\socialsurvey_resp, clear
keep resp_id f`degree'?_id
ren f`degree'?_id f`degree'?
reshape long f`degree', i(resp_id) j(friend)
drop if missing(f`degree')
recast long resp_id f`degree'
ren f`degree' id
sort id
merge m:1 id using ..\usafa\studies\c00-14demographics
keep if _merge == 3
drop _merge loce* 
gen wm = female==0 & black==0 & hispanic==0 & asian==0
foreach var in id squad3 squad4 wm female black hispanic asian pschool rathlete aca_cmp sat_m sat_v leadership_cmp cft {
   ren `var' friend_`var'
   }
ren resp_id id
sort id
merge m:1 id using ..\usafa\studies\c00-14demographics
keep if _merge == 3
drop _merge loce* 
gen wm = female==0 & black==0 & hispanic==0 & asian==0
foreach var in id squad4 squad3 wm female black hispanic asian pschool rathlete aca_cmp sat_m sat_v leadership_cmp cft {
   ren `var' resp_`var'
   }
gen same_squad3 = resp_squad3==friend_squad3
gen same_squad4 = resp_squad4==friend_squad4
gen both_rathlete = resp_rathlete==1 & friend_rathlete==1
label var friend_wm "Friend is White Male"
label var friend_black "Friend is Black"
label var friend_hispanic "Friend is Hispanic"
label var friend_asian "Friend is Asian"
label var both_rathlete "Both are Recruited Athletes"
label var same_squad3 "Both in Same Sophomore Squadron"
label var same_squad4 "Both in Same Freshman Squadron"
save social_survey_friend`degree', replace
}

* Study Partners

forvalues degree = 3/4 {
use ..\usafa\socialsurvey\socialsurvey_resp, clear
keep resp_id s`degree'?_id
ren s`degree'?_id s`degree'?
reshape long s`degree', i(resp_id) j(study)
drop if missing(s`degree')
recast long resp_id s`degree'
ren s`degree' id
sort id
merge m:1 id using ..\usafa\studies\c00-14demographics
keep if _merge == 3
drop _merge loce* 
gen wm = female==0 & black==0 & hispanic==0 & asian==0
foreach var in id squad3 squad4 wm female black hispanic asian pschool rathlete aca_cmp sat_m sat_v leadership_cmp cft {
   ren `var' study_`var'
   }
ren resp_id id
sort id
merge m:1 id using ..\usafa\studies\c00-14demographics
keep if _merge == 3
drop _merge loce* 
gen wm = female==0 & black==0 & hispanic==0 & asian==0
foreach var in id squad4 squad3 wm female black hispanic asian pschool rathlete aca_cmp sat_m sat_v leadership_cmp cft {
   ren `var' resp_`var'
   }
gen same_squad3 = resp_squad3==study_squad3
gen same_squad4 = resp_squad4==study_squad4
gen both_rathlete = resp_rathlete==1 & study_rathlete==1
label var study_wm "Study Partner is White Male"
label var study_black "Study Partner is Black"
label var study_hispanic "Study Partner is Hispanic"
label var study_asian "Study Partner is Asian"
label var both_rathlete "Both are Recruited Athletes"
label var same_squad3 "Both in Same Sophomore Squadron"
label var same_squad4 "Both in Same Freshman Squadron"
save social_survey_study`degree', replace
}

/**********  Table A.1 Friends & Study Partners of White Male Students  *************/

use social_survey_friend4, clear
reg  same_squad4 same_squad3 friend_black friend_hispanic friend_asian friend_wm both_rathlete if resp_wm 
outreg2 using social_isolation_friend_w.tex, nocons nonotes replace se tdec(3) label cttop("Freshman",  "Full" )sum
reg  same_squad4 same_squad3 friend_black friend_hispanic friend_asian friend_wm both_rathlete if resp_wm & same_squad4==0
outreg2 using social_isolation_friend_w.tex, nocons nonotes append se tdec(3) label cttop("Freshman", "Not Matched" )sum
use social_survey_friend3, clear
reg  same_squad4 same_squad3 friend_black friend_hispanic friend_asian friend_wm both_rathlete if resp_wm 
outreg2 using social_isolation_friend_w.tex, nocons nonotes append se tdec(3) label cttop("Sophomore",  "Full" )sum
reg  same_squad4 same_squad3 friend_black friend_hispanic friend_asian friend_wm both_rathlete if resp_wm & same_squad3==0
outreg2 using social_isolation_friend_w.tex, nocons nonotes append tex(frag pretty) se tdec(3) label cttop("Sophomore",  "Not Matched" )sum

use social_survey_study4, clear
reg  same_squad4 same_squad3 study_black study_hispanic study_asian study_wm both_rathlete if resp_wm 
outreg2 using social_isolation_study_w.tex, nocons nonotes replace se tdec(3) label cttop("Freshman",  "Full" )sum
reg  same_squad4 same_squad3 study_black study_hispanic study_asian study_wm both_rathlete if resp_wm & same_squad4==0
outreg2 using social_isolation_study_w.tex, nocons nonotes append se tdec(3) label cttop("Freshman",  "Not Matched" )sum
use social_survey_study3, clear
reg  same_squad4 same_squad3 study_black study_hispanic study_asian study_wm both_rathlete if resp_wm 
outreg2 using social_isolation_study_w.tex, nocons nonotes append se tdec(3) label cttop("Sophomore",  "Full" )sum
reg  same_squad4 same_squad3 study_black study_hispanic study_asian study_wm both_rathlete if resp_wm & same_squad3==0
outreg2 using social_isolation_study_w.tex, nocons nonotes append tex(frag pretty) se tdec(3) label cttop("Sophomore",  "Not Matched" )sum


/*************** Table A.2 Friends & Study Partners of Black Male Students *****************/

use social_survey_friend4, clear
reg  same_squad4 same_squad3 friend_black friend_hispanic friend_asian friend_wm  both_rathlete if resp_black==1 & resp_female==0 
outreg2 using social_isolation_friend_b.tex, nocons nonotes replace se tdec(3) label cttop("Freshman",  "Full" )sum
reg  same_squad4 same_squad3 friend_black friend_hispanic friend_asian friend_wm both_rathlete if resp_black==1 & resp_female==0 & same_squad4==0
outreg2 using social_isolation_friend_b.tex, nocons nonotes append se tdec(3) label cttop("Freshman", "Not Matched" )sum
use social_survey_friend3, clear
reg  same_squad4 same_squad3 friend_black friend_hispanic friend_asian friend_wm both_rathlete if resp_black==1 & resp_female==0 
outreg2 using social_isolation_friend_b.tex, nocons nonotes append se tdec(3) label cttop("Sophomore",  "Full" )sum
reg  same_squad4 same_squad3 friend_black friend_hispanic friend_asian friend_wm both_rathlete if resp_black==1 & resp_female==0 & same_squad3==0
outreg2 using social_isolation_friend_b.tex, nocons nonotes append tex(frag pretty) se tdec(3) label cttop("Sophomore",  "Not Matched" )sum

use social_survey_study4, clear
reg  same_squad4 same_squad3 study_black study_hispanic study_asian study_wm both_rathlete if resp_black==1 & resp_female==0 
outreg2 using social_isolation_study_b.tex, nocons nonotes replace se tdec(3) label cttop("Freshman",  "Full" )sum
reg  same_squad4 same_squad3 study_black study_hispanic study_asian study_wm both_rathlete if resp_black==1 & resp_female==0 & same_squad4==0
outreg2 using social_isolation_study_b.tex, nocons nonotes append se tdec(3) label cttop("Freshman",  "Not Matched" )sum
use social_survey_study3, clear
reg  same_squad4 same_squad3 study_black study_hispanic study_asian study_wm both_rathlete if resp_black==1 & resp_female==0 
outreg2 using social_isolation_study_b.tex, nocons nonotes append se tdec(3) label cttop("Sophomore",  "Full" )sum
reg  same_squad4 same_squad3 study_black study_hispanic study_asian study_wm both_rathlete if resp_black==1 & resp_female==0 & same_squad3==0
outreg2 using social_isolation_study_b.tex, nocons nonotes append tex(frag pretty) se tdec(3) label cttop("Sophomore",  "Not Matched" )sum

/**********  Table A.3 Black Friends Outside Freshman Squadron ****************/

use social_survey_friend4
ren resp_id id
ren resp_squad4 squad4
sort id
by id: egen num_black_friends = sum(friend_black)
by id: egen fs = sum(friend_black) if same_squad4==1
by id: egen fd = sum(friend_black) if same_squad4==0
by id: egen num_black_friends_same = max(fs)
by id: egen num_black_friends_out = max(fd)
duplicates  drop id, force
replace num_black_friends_same = 0 if missing(num_black_friends_same)
replace num_black_friends_out = 0 if missing(num_black_friends_out)
gen black_friends_out = num_black_friends_out > 0
sort cyear squad4
merge m:1 cyear squad4 using demo
drop if _merge != 3
drop _merge
sort cyear squad4
egen cyear_squad4 = group(cyear squad4)

label var fresh_black_aca "Black Freshman HS Performance"
label var fresh_black_sat "Black Freshman SAT"
label var fresh_num_black "Number of Black Freshmen"
label var num_black_friends_out "Outside Black Friends"


reg num_black_friends_out fresh_black_aca fresh_black_sat fresh_num_black no_blacks_fresh i.cyear sat_v sat_m leadership_cmp cft_score aca_cmp rathlete pschool missing_aca_cmp missing_sat_v missing_sat_m missing_leadership_cmp missing_cft_score missing_rathlete fresh_wm_aca fresh_wm_sat fresh_bu_aca fresh_bu_sat missing_bu_aca missing_bu_sat if resp_wm==1, cluster(cyear_squad4) 
outreg2 using outside_black_friend_reg.tex, keep(fresh_black_aca fresh_black_sat fresh_num_black) replace tex(frag pretty) nocons nonotes se  bdec(4)  tdec(3)  label 


/*************  Falsification:  Fresh WM on Avg Fresh Black Attributes 4 **********/
/*************  Panel A:  Algorthmic Assignment to Squadrons *******************/

scalar rotate_start = 1

local rep = 5000

set seed 20130326
use ayear4, clear
sort id
merge 1:1 id using ..\usafa\studies\c00-14demographics
keep if _merge == 3
drop _merge
ren leadership_cmp lead_cmp
drop if missing(female) | missing(black) | missing(hispanic) | missing(asian)
gen white = (black==0) & (hispanic==0) & (asian==0)
gen wm = white & female == 0
sort ayear4 squad4 id
gen sat = sat_m + sat_v
egen ayear4squad4 = group(ayear4 squad4)
egen b4a = mean(aca_cmp) if black == 1 & squad4 != . & squad4 < 37, by(ayear4squad4)
egen b4s = mean(sat) if black == 1& squad4 != . & squad4 < 37, by(ayear4squad4)
egen b4l = mean(lead_cmp) if black == 1& squad4 != . & squad4 < 37, by(ayear4squad4)
egen b4c = mean(cft_score) if black == 1& squad4 != . & squad4 < 37, by(ayear4squad4)
egen b4aca = max(b4a) if squad4 != . & squad4 < 37, by(ayear4squad4)
egen b4sat = max(b4s) if squad4 != . & squad4 < 37, by(ayear4squad4)
egen b4ldr = max(b4l) if squad4 != . & squad4 < 37, by(ayear4squad4)
egen b4cft = max(b4c) if squad4 != . & squad4 < 37, by(ayear4squad4)
egen b4num = sum(black) if squad4 != . & squad4 < 37, by(ayear4squad4)
by ayear4: center sat aca_cmp lead_cmp cft_score b4aca b4sat b4ldr b4cft, standardize 
* gen c_sat = sat
* ren b4aca c_b4aca
* ren b4sat c_b4sat
ren b4num c_b4num
gen no_fresh_black = c_b4num == 0
foreach var in c_b4aca c_b4sat c_b4ldr c_b4cft {
   replace `var' = 0 if no_fresh_black == 1
   }
foreach var in aca_cmp sat lead_cmp cft {
   gen mb_`var' = black == 1 & missing(`var')
   egen smb_`var' = max(mb_`var'), by(ayear4squad4)
   }
gen m_b4aca = missing(c_b4aca) & smb_aca_cmp == 1
gen m_b4sat = missing(c_b4sat) & smb_sat == 1
gen m_b4ldr = missing(c_b4ldr) & smb_lead_cmp == 1
gen m_b4cft = missing(c_b4cft) & smb_cft == 1
replace c_b4aca = 0 if m_b4aca == 1
replace c_b4sat = 0 if m_b4sat == 1
replace c_b4ldr = 0 if m_b4ldr == 1
replace c_b4cft = 0 if m_b4cft == 1

gen double r = 0
gen s = 0
gen y = 0
gen assigned = 0
gen fillers = 0

foreach y in c_aca_cmp c_sat c_lead_cmp c_cft_score {
   reg `y' c_b4aca c_b4sat c_b4ldr c_b4cft c_b4num no_fresh_black m_b4* if wm==1 
   foreach x in  b4aca b4sat b4ldr b4cft b4num {
      scalar b_`y'c_r`x' = _b[c_`x']
	  scalar a_`y'c_r`x' = 0
	  scalar ar_`y'c_r`x' = 0
	  }
    } 

forvalues i = 1/`rep' {
  if `i'/1000 == round(`i'/1000) {
     display `i'
     }
  quietly {
  replace s = 40
  replace assigned = 0
  sort ayear4 id
  replace r = runiform()
  foreach year in 1998 2000 2001 2002 2003 {
    replace y = ayear4 == `year'
    sum ayear4 if y
    scalar sq_size = trunc(`r(N)'/36) 
	gsort -y -female +r, g(n)
	replace s = mod(n,36) if female == 1 & y
	replace assigned = 1 if female == 1 & y
	sum n if female == 1 & y
	local next = mod(`r(N)',36)
	if rotate_start == 0 {
		local next = 0 
		}
	drop n
	gsort -y -black +assigned +r, g(n)
	replace s = mod(n+`next',36) if black == 1 & assigned == 0 & y
	sum n if black == 1 & assigned == 0 & y
	local next = mod(`r(N)'+`next',36)
	if rotate_start == 0 {
		local next = 0 
		}
	drop n
	replace assigned = 1 if black == 1 & y
	gsort -y -hispanic +assigned +r, g(n)
	replace s = mod(n+`next',36) if hispanic == 1 & assigned == 0 & y
	sum n if hispanic == 1 & assigned == 0 & y
	local next = mod(`r(N)'+`next',36)
	if rotate_start == 0 {
		local next = 0 
		}
	drop n
	replace assigned = 1 if hispanic == 1 & y
	gsort -y -asian +assigned +r, g(n)
	replace s = mod(n+`next',36) if asian == 1 & assigned == 0 & y
	sum n if asian == 1 & assigned == 0 & y
	local next = mod(`r(N)'+`next',36)
	if rotate_start == 0 {
		local next = 0 
		}
	replace assigned = 1 if asian == 1 & y
	drop n
	gsort -y -rathlete +assigned +r, g(n)
	replace s = mod(n+`next',36) if rathlete == 1 & assigned == 0 & y
	sum n if rathlete == 1 & assigned == 0 & y
	local next = mod(`r(N)'+`next',36)
	if rotate_start == 0 {
		local next = 0 
		}
	replace assigned = 1 if rathlete == 1 & y
	drop n 
 	gsort -y -pschool +assigned +r, g(n)
	replace s = mod(n+`next',36) if pschool==1 & assigned == 0 & y
	replace assigned = 1 if pschool == 1 & y
	drop n 
    replace s = 36 if s == 0	& y
	forvalues j = 1/36 {
	    quietly sum ayear4 if s == `j' & y
		scalar needed = sq_size - `r(N)'
		gsort -y +assigned +r, g(n)
		replace s = `j' if n <= needed
		replace assigned = 1 if n <= needed
		drop n
		}
	gsort -y +assigned +r, g(n)
	replace s = n if assigned == 0 & y
	drop n
	}
  sort ayear4 s
  egen rb4a = mean(aca_cmp) if black == 1, by(ayear4 s)
  egen rb4s = mean(sat) if black == 1, by(ayear4 s)
  egen rb4l = mean(lead_cmp) if black == 1, by(ayear4 s)
  egen rb4c = mean(cft_score) if black == 1, by(ayear4 s)
  egen rb4aca = max(rb4a), by(ayear4 s)
  egen rb4sat = max(rb4s), by(ayear4 s)
  egen rb4ldr = max(rb4l), by(ayear4 s)
  egen rb4cft = max(rb4c), by(ayear4 s)
  egen rb4num = sum(black), by(ayear4 s)
  by ayear4: center rb4aca rb4sat rb4ldr rb4cft, standardize
  ren rb4num c_rb4num

  foreach var in aca_cmp sat lead_cmp cft {
    egen rsmb_`var' = max(mb_`var'), by(ayear4 s)
    }
  gen m_rb4aca = missing(c_rb4aca) & rsmb_aca_cmp == 1
  gen m_rb4sat = missing(c_rb4sat) & rsmb_sat == 1
  gen m_rb4ldr = missing(c_rb4ldr) & rsmb_lead_cmp == 1
  gen m_rb4cft = missing(c_rb4cft) & rsmb_cft == 1
  replace c_rb4aca = 0 if m_rb4aca == 1
  replace c_rb4sat = 0 if m_rb4sat == 1
  replace c_rb4ldr = 0 if m_rb4ldr == 1
  replace c_rb4cft = 0 if m_rb4cft == 1
  foreach y in c_aca_cmp c_sat c_lead_cmp c_cft_score {
     reg `y' c_rb4aca c_rb4sat c_rb4ldr c_rb4cft c_rb4num m_rb4* if wm == 1 
     foreach x in c_rb4aca c_rb4sat c_rb4ldr c_rb4cft c_rb4num {
 	    scalar a_`y'`x' = a_`y'`x' + (_b[`x'] < b_`y'`x')
		}
 
	 }
  drop rb4a rb4s rb4l rb4c rb4aca rb4sat rb4ldr rb4cft c_r* m_r* rsmb_*

  }
  }
  
label var c_b4aca "Black Freshman HS Performance"
label var c_b4sat "Black Freshman SAT Score"
label var c_b4ldr "Black Freshman Leadership Score"
label var c_b4cft "Black Freshman Fitness Score"
label var c_b4num "Number of Black Freshmen"  
  
tempname out_main out_t
postfile `out_main' str20 y str20 x  p using false_fresh_A4A_algo, replace

foreach y in c_aca_cmp c_sat c_lead_cmp c_cft_score {
   foreach x in  c_rb4aca c_rb4sat c_rb4ldr c_rb4cft c_rb4num  {
      post `out_main' ("`y'") ("`x'")  (a_`y'`x'/`rep')
	  }
	}
foreach y in c_aca_cmp c_sat c_lead_cmp c_cft_score {
    reg `y' c_b4aca c_b4sat c_b4ldr c_b4cft c_b4num no_fresh_black m_b4* if wm==1 , cluster(ayear4squad4)
    scalar j = 0
    foreach x in b4aca b4sat b4ldr b4cft b4num  {
       scalar j = j + 1
       local num = "p" + string(j)
       scalar `num'  = 2*min(a_`y'c_r`x'/`rep',1-a_`y'c_r`x'/`rep')
      }
	if `y' == c_aca_cmp {
	   outreg2 using falsification_fresh_A4A_r.tex, keep(c_b4aca c_b4sat c_b4ldr c_b4cft c_b4num) nocons nonotes replace se  tdec(3) bd(3) label ct("Academic", "Composiite") /*
	   */ addstat("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5)
 	   }
 	if `y' == c_sat  {
	   outreg2 using falsification_fresh_A4A_r.tex, keep(c_b4aca c_b4sat c_b4ldr c_b4cft c_b4num) nocons nonotes append se  tdec(3) bd(3) label ct("SAT") /* 
	   */ addstat("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5)
  	   }
 	if  `y' == c_lead_cmp {
	   outreg2 using falsification_fresh_A4A_r.tex, keep(c_b4aca c_b4sat c_b4ldr c_b4cft c_b4num) nocons nonotes append se  tdec(3) bd(3) label ct("lead", "Composite") /*
	   */ addstat("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5)
 	   }
	if `y' == c_cft_score {
	   outreg2 using falsification_fresh_A4A_r.tex, keep(c_b4aca c_b4sat c_b4ldr c_b4cft c_b4num) nocons nonotes append tex(frag pretty) se  tdec(3) bd(3) label ct("Fitness",  "Test") /*
	   */ addstat("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5)
 	   }

    }

	
postclose `out_main'


use false_fresh_A4A_algo, clear

scalar c2 = 0
forvalues i = 0.1 (0.1)1 {
   quietly sum p if p >= `i'-.1 & p < `i'
   scalar c2 = c2 + ((r(N)-2)^2/2)
   }
scalar pval = chi2tail(10,c2)
display "Algorithm A4A " pval

/*************  Panel B:  Random Assignment to Squadrons *******************/

set seed 20130326
use ayear4, clear
sort id
merge 1:1 id using ..\usafa\studies\c00-14demographics
keep if _merge == 3
drop _merge
ren leadership_cmp lead_cmp
drop if missing(female) | missing(black) | missing(hispanic) | missing(asian)
gen white = (black==0) & (hispanic==0) & (asian==0)
gen wm = white & female == 0
sort ayear4 squad4 id
gen sat = sat_m + sat_v
egen ayear4squad4 = group(ayear4 squad4)
egen b4a = mean(aca_cmp) if black == 1 & squad4 != . & squad4 < 37, by(ayear4squad4)
egen b4s = mean(sat) if black == 1& squad4 != . & squad4 < 37, by(ayear4squad4)
egen b4l = mean(lead_cmp) if black == 1& squad4 != . & squad4 < 37, by(ayear4squad4)
egen b4c = mean(cft_score) if black == 1& squad4 != . & squad4 < 37, by(ayear4squad4)
egen b4aca = max(b4a) if squad4 != . & squad4 < 37, by(ayear4squad4)
egen b4sat = max(b4s) if squad4 != . & squad4 < 37, by(ayear4squad4)
egen b4ldr = max(b4l) if squad4 != . & squad4 < 37, by(ayear4squad4)
egen b4cft = max(b4c) if squad4 != . & squad4 < 37, by(ayear4squad4)
egen b4num = sum(black) if squad4 != . & squad4 < 37, by(ayear4squad4)
by ayear4: center sat aca_cmp lead_cmp cft_score b4aca b4sat b4ldr b4cft, standardize 
* gen c_sat = sat
* ren b4aca c_b4aca
* ren b4sat c_b4sat
ren b4num c_b4num
gen no_fresh_black = c_b4num == 0
foreach var in c_b4aca c_b4sat c_b4ldr c_b4cft {
   replace `var' = 0 if no_fresh_black == 1
   }
foreach var in aca_cmp sat lead_cmp cft {
   gen mb_`var' = black == 1 & missing(`var')
   egen smb_`var' = max(mb_`var'), by(ayear4squad4)
   }
gen m_b4aca = missing(c_b4aca) & smb_aca_cmp == 1
gen m_b4sat = missing(c_b4sat) & smb_sat == 1
gen m_b4ldr = missing(c_b4ldr) & smb_lead_cmp == 1
gen m_b4cft = missing(c_b4cft) & smb_cft == 1
replace c_b4aca = 0 if m_b4aca == 1
replace c_b4sat = 0 if m_b4sat == 1
replace c_b4ldr = 0 if m_b4ldr == 1
replace c_b4cft = 0 if m_b4cft == 1

gen double r = 0
gen s = 0
gen y = 0
gen assigned = 0
gen fillers = 0

foreach y in c_aca_cmp c_sat c_lead_cmp c_cft_score {
   reg `y' c_b4aca c_b4sat c_b4ldr c_b4cft c_b4num no_fresh_black m_b4* if wm==1 
   foreach x in  b4aca b4sat b4ldr b4cft b4num {
      scalar b_`y'c_r`x' = _b[c_`x']
	  scalar a_`y'c_r`x' = 0
	  }
   } 


  

forvalues i = 1/`rep' {
  if `i'/1000 == round(`i'/1000) {
     display `i'
     }
  quietly {
  replace s = 40
  replace assigned = 0
  sort ayear4 id
  replace r = uniform()
  foreach year in 1998 2000 2001 2002 2003 {
    replace y = ayear4 == `year'
    sum ayear4 if y
    scalar sq_size = trunc(`r(N)'/36) 
	gsort -y -female +r, g(n)
	replace s = mod(n,36) if female == 1 & y
	replace assigned = 1 if female == 1 & y
	sum n if female == 1 & y
	local next = mod(`r(N)',36)
	if rotate_start == 0 {
		local next = 0 
		}
	drop n
	gsort -y female +r, g(n)
	replace s = mod(n+`next',36) if female==0 & assigned == 0 & y
	replace assigned = 1 if female == 0 & y
    replace s = 36 if s == 0	& y
	drop n
	forvalues j = 1/36 {
	    quietly sum ayear4 if s == `j' & y
		scalar needed = sq_size - `r(N)'
		gsort -y +assigned +r, g(n)
		replace s = `j' if n <= needed
		replace assigned = 1 if n <= needed
		drop n
		}
	gsort -y +assigned +r, g(n)
	replace s = n if assigned == 0 & y
	drop n
	}
  sort ayear4 s
  egen rb4a = mean(aca_cmp) if black == 1, by(ayear4 s)
  egen rb4s = mean(sat) if black == 1, by(ayear4 s)
  egen rb4l = mean(lead_cmp) if black == 1, by(ayear4 s)
  egen rb4c = mean(cft_score) if black == 1, by(ayear4 s)
  egen rb4aca = max(rb4a), by(ayear4 s)
  egen rb4sat = max(rb4s), by(ayear4 s)
  egen rb4ldr = max(rb4l), by(ayear4 s)
  egen rb4cft = max(rb4c), by(ayear4 s)
  egen rb4num = sum(black), by(ayear4 s)
  by ayear4: center rb4aca rb4sat rb4ldr rb4cft, standardize
  ren rb4num c_rb4num
  gen rno_fresh_black = c_rb4num == 0
  foreach var in aca_cmp sat lead_cmp cft {
    egen rsmb_`var' = max(mb_`var'), by(ayear4 s)
    }
  gen m_rb4aca = missing(c_rb4aca) & rsmb_aca_cmp == 1
  gen m_rb4sat = missing(c_rb4sat) & rsmb_sat == 1
  gen m_rb4ldr = missing(c_rb4ldr) & rsmb_lead_cmp == 1
  gen m_rb4cft = missing(c_rb4cft) & rsmb_cft == 1
  replace c_rb4aca = 0 if m_rb4aca == 1
  replace c_rb4sat = 0 if m_rb4sat == 1
  replace c_rb4ldr = 0 if m_rb4ldr == 1
  replace c_rb4cft = 0 if m_rb4cft == 1
  foreach y in c_aca_cmp c_sat c_lead_cmp c_cft_score {
     reg `y' c_rb4aca c_rb4sat c_rb4ldr c_rb4cft c_rb4num m_rb4* rno_fresh_black if wm == 1 
     foreach x in c_rb4aca c_rb4sat c_rb4ldr c_rb4cft c_rb4num {
 	    scalar a_`y'`x' = a_`y'`x' + (_b[`x'] < b_`y'`x')
		}
 
	 }
  drop rb4a rb4s rb4l rb4c rb4aca rb4sat rb4ldr rb4cft c_r* m_r* rsmb_* rno_fresh_black
  }
  }
  
label var c_b4aca "Black Freshman HS Performance"
label var c_b4sat "Black Freshman SAT Score"
label var c_b4ldr "Black Freshman Leadership Score"
label var c_b4cft "Black Freshman Fitness Score"
label var c_b4num "Number of Black Freshmen"  
  
 
  
tempname out_main out_t
 
postfile `out_main' str20 y str20 x p using false_fresh_A4B_rand, replace

 
foreach y in c_aca_cmp c_sat c_lead_cmp c_cft_score {
   foreach x in  c_rb4aca c_rb4sat c_rb4ldr c_rb4cft c_rb4num  {
      post `out_main' ("`y'") ("`x'")  (a_`y'`x'/`rep')
	  }
	}

	
postclose `out_main'

 
foreach y in c_aca_cmp c_sat c_lead_cmp c_cft_score {
    reg `y' c_b4aca c_b4sat c_b4ldr c_b4cft c_b4num no_fresh_black  m_b4* if wm==1 , cluster(ayear4squad4)
    scalar j = 0
    foreach x in b4aca b4sat b4ldr b4cft b4num  {
       scalar j = j + 1
       local num = "p" + string(j)
       scalar `num'  = 2*min(a_`y'c_r`x'/`rep',1-a_`y'c_r`x'/`rep')
      }
	if `y' == c_aca_cmp {
	   outreg2 using falsification_fresh_A4B_r.tex, keep(c_b4aca c_b4sat c_b4ldr c_b4cft c_b4num) nocons nonotes replace se  tdec(3) bd(3) label ct("Academic", "Composiite") /*
	   */ addstat("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5)
 	   }
 	if `y' == c_sat  {
	   outreg2 using falsification_fresh_A4B_r.tex, keep(c_b4aca c_b4sat c_b4ldr c_b4cft c_b4num) nocons nonotes append se  tdec(3) bd(3) label ct("SAT") /* 
	   */ addstat("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5)
  	   }
 	if  `y' == c_lead_cmp {
	   outreg2 using falsification_fresh_A4B_r.tex, keep(c_b4aca c_b4sat c_b4ldr c_b4cft c_b4num) nocons nonotes append se  tdec(3) bd(3) label ct("lead", "Composite") /*
	   */ addstat("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5)
 	   }
	if `y' == c_cft_score {
	   outreg2 using falsification_fresh_A4B_r.tex, keep(c_b4aca c_b4sat c_b4ldr c_b4cft c_b4num) nocons nonotes append tex(frag pretty) se  tdec(3) bd(3) label ct("Fitness",  "Test") /*
	   */ addstat("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5)
 	   }

    } 

	
use false_fresh_A4B_rand, clear

scalar c2 = 0
forvalues i = 0.1 (0.1)1 {
   quietly sum p if p >= `i'-.1 & p < `i'
   scalar c2 = c2 + ((r(N)-2)^2/2)
   }
scalar pval = chi2tail(10,c2)
display "Randomized A4B " pval

/**************  Sophomore Falsifications: Algorithmic Squadron Assignment A5, Panel A; A6, Panel A ***/

set seed 20130326
use ayear3, clear
duplicates drop id ayear3, force
sort id
merge 1:1 id using ..\usafa\studies\c00-14demographics
keep if _merge == 3
drop _merge
ren leadership_cmp lead_cmp
drop if  missing(female) | missing(black) | missing(hispanic) | missing(asian)
gen white = (black==0) & (hispanic==0) & (asian==0)
gen wm = white & female == 0
sort cyear squad4 id
gen sat = sat_m + sat_v
egen ayear4squad4 = group(ayear4 squad4)
egen b4a = mean(aca_cmp) if black == 1 & squad4 != . & squad4 < 37, by(cyear squad4)
egen b4s = mean(sat) if black == 1& squad4 != . & squad4 < 37, by(cyear squad4)
egen b4l = mean(lead_cmp) if black == 1& squad4 != . & squad4 < 37, by(cyear squad4)
egen b4c = mean(cft_score) if black == 1& squad4 != . & squad4 < 37, by(cyear squad4)
egen b4aca = max(b4a) if squad4 != . & squad4 < 37, by(cyear squad4)
egen b4sat = max(b4s) if squad4 != . & squad4 < 37, by(cyear squad4)
egen b4ldr = max(b4l) if squad4 != . & squad4 < 37, by(cyear squad4)
egen b4cft = max(b4c) if squad4 != . & squad4 < 37, by(cyear squad4)
egen b4num = sum(black) if squad4 != . & squad4 < 37, by(cyear squad4)
sort ayear4
by ayear4: center aca_cmp lead_cmp cft_score b4aca b4sat b4ldr b4cft, standardize 
gen c_sat = sat
* ren b4aca c_b4aca
* ren b4sat c_b4sat
ren b4num c_b4num
gen no_fresh_black = c_b4num == 0
foreach var in c_b4aca c_b4sat c_b4ldr c_b4cft {
   replace `var' = 0 if no_fresh_black == 1
   }
sort ayear3 squad3 id
egen ayear3squad3 = group(ayear3 squad3)
egen b3a = mean(aca_cmp) if black == 1 & squad3 != . & squad3 < 37, by(ayear3 squad3)
egen b3s = mean(sat) if black == 1 & squad3 != . & squad3 < 37, by(ayear3 squad3)
egen b3l = mean(lead_cmp) if black == 1 & squad3 != . & squad3 < 37, by(ayear3 squad3)
egen b3c = mean(cft_score) if black == 1 & squad3 != . & squad3 < 37, by(ayear3 squad3)
egen b3aca = max(b3a) if  squad3 != . & squad3 < 37, by(ayear3 squad3)
egen b3sat = max(b3s) if squad3 != . & squad3 < 37, by(ayear3 squad3)
egen b3ldr = max(b3l) if squad3 != . & squad3 < 37, by(ayear3 squad3)
egen b3cft = max(b3c) if squad3 != . & squad3 < 37, by(ayear3 squad3)
egen b3num = sum(black) if squad3 != . & squad3 < 37, by(ayear3 squad3)
by ayear3: center b3aca b3sat b3ldr b3cft, standardize 
* ren b3aca c_b3aca
* ren b3sat c_b3sat
foreach var in aca sat ldr cft {
   gen missing_b3`var' = c_b3`var' == .
   replace c_b3`var' = 0 if c_b3`var' == .
   }
foreach var in aca_cmp sat lead_cmp cft {
   gen mb_`var' = black == 1 & missing(`var')
   egen smb3_`var' = max(mb_`var'), by(ayear3 squad3)
   }
gen m_b3aca = missing(c_b3aca) & smb3_aca_cmp == 1
gen m_b3sat = missing(c_b3sat) & smb3_sat == 1
gen m_b3ldr = missing(c_b3ldr) & smb3_lead_cmp == 1
gen m_b3cft = missing(c_b3cft) & smb3_cft == 1
replace c_b3aca = 0 if m_b3aca == 1
replace c_b3sat = 0 if m_b3sat == 1
replace c_b3ldr = 0 if m_b3ldr == 1
replace c_b3cft = 0 if m_b3cft == 1
ren b3num c_b3num
gen double r = 0
gen s = 0
gen y = 0
gen assigned = 0
gen fillers = 0
gen same = 0
foreach y in c_aca_cmp c_sat c_lead_cmp c_cft_score {
   xi:reg `y' c_b3aca c_b3sat c_b3ldr c_b3cft c_b3num m_b3* if wm==1 
   foreach x in  b3aca b3sat b3ldr b3cft b3num {
       scalar b_`y'c_r`x' = _b[c_`x']
	  scalar a_`y'c_r`x' = 0
	  }
   }
foreach y in c_b4aca c_b4sat c_b4ldr c_b4cft c_b4num {
   xi:reg `y' c_b3aca c_b3sat c_b3ldr c_b3cft c_b3num i.ayear4 m_b3* if wm==1 & no_fresh_black == 0
   foreach x in  b3aca b3sat b3ldr b3cft b3num {
       scalar b_`y'c_r`x' = _b[c_`x']
	  scalar a_`y'c_r`x' = 0
	  }
   }
forvalues i = 1/`rep' {
  if `i'/1000 == round(`i'/1000) {
     display `i'
     }
  quietly {
  replace s = 40
  replace assigned = 0
  sort cyear id
  replace r = uniform()
  foreach year in 1999 2001 2002 2003 2004 {
    replace y = ayear3 == `year'
    sum ayear3 if y
    scalar sq_size = trunc(`r(N)'/36) 
	gsort -y -female +r, g(n)
	replace s = mod(n,36) if female == 1 & y
	replace assigned = 1 if female == 1 & y
	sum n if female == 1 & y
	local next = mod(`r(N)',36)
	if rotate_start == 0 {
		local next = 0 
		}
	drop n
	gsort -y -black +assigned +r, g(n)
	replace s = mod(n+`next',36) if black == 1 & assigned == 0 & y
	sum n if black == 1 & assigned == 0 & y
	local next = mod(`r(N)'+`next',36)
	if rotate_start == 0 {
		local next = 0 
		}
	drop n
	replace assigned = 1 if black == 1 & y
	gsort -y -hispanic +assigned +r, g(n)
	replace s = mod(n+`next',36) if hispanic == 1 & assigned == 0 & y
	sum n if hispanic == 1 & assigned == 0 & y
	local next = mod(`r(N)'+`next',36)
	if rotate_start == 0 {
		local next = 0 
		}
	drop n
	replace assigned = 1 if hispanic == 1 & y
	gsort -y -asian +assigned +r, g(n)
	replace s = mod(n+`next',36) if asian == 1 & assigned == 0 & y
	sum n if asian == 1 & assigned == 0 & y
	local next = mod(`r(N)'+`next',36)
	if rotate_start == 0 {
		local next = 0 
		}
	replace assigned = 1 if asian == 1 & y
	drop n
	gsort -y -rathlete +assigned +r, g(n)
	replace s = mod(n+`next',36) if rathlete == 1 & assigned == 0 & y
	sum n if rathlete == 1 & assigned == 0 & y
	local next = mod(`r(N)'+`next',36)
	if rotate_start == 0 {
		local next = 0 
		}
	replace assigned = 1 if rathlete == 1 & y
	drop n 
 	gsort -y -pschool +assigned +r, g(n)
	replace s = mod(n+`next',36) if pschool==1 & assigned == 0 & y
	replace assigned = 1 if pschool == 1 & y
	drop n 
    replace s = 36 if s == 0	& y
	forvalues j = 1/36 {
	    quietly sum ayear3 if s == `j' & y
		scalar needed = sq_size - `r(N)'
		gsort -y +assigned +r, g(n)
		replace s = `j' if n <= needed
		replace assigned = 1 if n <= needed
		drop n
		}
	gsort -y +assigned +r, g(n)
	replace s = n if assigned == 0 & y
	sum n if assigned == 0 & y
    local next = mod(`r(N)',36)
	drop n
	replace same = squad4 == s
    replace r = uniform() if same & y
	gsort -y -same +r, g(n)
	replace s = mod(n+`next',36) if same & y
	replace s = 36 if s == 0 & y
	drop n
	}
  sort ayear3 s
  egen rb3a = mean(aca_cmp) if black == 1, by(ayear3 s)
  egen rb3s = mean(sat) if black == 1, by(ayear3 s)
  egen rb3l = mean(lead_cmp) if black == 1, by(ayear3 s)
  egen rb3c = mean(cft_score) if black == 1, by(ayear3 s)
  egen rb3aca = max(rb3a), by(ayear3 s)
  egen rb3sat = max(rb3s), by(ayear3 s)
  egen rb3ldr = max(rb3l), by(ayear3 s)
  egen rb3cft = max(rb3c), by(ayear3 s)
  egen rb3num = sum(black), by(ayear3 s)
  by ayear3: center rb3aca rb3sat rb3ldr rb3cft, standardize
  foreach var in aca_cmp sat lead_cmp cft {
     egen rsmb3_`var' = max(mb_`var'), by(ayear3 s)
     }
  gen m_rb3aca = missing(c_rb3aca) & rsmb3_aca_cmp == 1
  gen m_rb3sat = missing(c_rb3sat) & rsmb3_sat == 1
  gen m_rb3ldr = missing(c_rb3ldr) & rsmb3_lead_cmp == 1
  gen m_rb3cft = missing(c_rb3cft) & rsmb3_cft == 1
  replace c_rb3aca = 0 if m_rb3aca == 1
  replace c_rb3sat = 0 if m_rb3sat == 1
  replace c_rb3ldr = 0 if m_rb3ldr == 1
  replace c_rb3cft = 0 if m_rb3cft == 1
  ren rb3num c_rb3num
  foreach y in c_aca_cmp c_sat c_lead_cmp c_cft_score {
     xi:reg `y' c_rb3aca c_rb3sat c_rb3ldr c_rb3cft c_rb3num m_rb3* if wm == 1
     foreach x in c_rb3aca c_rb3sat c_rb3ldr c_rb3cft c_rb3num {
 	    scalar a_`y'`x' = a_`y'`x' + (_b[`x'] < b_`y'`x')
        }
	}
  foreach y in c_b4aca c_b4sat c_b4ldr c_b4cft c_b4num {
     xi:reg `y' c_rb3aca c_rb3sat c_rb3ldr c_rb3cft c_rb3num i.ayear4 m_rb3* if wm == 1 & no_fresh_black == 0
     foreach x in c_rb3aca c_rb3sat c_rb3ldr c_rb3cft c_rb3num {
 	    scalar a_`y'`x' = a_`y'`x' + (_b[`x'] < b_`y'`x')
        }
	}
 	 }
  drop rb3a rb3s rb3l rb3c rb3aca rb3sat rb3ldr rb3cft c_r* m_r* rsmb3_*
  }

 

 
label var c_b3aca "Sophomore Black HS Performance"
label var c_b3sat "Sophomore Black SAT Score"
label var c_b3ldr "Sophomore Black Leadership Score"
label var c_b3cft "Sophomore Black Fitness Score"
label var c_b3num "Number of Sophomore Black Students"

tempname out_b out_c
postfile `out_b' str20 y str20 x  p using soph_falsification_A5A_algo, replace
postfile `out_c' str20 y str20 x  p using soph_falsification_A6A_algo, replace


foreach y in c_aca_cmp c_sat c_lead_cmp c_cft_score  {
    foreach x in  c_rb3aca c_rb3sat c_rb3ldr c_rb3cft c_rb3num {
        post `out_b' ("`y'") ("`x'")  (a_`y'`x'/`rep')
		}
	}

foreach y in c_b4aca c_b4sat c_b4ldr c_b4cft c_b4num {
    foreach x in  c_rb3aca c_rb3sat c_rb3ldr c_rb3cft c_rb3num {
        post `out_c' ("`y'") ("`x'")  (a_`y'`x'/`rep')
        }
	}

postclose `out_b'
postclose `out_c'	

foreach y in c_aca_cmp c_sat c_lead_cmp c_cft_score  {
    xi:reg `y' c_b3aca c_b3sat c_b3ldr c_b3cft c_b3num missing_b3* m_b3* if wm==1 , cluster(ayear3squad3)
    scalar j = 0
    foreach x in  c_rb3aca c_rb3sat c_rb3ldr c_rb3cft c_rb3num {
	    scalar j = j + 1
        local num = "p" + string(j)
        scalar `num'  = 2*min(a_`y'`x'/`rep',1-a_`y'`x'/`rep')
		} 
	if `y' == c_aca_cmp {
	   outreg2 using falsification_soph_algo_A5A_r.tex, keep(c_b3aca c_b3sat c_b3ldr c_b3cft c_b3num) nocons nonotes replace se 10pct tdec(3) bd(3) label ct("High School", "Performance") /*
	   */ addstat("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5 )
 	   }
 	if `y' == c_sat  {
	   outreg2 using falsification_soph_algo_A5A_r.tex, keep(c_b3aca c_b3sat c_b3ldr c_b3cft c_b3num) nocons nonotes append se 10pct tdec(3) bd(3) label ct("SAT") /* 
	   */ addstat("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5 )
  	   }
 	if  `y' == c_lead_cmp {
	   outreg2 using falsification_soph_algo_A5A_r.tex, keep(c_b3aca c_b3sat c_b3ldr c_b3cft c_b3num) nocons nonotes append se 10pct tdec(3) bd(3) label ct("lead", "Score") /*
	   */ addstat("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5 )
  	   }
	if `y' == c_cft_score {
	   outreg2 using falsification_soph_algo_A5A_r.tex, keep(c_b3aca c_b3sat c_b3ldr c_b3cft c_b3num) nocons nonotes append tex(frag pretty) se 10pct tdec(3) bd(3) label ct("Fitness",  "Score") /*
	   */ addstat("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5 )
 	   }
	}

	
	
foreach y in c_b4aca c_b4sat c_b4ldr c_b4cft c_b4num {
    xi:reg `y' c_b3aca c_b3sat c_b3ldr c_b3cft c_b3num i.ayear4 missing_b3* m_b3* if wm==1 & no_fresh_black == 0 , cluster(ayear3squad3)
    scalar j = 0
    foreach x in  c_rb3aca c_rb3sat c_rb3ldr c_rb3cft c_rb3num {
	    scalar j = j + 1
        local num = "p" + string(j)
        scalar `num'  = 2*min(a_`y'`x'/`rep',1-a_`y'`x'/`rep')
		}
	if `y' == c_b4aca {
	   outreg2 using falsification_soph_algo_A6A_r.tex, keep(c_b3aca c_b3sat c_b3ldr c_b3cft c_b3num) nocons nonotes replace  se 10pct tdec(3) bd(3) label ct("Fresh Black", "High School", "Performance") /*
	   */ addstat("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5 )
 	   }
	if `y' == c_b4sat {
	   outreg2 using falsification_soph_algo_A6A_r.tex, keep(c_b3aca c_b3sat c_b3ldr c_b3cft c_b3num) nocons nonotes append  se 10pct tdec(3) bd(3) label ct("Fresh Black",  "SAT") /*
	   */ addstat("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5 )
 	   }
	if `y' == c_b4ldr {
	   outreg2 using falsification_soph_algo_A6A_r.tex, keep(c_b3aca c_b3sat c_b3ldr c_b3cft c_b3num) nocons nonotes append  se 10pct tdec(3) bd(3) label ct("Fresh Black",  "lead", "Score") /*
	   */ addstat("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5 )
 	   }
	if `y' == c_b4cft {
	   outreg2 using falsification_soph_algo_A6A_r.tex, keep(c_b3aca c_b3sat c_b3ldr c_b3cft c_b3num) nocons nonotes append  se 10pct tdec(3) bd(3) label ct("Fresh Black", "Fitness", "Score") /*
	   */ addstat("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5 )
 	   }
	if `y' == c_b4num {
	   outreg2 using falsification_soph_algo_A6A_r.tex, keep(c_b3aca c_b3sat c_b3ldr c_b3cft c_b3num) nocons nonotes append tex(frag pretty) se 10pct tdec(3) bd(3) label ct("Number", "Fresh Black") /*
	   */ addstat("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5 )
 	   } 
	}



use soph_falsification_A5A_algo, clear

scalar c2 = 0
forvalues i = 0.1 (0.1)1 {
   quietly sum p if p >= `i'-.1 & p < `i'
   scalar c2 = c2 + ((r(N)-2)^2/2)
   }
scalar pval = chi2tail(10,c2)
display "Sophomore A5A Algorithm  " pval

use soph_falsification_A6A_algo, clear

scalar c2 = 0
forvalues i = 0.1 (0.1)1 {
   quietly sum p if p >= `i'-.1 & p < `i'
   scalar c2 = c2 + ((r(N)-2)^2/2)
   }
scalar pval = chi2tail(10,c2)
display "Sophomore A6A Algorithm  " pval


/**************  Sophomore Falsifications: Random Squadron Assignment A5, Panel B; A6, Panel B ***/

set seed 20130326
use ayear3, clear
duplicates drop id ayear3, force
sort id
merge 1:1 id using ..\usafa\studies\c00-14demographics
keep if _merge == 3
drop _merge
ren leadership_cmp lead_cmp
drop if  missing(female) | missing(black) | missing(hispanic) | missing(asian)
gen white = (black==0) & (hispanic==0) & (asian==0)
gen wm = white & female == 0
sort cyear squad4 id
gen sat = sat_m + sat_v
egen ayear4squad4 = group(ayear4 squad4)
egen b4a = mean(aca_cmp) if black == 1 & squad4 != . & squad4 < 37, by(cyear squad4)
egen b4s = mean(sat) if black == 1& squad4 != . & squad4 < 37, by(cyear squad4)
egen b4l = mean(lead_cmp) if black == 1& squad4 != . & squad4 < 37, by(cyear squad4)
egen b4c = mean(cft_score) if black == 1& squad4 != . & squad4 < 37, by(cyear squad4)
egen b4aca = max(b4a) if squad4 != . & squad4 < 37, by(cyear squad4)
egen b4sat = max(b4s) if squad4 != . & squad4 < 37, by(cyear squad4)
egen b4ldr = max(b4l) if squad4 != . & squad4 < 37, by(cyear squad4)
egen b4cft = max(b4c) if squad4 != . & squad4 < 37, by(cyear squad4)
egen b4num = sum(black) if squad4 != . & squad4 < 37, by(cyear squad4)
sort ayear4
by ayear4: center aca_cmp lead_cmp cft_score b4aca b4sat b4ldr b4cft, standardize 
gen c_sat = sat
* ren b4aca c_b4aca
* ren b4sat c_b4sat
ren b4num c_b4num
gen no_fresh_black = c_b4num == 0
foreach var in c_b4aca c_b4sat c_b4ldr c_b4cft {
   replace `var' = 0 if no_fresh_black == 1
   }
sort ayear3 squad3 id
egen ayear3squad3 = group(ayear3 squad3)
egen b3a = mean(aca_cmp) if black == 1 & squad3 != . & squad3 < 37, by(ayear3 squad3)
egen b3s = mean(sat) if black == 1 & squad3 != . & squad3 < 37, by(ayear3 squad3)
egen b3l = mean(lead_cmp) if black == 1 & squad3 != . & squad3 < 37, by(ayear3 squad3)
egen b3c = mean(cft_score) if black == 1 & squad3 != . & squad3 < 37, by(ayear3 squad3)
egen b3aca = max(b3a) if  squad3 != . & squad3 < 37, by(ayear3 squad3)
egen b3sat = max(b3s) if squad3 != . & squad3 < 37, by(ayear3 squad3)
egen b3ldr = max(b3l) if squad3 != . & squad3 < 37, by(ayear3 squad3)
egen b3cft = max(b3c) if squad3 != . & squad3 < 37, by(ayear3 squad3)
egen b3num = sum(black) if squad3 != . & squad3 < 37, by(ayear3 squad3)
by ayear3: center b3aca b3sat b3ldr b3cft, standardize 
* ren b3aca c_b3aca
* ren b3sat c_b3sat
foreach var in aca sat ldr cft {
   gen missing_b3`var' = c_b3`var' == .
   replace c_b3`var' = 0 if c_b3`var' == .
   }
foreach var in aca_cmp sat lead_cmp cft {
   gen mb_`var' = black == 1 & missing(`var')
   egen smb3_`var' = max(mb_`var'), by(ayear3 squad3)
   }
gen m_b3aca = missing(c_b3aca) & smb3_aca_cmp == 1
gen m_b3sat = missing(c_b3sat) & smb3_sat == 1
gen m_b3ldr = missing(c_b3ldr) & smb3_lead_cmp == 1
gen m_b3cft = missing(c_b3cft) & smb3_cft == 1
replace c_b3aca = 0 if m_b3aca == 1
replace c_b3sat = 0 if m_b3sat == 1
replace c_b3ldr = 0 if m_b3ldr == 1
replace c_b3cft = 0 if m_b3cft == 1
ren b3num c_b3num
gen double r = 0
gen s = 0
gen y = 0
gen assigned = 0
gen fillers = 0
gen same = 0
foreach y in c_aca_cmp c_sat c_lead_cmp c_cft_score  {
   xi:reg `y' c_b3aca c_b3sat c_b3ldr c_b3cft c_b3num m_b3* if wm==1 
   foreach x in  b3aca b3sat b3ldr b3cft b3num {
      scalar b_`y'c_r`x' = _b[c_`x']
	  scalar a_`y'c_r`x' = 0
	  }
   }
foreach y in c_b4aca c_b4sat c_b4ldr c_b4cft c_b4num {
   xi:reg `y' c_b3aca c_b3sat c_b3ldr c_b3cft c_b3num i.ayear4 m_b3* if wm==1 & no_fresh_black == 0
   foreach x in  b3aca b3sat b3ldr b3cft b3num {
      scalar b_`y'c_r`x' = _b[c_`x']
	  scalar a_`y'c_r`x' = 0
	  }
   }
forvalues i = 1/`rep' {
  if `i'/1000 == round(`i'/1000) {
     display `i'
     }
  quietly {
  replace s = 40
  replace assigned = 0
  sort cyear id
  replace r = uniform()
  foreach year in 1999 2001 2002 2003 2004 {
    replace y = ayear3 == `year'
    sum ayear3 if y
    scalar sq_size = trunc(`r(N)'/36) 
	gsort -y -female +r, g(n)
	replace s = mod(n,36) if female == 1 & y
	replace assigned = 1 if female == 1 & y
	sum n if female == 1 & y
	local next = mod(`r(N)',36)
	if rotate_start == 0 {
		local next = 0 
		}
	drop n
	gsort -y female +r, g(n)
	replace s = mod(n+`next',36) if female==0 & assigned == 0 & y
	replace assigned = 1 if female == 0 & y
    replace s = 36 if s == 0	& y
	drop n
	forvalues j = 1/36 {
	    quietly sum ayear3 if s == `j' & y
		scalar needed = sq_size - `r(N)'
		gsort -y +assigned +r, g(n)
		replace s = `j' if n <= needed
		replace assigned = 1 if n <= needed
		drop n
		}
	gsort -y +assigned +r, g(n)
	replace s = n if assigned == 0 & y
	drop n
	}
  sort ayear3 s
  egen rb3a = mean(aca_cmp) if black == 1, by(ayear3 s)
  egen rb3s = mean(sat) if black == 1, by(ayear3 s)
  egen rb3l = mean(lead_cmp) if black == 1, by(ayear3 s)
  egen rb3c = mean(cft_score) if black == 1, by(ayear3 s)
  egen rb3aca = max(rb3a), by(ayear3 s)
  egen rb3sat = max(rb3s), by(ayear3 s)
  egen rb3ldr = max(rb3l), by(ayear3 s)
  egen rb3cft = max(rb3c), by(ayear3 s)
  egen rb3num = sum(black), by(ayear3 s)
  by ayear3: center rb3aca rb3sat rb3ldr rb3cft, standardize
  foreach var in aca_cmp sat lead_cmp cft {
     egen rsmb3_`var' = max(mb_`var'), by(ayear3 s)
     }
  gen m_rb3aca = missing(c_rb3aca) & rsmb3_aca_cmp == 1
  gen m_rb3sat = missing(c_rb3sat) & rsmb3_sat == 1
  gen m_rb3ldr = missing(c_rb3ldr) & rsmb3_lead_cmp == 1
  gen m_rb3cft = missing(c_rb3cft) & rsmb3_cft == 1
  replace c_rb3aca = 0 if m_rb3aca == 1
  replace c_rb3sat = 0 if m_rb3sat == 1
  replace c_rb3ldr = 0 if m_rb3ldr == 1
  replace c_rb3cft = 0 if m_rb3cft == 1
  ren rb3num c_rb3num
  gen rno_soph_black = c_rb3num == 0
  foreach y in c_aca_cmp c_sat c_lead_cmp c_cft_score {
     xi:reg `y' c_rb3aca c_rb3sat c_rb3ldr c_rb3cft c_rb3num m_rb3* rno_soph_black if wm == 1
     foreach x in c_rb3aca c_rb3sat c_rb3ldr c_rb3cft c_rb3num {
 	    scalar a_`y'`x' = a_`y'`x' + (_b[`x'] < b_`y'`x')
        }
	}
  foreach y in c_b4aca c_b4sat c_b4ldr c_b4cft c_b4num {
     xi:reg `y' c_rb3aca c_rb3sat c_rb3ldr c_rb3cft c_rb3num i.ayear4  m_rb3* rno_soph_black if wm == 1 & no_fresh_black == 0
     foreach x in c_rb3aca c_rb3sat c_rb3ldr c_rb3cft c_rb3num {
 	    scalar a_`y'`x' = a_`y'`x' + (_b[`x'] < b_`y'`x')
        }
	}
  drop rb3a rb3s rb3l rb3c rb3aca rb3sat rb3ldr rb3cft c_r* m_r* rsmb3_* rno_soph_black
  }
  }
 
tempname out_b out_c
postfile `out_b' str20 y str20 x  p using soph_falsification_A5B_rand, replace
postfile `out_c' str20 y str20 x  p using soph_falsification_A6B_rand, replace
 
 
label var c_b3aca "Sophomore Black HS Performance"
label var c_b3sat "Sophomore Black SAT Score"
label var c_b3ldr "Sophomore Black Leadership Score"
label var c_b3cft "Sophomore Black Fitness Score"
label var c_b3num "Number of Sophomore Black Students"

foreach y in c_aca_cmp c_sat c_lead_cmp c_cft_score  {
    foreach x in  c_rb3aca c_rb3sat c_rb3ldr c_rb3cft c_rb3num {
        post `out_b' ("`y'") ("`x'")  (a_`y'`x'/`rep')
		}
	}

foreach y in c_b4aca c_b4sat c_b4ldr c_b4cft c_b4num {
    foreach x in  c_rb3aca c_rb3sat c_rb3ldr c_rb3cft c_rb3num {
        post `out_c' ("`y'") ("`x'")  (a_`y'`x'/`rep')
        }
	}

postclose `out_b'
postclose `out_c'	



foreach y in c_aca_cmp c_sat c_lead_cmp c_cft_score  {
    xi:reg `y' c_b3aca c_b3sat c_b3ldr c_b3cft c_b3num missing_b3* m_b3* if wm==1 , cluster(ayear3squad3)
    scalar j = 0
    foreach x in  c_rb3aca c_rb3sat c_rb3ldr c_rb3cft c_rb3num {
	    scalar j = j + 1
        local num = "p" + string(j)
        scalar `num'  = 2*min(a_`y'`x'/`rep',1-a_`y'`x'/`rep')
		} 
	if `y' == c_aca_cmp {
	   outreg2 using falsification_soph_rand_A5B_r.tex, keep(c_b3aca c_b3sat c_b3ldr c_b3cft c_b3num) nocons nonotes replace se 10pct tdec(3) bd(3) label ct("High School", "Performance") /*
	   */ addstat("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5 )
 	   }
 	if `y' == c_sat  {
	   outreg2 using falsification_soph_rand_A5B_r.tex, keep(c_b3aca c_b3sat c_b3ldr c_b3cft c_b3num) nocons nonotes append se 10pct tdec(3) bd(3) label ct("SAT") /* 
	   */ addstat("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5 )
  	   }
 	if  `y' == c_lead_cmp {
	   outreg2 using falsification_soph_rand_A5B_r.tex, keep(c_b3aca c_b3sat c_b3ldr c_b3cft c_b3num) nocons nonotes append se 10pct tdec(3) bd(3) label ct("lead", "Score") /*
	   */ addstat("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5 )
  	   }
	if `y' == c_cft_score {
	   outreg2 using falsification_soph_rand_A5B_r.tex, keep(c_b3aca c_b3sat c_b3ldr c_b3cft c_b3num) nocons nonotes append tex(frag pretty) se 10pct tdec(3) bd(3) label ct("Fitness",  "Score") /*
	   */ addstat("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5 )
 	   }
	}


	
foreach y in c_b4aca c_b4sat c_b4ldr c_b4cft c_b4num {
    xi:reg `y' c_b3aca c_b3sat c_b3ldr c_b3cft c_b3num i.ayear4 missing_b3* m_b3* if wm==1 & no_fresh_black == 0 , cluster(ayear3squad3)
    scalar j = 0
    foreach x in  c_rb3aca c_rb3sat c_rb3ldr c_rb3cft c_rb3num {
	    scalar j = j + 1
        local num = "p" + string(j)
        scalar `num'  = 2*min(a_`y'`x'/`rep',1-a_`y'`x'/`rep')
		}
	if `y' == c_b4aca {
	   outreg2 using falsification_soph_rand_A6B_r.tex, keep(c_b3aca c_b3sat c_b3ldr c_b3cft c_b3num) nocons nonotes replace  se 10pct tdec(3) bd(3) label ct("Fresh Black", "High School", "Performance") /*
	   */ addstat("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5 )
 	   }
	if `y' == c_b4sat {
	   outreg2 using falsification_soph_rand_A6B_r.tex, keep(c_b3aca c_b3sat c_b3ldr c_b3cft c_b3num) nocons nonotes append  se 10pct tdec(3) bd(3) label ct("Fresh Black",  "SAT") /*
	   */ addstat("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5 )
 	   }
	if `y' == c_b4ldr {
	   outreg2 using falsification_soph_rand_A6B_r.tex, keep(c_b3aca c_b3sat c_b3ldr c_b3cft c_b3num) nocons nonotes append  se 10pct tdec(3) bd(3) label ct("Fresh Black",  "lead", "Score") /*
	   */ addstat("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5 )
 	   }
	if `y' == c_b4cft {
	   outreg2 using falsification_soph_rand_A6B_r.tex, keep(c_b3aca c_b3sat c_b3ldr c_b3cft c_b3num) nocons nonotes append  se 10pct tdec(3) bd(3) label ct("Fresh Black", "Fitness", "Score") /*
	   */ addstat("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5 )
 	   }
	if `y' == c_b4num {
	   outreg2 using falsification_soph_rand_A6B_r.tex, keep(c_b3aca c_b3sat c_b3ldr c_b3cft c_b3num) nocons nonotes append tex(frag pretty) se 10pct tdec(3) bd(3) label ct("Number", "Fresh Black") /*
	   */ addstat("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5 )
 	   } 
	}

 
use soph_falsification_A5B_rand, clear

scalar c2 = 0
forvalues i = 0.1 (0.1)1 {
   quietly sum p if p >= `i'-.1 & p < `i'
   scalar c2 = c2 + ((r(N)-2)^2/2)
   }
scalar pval = chi2tail(10,c2)
display "Sophomore A5B Rand  " pval

use soph_falsification_A6B_rand, clear

scalar c2 = 0
forvalues i = 0.1 (0.1)1 {
   quietly sum p if p >= `i'-.1 & p < `i'
   scalar c2 = c2 + ((r(N)-2)^2/2)
   }
scalar pval = chi2tail(10,c2)
display "Sophomore A6B Rand  " pval

 
/*********************** Table A7:  Decile ************************************************/

local main = "fresh_black_aca fresh_black_sat fresh_num_black "
local low = "fresh_black_aca bot_fresh_black_aca fresh_black_sat bot_fresh_black_sat fresh_num_black bot_fresh_num_black pct_black_bot"
local top = "fresh_black_aca top_fresh_black_aca fresh_black_sat top_fresh_black_sat fresh_num_black top_fresh_num_black"
local tercile = "fresh_num_black_l fresh_num_black_m fresh_num_black_h "
local mmain = "fresh_black_m_aca fresh_black_m_sat fresh_num_bm "
local mlow = "fresh_black_m_aca bot_fresh_black_m_aca fresh_black_m_sat bot_fresh_black_m_sat fresh_num_bm bot_fresh_num_bm"
local mtop = "fresh_black_m_aca top_fresh_black_m_aca fresh_black_m_sat top_fresh_black_m_sat fresh_num_bm top_fresh_num_bm"
local mtercile = "fresh_num_bm_l fresh_num_bm_m fresh_num_bm_h "
local mspec1 = "no_black_m_fresh soph_num_black i.ayear4*missing_fresh_black_sat i.ayear4*missing_fresh_black_aca  "
local spec1 = "no_blacks_fresh soph_num_black i.ayear4*missing_fresh_black_sat i.ayear4*missing_fresh_black_aca  "
local spec2 = "`spec1' sat_v sat_m leadership_cmp cft_score aca_cmp rathlete pschool missing_aca_cmp missing_sat_v missing_sat_m missing_leadership_cmp missing_cft_score missing_rathlete "
local spec3 = "`spec2' fresh_wm_aca fresh_wm_sat "
local spec4 = "`spec3' fresh_bu_aca fresh_bu_sat missing_bu_aca missing_bu_sat "
local spec5 = "`spec4' soph_black_aca soph_black_sat soph_black_cft soph_black_lead "
local spec6 = "`spec5' i.sq3_ayear3  "
local spec7 = "`spec5' black_classmate_aca black_classmate_sat num_black_classmate "
local spec8 = "`spec5' fresh_black_cft fresh_black_lead fresh_black_pschool fresh_black_rathlete fresh_black_alo "
local spec9 = "`spec5' i.residence missing_residence "
local decile = "fresh_num_black_10 fresh_num_black_20 fresh_num_black_30 fresh_num_black_40 fresh_num_black_50 fresh_num_black_60 fresh_num_black_70 fresh_num_black_80 fresh_num_black_90 fresh_num_black_100 " 
local quintile = "fresh_num_black_20 fresh_num_black_40 fresh_num_black_60 fresh_num_black_80 fresh_num_black_100 " 


use roommate_data_final, clear


forvalues n = 10(10)90 {
   egen aca_`n' = pctile(aca_cmp), p(`n') by(ayear4)
   }
gen aca_b10 = (black==1 & aca_cmp < aca_10)
gen aca_b100 = (black==1 & aca_cmp >= aca_90)
forvalues n = 20(10)90 {
   local nl = `n' - 10
   gen aca_b`n' = (black==1 & aca_cmp >= aca_`nl' & aca_cmp < aca_`n')
   }
forvalues n = 10(10)100 {
   egen fresh_num_black_`n'  = sum(aca_b`n'), by(sq4_ayear4)
   }


drop if squad3 > 36
drop if squad4 > 36

local rep = 5000

*base model 1

xi: reg br_7 `decile' `spec1'  if wm == 1 & soph_num_black>0 & same_fresh_black==0 & same_team == 0,  cluster(sq4_ayear)
foreach var in `decile'  {
	scalar b_`var'1 = _b[`var']
	scalar accum_`var'1 = 0
	}
	
*own characteristics 2	

xi: reg br_7 `decile' `spec2'  if wm == 1 & soph_num_black>0 & same_fresh_black==0 & same_team == 0,  cluster(sq4_ayear)
foreach var in `decile'  {
	scalar b_`var'2 = _b[`var']
	scalar accum_`var'2 = 0
	}
	
*Sophmore black peer characterisics 3

xi: reg br_7 `decile' `spec5'  if wm == 1 & soph_num_black>0 & same_fresh_black==0 & same_team == 0,  cluster(sq4_ayear)
foreach var in `decile' {
	scalar b_`var'3 = _b[`var']
	scalar accum_`var'3 = 0
	}

*Sophmore squadron FE 4

xi: reg br_7 `decile' `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear )  
foreach var in `decile' {
	scalar b_`var'4 = _b[`var']
	scalar accum_`var'4 = 0
	}

*Include nonacademic black peer characteristics 5

xi: reg br_7 `decile' `spec8'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear )  
foreach var in `decile' {
	scalar b_`var'5 = _b[`var']
	scalar accum_`var'5 = 0
	}

*Include residence fixed effects 6

xi: reg br_7 `decile' `spec9'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear )  
foreach var in `decile' {
	scalar b_`var'6 = _b[`var']
	scalar accum_`var'6 = 0
	}



gen double r = 0
gen rm = 0
gen s = 0
gen sq = 0
gen y = 0
gen f = 0
gen assigned = 0
gen fillers = 0
gen odd = 0
gen rbr_7 = 0

forvalues i = 1/`rep' {
  if `i'/50 == round(`i'/50) {
     display `i'/50 "%"
     }
  quietly {
  sort ayear3 squad3 id
  replace r = uniform()
  replace rm = 99
  egen squad_count = count(id) if female == 0, by(ayear3 squad3)
  replace odd = squad_count /2 != trunc(squad_count/2)
  foreach year in 1999 2001 2002 2003 2004 {
    replace y = ayear3 == `year'
		forvalues squad = 1/36 {
			replace sq = `squad' == squad3
			gsort -y -sq +female +r, g(n)
			if y  & sq & (female == 0) {
			  if odd  {
				replace rm = trunc((n-1)/3) if  n <= 3 
				replace rm = trunc(n/2) if  n > 3 & n <= squad_count
				}
			  else {
				replace rm = trunc((n-1)/3) if n <= 6 
				replace rm = trunc((n-1)/2) if  n > 6 & n <= squad_count
				}
			  }
			drop n
			}
	}
  sort ayear3 squad3 rm
  egen rroommates = group(ayear3 squad3 rm)
  egen n_black_roommate = sum(black), by(rroommates)
  replace rbr_7 = n_black_roommate - black > 0
  replace rbr_7 = 1 if rbr_7 > 1

   *base model 1

  xi: reg rbr_7 `decile' `spec1' if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0
  foreach var in `decile' {
 	scalar accum_`var'1 = accum_`var'1 + (_b[`var'] < b_`var'1)
	}
 
   *own characteristics 2
   
   xi: reg rbr_7 `decile' `spec2' if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0
  foreach var in `decile'  {
 	scalar accum_`var'2 = accum_`var'2 + (_b[`var'] < b_`var'2)
	}

  *Sophmore black peer characterisics 3
  
  xi: reg rbr_7 `decile' `spec5'  if wm == 1 & soph_num_black >0  & same_fresh_black==0 & same_team == 0
  foreach var in `decile' {
 	scalar accum_`var'3 = accum_`var'3 + (_b[`var'] < b_`var'3)
	}

  *Sophmore squadron FE 4
  
  xi: reg rbr_7 `decile' `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0
  foreach var in `decile' {
 	scalar accum_`var'4 = accum_`var'4 + (_b[`var'] < b_`var'4)
	}
	
  *Include nonacademic black peer characteristics 5
  
   xi: reg rbr_7 `decile' `spec8'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0
  foreach var in `decile' {
 	scalar accum_`var'5 = accum_`var'5 + (_b[`var'] < b_`var'5)
	}

  *Include residence fixed effects 6
  
  xi: reg rbr_7 `decile' `spec9'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0
  foreach var in `decile' {
 	scalar accum_`var'6 = accum_`var'6 + (_b[`var'] < b_`var'6)
	}

	drop squad_count rroommates n_black_roommate 
  }
  }
 
/*********  Output  ******************/

***** base model 1

xi: reg br_7 `decile' `spec1' if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0,  cluster(sq4_ayear)
scalar j = 0
foreach v in `decile'  {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num' = 2*min(accum_`v'1/`rep',1-accum_`v'1/`rep')
   }
outreg2 using decile_r.tex, keep(`decile') nocons nonotes replace se  bdec(4)  tdec(3)  label  /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5,"p6",p6,"p7",p7,"p8",p8,"p9",p9,"p10",p10)

*****   own characteristics 2

xi: reg br_7 `decile' `spec2' if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear )  
scalar j = 0
foreach v in `decile'  {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num' = 2*min(accum_`v'2/`rep',1-accum_`v'2/`rep')
   }
outreg2 using decile_r.tex, keep(`decile' ) nocons nonotes append se  bdec(4)  tdec(3)  label  /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5,"p6",p6,"p7",p7,"p8",p8,"p9",p9,"p10",p10)


*****   Sophmore black peer characterisics 3

xi: reg br_7 `decile' `spec5'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear )  
scalar j = 0
foreach v in `decile' {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num'  = 2*min(accum_`v'3/`rep',1-accum_`v'3/`rep')
   }
outreg2 using decile_r.tex, keep(`decile') nocons nonotes append se  bdec(4)  tdec(3)  label   /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5,"p6",p6,"p7",p7,"p8",p8,"p9",p9,"p10",p10)


*****     Sophmore squadron FE 4

xi: reg br_7 `decile' `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear )  
scalar j = 0
foreach v in `decile' {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num'  = 2*min(accum_`v'4/`rep',1-accum_`v'4/`rep')
   }
outreg2 using decile_r.tex, keep(`decile') nocons nonotes append se  bdec(4)  tdec(3)  label   /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5,"p6",p6,"p7",p7,"p8",p8,"p9",p9,"p10",p10)


*****     Include nonacademic black peer characteristics 5

xi: reg br_7 `decile' `spec8'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear )  
scalar j = 0
foreach v in `decile' {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num' = 2*min(accum_`v'5/`rep',1-accum_`v'5/`rep')
   }
outreg2 using decile_r.tex, keep(`decile') nocons nonotes append se  bdec(4)  tdec(3)  label   /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5,"p6",p6,"p7",p7,"p8",p8,"p9",p9,"p10",p10)


*****     Include residence fixed effects 6

xi: reg br_7 `decile' `spec9'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear )  
scalar j = 0
foreach v in `decile' {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num'  = 2*min(accum_`v'6/`rep',1-accum_`v'6/`rep')
   }
outreg2 using decile_r.tex, keep(`decile') nocons nonotes append tex(frag pretty) se  bdec(4)  tdec(3)  label   /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5,"p6",p6,"p7",p7,"p8",p8,"p9",p9,"p10",p10)


/*********** Table A8:  Alternative Roommate Definitions ***********/

set matsize 11000

set seed 20130326
use roommate_data_final, clear

drop if squad3 > 36
drop if squad4 > 36


foreach days in 1 7 30 60 90 120 240  {
  xi: reg br_`days' `main' `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0 
  foreach var in `main' {
	scalar b_`var'`days' = _b[`var']
	scalar a_`var'`days' = 0
	}
  xi: reg br_`days' `low' `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0 
  foreach var in `low' {
	scalar bl_`var'`days' = _b[`var']
	scalar al_`var'`days' = 0
	}
  }

gen double r = 0
gen rm = 0
gen s = 0
gen sq = 0
gen y = 0
gen f = 0
gen assigned = 0
gen fillers = 0
gen odd = 0
gen rbr_240 = 0

forvalues i = 1/`rep' {
  if `i'/500 == round(`i'/500) {
     display `i'
     }
  quietly {
  sort ayear3 squad3 id
  replace r = uniform()
  replace rm = 99
  egen squad_count = count(id) if female == 0, by(ayear3 squad3)
  replace odd = squad_count /2 != trunc(squad_count/2)
  foreach year in 1999 2001 2002 2003 2004 {
    replace y = ayear3 == `year'
		forvalues squad = 1/36 {
			replace sq = `squad' == squad3
			gsort -y -sq +female +r, g(n)
			if y  & sq & (female == 0) {
			  if odd  {
				replace rm = trunc((n-1)/3) if  n <= 3 
				replace rm = trunc(n/2) if  n > 3 & n <= squad_count
				}
			  else {
				replace rm = trunc((n-1)/3) if n <= 6 
				replace rm = trunc((n-1)/2) if  n > 6 & n <= squad_count
				}
			  }
			drop n
			}
	}
  sort ayear3 squad3 rm
  egen rroommates = group(ayear3 squad3 rm)
  egen n_black_roommate = sum(black), by(rroommates)
  replace rbr_240 = n_black_roommate - black > 0

    
  xi: reg rbr_240 `main' `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0 
  foreach days in 1 7 30 60 90 120 240 {
    foreach var in `main' {
	  scalar a_`var'`days' = a_`var'`days' + (_b[`var'] < b_`var'`days')
	  }
    }
  xi: reg rbr_240 `low' `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0 
  foreach days in 1 7 30 60 90 120 240 {
    foreach var in `low' {
	  scalar al_`var'`days' = al_`var'`days' + (_b[`var'] < bl_`var'`days')
	  }
    }
  
  drop squad_count rroommates n_black_roommate 
  }
  }
 


xi: reg br_1 `main' `spec6' if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0 , cluster( sq4_ayear )  
scalar j = 0
foreach v in `main'  {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num' = 2*min(a_`v'1/`rep',1-a_`v'1/`rep')
   }
outreg2 using roommate_year_r.tex, keep(`main') nocons nonotes replace se  bdec(4)  tdec(3)  label ctitle("P Black", "Rmte", "1 Day") /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3)

foreach days in 7 30 60 90 120 {
  xi: reg br_`days' `main' `spec6' if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear )  
scalar j = 0
foreach v in `main'  {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num' = 2*min(a_`v'`days'/`rep',1-a_`v'`days'/`rep')
   }
  outreg2 using roommate_year_r.tex, keep(`main') nocons nonotes append se  bdec(4)  tdec(3)  label ctitle("P Black", "Rmte", "`days' Days") /*
  */ ad(3) adds("p1",p1,"p2",p2,"p3",p3)
  }
  
xi: reg br_240 `main' `spec6' if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear )  
scalar j = 0
foreach v in `main'  {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num' = 2*min(a_`v'240/`rep',1-a_`v'240/`rep')
   }
outreg2 using roommate_year_r.tex, keep(`main') nocons nonotes append tex(frag pretty) se  bdec(4)  tdec(3)  label ctitle("P Black", "Rmte", "240 Days") /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3)


xi: reg br_1 `low' `spec6' if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0 , cluster( sq4_ayear )  
scalar j = 0
foreach v in `low'  {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num' = 2*min(al_`v'1/`rep',1-al_`v'1/`rep')
   }
outreg2 using roommate_year_low_r.tex, keep(`low') nocons nonotes replace se  bdec(4)  tdec(3)  label ctitle("P Black", "Rmte", "1 Day") /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5,"p6",p6,"p7",p7)

foreach days in 7 30 60 90 120 {
  xi: reg br_`days' `low' `spec6' if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0 , cluster( sq4_ayear )  
scalar j = 0
foreach v in `low'  {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num' = 2*min(al_`v'`days'/`rep',1-al_`v'`days'/`rep')
   }
  outreg2 using roommate_year_low_r.tex, keep(`low') nocons nonotes append se  bdec(4)  tdec(3)  label ctitle("P Black", "Rmte", "`days' Days") /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5,"p6",p6,"p7",p7)
  }
  
xi: reg br_240 `low' `spec6' if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0 , cluster( sq4_ayear )  
scalar j = 0
foreach v in `low'  {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num' = 2*min(al_`v'240/`rep',1-al_`v'240/`rep')
   }
outreg2 using roommate_year_low_r.tex, keep(`low') nocons nonotes append tex(frag pretty) se  bdec(4)  tdec(3)  label ctitle("P Black", "Rmte", "240 Days") /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5,"p6",p6,"p7",p7)




log close
