log using contact_final.smcl, replace

clear
set more off

/******************** Table 1;  sUMMARY sTATS *****************/

* Summary Stats with complete observations

use roommate_data_final, clear
keep id roommate_length_mean
duplicates drop
sort id
save duration, replace

use ..\usafa\peeracademy\peer_master3, clear
keep id residence
duplicates drop id, force
gen missing_residence = residence == ""
replace residence = "missing" if residence == ""
sort residence
merge m:1  residence using pct_black
drop _merge
sum pct_black, detail
gen pct_black_bot = pct_black <= r(p50) & pct_black != .
gen pct_black_top = pct_black > r(p50) & pct_black != .
sort id
save residence, replace


use ayear4
sort id
merge 1:1 id using ..\usafa\studies\c00-14demographics
keep if _merge == 3
drop _merge
drop if squad3 > 36
drop if squad4 > 36  
drop if squad3 == .
drop if squad4 == .
sort cyear squad4 id
gen sat = sat_m + sat_v
egen fresh_num_black = sum(black), by(cyear squad4)
egen b4a = mean(aca_cmp) if black == 1, by(cyear squad4)
egen b4s = mean(sat) if black == 1, by(cyear squad4)
egen b4l = mean(leadership_cmp) if black == 1, by(cyear squad4)
egen b4c = mean(cft_score) if black == 1, by(cyear squad4)
egen fresh_black_aca = max(b4a), by(cyear squad4)
egen fresh_black_sat = max(b4s), by(cyear squad4)
egen fresh_black_lead = max(b4l), by(cyear squad4)
egen fresh_black_cft = max(b4c), by(cyear squad4)
sort cyear squad3 id
egen soph_num_black = sum(black), by(cyear squad3)
gen wm = (black==0) & (asian==0) & (hispanic==0) & (female==0)
sum fresh_black_aca, detail
scalar fresh_black_aca_m = r(p50)
sum fresh_num_black, detail
scalar fresh_num_black_m = r(p50)

label var fresh_black_aca "Black Fresh HS Performance"
label var fresh_black_sat "Black Freshman SAT"
label var fresh_black_cft "Black Freshman Fitness"
label var fresh_black_lead "Black Freshman Leadership"
label var fresh_num_black "Number of Black Freshmen"
label var aca_cmp "High School Performance"
label var sat "SAT Score"
label var leadership_cmp "Leadership Score"
label var cft_score "Fitness Score"
label var black "African American"
label var hispanic "Hispanic"
label var asian "Asian"
label var rathlete "Recruited Athlete"
label var female "Female"
sort id
merge 1:1 id using duration
drop if _merge == 2
drop _merge
sort id
merge 1:1 id using residence
drop if _merge == 2
drop _merge
label var roommate_length_mean "Roommate Length"
label var pct_black_bot "From Low \% Black State"


reg  fresh_num_black fresh_black_aca fresh_black_sat fresh_black_lead fresh_black_cft if wm == 1
outreg2 using summary_stats.tex, nocons nonotes replace se tdec(3) label cttop("All" "White", "Males" )sum

reg  fresh_num_black fresh_black_aca fresh_black_sat fresh_black_lead fresh_black_cft if wm == 1 & soph_num_black > 0
outreg2 using summary_stats.tex, nocons nonotes append se tdec(3) label cttop("White Male" "1+ Black" "Squadmates")sum

* Variables with missing observations

reg aca_cmp sat leadership_cmp cft_score rathlete  if wm == 1
outreg2 using sup_stats.tex, nocons nonotes replace se tdec(3) label  sum

reg aca_cmp sat leadership_cmp cft_score rathlete  if wm == 1 & soph_num_black > 0
outreg2 using sup_stats.tex, nocons nonotes append se tdec(3)  sum

reg pct_black_bot aca_cmp   if wm == 1
outreg2 using sup_stats_b.tex, nocons nonotes replace se tdec(3) label  sum

reg pct_black_bot aca_cmp  if wm == 1 & soph_num_black > 0
outreg2 using sup_stats_b.tex, nocons nonotes append se tdec(3)  sum



use roommate_data_final, clear
sort id
merge id using duration





foreach var in aca_cmp sat leadership_cmp cft_score {
  replace `var' = . if missing_`var' == 1
  }

drop if squad3 > 36
drop if squad4 > 36  
  


gen br = br_7
gen hr = hr_7
gen ar = ar_7
label var br "P(Black Roommate)"
label var hr "P(Hispanic Roommate)"
label var ar "P(Asian Roommate)"

reg  fresh_num_black fresh_black_aca fresh_black_sat fresh_black_lead fresh_black_cft roommate_length_mean br hr ar if wm == 1 & soph_num_black > 0 & same_fresh_black == 0 & same_team == 0
outreg2 using summary_stats.tex, nocons nonotes append se tdec(3) label cttop("White Male" "1+ Black" "Squadmates" "Roommates") sum

sum fresh_black_aca, detail
scalar fresh_black_aca_m = r(p50)

reg  fresh_num_black fresh_black_aca fresh_black_sat fresh_black_lead fresh_black_cft roommate_length_mean br hr ar if wm == 1 & soph_num_black > 0 & fresh_black_aca <= fresh_black_aca_m & same_fresh_black == 0 & same_team == 0
outreg2 using summary_stats.tex, nocons nonotes append se tdec(3) label cttop("White Male" "1+ Black" "Squadmates" "Roommates" "Low Black Peer" "HS Perform.") sum

reg  fresh_num_black fresh_black_aca fresh_black_sat fresh_black_lead fresh_black_cft roommate_length_mean br hr ar if wm == 1 & soph_num_black > 0 & fresh_black_aca > fresh_black_aca_m & same_fresh_black == 0 & same_team == 0
outreg2 using summary_stats.tex, nocons nonotes append se tdec(3) label cttop("White Male" "1+ Black" "Squadmates" "Roommates" "High Black Peer" "HS Perform.") sum

sum fresh_num_black, detail
scalar fresh_num_black_m = r(p50)

reg  fresh_num_black fresh_black_aca fresh_black_sat fresh_black_lead fresh_black_cft roommate_length_mean br hr ar if wm == 1 & soph_num_black > 0 & fresh_num_black <= fresh_num_black_m & same_fresh_black == 0 & same_team == 0
outreg2 using summary_stats.tex, nocons nonotes append se tdec(3) label cttop("White Male" "1+ Black" "Squadmates" "Roommates" "Low Number of" "Black Fresh. Peers" ) sum

reg  fresh_num_black fresh_black_aca fresh_black_sat fresh_black_lead fresh_black_cft roommate_length_mean br hr ar if wm == 1 & soph_num_black > 0 & fresh_num_black > fresh_num_black_m & same_fresh_black == 0 & same_team == 0
outreg2 using summary_stats.tex, nocons nonotes append tex(frag pretty) se tdec(3) label cttop("White Male" "1+ Black" "Squadmates" "Roommates" "High Number of" "Black Fresh.  Peers") sum


* Summary Stats with incomplete observations


reg aca_cmp sat leadership_cmp cft_score rathlete if wm == 1 & soph_num_black > 0 & same_fresh_black == 0 & same_team == 0
outreg2 using sup_stats.tex, nocons nonotes append se tdec(3) label sum

reg aca_cmp sat leadership_cmp cft_score rathlete if wm == 1 & soph_num_black > 0 & fresh_black_aca <= fresh_black_aca_m & same_fresh_black == 0 & same_team == 0
outreg2 using sup_stats.tex, nocons nonotes append se tdec(3) label sum

reg aca_cmp sat leadership_cmp cft_score rathlete if wm == 1 & soph_num_black > 0 & fresh_black_aca > fresh_black_aca_m & same_fresh_black == 0 & same_team == 0
outreg2 using sup_stats.tex, nocons nonotes append se tdec(3) label sum

reg aca_cmp sat leadership_cmp cft_score rathlete if wm == 1 & soph_num_black > 0 & fresh_num_black <= fresh_num_black_m & same_fresh_black == 0 & same_team == 0
outreg2 using sup_stats.tex, nocons nonotes append se tdec(3) label sum

reg aca_cmp sat leadership_cmp cft_score rathlete if wm == 1 & soph_num_black > 0 & fresh_num_black > fresh_num_black_m & same_fresh_black == 0 & same_team == 0
outreg2 using sup_stats.tex, nocons nonotes append tex(frag pretty) tdec(3) label sum

reg pct_black_bot aca_cmp  if wm == 1 & soph_num_black > 0 & same_fresh_black == 0 & same_team == 0
outreg2 using sup_stats_b.tex, nocons nonotes append se tdec(3) label sum

reg pct_black_bot aca_cmp if wm == 1 & soph_num_black > 0 & fresh_black_aca <= fresh_black_aca_m & same_fresh_black == 0 & same_team == 0
outreg2 using sup_stats_b.tex, nocons nonotes append se tdec(3) label sum

reg pct_black_bot aca_cmp if wm == 1 & soph_num_black > 0 & fresh_black_aca > fresh_black_aca_m & same_fresh_black == 0 & same_team == 0
outreg2 using sup_stats_b.tex, nocons nonotes append se tdec(3) label sum

reg pct_black_bot aca_cmp if wm == 1 & soph_num_black > 0 & fresh_num_black <= fresh_num_black_m & same_fresh_black == 0 & same_team == 0
outreg2 using sup_stats_b.tex, nocons nonotes append se tdec(3) label sum

reg pct_black_bot aca_cmp if wm == 1 & soph_num_black > 0 & fresh_num_black > fresh_num_black_m & same_fresh_black == 0 & same_team == 0
outreg2 using sup_stats_b.tex, nocons nonotes append tex(frag pretty) tdec(3) label sum


***Figure 1 Components ****

use ayear4, clear
sort id
merge 1:1 id using ..\usafa\studies\c00-14demographics
keep if _merge == 3
keep sat_v sat_m leadership_cmp cft_score aca_cmp rathlete pschool black hispanic asian female cyear squad4 squad3 id ayear4
sort id

drop if squad4==.
drop if squad4>36
gen sat=(sat_m + sat_v)
duplicates drop id, force
drop if aca_cmp==0
drop if sat==0
drop if leadership_cmp==0
drop if cft_score==0

gen wm = (black==0) & (asian==0) & (hispanic==0) & (female==0)


sum aca_cmp if black == 1
local aca_cmp_black_sd = string(r(sd),"%5.3f")
sum aca_cmp if wm == 1
local aca_cmp_wm_sd = string(r(sd),"%5.3f")
sum sat if black == 1
local sat_black_sd = string(r(sd),"%5.3f")
sum sat if wm == 1
local sat_wm_sd = string(r(sd),"%5.3f")
sum leadership_cmp if black == 1
local leadership_cmp_black_sd = string(r(sd),"%5.3f")
sum leadership_cmp if wm == 1
local leadership_cmp_wm_sd = string(r(sd),"%5.3f")
sum cft_score if black == 1
local cft_score_black_sd = string(r(sd),"%5.3f")
sum cft_score if wm == 1
local cft_score_wm_sd = string(r(sd),"%5.3f")



*density plots*

twoway (kdensity aca_cmp if black==1  , lcolor(blue) lpattern(solid)) (kdensity aca_cmp if wm==1 , lcolor(forest_green) lpattern(dash)) , ytitle(density) xtitle(High School Performance) legend(order(1 "Black Students" "(sd = `aca_cmp_black_sd')" 2 "White Male Students" "(sd = `aca_cmp_wm_sd')")) graphregion(fcolor(white) color(white) icolor(white)) plotregion()
graph export aca_cmp.pdf, as(pdf) replace

twoway (kdensity sat if black==1  , lcolor(blue) lpattern(solid)) (kdensity sat if wm==1 , lcolor(forest_green) lpattern(dash)) , ytitle(density) xtitle(SAT)  legend(order(1 "Black Students" "(sd = `sat_black_sd')" 2 "White Male Students" "(sd = `sat_wm_sd')" )) graphregion(fcolor(white) color(white) icolor(white)) plotregion()
graph export sat.pdf, as(pdf) replace

twoway (kdensity leadership_cmp if black==1  , lcolor(blue) lpattern(solid)) (kdensity leadership_cmp if wm==1 , lcolor(forest_green) lpattern(dash)) , ytitle(density) xtitle(Leadership Composite) legend(order(1 "Black Students" "(sd = `leadership_cmp_black_sd')" 2 "White Male Students" "(sd = `leadership_cmp_wm_sd')" )) graphregion(fcolor(white) color(white) icolor(white)) plotregion()
graph export leadership_cmp.pdf, as(pdf) replace

twoway (kdensity cft_score if black==1  , lcolor(blue) lpattern(solid)) (kdensity cft_score if wm==1, lcolor(forest_green) lpattern(dash)) , ytitle(density) xtitle(High School Fitness Score) legend(order(1 "Black Students" "(sd = `cft_score_black_sd')" 2 "White Male Students" "(sd = `cft_score_wm_sd')" )) graphregion(fcolor(white) color(white) icolor(white)) plotregion()
graph export cft_score.pdf, as(pdf) replace

clear

use ayear4
sort id
merge 1:1 id using ..\usafa\studies\c00-14demographics
keep if _merge == 3
keep sat_v sat_m leadership_cmp cft_score aca_cmp rathlete pschool black hispanic asian female cyear squad4 squad3 id ayear4
sort id

drop if squad4==.
drop if squad4>36

sort id
egen sq4_ayear4=group(squad4 ayear4)
egen sq3_ayear4=group(squad3 ayear4)
gen sat=(sat_m + sat_v)
gen wm = (black==0) & (asian==0) & (hispanic==0) & (female==0)
egen w4a = mean(aca_cmp) if wm==1, by(sq4_ayear4)
egen w4s = mean(sat) if wm==1, by(sq4_ayear4)
egen w4c = mean(cft_score) if wm==1, by(sq4_ayear4)
egen w4l = mean(leadership_cmp) if wm==1, by(sq4_ayear4)

egen b4a = mean(aca_cmp) if black == 1,  by(sq4_ayear4)
egen b4a_mean=mean(b4a), by(ayear4)
egen b4a_sd=sd(b4a), by(ayear4)
sort ayear4
by ayear4: summ b4a_mean b4a_sd
gen b4a_norm = (b4a-b4a_mean)/b4a_sd
egen fresh_black_aca = max(b4a_norm), by(sq4_ayear4) 
replace fresh_black_aca=0 if fresh_black_aca==.


egen b4s = mean(sat) if black == 1, by(sq4_ayear4)
egen fresh_black_sat = max(b4s), by(sq4_ayear4)
replace fresh_black_sat=0 if fresh_black_sat==.

duplicates drop sq4_ayear4 black, force

sum b4a
local b4a_sd = string(r(sd),"%5.3f")
sum w4a
local w4a_sd = string(r(sd),"%5.3f")
sum b4s
local b4s_sd = string(r(sd),"%5.3f")
sum w4s
local w4s_sd = string(r(sd),"%5.3f")


twoway (kdensity b4a , lcolor(blue) lpattern(solid)) (kdensity w4a , lcolor(forest_green) lpattern(dash)) , ytitle(density) xtitle(High School Performance)  legend(order(1 "Black Students" "(sd = `b4a_sd')" 2 "White Male Students" "(sd = `w4a_sd')" )) graphregion(fcolor(white) color(white) icolor(white)) plotregion()
graph export aca_cmp_sq.pdf, as(pdf) replace

twoway (kdensity b4s , lcolor(blue) lpattern(solid)) (kdensity w4s , lcolor(forest_green) lpattern(dash)) , ytitle(density) xtitle(SAT)  legend(order(1 "Black Students" "(sd = `b4s_sd')" 2 "White Male Students" "(sd = `w4s_sd')" )) graphregion(fcolor(white) color(white) icolor(white)) plotregion()
graph export sat_sq.pdf, as(pdf) replace


* Figure 2

use roommate_data_final, clear
keep if wm == 1 & same_fresh_black==0 & same_team==0 & soph_num_black>0

binscatter br_7 fresh_black_aca if pct_black_bot == 1, ytitle(F(Biracial Match)) xtitle(Black Peer High School Performance) ylabel(0(0.05)0.2)
graph export figure2a_low.pdf, as(pdf) replace

binscatter br_7 fresh_black_aca if pct_black_bot == 0, ytitle(F(Biracial Match)) xtitle(Black Peer High School Performance) ylabel(0(0.05)0.2)
graph export figure2b_high.pdf, as(pdf) replace

binscatter br_7 fresh_num_black if pct_black_bot == 1, ytitle(F(Biracial Match)) xtitle(Number of Black Freshman Peers) ylabel(0(0.05)0.2)
graph export figure2c_low.pdf, as(pdf) replace

binscatter br_7 fresh_num_black if pct_black_bot == 0, ytitle(F(Biracial Match)) xtitle(Number of Black Freshman Peers) ylabel(0(0.05)0.2)
graph export figure2d_high.pdf, as(pdf) replace



* Fiigure 3

sort soph_num_black fresh_num_black pct_black_bot
egen p_br = mean(br_7), by(soph_num_black fresh_num_black)
egen p_br_mean = mean(br_7), by(fresh_num_black pct_black_bot)
duplicates drop soph_num_black fresh_num_black pct_black_bot, force
label var p_br "Sample Frequency"
label var fresh_num_black "Number of Black Freshman Peers"
twoway bar p_br fresh_num_black if soph_num_black == 1, ylabel(0(0.02)0.1) barw(0.4) color(gs0) title("Frequency of Biracial Roommate Match") subtitle("1 Black Squadron Member")
   graph export p_br_1.pdf, as(pdf) replace
forvalues i = 2/4 {
   twoway bar p_br fresh_num_black if soph_num_black == `i', ylabel(0(0.05)0.3) barw(0.4) color(gs0) title("Frequency of Biracial Roommate Match") subtitle("`i' Black Sophomore Peers")
   graph export p_br_`i'.pdf, as(pdf) replace
   }
label var p_br_mean "Sample Frequency"
label var fresh_num_black "Number of Black Freshman Peers"
twoway bar p_br_mean fresh_num_black if pct_black_bot == 1, ylabel(0(0.05)0.2) barw(0.4) color(gs0) 
graph export figure2c_low.pdf, as(pdf) replace
twoway bar p_br_mean fresh_num_black if pct_black_bot == 0, ylabel(0(0.05)0.2) barw(0.4) color(gs0) 
graph export figure2d_high.pdf, as(pdf) replace

* Figure 4 Components

foreach v in l m h {
   use roommate_data_final, clear
   keep if wm == 1 & same_fresh_black==0 & same_team==0
   replace  fresh_num_black_`v' = 2 if  fresh_num_black_`v' > 2
   sort soph_num_black fresh_num_black_`v'
   egen p_br = mean(br_7), by(soph_num_black fresh_num_black_`v')
   egen p_br_mean_`v' = mean(br_7), by(fresh_num_black_`v')
   duplicates drop soph_num_black fresh_num_black_`v', force
   label var p_br_mean "Sample Frequency"
   if "`v'" == "l" {
      label var fresh_num_black_`v' "Number of Low HS Performance Black Freshman Peers"
	  }
   if "`v'" == "m" {
      label var fresh_num_black_`v' "Number of Med, HS Performance Black Freshman Peers"
	  }
   if "`v'" == "h" {
      label var fresh_num_black_`v' "Number of High HS Performance Black Freshman Peers"
	  }
   twoway bar p_br_mean fresh_num_black_`v', ylabel(0(0.02)0.1) xlabel(0(1)2) barw(0.4) color(gs0) 
   graph export figure4_`v'.pdf, as(pdf) replace
   }

use roommate_data_final, clear
label var roommate_length "Length of Roommate Relationship"
histogram roommate_length if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0 & roommate_length < 400
graph export roommate_length_histogram.pdf, as(pdf) replace


/*************** Tables 2 and 3 *****************************************/

local rep = 5000
set seed 20130326
use roommate_data_final, clear

local main = "fresh_black_aca fresh_black_sat fresh_num_black "
local low = "fresh_black_aca bot_fresh_black_aca fresh_black_sat bot_fresh_black_sat fresh_num_black bot_fresh_num_black pct_black_bot"
local top = "fresh_black_aca top_fresh_black_aca fresh_black_sat top_fresh_black_sat fresh_num_black top_fresh_num_black"
local tercile = "fresh_num_black_l fresh_num_black_m fresh_num_black_h "
local mmain = "fresh_black_m_aca fresh_black_m_sat fresh_num_bm "
local mlow = "fresh_black_m_aca bot_fresh_black_m_aca fresh_black_m_sat bot_fresh_black_m_sat fresh_num_bm bot_fresh_num_bm"
local mtop = "fresh_black_m_aca top_fresh_black_m_aca fresh_black_m_sat top_fresh_black_m_sat fresh_num_bm top_fresh_num_bm"
local mtercile = "fresh_num_bm_l fresh_num_bm_m fresh_num_bm_h "
local mspec1 = "no_black_m_fresh soph_num_black i.ayear4*missing_fresh_black_sat i.ayear4*missing_fresh_black_aca  "
local spec1 = "no_blacks_fresh soph_num_black i.ayear4*missing_fresh_black_sat i.ayear4*missing_fresh_black_aca  "
local spec2 = "`spec1' sat_v sat_m leadership_cmp cft_score aca_cmp rathlete pschool missing_aca_cmp missing_sat_v missing_sat_m missing_leadership_cmp missing_cft_score missing_rathlete "
local spec3 = "`spec2' fresh_wm_aca fresh_wm_sat "
local spec4 = "`spec3' fresh_bu_aca fresh_bu_sat missing_bu_aca missing_bu_sat "
local spec5 = "`spec4' soph_black_aca soph_black_sat soph_black_cft soph_black_lead "
local spec6 = "`spec5' i.sq3_ayear3  "
local spec7 = "`spec5' black_classmate_aca black_classmate_sat num_black_classmate "
local spec8 = "`spec5' fresh_black_cft fresh_black_lead fresh_black_pschool fresh_black_rathlete fresh_black_alo "
local spec9 = "`spec5' i.residence missing_residence "
local decile = "fresh_num_black_10 fresh_num_black_20 fresh_num_black_30 fresh_num_black_40 fresh_num_black_50 fresh_num_black_60 fresh_num_black_70 fresh_num_black_80 fresh_num_black_90 fresh_num_black_100 " 
local quintile = "fresh_num_black_20 fresh_num_black_40 fresh_num_black_60 fresh_num_black_80 fresh_num_black_100 " 


drop if squad3 > 36
drop if squad4 > 36

*base model 1

xi: reg br_7 `main' `spec1'  if wm == 1 & soph_num_black>0 & same_fresh_black==0 & same_team == 0,  cluster(sq4_ayear4)
foreach var in `main'  {
	scalar b_`var'1 = _b[`var']
	scalar accum_`var'1 = 0
	}
xi: reg br_7 `low' `spec1'  if wm == 1 & soph_num_black>0 & same_fresh_black==0 & same_team == 0 ,  cluster(sq4_ayear)
foreach var in `low'  {
	scalar b_`var'11 = _b[`var']
	scalar accum_`var'11 = 0
	}
xi: reg br_7 `tercile' `spec1'  if wm == 1 & soph_num_black>0 & same_fresh_black==0 & same_team == 0,  cluster(sq4_ayear)
foreach var in `tercile'  {
	scalar b_`var'1 = _b[`var']
	scalar accum_`var'1 = 0
	}


*own characteristics 2

xi: reg br_7 `main' `spec2' if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear )  
foreach var in `main'  {
	scalar b_`var'2 = _b[`var']
	scalar accum_`var'2 = 0
	}
xi: reg br_7 `low' `spec2' if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0 , cluster( sq4_ayear )  
foreach var in `low'  {
	scalar b_`var'12 = _b[`var']
	scalar accum_`var'12 = 0
	}
xi: reg br_7 `tercile' `spec2' if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear )  
foreach var in `tercile'  {
	scalar b_`var'2 = _b[`var']
	scalar accum_`var'2 = 0
	}



*Sophmore black peer characterisics 3

xi: reg br_7 `main' `spec5'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear )  
foreach var in `main' {
	scalar b_`var'3 = _b[`var']
	scalar accum_`var'3 = 0
	}
xi: reg br_7 `low' `spec5'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0 , cluster( sq4_ayear )  
foreach var in `low' {
	scalar b_`var'13 = _b[`var']
	scalar accum_`var'13 = 0
	}
xi: reg br_7 `tercile' `spec5'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear )  
foreach var in `tercile' {
	scalar b_`var'3 = _b[`var']
	scalar accum_`var'3 = 0
	}

*Sophmore squadron FE 4

xi: reg br_7 `main' `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear )  
foreach var in `main' {
	scalar b_`var'4 = _b[`var']
	scalar accum_`var'4 = 0
	}
xi: reg br_7 `low' `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0 , cluster( sq4_ayear )  
foreach var in `low' {
	scalar b_`var'14 = _b[`var']
	scalar accum_`var'14 = 0
	}
xi: reg br_7 `tercile' `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear )  
foreach var in `tercile' {
	scalar b_`var'4 = _b[`var']
	scalar accum_`var'4 = 0
	}



*Include nonacademic black peer characteristics 5

xi: reg br_7 `main' `spec8'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear )  
foreach var in `main' fresh_black_cft fresh_black_lead fresh_black_alo {
	scalar b_`var'5 = _b[`var']
	scalar accum_`var'5 = 0
	}
gen s_big = e(sample)
xi: reg br_7 `low' `spec8'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0 , cluster( sq4_ayear )  
foreach var in `low' fresh_black_cft fresh_black_lead fresh_black_alo {
	scalar b_`var'15 = _b[`var']
	scalar accum_`var'15 = 0
	}
xi: reg br_7 `tercile' `spec8'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear )  
foreach var in `tercile' {
	scalar b_`var'5 = _b[`var']
	scalar accum_`var'5 = 0
	}


*Include residence fixed effects 6

xi: reg br_7 `main' `spec9'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear )  
foreach var in `main' {
	scalar b_`var'6 = _b[`var']
	scalar accum_`var'6 = 0
	}
gen s_small = e(sample)
/* xi: reg br_7 `low' `spec9'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0 , cluster( sq4_ayear )  
foreach var in `low' {
	scalar b_`var'16 = _b[`var']
	scalar accum_`var'16 = 0
	}
*/	
xi: reg br_7 `tercile' `spec9'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear )  
foreach var in `tercile' {
	scalar b_`var'6 = _b[`var']
	scalar accum_`var'6 = 0
	}

gen double r = 0
gen rm = 0
gen s = 0
gen sq = 0
gen y = 0
gen f = 0
gen assigned = 0
gen fillers = 0
gen odd = 0
gen rbr_7 = 0

forvalues i = 1/`rep' {
  if `i'/100 == round(`i'/100) {
     display `i'
     }
  quietly {
  sort ayear3 squad3 id
  replace r = uniform()
  replace rm = 99
  egen squad_count = count(id) if female == 0, by(ayear3 squad3)
  replace odd = squad_count /2 != trunc(squad_count/2)
  foreach year in 1999 2001 2002 2003 2004 {
    replace y = ayear3 == `year'
		forvalues squad = 1/36 {
			replace sq = `squad' == squad3
			gsort -y -sq +female +r, g(n)
			if y  & sq & (female == 0) {
			  if odd  {
				replace rm = trunc((n-1)/3) if  n <= 3 
				replace rm = trunc(n/2) if  n > 3 & n <= squad_count
				}
			  else {
				replace rm = trunc((n-1)/3) if n <= 6 
				replace rm = trunc((n-1)/2) if  n > 6 & n <= squad_count
				}
			  }
			drop n
			}
	}
  sort ayear3 squad3 rm
  egen rroommates = group(ayear3 squad3 rm)
  egen n_black_roommate = sum(black), by(rroommates)
  replace rbr_7 = n_black_roommate - black > 0
  replace rbr_7 = 1 if rbr_7 > 1

  *base model 1
  
  xi: reg rbr_7 `main' `spec1' if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0
  foreach var in `main' {
 	scalar accum_`var'1 = accum_`var'1 + (_b[`var'] < b_`var'1)
	}
  xi: reg rbr_7 `low' `spec1' if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0 
  foreach var in `low' {
 	scalar accum_`var'11 = accum_`var'11 + (_b[`var'] < b_`var'11)
	}
  xi: reg rbr_7 `tercile' `spec1' if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0
  foreach var in `tercile' {
 	scalar accum_`var'1 = accum_`var'1 + (_b[`var'] < b_`var'1)
	}
 
   *own characteristics 2
   
  xi: reg rbr_7 `main' `spec2' if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0
  foreach var in `main'  {
 	scalar accum_`var'2 = accum_`var'2 + (_b[`var'] < b_`var'2)
	}
  xi: reg rbr_7 `low' `spec2' if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0 
  foreach var in `low'  {
 	scalar accum_`var'12 = accum_`var'12 + (_b[`var'] < b_`var'12)
	}
  xi: reg rbr_7 `tercile' `spec2' if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0
  foreach var in `tercile'  {
 	scalar accum_`var'2 = accum_`var'2 + (_b[`var'] < b_`var'2)
	}

  *Sophmore black peer characterisics 3
  
  xi: reg rbr_7 `main' `spec5'  if wm == 1 & soph_num_black >0  & same_fresh_black==0 & same_team == 0
  foreach var in `main' {
 	scalar accum_`var'3 = accum_`var'3 + (_b[`var'] < b_`var'3)
	}
  xi: reg rbr_7 `low' `spec5'  if wm == 1 & soph_num_black >0  & same_fresh_black==0 & same_team == 0 
  foreach var in `low' {
 	scalar accum_`var'13 = accum_`var'13 + (_b[`var'] < b_`var'13)
	}
  xi: reg rbr_7 `tercile' `spec5'  if wm == 1 & soph_num_black >0  & same_fresh_black==0 & same_team == 0
  foreach var in `tercile' {
 	scalar accum_`var'3 = accum_`var'3 + (_b[`var'] < b_`var'3)
	}

  *Sophmore squadron FE 4
  
  xi: reg rbr_7 `main' `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0
  foreach var in `main' {
 	scalar accum_`var'4 = accum_`var'4 + (_b[`var'] < b_`var'4)
	}
  xi: reg rbr_7 `low' `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0 
  foreach var in `low' {
 	scalar accum_`var'14 = accum_`var'14 + (_b[`var'] < b_`var'14)
	}
  xi: reg rbr_7 `tercile' `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0
  foreach var in `tercile' {
 	scalar accum_`var'4 = accum_`var'4 + (_b[`var'] < b_`var'4)
	}

 	
	
  *Include nonacademic black peer characteristics 5
  
  xi: reg rbr_7 `main' `spec8'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0
  foreach var in `main' fresh_black_cft fresh_black_lead fresh_black_alo {
 	scalar accum_`var'5 = accum_`var'5 + (_b[`var'] < b_`var'5)
	}
  xi: reg rbr_7 `low' `spec8'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0 
  foreach var in `low' fresh_black_cft fresh_black_lead fresh_black_alo {
 	scalar accum_`var'15 = accum_`var'15 + (_b[`var'] < b_`var'15)
	}
  xi: reg rbr_7 `tercile' `spec8'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0
  foreach var in `tercile' {
 	scalar accum_`var'5 = accum_`var'5 + (_b[`var'] < b_`var'5)
	}

  *Include residence fixed effects 6
  
  xi: reg rbr_7 `main' `spec9'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0
  foreach var in `main' {
 	scalar accum_`var'6 = accum_`var'6 + (_b[`var'] < b_`var'6)
	}
/*  xi: reg rbr_7 `low' `spec9'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0 
  foreach var in `low' {
 	scalar accum_`var'16 = accum_`var'16 + (_b[`var'] < b_`var'16)
	}
*/	
  xi: reg rbr_7 `tercile' `spec9'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0
  foreach var in `tercile' {
 	scalar accum_`var'6 = accum_`var'6 + (_b[`var'] < b_`var'6)
	}
 
  drop squad_count rroommates n_black_roommate 
  }
  }
 

/*********  Output  ******************/

***** base model 1

xi: reg br_7 `main' `spec1' if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0,  cluster(sq4_ayear)
scalar j = 0
foreach v in `main'  {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num' = 2*min(accum_`v'1/`rep',1-accum_`v'1/`rep')
   }
outreg2 using main_a_r.tex, keep(`main') nocons nonotes replace se  bdec(4)  tdec(3)  label  /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3)

xi: reg br_7 `low' `spec1' if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0 ,  cluster(sq4_ayear)
scalar j = 0
foreach v in `low'  {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num' = 2*min(accum_`v'11/`rep',1-accum_`v'11/`rep')
   }
outreg2 using main_b_r.tex, keep(`low') nocons nonotes replace se  bdec(4)  tdec(3)  label  /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5,"p6",p6,"p7",p7)

xi: reg br_7 `tercile' `spec1' if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0,  cluster(sq4_ayear)
scalar j = 0
foreach v in `tercile'  {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num' = 2*min(accum_`v'1/`rep',1-accum_`v'1/`rep')
   }
outreg2 using main_c_r.tex, keep(`tercile') nocons nonotes replace se  bdec(4)  tdec(3)  label  /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3)

*****   own characteristics 2

xi: reg br_7 `main' `spec2' if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear )  
scalar j = 0
foreach v in `main'  {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num' = 2*min(accum_`v'2/`rep',1-accum_`v'2/`rep')
   }
outreg2 using main_a_r.tex, keep(`main' ) nocons nonotes append se  bdec(4)  tdec(3)  label  /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3)

xi: reg br_7 `low' `spec2' if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0 , cluster( sq4_ayear )  
scalar j = 0
foreach v in `low'  {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num' = 2*min(accum_`v'12/`rep',1-accum_`v'12/`rep')
   }
outreg2 using main_b_r.tex, keep(`low' ) nocons nonotes append se  bdec(4)  tdec(3)  label  /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5,"p6",p6,"p7",p7)

xi: reg br_7 `tercile' `spec2' if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear )  
scalar j = 0
foreach v in `tercile'  {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num' = 2*min(accum_`v'2/`rep',1-accum_`v'2/`rep')
   }
outreg2 using main_c_r.tex, keep(`tercile' ) nocons nonotes append se  bdec(4)  tdec(3)  label  /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3)


*****   Sophmore black peer characterisics 3

xi: reg br_7 `main' `spec5'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear )  
scalar j = 0
foreach v in `main' {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num'  = 2*min(accum_`v'3/`rep',1-accum_`v'3/`rep')
   }
outreg2 using main_a_r.tex, keep(`main') nocons nonotes append se  bdec(4)  tdec(3)  label   /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3)

xi: reg br_7 `low' `spec5'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0 , cluster( sq4_ayear )  
scalar j = 0
foreach v in `low' {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num'  = 2*min(accum_`v'13/`rep',1-accum_`v'13/`rep')
   }
outreg2 using main_b_r.tex, keep(`low') nocons nonotes append tex(frag pretty) se  bdec(4)  tdec(3)  label   /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5,"p6",p6,"p7",p7)

xi: reg br_7 `tercile' `spec5'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear )  
scalar j = 0
foreach v in `tercile' {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num'  = 2*min(accum_`v'3/`rep',1-accum_`v'3/`rep')
   }
outreg2 using main_c_r.tex, keep(`tercile') nocons nonotes append se  bdec(4)  tdec(3)  label   /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3)


*****     Sophmore squadron FE 4

xi: reg br_7 `main' `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear )  
scalar j = 0
foreach v in `main' {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num'  = 2*min(accum_`v'4/`rep',1-accum_`v'4/`rep')
   }
outreg2 using main_a_r.tex, keep(`main') nocons nonotes append se  bdec(4)  tdec(3)  label   /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3)

xi: reg br_7 `low' `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0 , cluster( sq4_ayear )  
scalar j = 0
foreach v in `low' {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num'  = 2*min(accum_`v'14/`rep',1-accum_`v'14/`rep')
   }
outreg2 using main_b_r.tex, keep(`low') nocons nonotes append se  bdec(4)  tdec(3)  label   /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5,"p6",p6,"p7",p7)

xi: reg br_7 `tercile' `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear )  
scalar j = 0
foreach v in `tercile' {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num'  = 2*min(accum_`v'4/`rep',1-accum_`v'4/`rep')
   }
outreg2 using main_c_r.tex, keep(`tercile') nocons nonotes append se  bdec(4)  tdec(3)  label   /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3)


*****     Include nonacademic black peer characteristics 5

xi: reg br_7 `main' `spec8'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear )  
scalar j = 0
foreach v in `main' fresh_black_cft fresh_black_lead fresh_black_alo {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num' = 2*min(accum_`v'5/`rep',1-accum_`v'5/`rep')
   }
outreg2 using main_a_r.tex, keep(`main' fresh_black_cft fresh_black_lead  fresh_black_alo) nocons nonotes append se  bdec(4)  tdec(3)  label   /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5,"p6",p6)

xi: reg br_7 `low' `spec8'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0 , cluster( sq4_ayear )  
scalar j = 0
foreach v in `low' fresh_black_cft fresh_black_lead fresh_black_alo {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num' = 2*min(accum_`v'15/`rep',1-accum_`v'15/`rep')
   }
outreg2 using main_b_r.tex, keep(`low' fresh_black_cft fresh_black_lead fresh_black_alo) nocons nonotes append tex(frag pretty) se  bdec(4)  tdec(3)  label   /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5,"p6",p6,"p7",p7,"p8",p8,"p9",p9,"p10",p10)

xi: reg br_7 `tercile' `spec8'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear )  
scalar j = 0
foreach v in `tercile' {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num' = 2*min(accum_`v'5/`rep',1-accum_`v'5/`rep')
   }
outreg2 using main_c_r.tex, keep(`tercile') nocons nonotes append se  bdec(4)  tdec(3)  label   /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3)


*****     Include residence fixed effects 6

xi: reg br_7 `main' `spec9'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear )  
scalar j = 0
foreach v in `main' {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num'  = 2*min(accum_`v'6/`rep',1-accum_`v'6/`rep')
   }
outreg2 using main_a_r.tex, keep(`main') nocons nonotes append tex(frag pretty) se  bdec(4)  tdec(3)  label   /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3)

/* xi: reg br_7 `low' `spec9'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0 , cluster( sq4_ayear )  
scalar j = 0
foreach v in `low' {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num'  = 2*min(accum_`v'16/`rep',1-accum_`v'16/`rep')
   }
outreg2 using main_b_r.tex, keep(`low') nocons nonotes append tex(frag pretty) se  bdec(4)  tdec(3)  label   /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5,"p6",p6,"p7",p7)
*/

xi: reg br_7 `tercile' `spec9'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear )  
scalar j = 0
foreach v in `tercile' {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num'  = 2*min(accum_`v'6/`rep',1-accum_`v'6/`rep')
   }
outreg2 using main_c_r.tex, keep(`tercile') nocons nonotes append tex(frag pretty) se  bdec(4)  tdec(3)  label   /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3)



/************* Robustness Tables 4 and 5 *********************************/


set seed 20130326
use roommate_data_final, clear

gen missing_d_aca = d_fresh_black_aca == .
replace d_fresh_black_aca = 0 if d_fresh_black_aca == .


drop if squad3 > 36
drop if squad4 > 36

sort cyear squad4
by cyear squad4: egen sq4_male = sum(male)
gen fresh_prop_black = fresh_num_black / sq4_male
label var fresh_prop_black "Proportion of Freshman Squadron Black"
gen bot_fresh_prop_black = pct_black_bot * fresh_prop_black
label var bot_fresh_prop_black "Low \% Black $\times$ Prop of Fresh Squadron Black"

*base model 1 - Specification 5 from main table

xi: reg br_7 `low' `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
foreach var in `low' {
	scalar b_`var'1 = _b[`var']
	scalar a_`var'1 = 0
	}

* fresh_black_aca only 2

xi: reg br_7 fresh_black_aca bot_fresh_black_aca pct_black_bot `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
foreach v in  fresh_black_aca bot_fresh_black_aca pct_black_bot {
   scalar b_`v'2 = _b[`v']
   scalar a_`v'2 = 0
   }
	
* fresh_black_sat only 3

xi: reg br_7 fresh_black_sat bot_fresh_black_sat pct_black_bot `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
foreach v in  fresh_black_sat bot_fresh_black_sat pct_black_bot  {
   scalar b_`v'3 = _b[`v']
   scalar a_`v'3 = 0
   }
	
* fresh_num_black only 4

xi: reg br_7 fresh_num_black bot_fresh_num_black pct_black_bot `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
foreach v in  fresh_num_black bot_fresh_num_black pct_black_bot  {
   scalar b_`v'4 = _b[`v']
   scalar a_`v'4 = 0
   }

* control for classroom black peers 5

xi: reg br_7 `low' black_classmate_aca black_classmate_sat num_black_classmate `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
foreach v in  `low' black_classmate_aca black_classmate_sat num_black_classmate  {
   scalar b_`v'5 = _b[`v']
   scalar a_`v'5 = 0
   }
   
   
* Proportion of Freshman Black  6

xi: reg br_7 fresh_black_aca bot_fresh_black_aca fresh_black_sat bot_fresh_black_sat fresh_prop_black bot_fresh_prop_black pct_black_bot `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
foreach var in fresh_black_aca bot_fresh_black_aca fresh_black_sat bot_fresh_black_sat fresh_prop_black bot_fresh_prop_black pct_black_bot  {
	scalar b_`var'6 = _b[`var']
	scalar a_`var'6 = 0
	}

* Predicted GPA 7

xi: reg br_7 fresh_black_gpa_hat bot_fresh_black_gpa_hat fresh_num_black bot_fresh_num_black pct_black_bot missing_fresh_black_gpa_hat `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
foreach var in fresh_black_gpa_hat bot_fresh_black_gpa_hat fresh_num_black bot_fresh_num_black pct_black_bot  {
	scalar b_`var'7 = _b[`var']
	scalar a_`var'7 = 0
	}

* Freshman Black Males Only 8

xi: reg br_7 fresh_black_m_aca fresh_black_m_sat fresh_num_bm no_black_m_fresh `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
foreach var in fresh_black_m_aca fresh_black_m_sat fresh_num_bm {
	scalar b_`var'8 = _b[`var']
	scalar a_`var'8 = 0
	}

* Freshman Black Dropouts 9	
	
xi: reg br_7 `low' fresh_black_dropout `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
foreach var in `low' fresh_black_dropout {
	scalar b_`var'9 = _b[`var']
	scalar a_`var'9 = 0
	}

* Ranks 10
	
xi: reg br_7 r_fresh_black_aca r_fresh_black_sat r_fresh_num_black `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
foreach var in r_fresh_black_aca r_fresh_black_sat r_fresh_num_black   {
	scalar b_`var'10 = _b[`var']
	scalar a_`var'10 = 0
	}

* Homophily 11
	
xi: reg br_7 `low' d_fresh_black_aca bot_d_fresh_black_aca missing_d_aca `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
foreach var in `low' d_fresh_black_aca bot_d_fresh_black_aca  {
	scalar b_`var'11 = _b[`var']
	scalar a_`var'11 = 0
	}

	
* Exclude Fresh Black Roommate 12
	
xi: reg br_7 `low' `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0 & fresh_black_roommate == 0, cluster( sq4_ayear4 )  
foreach var in `low'  {
	scalar b_`var'12 = _b[`var']
	scalar a_`var'12 = 0
	}

* Separate SAT-V and SAT-M 13
	
xi: reg br_7 fresh_black_aca bot_fresh_black_aca fresh_black_sat_v fresh_black_sat_m  fresh_num_black bot_fresh_num_black pct_black_bot `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0 , cluster( sq4_ayear4 )  
foreach var in fresh_black_aca bot_fresh_black_aca fresh_black_sat_v fresh_black_sat_m fresh_num_black bot_fresh_num_black pct_black_bot   {
	scalar b_`var'13 = _b[`var']
	scalar a_`var'13 = 0
	}



gen double r = 0
gen rm = 0
gen s = 0
gen sq = 0
gen y = 0
gen f = 0
gen assigned = 0
gen fillers = 0
gen odd = 0
gen rbr_7 = 0

forvalues i = 1/`rep' {
  if `i'/500 == round(`i'/500) {
     display `i'
     }
quietly {
  sort ayear3 squad3 id
  replace r = uniform()
  replace rm = 99
  egen squad_count = count(id) if female == 0, by(ayear3 squad3)
  replace odd = squad_count /2 != trunc(squad_count/2)
  foreach year in 1999 2001 2002 2003 2004 {
    replace y = ayear3 == `year'
		forvalues squad = 1/36 {
			replace sq = `squad' == squad3
			gsort -y -sq +female +r, g(n)
			if y  & sq & (female == 0) {
			  if odd  {
				replace rm = trunc((n-1)/3) if  n <= 3 
				replace rm = trunc(n/2) if  n > 3 & n <= squad_count
				}
			  else {
				replace rm = trunc((n-1)/3) if n <= 6 
				replace rm = trunc((n-1)/2) if  n > 6 & n <= squad_count
				}
			  }
			drop n
			}
	}
  sort ayear3 squad3 rm
  egen rroommates = group(ayear3 squad3 rm)
  egen n_black_roommate = sum(black), by(rroommates)
  replace rbr_7 = n_black_roommate - black > 0
  replace rbr_7 = 1 if rbr_7 > 1

  *base model 1
  
  xi: reg rbr_7 `low' `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
  foreach var in `low' {
 	scalar a_`var'1 = a_`var'1 + (_b[`var'] < b_`var'1)
	}
 
  * fresh_black_aca only 2

  xi: reg rbr_7 fresh_black_aca bot_fresh_black_aca pct_black_bot `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
  foreach var in fresh_black_aca bot_fresh_black_aca pct_black_bot  {
 	scalar a_`var'2 = a_`var'2 + (_b[`var'] < b_`var'2)
	}

  * fresh_black_sat only 3

  xi: reg rbr_7 fresh_black_sat bot_fresh_black_sat pct_black_bot  `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
  foreach var in fresh_black_sat bot_fresh_black_sat pct_black_bot {
 	scalar a_`var'3 = a_`var'3 + (_b[`var'] < b_`var'3)
	}

  * fresh_num_black only 4

  xi: reg rbr_7 fresh_num_black bot_fresh_num_black pct_black_bot  `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
  foreach var in fresh_num_black bot_fresh_num_black  pct_black_bot  {
 	scalar a_`var'4 = a_`var'4 + (_b[`var'] < b_`var'4)
	}

  * control for classroom black peers 5

  xi: reg rbr_7 `low' black_classmate_aca black_classmate_sat num_black_classmate `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
  foreach var in `low' black_classmate_aca black_classmate_sat num_black_classmate  {
 	scalar a_`var'5 = a_`var'5 + (_b[`var'] < b_`var'5)
	}
	
  * Proportion of Freshman Black  6

  xi: reg rbr_7 fresh_black_aca bot_fresh_black_aca fresh_black_sat bot_fresh_black_sat fresh_prop_black bot_fresh_prop_black pct_black_bot  `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
  foreach var in fresh_black_aca bot_fresh_black_aca fresh_black_sat bot_fresh_black_sat fresh_prop_black bot_fresh_prop_black pct_black_bot  {
 	scalar a_`var'6 = a_`var'6 + (_b[`var'] < b_`var'6)
	}

  * Predicted GPA 7

  xi: reg rbr_7 fresh_black_gpa_hat bot_fresh_black_gpa_hat fresh_num_black bot_fresh_num_black pct_black_bot missing_fresh_black_gpa_hat `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
  foreach var in fresh_black_gpa_hat bot_fresh_black_gpa_hat fresh_num_black bot_fresh_num_black pct_black_bot   {
 	scalar a_`var'7 = a_`var'7 + (_b[`var'] < b_`var'7)
	}
	
  * Freshman Black Males Only 8

  xi: reg rbr_7 fresh_black_m_aca fresh_black_m_sat fresh_num_bm no_black_m_fresh `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
  foreach var in fresh_black_m_aca fresh_black_m_sat fresh_num_bm  {
 	scalar a_`var'8 = a_`var'8 + (_b[`var'] < b_`var'8)
	}
 
  * Freshman Black Dropouts 9	
	
  xi: reg rbr_7 `low' fresh_black_dropout `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
  foreach var in `low' fresh_black_dropout {
 	scalar a_`var'9 = a_`var'9 + (_b[`var'] < b_`var'9)
	}
 
  * Ranks 10
	
  xi: reg rbr_7 r_fresh_black_aca r_fresh_black_sat r_fresh_num_black `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
  foreach var in r_fresh_black_aca r_fresh_black_sat r_fresh_num_black  {
 	scalar a_`var'10 = a_`var'10 + (_b[`var'] < b_`var'10)
	}

  * Homophily 11
	
  xi: reg rbr_7 `low' d_fresh_black_aca bot_d_fresh_black_aca missing_d_aca `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
  foreach var in `low' d_fresh_black_aca bot_d_fresh_black_aca  {
 	scalar a_`var'11 = a_`var'11 + (_b[`var'] < b_`var'11)
	}

  * Exclude Fresh Black Roommate 12
	
  xi: reg rbr_7 `low' `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0 & fresh_black_roommate == 0, cluster( sq4_ayear4 )  
  foreach var in `low'  {
 	scalar a_`var'12 = a_`var'12 + (_b[`var'] < b_`var'12)
	}

  * Separate SAT-V and SAT-M 13
	
  xi: reg rbr_7 fresh_black_aca bot_fresh_black_aca fresh_black_sat_v fresh_black_sat_m fresh_num_black bot_fresh_num_black pct_black_bot `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0 , cluster( sq4_ayear4 )  
  foreach var in fresh_black_aca bot_fresh_black_aca fresh_black_sat_v fresh_black_sat_m  fresh_num_black bot_fresh_num_black  pct_black_bot  {
 	scalar a_`var'13 = a_`var'13 + (_b[`var'] < b_`var'13)
	}
	

 
  drop squad_count rroommates n_black_roommate 
  }
  }
 

*base model 1 - Specification 5 from main table

xi: reg br_7 `low' `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
scalar j = 0
foreach v in `low'  {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num' = 2*min(a_`v'1/`rep',1-a_`v'1/`rep')
   }
outreg2 using robust_rs.tex, keep(`low' ) nocons nonotes replace se  bdec(4)  tdec(3)  label  /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5,"p6",p6,"p7",p7)
outreg2 using robust_rs2.tex, keep(`low' ) nocons nonotes replace se  bdec(4)  tdec(3)  label  /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5,"p6",p6,"p7",p7)


* fresh_black_aca only 2

xi: reg br_7 fresh_black_aca bot_fresh_black_aca pct_black_bot `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
scalar j = 0
foreach v in fresh_black_aca bot_fresh_black_aca pct_black_bot  {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num' = 2*min(a_`v'2/`rep',1-a_`v'2/`rep')
   if j == 2 {
      scalar j = 6
	  }
   }
outreg2 using robust_rs.tex, keep(fresh_black_aca  bot_fresh_black_aca pct_black_bot) nocons nonotes append se  bdec(4)  tdec(3)  label   /*
*/ ad(3) adds("p1",p1,"p2",p2,"p7",p7)

* fresh_black_sat only 3

xi: reg br_7 fresh_black_sat bot_fresh_black_sat pct_black_bot `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
scalar j = 2
foreach v in fresh_black_sat bot_fresh_black_sat pct_black_bot {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num' = 2*min(a_`v'3/`rep',1-a_`v'3/`rep')
   if j == 4 {
      scalar j = 6
	  }
   }
outreg2 using robust_rs.tex, keep(fresh_black_sat bot_fresh_black_sat pct_black_bot) nocons nonotes append se  bdec(4)  tdec(3)  label   /*
*/ ad(3) adds("p3",p3,"p4",p4,"p7",p7)

* fresh_num_black only 4

xi: reg br_7 fresh_num_black bot_fresh_num_black pct_black_bot `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
scalar j = 4
foreach v in fresh_num_black bot_fresh_num_black  pct_black_bot  {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num' = 2*min(a_`v'4/`rep',1-a_`v'4/`rep')
   }
outreg2 using robust_rs.tex, keep(fresh_num_black bot_fresh_num_black pct_black_bot) nocons nonotes append se  bdec(4)  tdec(3)  label   /*
*/ ad(3) adds("p5",p5,"p6",p6,"p7",p7)

* Separate SAT-V and SAT-M 13
	
xi: reg br_7 fresh_black_aca bot_fresh_black_aca fresh_black_sat_v fresh_black_sat_m fresh_num_black bot_fresh_num_black pct_black_bot `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
scalar j = 0
foreach v in fresh_black_aca bot_fresh_black_aca fresh_num_black bot_fresh_num_black pct_black_bot fresh_black_sat_v fresh_black_sat_m   {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num' = 2*min(a_`v'13/`rep',1-a_`v'13/`rep')
   if j == 2 {
      scalar j = 4
	  }
   }
outreg2 using robust_rs.tex, keep(fresh_black_aca bot_fresh_black_aca pct_black_bot fresh_black_sat_v fresh_black_sat_m fresh_num_black bot_fresh_num_black) nocons nonotes append se  bdec(4)  tdec(3)  label   /*
*/ ad(3) adds("p1",p1,"p2",p2,"p5",p5,"p6",p6,"p7",p7,"p8",p8,"p9",p9)


* control for classroom black peers 5

xi: reg br_7 `low' black_classmate_aca black_classmate_sat num_black_classmate `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
scalar j = 0
foreach v in `low' black_classmate_aca black_classmate_sat num_black_classmate  {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num' = 2*min(a_`v'5/`rep',1-a_`v'5/`rep')
   if j == 7 {
      scalar j = 11
	  }
   }
outreg2 using robust_rs.tex, keep(`low' black_classmate_aca black_classmate_sat num_black_classmate ) nocons nonotes append se  bdec(4)  tdec(3)  label   /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5,"p6",p6,"p7",p7,"p12",p12,"p13",p13,"p14",p14)

* Exclude Fresh Black Roommate 12
	
xi: reg br_7 `low' `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0 & fresh_black_roommate == 0, cluster( sq4_ayear4 )  
scalar j = 0
foreach v in `low' {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num'  = 2*min(a_`v'12/`rep',1-a_`v'12/`rep')
   }
outreg2 using robust_rs.tex, keep(`low') nocons nonotes append tex(frag pretty) se  bdec(4)  tdec(3)  label   /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5,"p6",p6,"p7",p7)


* Proportion of Freshman Black  6

xi: reg br_7 fresh_black_aca bot_fresh_black_aca fresh_black_sat bot_fresh_black_sat fresh_prop_black bot_fresh_prop_black pct_black_bot `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
scalar j = 0
foreach v in fresh_black_aca bot_fresh_black_aca fresh_black_sat bot_fresh_black_sat pct_black_bot fresh_prop_black bot_fresh_prop_black   {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num'  = 2*min(a_`v'6/`rep',1-a_`v'6/`rep')
   if j == 4 {
      scalar j = 7
	  }
  }
outreg2 using robust_rs2.tex, keep(fresh_black_aca bot_fresh_black_aca fresh_black_sat bot_fresh_black_sat pct_black_bot fresh_prop_black bot_fresh_prop_black) nocons nonotes append se  bdec(4)  tdec(3)  label   /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p7",p7,"p8",p8,"p9",p9)

* Predicted GPA 7

xi: reg br_7 fresh_black_gpa_hat bot_fresh_black_gpa_hat fresh_num_black bot_fresh_num_black pct_black_bot missing_fresh_black_gpa_hat `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
scalar j = 4
foreach v in fresh_num_black bot_fresh_num_black pct_black_bot fresh_black_gpa_hat bot_fresh_black_gpa_hat {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num'  = 2*min(a_`v'7/`rep',1-a_`v'7/`rep')
   if j == 7 {
      scalar j = 9
	  }
   }
outreg2 using robust_rs2.tex, keep(fresh_num_black bot_fresh_num_black pct_black_bot fresh_black_gpa_hat bot_fresh_black_gpa_hat ) nocons nonotes append se  bdec(4)  tdec(3)  label   /*
*/ ad(3) adds("p5",p5,"p6",p6,"p7",p7,"p10",p10,"p11",p11)


* Freshman Black Males Only 8

xi: reg br_7 fresh_black_m_aca fresh_black_m_sat fresh_num_bm no_black_m_fresh `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
scalar j = 11
foreach v in fresh_black_m_aca fresh_black_m_sat fresh_num_bm  {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num' = 2*min(a_`v'8/`rep',1-a_`v'8/`rep')
   }
outreg2 using robust_rs2.tex, keep(fresh_black_m_aca fresh_black_m_sat fresh_num_bm) nocons nonotes append se  bdec(4)  tdec(3)  label   /*
*/ ad(3) adds("p12",p12,"p13",p13,"p14",p14)

* Freshman Black Dropouts 9	

xi: reg br_7 `low' fresh_black_dropout `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
scalar j = 0
foreach v in `low' fresh_black_dropout {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num' = 2*min(a_`v'9/`rep',1-a_`v'9/`rep')
   if j == 7 {
      scalar j = 14
	  }
   }
outreg2 using robust_rs2.tex, keep(`low' fresh_black_dropout) nocons nonotes append se  bdec(4)  tdec(3)  label   /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5,"p6",p6,"p7",p7,"p15",p15)

* Ranks 10
	
xi: reg br_7  r_fresh_black_aca r_fresh_black_sat r_fresh_num_black `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
scalar j = 15
foreach v in r_fresh_black_aca r_fresh_black_sat r_fresh_num_black  {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num' = 2*min(a_`v'10/`rep',1-a_`v'10/`rep')
   }
outreg2 using robust_rs2.tex, keep(`low' r_fresh_black_aca r_fresh_black_sat r_fresh_num_black ) nocons nonotes append se  bdec(4)  tdec(3)  label   /*
*/ ad(3) adds("p16",p16,"p17",p17,"p18",p18)

* Homophily 11
	
xi: reg br_7 `low' d_fresh_black_aca bot_d_fresh_black_aca missing_d_aca `spec6'  if wm == 1 & soph_num_black >0 & same_fresh_black==0 & same_team == 0, cluster( sq4_ayear4 )  
scalar j = 0
foreach v in `low' d_fresh_black_aca bot_d_fresh_black_aca  {
   scalar j = j + 1
   local num = "p" + string(j)
   scalar `num' = 2*min(a_`v'11/`rep',1-a_`v'11/`rep')
   if j == 7 {
      scalar j = 18
	  }
   }
outreg2 using robust_rs2.tex, keep(`low' d_fresh_black_aca bot_d_fresh_black_aca) nocons nonotes append tex(frag pretty) se  bdec(4)  tdec(3)  label   /*
*/ ad(3) adds("p1",p1,"p2",p2,"p3",p3,"p4",p4,"p5",p5,"p6",p6,"p7",p7,"p19",p19,"p20",p20)




  
  log close  

