function [overallpoolSize,poolSizeVar] = poolMoments(directory,realdata)


directoryOutput = [directory 'output/calibration_output.mat'];

if ~exist(directoryOutput)
error('calibration_output.mat not found.');
end


load(directoryOutput)

numofPar = size(simulation_calib.simAltPoolSize,1);
numofSim = size(simulation_calib.simAltPoolSize{1},1);

if nargin == 1
    
    for i = 1 : numofPar
simPairPoolSize = simulation_calib.simPairPoolSize{i}';
simChipPoolSize = simulation_calib.simChipPoolSize{i}';
simAltPoolSize = simulation_calib.simAltPoolSize{i}';
simPairTrans = cumsum(simulation_calib.simPairTrans{i}');
simPairPerish = cumsum(simulation_calib.simPairPerish{i}');
simChipTrans = cumsum(simulation_calib.simChipTrans{i}');
simChipPerish = cumsum(simulation_calib.simChipPerish{i}');
simAltruisticTrans = cumsum(simulation_calib.simAltruisticTrans{i}');
simAltruisticPerish = cumsum(simulation_calib.simAltruisticPerish{i}');

overallpoolSize{i} = [(mean(simAltPoolSize(1:330,:))) ;   (mean(simAltPoolSize(331:660,:))) ;         (mean(simAltPoolSize(661:end,:))) ;...
    (mean(simChipPoolSize(1:330,:))) ;          (mean(simChipPoolSize(331:660,:))) ;    (   mean(simChipPoolSize(661:end,:))) ;...
    (mean(simPairPoolSize(1:330,:))) ;          (mean(simPairPoolSize(331:660,:))) ;        (mean(simPairPoolSize(661:end,:))) ;...
    (mean(simAltruisticTrans(1:330,:))) ;       (mean(simAltruisticTrans(331:660,:))) ;     (mean(simAltruisticTrans(661:end,:))) ;...
    (mean(simChipTrans(1:330,:))) ;             (mean(simChipTrans(331:660,:))) ;           (mean(simChipTrans(661:end,:))); ...
    (mean(simPairTrans(1:330,:))) ;             (mean(simPairTrans(331:660,:))) ;           (mean(simPairTrans(661:end,:))); ...
    (mean(simAltruisticPerish(1:330,:))) ;      (mean(simAltruisticPerish(331:660,:))) ;    (mean(simAltruisticPerish(661:end,:))); ...
    (mean(simChipPerish(1:330,:))) ;            (mean(simChipPerish(331:660,:))) ;          (mean(simChipPerish(661:end,:))) ;...
    (mean(simPairPerish(1:330,:))) ;            (mean(simPairPerish(331:660,:))) ;          (mean(simPairPerish(661:end,:)))];

    end

else
simPairPoolSize = realmarket_stat.pairinRealMark;
simChipPoolSize = realmarket_stat.chipinRealMark;
simAltPoolSize = realmarket_stat.altruisticinRealMark;
simPairTrans = cumsum(realmarket_stat.pairTransinRealMark);
simPairPerish = cumsum(realmarket_stat.pairPerishinRealMark);
simChipTrans = cumsum(realmarket_stat.chipTransinRealMark);
simChipPerish = cumsum(realmarket_stat.chipPerishinRealMark);
simAltruisticTrans = cumsum(realmarket_stat.altruisticTransinRealMark);
simAltruisticPerish = cumsum(realmarket_stat.altruisticPerishinRealMark);

overallpoolSize = [mean(mean(simAltPoolSize(1:330))) ; mean(mean(simAltPoolSize(331:660))) ; mean(mean(simAltPoolSize(661:end))) ;...
    mean(mean(simChipPoolSize(1:330))) ; mean(mean(simChipPoolSize(331:660))) ; mean(mean(simChipPoolSize(661:end))) ;...
    mean(mean(simPairPoolSize(1:330))) ; mean(mean(simPairPoolSize(331:660))) ; mean(mean(simPairPoolSize(661:end))) ;...
    mean(mean(simAltruisticTrans(1:330))) ; mean(mean(simAltruisticTrans(331:660))) ; mean(mean(simAltruisticTrans(661:end))) ;...
    mean(mean(simChipTrans(1:330))) ; mean(mean(simChipTrans(331:660))) ; mean(mean(simChipTrans(661:end))); ...
    mean(mean(simPairTrans(1:330))) ; mean(mean(simPairTrans(331:660))) ; mean(mean(simPairTrans(661:end))); ...
    mean(mean(simAltruisticPerish(1:330))) ; mean(mean(simAltruisticPerish(331:660))) ; mean(mean(simAltruisticPerish(661:end))); ...
    mean(mean(simChipPerish(1:330))) ; mean(mean(simChipPerish(331:660))) ; mean(mean(simChipPerish(661:end))) ;...
    mean(mean(simPairPerish(1:330))) ; mean(mean(simPairPerish(331:660))) ; mean(mean(simPairPerish(661:end)))];



poolSizeVar = [mean(reshape(randsample(simAltPoolSize(1:330),330 * numofSim,1),330,numofSim));...
    mean(reshape(randsample(simAltPoolSize(331:660),330 * numofSim,1),330,numofSim));...
    mean(reshape(randsample(simAltPoolSize(661:end),330 * numofSim,1),330,numofSim));...
    mean(reshape(randsample(simChipPoolSize(1:330),330 * numofSim,1),330,numofSim));...
    mean(reshape(randsample(simChipPoolSize(331:660),330 * numofSim,1),330,numofSim));...
    mean(reshape(randsample(simChipPoolSize(661:end),330 * numofSim,1),330,numofSim));...
    mean(reshape(randsample(simPairPoolSize(1:330),330 * numofSim,1),330,numofSim));...
    mean(reshape(randsample(simPairPoolSize(331:660),330 * numofSim,1),330,numofSim));...
    mean(reshape(randsample(simPairPoolSize(661:end),330 * numofSim,1),330,numofSim));...
    mean(reshape(randsample(simAltruisticTrans(1:330),330 * numofSim,1),330,numofSim));...
    mean(reshape(randsample(simAltruisticTrans(331:660),330 * numofSim,1),330,numofSim));...
    mean(reshape(randsample(simAltruisticTrans(661:end),330 * numofSim,1),330,numofSim));...
    mean(reshape(randsample(simChipTrans(1:330),330 * numofSim,1),330,numofSim));...
    mean(reshape(randsample(simChipTrans(331:660),330 * numofSim,1),330,numofSim));...
    mean(reshape(randsample(simChipTrans(661:end),330 * numofSim,1),330,numofSim));...
    mean(reshape(randsample(simPairTrans(1:330),330 * numofSim,1),330,numofSim));...
    mean(reshape(randsample(simPairTrans(331:660),330 * numofSim,1),330,numofSim));...
    mean(reshape(randsample(simPairTrans(661:end),330 * numofSim,1),330,numofSim));...
    mean(reshape(randsample(simAltruisticPerish(1:330),330 * numofSim,1),330,numofSim));...
    mean(reshape(randsample(simAltruisticPerish(331:660),330 * numofSim,1),330,numofSim));...
    mean(reshape(randsample(simAltruisticPerish(661:end),330 * numofSim,1),330,numofSim));...
    mean(reshape(randsample(simChipPerish(1:330),330 * numofSim,1),330,numofSim));...
    mean(reshape(randsample(simChipPerish(331:660),330 * numofSim,1),330,numofSim));...
    mean(reshape(randsample(simChipPerish(661:end),330 * numofSim,1),330,numofSim));...
    mean(reshape(randsample(simPairPerish(1:330),330 * numofSim,1),330,numofSim));...
    mean(reshape(randsample(simPairPerish(331:660),330 * numofSim,1),330,numofSim));...
    mean(reshape(randsample(simPairPerish(661:end),330 * numofSim,1),330,numofSim))];



end

directory = [directory 'output/' ];
fileName = ['poolSizeMoments.mat'];
fileName = fullfile(directory, fileName);
save(fileName,'overallpoolSize');

end