clear all
submissionsData = readtable('./data/submissions-data.csv');
initial = 19084;
stataFormatInitialDay = 19084;
totalDraw = 1000;
numofDays = 977;

%% Summary Tables

entries = (strcmp(submissionsData.category,'a') & submissionsData.d_arr_date_min>=19084) + ...
((  strcmp(submissionsData.category,'p') |strcmp(submissionsData.category,'c'))...
&   submissionsData.r_arr_date_min>=19084);

submissionsData = submissionsData(entries>0,:);

chips = (strcmp(submissionsData.category,'c') & ...
    submissionsData.r_dep_date_min>= initial);
pairs = (strcmp(submissionsData.category,'p') & ...
    submissionsData.r_dep_date_min>= initial);
altruistics = (strcmp(submissionsData.category,'a') & ...
    submissionsData.d_dep_date_min>= initial);


overdemanded = ...
    ((strcmp(submissionsData.r_abo,'AB')& strcmp(submissionsData.d_abo,'B'))|...
    (strcmp(submissionsData.r_abo,'AB')& strcmp(submissionsData.d_abo,'A'))|...
    (strcmp(submissionsData.r_abo,'AB')& strcmp(submissionsData.d_abo,'O'))|...
    (strcmp(submissionsData.r_abo,'A')& strcmp(submissionsData.d_abo,'O'))|...
    (strcmp(submissionsData.r_abo,'B')& strcmp(submissionsData.d_abo,'O')))& ...
    (submissionsData.r_arr_date_min>= initial);

underdemanded = ...
    ((strcmp(submissionsData.r_abo,'O')& strcmp(submissionsData.d_abo,'AB'))|...
    (strcmp(submissionsData.r_abo,'O')& strcmp(submissionsData.d_abo,'B'))|...
    (strcmp(submissionsData.r_abo,'O')& strcmp(submissionsData.d_abo,'A'))|...
    (strcmp(submissionsData.r_abo,'A')& strcmp(submissionsData.d_abo,'AB'))|...
    (strcmp(submissionsData.r_abo,'B')& strcmp(submissionsData.d_abo,'AB')))& ...
    (submissionsData.r_arr_date_min>= initial);

normaldemanded = ...
    ((strcmp(submissionsData.r_abo,'AB')& strcmp(submissionsData.d_abo,'AB'))|...
    (strcmp(submissionsData.r_abo,'B')& strcmp(submissionsData.d_abo,'B'))|...
    (strcmp(submissionsData.r_abo,'A')& strcmp(submissionsData.d_abo,'A'))|...
    (strcmp(submissionsData.r_abo,'O')& strcmp(submissionsData.d_abo,'O'))|...
    (strcmp(submissionsData.r_abo,'A')& strcmp(submissionsData.d_abo,'B'))|...
    (strcmp(submissionsData.r_abo,'B')& strcmp(submissionsData.d_abo,'A')))& ...
    (submissionsData.r_arr_date_min>= initial);

varNames = {'type','GroupCount','mean_recipientTransplanted','mean_recipientDuration','mean_donorTransplanted','mean_donorDuration','mean_durationDonorTransplanted','mean_durationDonorNotTransplanted','mean_durationRecipientTransplanted','mean_durationRecipientNotTransplanted'};
statTable = array2table(zeros(6,size(varNames,2)-2));
statTable.Properties.VariableNames = varNames(3:end) ;
statTable.Properties.RowNames = {'Pairs', 'Chips', 'Altruistics',...
    'UnderDemanded','OverDemanded','NormalDemanded'};

statTable(:,1) = array2table ([...
    mean(isnan(submissionsData.r_transplanted(submissionsData.r_dep_date_max~=20061&pairs))==0);...
    mean(isnan(submissionsData.r_transplanted(submissionsData.r_dep_date_max~=20061&chips))==0);...
    mean(isnan(submissionsData.r_transplanted(submissionsData.d_dep_date_max~=20061&altruistics))==0);...
    mean(isnan(submissionsData.r_transplanted(submissionsData.r_dep_date_max~=20061&underdemanded))==0);...
    mean(isnan(submissionsData.r_transplanted(submissionsData.r_dep_date_max~=20061&overdemanded))==0);...
    mean(isnan(submissionsData.r_transplanted(submissionsData.r_dep_date_max~=20061&normaldemanded))==0);...
    ]);

statTable(:,2) = array2table ([...
        mean((submissionsData.r_dep_date_max(submissionsData.r_dep_date_max~=20061&pairs))...
    -(submissionsData.r_arr_date_min(submissionsData.r_dep_date_max~=20061&pairs)));...
        mean((submissionsData.r_dep_date_max(submissionsData.r_dep_date_max~=20061&chips))...
    -(submissionsData.r_arr_date_min(submissionsData.r_dep_date_max~=20061&chips)));...
        mean((submissionsData.r_dep_date_max(submissionsData.r_dep_date_max~=20061&altruistics))...
    -(submissionsData.r_arr_date_min(submissionsData.r_dep_date_max~=20061&altruistics)));...
        mean((submissionsData.r_dep_date_max(submissionsData.r_dep_date_max~=20061&underdemanded))...
    -(submissionsData.r_arr_date_min(submissionsData.r_dep_date_max~=20061&underdemanded)));...
        mean((submissionsData.r_dep_date_max(submissionsData.r_dep_date_max~=20061&overdemanded))...
    -(submissionsData.r_arr_date_min(submissionsData.r_dep_date_max~=20061&overdemanded)));...
        mean((submissionsData.r_dep_date_max(submissionsData.r_dep_date_max~=20061&normaldemanded))...
    -(submissionsData.r_arr_date_min(submissionsData.r_dep_date_max~=20061&normaldemanded)))]);

statTable(:,3) = array2table ([...
    mean(isnan(submissionsData.d_transplanted(submissionsData.d_dep_date_max~=20061&pairs))==0);...
    mean(isnan(submissionsData.d_transplanted(submissionsData.d_dep_date_max~=20061&chips))==0);...
    mean(isnan(submissionsData.d_transplanted(submissionsData.d_dep_date_max~=20061&altruistics))==0);...
    mean(isnan(submissionsData.d_transplanted(submissionsData.d_dep_date_max~=20061&underdemanded))==0);...
    mean(isnan(submissionsData.d_transplanted(submissionsData.d_dep_date_max~=20061&overdemanded))==0);...
    mean(isnan(submissionsData.d_transplanted(submissionsData.d_dep_date_max~=20061&normaldemanded))==0);...
    ]);

statTable(:,4) = array2table ([...
        mean((submissionsData.d_dep_date_max(submissionsData.d_dep_date_max~=20061&pairs))...
    -(submissionsData.d_arr_date_min(submissionsData.d_dep_date_max~=20061&pairs)));...
        mean((submissionsData.d_dep_date_max(submissionsData.d_dep_date_max~=20061&chips))...
    -(submissionsData.d_arr_date_min(submissionsData.d_dep_date_max~=20061&chips)));...
        mean((submissionsData.d_dep_date_max(submissionsData.d_dep_date_max~=20061&altruistics))...
    -(submissionsData.d_arr_date_min(submissionsData.d_dep_date_max~=20061&altruistics)));...
        mean((submissionsData.d_dep_date_max(submissionsData.d_dep_date_max~=20061&underdemanded))...
    -(submissionsData.d_arr_date_min(submissionsData.d_dep_date_max~=20061&underdemanded)));...
        mean((submissionsData.d_dep_date_max(submissionsData.d_dep_date_max~=20061&overdemanded))...
    -(submissionsData.d_arr_date_min(submissionsData.d_dep_date_max~=20061&overdemanded)));...
        mean((submissionsData.d_dep_date_max(submissionsData.d_dep_date_max~=20061&normaldemanded))...
    -(submissionsData.d_arr_date_min(submissionsData.d_dep_date_max~=20061&normaldemanded)))]);

statTable(:,5) = array2table ([...
        mean((submissionsData.d_dep_date_max(submissionsData.d_dep_date_max~=20061&isnan(submissionsData.d_transplanted)==0&pairs))...
    -(submissionsData.d_arr_date_min(submissionsData.d_dep_date_max~=20061&isnan(submissionsData.d_transplanted)==0&pairs)));...
        mean((submissionsData.d_dep_date_max(submissionsData.d_dep_date_max~=20061&isnan(submissionsData.d_transplanted)==0&chips))...
    -(submissionsData.d_arr_date_min(submissionsData.d_dep_date_max~=20061&isnan(submissionsData.d_transplanted)==0&chips)));...
        mean((submissionsData.d_dep_date_max(submissionsData.d_dep_date_max~=20061&isnan(submissionsData.d_transplanted)==0&altruistics))...
    -(submissionsData.d_arr_date_min(submissionsData.d_dep_date_max~=20061&isnan(submissionsData.d_transplanted)==0&altruistics)));...
        mean((submissionsData.d_dep_date_max(submissionsData.d_dep_date_max~=20061&isnan(submissionsData.d_transplanted)==0&underdemanded))...
    -(submissionsData.d_arr_date_min(submissionsData.d_dep_date_max~=20061&isnan(submissionsData.d_transplanted)==0&underdemanded)));...
        mean((submissionsData.d_dep_date_max(submissionsData.d_dep_date_max~=20061&isnan(submissionsData.d_transplanted)==0&overdemanded))...
    -(submissionsData.d_arr_date_min(submissionsData.d_dep_date_max~=20061&isnan(submissionsData.d_transplanted)==0&overdemanded)));...
        mean((submissionsData.d_dep_date_max(submissionsData.d_dep_date_max~=20061&isnan(submissionsData.d_transplanted)==0&normaldemanded))...
    -(submissionsData.d_arr_date_min(submissionsData.d_dep_date_max~=20061&isnan(submissionsData.d_transplanted)==0&normaldemanded)))]);

statTable(:,6) = array2table ([...
        mean((submissionsData.d_dep_date_max(submissionsData.d_dep_date_max~=20061&isnan(submissionsData.d_transplanted)==1&pairs))...
    -(submissionsData.d_arr_date_min(submissionsData.d_dep_date_max~=20061&isnan(submissionsData.d_transplanted)==1&pairs)));...
        mean((submissionsData.d_dep_date_max(submissionsData.d_dep_date_max~=20061&isnan(submissionsData.d_transplanted)==1&chips))...
    -(submissionsData.d_arr_date_min(submissionsData.d_dep_date_max~=20061&isnan(submissionsData.d_transplanted)==1&chips)));...
        mean((submissionsData.d_dep_date_max(submissionsData.d_dep_date_max~=20061&isnan(submissionsData.d_transplanted)==1&altruistics))...
    -(submissionsData.d_arr_date_min(submissionsData.d_dep_date_max~=20061&isnan(submissionsData.d_transplanted)==1&altruistics)));...
        mean((submissionsData.d_dep_date_max(submissionsData.d_dep_date_max~=20061&isnan(submissionsData.d_transplanted)==1&underdemanded))...
    -(submissionsData.d_arr_date_min(submissionsData.d_dep_date_max~=20061&isnan(submissionsData.d_transplanted)==1&underdemanded)));...
        mean((submissionsData.d_dep_date_max(submissionsData.d_dep_date_max~=20061&isnan(submissionsData.d_transplanted)==1&overdemanded))...
    -(submissionsData.d_arr_date_min(submissionsData.d_dep_date_max~=20061&isnan(submissionsData.d_transplanted)==1&overdemanded)));...
        mean((submissionsData.d_dep_date_max(submissionsData.d_dep_date_max~=20061&isnan(submissionsData.d_transplanted)==1&normaldemanded))...
    -(submissionsData.d_arr_date_min(submissionsData.d_dep_date_max~=20061&isnan(submissionsData.d_transplanted)==1&normaldemanded)))]);

statTable(:,7) = array2table ([...
        mean((submissionsData.r_dep_date_max(submissionsData.r_dep_date_max~=20061&isnan(submissionsData.r_transplanted)==0&pairs))...
    -(submissionsData.r_arr_date_min(submissionsData.r_dep_date_max~=20061&isnan(submissionsData.r_transplanted)==0&pairs)));...
        mean((submissionsData.r_dep_date_max(submissionsData.r_dep_date_max~=20061&isnan(submissionsData.r_transplanted)==0&chips))...
    -(submissionsData.r_arr_date_min(submissionsData.r_dep_date_max~=20061&isnan(submissionsData.r_transplanted)==0&chips)));...
        mean((submissionsData.r_dep_date_max(submissionsData.r_dep_date_max~=20061&isnan(submissionsData.r_transplanted)==0&altruistics))...
    -(submissionsData.r_arr_date_min(submissionsData.r_dep_date_max~=20061&isnan(submissionsData.r_transplanted)==0&altruistics)));...
        mean((submissionsData.r_dep_date_max(submissionsData.r_dep_date_max~=20061&isnan(submissionsData.r_transplanted)==0&underdemanded))...
    -(submissionsData.r_arr_date_min(submissionsData.r_dep_date_max~=20061&isnan(submissionsData.r_transplanted)==0&underdemanded)));...
        mean((submissionsData.r_dep_date_max(submissionsData.r_dep_date_max~=20061&isnan(submissionsData.r_transplanted)==0&overdemanded))...
    -(submissionsData.r_arr_date_min(submissionsData.r_dep_date_max~=20061&isnan(submissionsData.r_transplanted)==0&overdemanded)));...
        mean((submissionsData.r_dep_date_max(submissionsData.r_dep_date_max~=20061&isnan(submissionsData.r_transplanted)==0&normaldemanded))...
    -(submissionsData.r_arr_date_min(submissionsData.r_dep_date_max~=20061&isnan(submissionsData.r_transplanted)==0&normaldemanded)))]);

statTable(:,8) = array2table ([...
        mean((submissionsData.r_dep_date_max(submissionsData.r_dep_date_max~=20061&isnan(submissionsData.r_transplanted)==1&pairs))...
    -(submissionsData.r_arr_date_min(submissionsData.r_dep_date_max~=20061&isnan(submissionsData.r_transplanted)==1&pairs)));...
        mean((submissionsData.r_dep_date_max(submissionsData.r_dep_date_max~=20061&isnan(submissionsData.r_transplanted)==1&chips))...
    -(submissionsData.r_arr_date_min(submissionsData.r_dep_date_max~=20061&isnan(submissionsData.r_transplanted)==1&chips)));...
        mean((submissionsData.r_dep_date_max(submissionsData.r_dep_date_max~=20061&isnan(submissionsData.r_transplanted)==1&altruistics))...
    -(submissionsData.r_arr_date_min(submissionsData.r_dep_date_max~=20061&isnan(submissionsData.r_transplanted)==1&altruistics)));...
        mean((submissionsData.r_dep_date_max(submissionsData.r_dep_date_max~=20061&isnan(submissionsData.r_transplanted)==1&underdemanded))...
    -(submissionsData.r_arr_date_min(submissionsData.r_dep_date_max~=20061&isnan(submissionsData.r_transplanted)==1&underdemanded)));...
        mean((submissionsData.r_dep_date_max(submissionsData.r_dep_date_max~=20061&isnan(submissionsData.r_transplanted)==1&overdemanded))...
    -(submissionsData.r_arr_date_min(submissionsData.r_dep_date_max~=20061&isnan(submissionsData.r_transplanted)==1&overdemanded)));...
        mean((submissionsData.r_dep_date_max(submissionsData.r_dep_date_max~=20061&isnan(submissionsData.r_transplanted)==1&normaldemanded))...
    -(submissionsData.r_arr_date_min(submissionsData.r_dep_date_max~=20061&isnan(submissionsData.r_transplanted)==1&normaldemanded)))]);
    


submissionsData = readtable('./data/submissions-data.csv');
    
chips = (strcmp(submissionsData.category,'c') & ...
    submissionsData.r_dep_date_min>= initial);
pairs = (strcmp(submissionsData.category,'p') & ...
    submissionsData.r_dep_date_min>= initial);
altruistics = (strcmp(submissionsData.category,'a') & ...
    submissionsData.d_dep_date_min>= initial);
%% Cycle Chain


% Cycles

cycleIndexes = submissionsData.r_transplant_index(submissionsData.r_tx_cycle==1 & pairs);

uniqCycleIndexes = unique(cycleIndexes);
cycleLengths = zeros(1,length(uniqCycleIndexes));
cycleLen = zeros(size(submissionsData,1),1);
for i = 1 : length(uniqCycleIndexes)
   cycleLengths(i) = sum(cycleIndexes==uniqCycleIndexes(i));
   cycleLen(submissionsData.r_transplant_index ==uniqCycleIndexes(i)) = cycleLengths(i);
end
    
submissionsData.cycleLen = cycleLen;
% Chains

chainIndexes = submissionsData.d_transplant_index( altruistics & ...
    submissionsData.d_transplanted==1);


uniqChainIndexes = unique(chainIndexes);
chainLengths = zeros(1,length(uniqChainIndexes));
chainLen = zeros(size(submissionsData,1),1);

for i = 1 : length(uniqChainIndexes)
    % +1 since we are only counting patients in the chains. +1 is the
    % altruistic donor who initiates the chain. 
      chainLengths(i) = sum(submissionsData.d_transplant_index==uniqChainIndexes(i)) + 1;
   chainLen(submissionsData.r_transplant_index ==uniqChainIndexes(i)) = chainLengths(i);
   chainLen(submissionsData.d_transplant_index ==uniqChainIndexes(i)) = chainLengths(i);
end

submissionsData.chainLen = chainLen;



totalTransplant = ...
    sum(submissionsData.r_transplanted==1 | submissionsData.d_transplanted==1);
chainRatio = sum(submissionsData.d_tx_chain==1| ...
    submissionsData.r_tx_chain==1)/totalTransplant;
cycleRatio = sum(submissionsData.d_tx_cycle==1 | ...
    submissionsData.r_tx_cycle==1)/totalTransplant;
twocycleRatio = cycleRatio * (sum(cycleLengths==2)*2/...
    (sum(cycleLengths==3)*3+sum(cycleLengths==2)*2));
threecycleRatio = cycleRatio * (sum(cycleLengths==3)*3/...
    (sum(cycleLengths==3)*3+sum(cycleLengths==2)*2));

overallTransPerReal = [twocycleRatio threecycleRatio chainRatio mean(chainLengths) ];

%% Pool 
for i = 1: numofDays
    
chipinRealMark(i) = sum(strcmp(submissionsData.category,'c') & ...
    (submissionsData.r_arr_date_min<= stataFormatInitialDay-1+i &...
    submissionsData.r_dep_date_max> stataFormatInitialDay-1+i));
pairinRealMark(i) = sum(strcmp(submissionsData.category,'p') & ...
    (submissionsData.r_arr_date_min<= stataFormatInitialDay-1+i &...
    submissionsData.r_dep_date_max> stataFormatInitialDay-1+i));
altruisticinRealMark(i) = sum(strcmp(submissionsData.category,'a') & ...
    (submissionsData.d_arr_date_min<= stataFormatInitialDay-1+i &...
    submissionsData.d_dep_date_max> stataFormatInitialDay-1+i));
chipTransinRealMark(i) = sum(strcmp(submissionsData.category,'c') & ...
    (...
    submissionsData.r_dep_date_max== stataFormatInitialDay-1+i)&...
    submissionsData.r_transplanted==1);
pairTransinRealMark(i) = sum(strcmp(submissionsData.category,'p') & ...
    (...
    submissionsData.r_dep_date_max== stataFormatInitialDay-1+i)&...
    submissionsData.r_transplanted==1);
altruisticTransinRealMark(i) = sum(strcmp(submissionsData.category,'a') & ...
    (...
    submissionsData.d_dep_date_max== stataFormatInitialDay-1+i)&...
    submissionsData.d_transplanted==1);

chipPerishinRealMark(i) = sum(strcmp(submissionsData.category,'c') & ...
    (...
    submissionsData.r_dep_date_max== stataFormatInitialDay-1+i)&...
    isnan(submissionsData.r_transplanted)==1);
pairPerishinRealMark(i) = sum(strcmp(submissionsData.category,'p') & ...
    (...
    submissionsData.r_dep_date_max== stataFormatInitialDay-1+i)&...
    isnan(submissionsData.r_transplanted)==1);
altruisticPerishinRealMark(i) = sum(strcmp(submissionsData.category,'a') & ...
    (...
    submissionsData.d_dep_date_max== stataFormatInitialDay-1+i)&...
    isnan(submissionsData.d_transplanted)==1);

allMarkSizeinRealMark(i) = chipinRealMark(i)+pairinRealMark(i)+altruisticinRealMark(i) ;
allTransinRealMark(i) = chipTransinRealMark(i)+pairTransinRealMark(i)+altruisticTransinRealMark(i) ;
allPerishinRealMark(i) = chipPerishinRealMark(i)+pairPerishinRealMark(i)+altruisticPerishinRealMark(i) ;

end

realmarket_stat.chipinRealMark = chipinRealMark;
realmarket_stat.pairinRealMark = pairinRealMark;
realmarket_stat.altruisticinRealMark = altruisticinRealMark;
realmarket_stat.chipTransinRealMark = chipTransinRealMark;
realmarket_stat.pairTransinRealMark = pairTransinRealMark;
realmarket_stat.altruisticTransinRealMark = altruisticTransinRealMark;
realmarket_stat.chipPerishinRealMark = chipPerishinRealMark;
realmarket_stat.pairPerishinRealMark = pairPerishinRealMark;
realmarket_stat.altruisticPerishinRealMark = altruisticPerishinRealMark;
realmarket_stat.allMarkSizeinRealMark = allMarkSizeinRealMark;
realmarket_stat.allTransinRealMark = allTransinRealMark;
realmarket_stat.allPerishinRealMark = allPerishinRealMark;


simPairPoolSize = realmarket_stat.pairinRealMark;
simChipPoolSize = realmarket_stat.chipinRealMark;
simAltPoolSize = realmarket_stat.altruisticinRealMark;
simPairTrans = cumsum(realmarket_stat.pairTransinRealMark);
simPairPerish = cumsum(realmarket_stat.pairPerishinRealMark);
simChipTrans = cumsum(realmarket_stat.chipTransinRealMark);
simChipPerish = cumsum(realmarket_stat.chipPerishinRealMark);
simAltruisticTrans = cumsum(realmarket_stat.altruisticTransinRealMark);
simAltruisticPerish = cumsum(realmarket_stat.altruisticPerishinRealMark);

poolSize = [mean(mean(simAltPoolSize(1:330))) ; mean(mean(simAltPoolSize(331:660))) ; mean(mean(simAltPoolSize(661:end))) ;...
    mean(mean(simChipPoolSize(1:330))) ; mean(mean(simChipPoolSize(331:660))) ; mean(mean(simChipPoolSize(661:end))) ;...
    mean(mean(simPairPoolSize(1:330))) ; mean(mean(simPairPoolSize(331:660))) ; mean(mean(simPairPoolSize(661:end))) ;...
    mean(mean(simAltruisticTrans(1:330))) ; mean(mean(simAltruisticTrans(331:660))) ; mean(mean(simAltruisticTrans(661:end))) ;...
    mean(mean(simChipTrans(1:330))) ; mean(mean(simChipTrans(331:660))) ; mean(mean(simChipTrans(661:end))); ...
    mean(mean(simPairTrans(1:330))) ; mean(mean(simPairTrans(331:660))) ; mean(mean(simPairTrans(661:end))); ...
    mean(mean(simAltruisticPerish(1:330))) ; mean(mean(simAltruisticPerish(331:660))) ; mean(mean(simAltruisticPerish(661:end))); ...
    mean(mean(simChipPerish(1:330))) ; mean(mean(simChipPerish(331:660))) ; mean(mean(simChipPerish(661:end))) ;...
    mean(mean(simPairPerish(1:330))) ; mean(mean(simPairPerish(331:660))) ; mean(mean(simPairPerish(661:end)))];



for i = 1 : totalDraw
    i
    submissionsDataSample = sortrows([submissionsData(~entries,:) ; submissionsData(randsample(find(entries),sum(entries),1)',:)],1);
    
    
    
    %% Pool 
        for j = 1: numofDays

        chipinRealMark(j) = sum(strcmp(submissionsDataSample.category,'c') & ...
            (submissionsDataSample.r_arr_date_min<= stataFormatInitialDay-1+j &...
            submissionsDataSample.r_dep_date_max> stataFormatInitialDay-1+j));
        pairinRealMark(j) = sum(strcmp(submissionsDataSample.category,'p') & ...
            (submissionsDataSample.r_arr_date_min<= stataFormatInitialDay-1+j &...
            submissionsDataSample.r_dep_date_max> stataFormatInitialDay-1+j));
        altruisticinRealMark(j) = sum(strcmp(submissionsDataSample.category,'a') & ...
            (submissionsDataSample.d_arr_date_min<= stataFormatInitialDay-1+j &...
            submissionsDataSample.d_dep_date_max> stataFormatInitialDay-1+j));
        chipTransinRealMark(j) = sum(strcmp(submissionsDataSample.category,'c') & ...
            (...
            submissionsDataSample.r_dep_date_max== stataFormatInitialDay-1+j)&...
            submissionsDataSample.r_transplanted==1);
        pairTransinRealMark(j) = sum(strcmp(submissionsDataSample.category,'p') & ...
            (...
            submissionsDataSample.r_dep_date_max== stataFormatInitialDay-1+j)&...
            submissionsDataSample.r_transplanted==1);
        altruisticTransinRealMark(j) = sum(strcmp(submissionsDataSample.category,'a') & ...
            (...
            submissionsDataSample.d_dep_date_max== stataFormatInitialDay-1+j)&...
            submissionsDataSample.d_transplanted==1);

        chipPerishinRealMark(j) = sum(strcmp(submissionsDataSample.category,'c') & ...
            (...
            submissionsDataSample.r_dep_date_max== stataFormatInitialDay-1+j)&...
            isnan(submissionsDataSample.r_transplanted)==1);
        pairPerishinRealMark(j) = sum(strcmp(submissionsDataSample.category,'p') & ...
            (...
            submissionsDataSample.r_dep_date_max== stataFormatInitialDay-1+j)&...
            isnan(submissionsDataSample.r_transplanted)==1);
        altruisticPerishinRealMark(j) = sum(strcmp(submissionsDataSample.category,'a') & ...
            (...
            submissionsDataSample.d_dep_date_max== stataFormatInitialDay-1+j)&...
            isnan(submissionsDataSample.d_transplanted)==1);

        allMarkSizeinRealMark(j) = chipinRealMark(j)+pairinRealMark(j)+altruisticinRealMark(j) ;
        allTransinRealMark(j) = chipTransinRealMark(j)+pairTransinRealMark(j)+altruisticTransinRealMark(j) ;
        allPerishinRealMark(j) = chipPerishinRealMark(j)+pairPerishinRealMark(j)+altruisticPerishinRealMark(j) ;

        end

        realmarket_stat.chipinRealMark = chipinRealMark;
        realmarket_stat.pairinRealMark = pairinRealMark;
        realmarket_stat.altruisticinRealMark = altruisticinRealMark;
        realmarket_stat.chipTransinRealMark = chipTransinRealMark;
        realmarket_stat.pairTransinRealMark = pairTransinRealMark;
        realmarket_stat.altruisticTransinRealMark = altruisticTransinRealMark;
        realmarket_stat.chipPerishinRealMark = chipPerishinRealMark;
        realmarket_stat.pairPerishinRealMark = pairPerishinRealMark;
        realmarket_stat.altruisticPerishinRealMark = altruisticPerishinRealMark;
        realmarket_stat.allMarkSizeinRealMark = allMarkSizeinRealMark;
        realmarket_stat.allTransinRealMark = allTransinRealMark;
        realmarket_stat.allPerishinRealMark = allPerishinRealMark;
       
        simPairPoolSize = realmarket_stat.pairinRealMark;
        simChipPoolSize = realmarket_stat.chipinRealMark;
        simAltPoolSize = realmarket_stat.altruisticinRealMark;
        simPairTrans = cumsum(realmarket_stat.pairTransinRealMark);
        simPairPerish = cumsum(realmarket_stat.pairPerishinRealMark);
        simChipTrans = cumsum(realmarket_stat.chipTransinRealMark);
        simChipPerish = cumsum(realmarket_stat.chipPerishinRealMark);
        simAltruisticTrans = cumsum(realmarket_stat.altruisticTransinRealMark);
        simAltruisticPerish = cumsum(realmarket_stat.altruisticPerishinRealMark);

        poolSizeSamp = [mean(mean(simAltPoolSize(1:330))) ; mean(mean(simAltPoolSize(331:660))) ; mean(mean(simAltPoolSize(661:end))) ;...
            mean(mean(simChipPoolSize(1:330))) ; mean(mean(simChipPoolSize(331:660))) ; mean(mean(simChipPoolSize(661:end))) ;...
            mean(mean(simPairPoolSize(1:330))) ; mean(mean(simPairPoolSize(331:660))) ; mean(mean(simPairPoolSize(661:end))) ;...
            mean(mean(simAltruisticTrans(1:330))) ; mean(mean(simAltruisticTrans(331:660))) ; mean(mean(simAltruisticTrans(661:end))) ;...
            mean(mean(simChipTrans(1:330))) ; mean(mean(simChipTrans(331:660))) ; mean(mean(simChipTrans(661:end))); ...
            mean(mean(simPairTrans(1:330))) ; mean(mean(simPairTrans(331:660))) ; mean(mean(simPairTrans(661:end))); ...
            mean(mean(simAltruisticPerish(1:330))) ; mean(mean(simAltruisticPerish(331:660))) ; mean(mean(simAltruisticPerish(661:end))); ...
            mean(mean(simChipPerish(1:330))) ; mean(mean(simChipPerish(331:660))) ; mean(mean(simChipPerish(661:end))) ;...
            mean(mean(simPairPerish(1:330))) ; mean(mean(simPairPerish(331:660))) ; mean(mean(simPairPerish(661:end)))];
        
        poolSizeVar{i} = poolSizeSamp;
        


        
%% Cycle Chain
        
        totalTransplant = ...
            sum(submissionsDataSample.r_transplanted==1 | submissionsDataSample.d_transplanted==1);
        chainRatio = sum(submissionsDataSample.d_tx_chain==1| ...
            submissionsDataSample.r_tx_chain==1)/totalTransplant;
        cycleRatio = sum(submissionsDataSample.d_tx_cycle==1 | ...
            submissionsDataSample.r_tx_cycle==1)/totalTransplant;
        twocycleRatio = cycleRatio * (sum(cycleLengths==2)*2/...
            (sum(cycleLengths==3)*3+sum(cycleLengths==2)*2));
        threecycleRatio = cycleRatio * (sum(cycleLengths==3)*3/...
            (sum(cycleLengths==3)*3+sum(cycleLengths==2)*2));
        chainLens = submissionsDataSample.chainLen(submissionsDataSample.chainLen>0);
        chainLenuUnq = unique(chainLens) ;
        
        for j = 1 : length(chainLenuUnq)
            
            chainObs(j) = sum(chainLens == chainLenuUnq(j));
                        
        end
        
%% Summary Table Moments
        entries = (strcmp(submissionsDataSample.category,'a') & submissionsDataSample.d_arr_date_min>=19084) + ...
        ((  strcmp(submissionsDataSample.category,'p') |strcmp(submissionsDataSample.category,'c'))...
        &   submissionsDataSample.r_arr_date_min>=19084);

        submissionsDataSample = submissionsDataSample(entries>0,:);

        chips = (strcmp(submissionsDataSample.category,'c') & ...
            submissionsDataSample.r_arr_date_min>= initial);
        pairs = (strcmp(submissionsDataSample.category,'p') & ...
            submissionsDataSample.r_arr_date_min>= initial);
        altruistics = (strcmp(submissionsDataSample.category,'a') & ...
            submissionsDataSample.d_arr_date_min>= initial);

        overdemanded = ...
            ((strcmp(submissionsDataSample.r_abo,'AB')& strcmp(submissionsDataSample.d_abo,'B'))|...
            (strcmp(submissionsDataSample.r_abo,'AB')& strcmp(submissionsDataSample.d_abo,'A'))|...
            (strcmp(submissionsDataSample.r_abo,'AB')& strcmp(submissionsDataSample.d_abo,'O'))|...
            (strcmp(submissionsDataSample.r_abo,'A')& strcmp(submissionsDataSample.d_abo,'O'))|...
            (strcmp(submissionsDataSample.r_abo,'B')& strcmp(submissionsDataSample.d_abo,'O')))& ...
            (submissionsDataSample.r_arr_date_min>= initial);

        underdemanded = ...
            ((strcmp(submissionsDataSample.r_abo,'O')& strcmp(submissionsDataSample.d_abo,'AB'))|...
            (strcmp(submissionsDataSample.r_abo,'O')& strcmp(submissionsDataSample.d_abo,'B'))|...
            (strcmp(submissionsDataSample.r_abo,'O')& strcmp(submissionsDataSample.d_abo,'A'))|...
            (strcmp(submissionsDataSample.r_abo,'A')& strcmp(submissionsDataSample.d_abo,'AB'))|...
            (strcmp(submissionsDataSample.r_abo,'B')& strcmp(submissionsDataSample.d_abo,'AB')))& ...
            (submissionsDataSample.r_arr_date_min>= initial);

        normaldemanded = ...
            ((strcmp(submissionsDataSample.r_abo,'AB')& strcmp(submissionsDataSample.d_abo,'AB'))|...
            (strcmp(submissionsDataSample.r_abo,'B')& strcmp(submissionsDataSample.d_abo,'B'))|...
            (strcmp(submissionsDataSample.r_abo,'A')& strcmp(submissionsDataSample.d_abo,'A'))|...
            (strcmp(submissionsDataSample.r_abo,'O')& strcmp(submissionsDataSample.d_abo,'O'))|...
            (strcmp(submissionsDataSample.r_abo,'A')& strcmp(submissionsDataSample.d_abo,'B'))|...
            (strcmp(submissionsDataSample.r_abo,'B')& strcmp(submissionsDataSample.d_abo,'A')))& ...
            (submissionsDataSample.r_arr_date_min>= initial);

        varNames = {'type','GroupCount','mean_recipientTransplanted','mean_recipientDuration','mean_donorTransplanted','mean_donorDuration','mean_durationDonorTransplanted','mean_durationDonorNotTransplanted','mean_durationRecipientTransplanted','mean_durationRecipientNotTransplanted'};
        statTableVarSample = array2table(zeros(6,size(varNames,2)-2));
        statTableVarSample.Properties.VariableNames = varNames(3:end) ;
        statTableVarSample.Properties.RowNames = {'Pairs', 'Chips', 'Altruistics',...
            'UnderDemanded','OverDemanded','NormalDemanded'};

        statTableVarSample(:,1) = array2table ([...
            mean(isnan(submissionsDataSample.r_transplanted(submissionsDataSample.r_dep_date_max~=20061&pairs))==0);...
            mean(isnan(submissionsDataSample.r_transplanted(submissionsDataSample.r_dep_date_max~=20061&chips))==0);...
            mean(isnan(submissionsDataSample.r_transplanted(submissionsDataSample.d_dep_date_max~=20061&altruistics))==0);...
            mean(isnan(submissionsDataSample.r_transplanted(submissionsDataSample.r_dep_date_max~=20061&underdemanded))==0);...
            mean(isnan(submissionsDataSample.r_transplanted(submissionsDataSample.r_dep_date_max~=20061&overdemanded))==0);...
            mean(isnan(submissionsDataSample.r_transplanted(submissionsDataSample.r_dep_date_max~=20061&normaldemanded))==0);...
            ]);

        statTableVarSample(:,2) = array2table ([...
                mean((submissionsDataSample.r_dep_date_max(submissionsDataSample.r_dep_date_max~=20061&pairs))...
            -(submissionsDataSample.r_arr_date_min(submissionsDataSample.r_dep_date_max~=20061&pairs)));...
                mean((submissionsDataSample.r_dep_date_max(submissionsDataSample.r_dep_date_max~=20061&chips))...
            -(submissionsDataSample.r_arr_date_min(submissionsDataSample.r_dep_date_max~=20061&chips)));...
                mean((submissionsDataSample.r_dep_date_max(submissionsDataSample.r_dep_date_max~=20061&altruistics))...
            -(submissionsDataSample.r_arr_date_min(submissionsDataSample.r_dep_date_max~=20061&altruistics)));...
                mean((submissionsDataSample.r_dep_date_max(submissionsDataSample.r_dep_date_max~=20061&underdemanded))...
            -(submissionsDataSample.r_arr_date_min(submissionsDataSample.r_dep_date_max~=20061&underdemanded)));...
                mean((submissionsDataSample.r_dep_date_max(submissionsDataSample.r_dep_date_max~=20061&overdemanded))...
            -(submissionsDataSample.r_arr_date_min(submissionsDataSample.r_dep_date_max~=20061&overdemanded)));...
                mean((submissionsDataSample.r_dep_date_max(submissionsDataSample.r_dep_date_max~=20061&normaldemanded))...
            -(submissionsDataSample.r_arr_date_min(submissionsDataSample.r_dep_date_max~=20061&normaldemanded)))]);

        statTableVarSample(:,3) = array2table ([...
            mean(isnan(submissionsDataSample.d_transplanted(submissionsDataSample.d_dep_date_max~=20061&pairs))==0);...
            mean(isnan(submissionsDataSample.d_transplanted(submissionsDataSample.d_dep_date_max~=20061&chips))==0);...
            mean(isnan(submissionsDataSample.d_transplanted(submissionsDataSample.d_dep_date_max~=20061&altruistics))==0);...
            mean(isnan(submissionsDataSample.d_transplanted(submissionsDataSample.d_dep_date_max~=20061&underdemanded))==0);...
            mean(isnan(submissionsDataSample.d_transplanted(submissionsDataSample.d_dep_date_max~=20061&overdemanded))==0);...
            mean(isnan(submissionsDataSample.d_transplanted(submissionsDataSample.d_dep_date_max~=20061&normaldemanded))==0);...
            ]);

        statTableVarSample(:,4) = array2table ([...
                mean((submissionsDataSample.d_dep_date_max(submissionsDataSample.d_dep_date_max~=20061&pairs))...
            -(submissionsDataSample.d_arr_date_min(submissionsDataSample.d_dep_date_max~=20061&pairs)));...
                mean((submissionsDataSample.d_dep_date_max(submissionsDataSample.d_dep_date_max~=20061&chips))...
            -(submissionsDataSample.d_arr_date_min(submissionsDataSample.d_dep_date_max~=20061&chips)));...
                mean((submissionsDataSample.d_dep_date_max(submissionsDataSample.d_dep_date_max~=20061&altruistics))...
            -(submissionsDataSample.d_arr_date_min(submissionsDataSample.d_dep_date_max~=20061&altruistics)));...
                mean((submissionsDataSample.d_dep_date_max(submissionsDataSample.d_dep_date_max~=20061&underdemanded))...
            -(submissionsDataSample.d_arr_date_min(submissionsDataSample.d_dep_date_max~=20061&underdemanded)));...
                mean((submissionsDataSample.d_dep_date_max(submissionsDataSample.d_dep_date_max~=20061&overdemanded))...
            -(submissionsDataSample.d_arr_date_min(submissionsDataSample.d_dep_date_max~=20061&overdemanded)));...
                mean((submissionsDataSample.d_dep_date_max(submissionsDataSample.d_dep_date_max~=20061&normaldemanded))...
            -(submissionsDataSample.d_arr_date_min(submissionsDataSample.d_dep_date_max~=20061&normaldemanded)))]);

        statTableVarSample(:,5) = array2table ([...
                mean((submissionsDataSample.d_dep_date_max(submissionsDataSample.d_dep_date_max~=20061&isnan(submissionsDataSample.d_transplanted)==0&pairs))...
            -(submissionsDataSample.d_arr_date_min(submissionsDataSample.d_dep_date_max~=20061&isnan(submissionsDataSample.d_transplanted)==0&pairs)));...
                mean((submissionsDataSample.d_dep_date_max(submissionsDataSample.d_dep_date_max~=20061&isnan(submissionsDataSample.d_transplanted)==0&chips))...
            -(submissionsDataSample.d_arr_date_min(submissionsDataSample.d_dep_date_max~=20061&isnan(submissionsDataSample.d_transplanted)==0&chips)));...
                mean((submissionsDataSample.d_dep_date_max(submissionsDataSample.d_dep_date_max~=20061&isnan(submissionsDataSample.d_transplanted)==0&altruistics))...
            -(submissionsDataSample.d_arr_date_min(submissionsDataSample.d_dep_date_max~=20061&isnan(submissionsDataSample.d_transplanted)==0&altruistics)));...
                mean((submissionsDataSample.d_dep_date_max(submissionsDataSample.d_dep_date_max~=20061&isnan(submissionsDataSample.d_transplanted)==0&underdemanded))...
            -(submissionsDataSample.d_arr_date_min(submissionsDataSample.d_dep_date_max~=20061&isnan(submissionsDataSample.d_transplanted)==0&underdemanded)));...
                mean((submissionsDataSample.d_dep_date_max(submissionsDataSample.d_dep_date_max~=20061&isnan(submissionsDataSample.d_transplanted)==0&overdemanded))...
            -(submissionsDataSample.d_arr_date_min(submissionsDataSample.d_dep_date_max~=20061&isnan(submissionsDataSample.d_transplanted)==0&overdemanded)));...
                mean((submissionsDataSample.d_dep_date_max(submissionsDataSample.d_dep_date_max~=20061&isnan(submissionsDataSample.d_transplanted)==0&normaldemanded))...
            -(submissionsDataSample.d_arr_date_min(submissionsDataSample.d_dep_date_max~=20061&isnan(submissionsDataSample.d_transplanted)==0&normaldemanded)))]);

        statTableVarSample(:,6) = array2table ([...
                mean((submissionsDataSample.d_dep_date_max(submissionsDataSample.d_dep_date_max~=20061&isnan(submissionsDataSample.d_transplanted)==1&pairs))...
            -(submissionsDataSample.d_arr_date_min(submissionsDataSample.d_dep_date_max~=20061&isnan(submissionsDataSample.d_transplanted)==1&pairs)));...
                mean((submissionsDataSample.d_dep_date_max(submissionsDataSample.d_dep_date_max~=20061&isnan(submissionsDataSample.d_transplanted)==1&chips))...
            -(submissionsDataSample.d_arr_date_min(submissionsDataSample.d_dep_date_max~=20061&isnan(submissionsDataSample.d_transplanted)==1&chips)));...
                mean((submissionsDataSample.d_dep_date_max(submissionsDataSample.d_dep_date_max~=20061&isnan(submissionsDataSample.d_transplanted)==1&altruistics))...
            -(submissionsDataSample.d_arr_date_min(submissionsDataSample.d_dep_date_max~=20061&isnan(submissionsDataSample.d_transplanted)==1&altruistics)));...
                mean((submissionsDataSample.d_dep_date_max(submissionsDataSample.d_dep_date_max~=20061&isnan(submissionsDataSample.d_transplanted)==1&underdemanded))...
            -(submissionsDataSample.d_arr_date_min(submissionsDataSample.d_dep_date_max~=20061&isnan(submissionsDataSample.d_transplanted)==1&underdemanded)));...
                mean((submissionsDataSample.d_dep_date_max(submissionsDataSample.d_dep_date_max~=20061&isnan(submissionsDataSample.d_transplanted)==1&overdemanded))...
            -(submissionsDataSample.d_arr_date_min(submissionsDataSample.d_dep_date_max~=20061&isnan(submissionsDataSample.d_transplanted)==1&overdemanded)));...
                mean((submissionsDataSample.d_dep_date_max(submissionsDataSample.d_dep_date_max~=20061&isnan(submissionsDataSample.d_transplanted)==1&normaldemanded))...
            -(submissionsDataSample.d_arr_date_min(submissionsDataSample.d_dep_date_max~=20061&isnan(submissionsDataSample.d_transplanted)==1&normaldemanded)))]);

        statTableVarSample(:,7) = array2table ([...
                mean((submissionsDataSample.r_dep_date_max(submissionsDataSample.r_dep_date_max~=20061&isnan(submissionsDataSample.r_transplanted)==0&pairs))...
            -(submissionsDataSample.r_arr_date_min(submissionsDataSample.r_dep_date_max~=20061&isnan(submissionsDataSample.r_transplanted)==0&pairs)));...
                mean((submissionsDataSample.r_dep_date_max(submissionsDataSample.r_dep_date_max~=20061&isnan(submissionsDataSample.r_transplanted)==0&chips))...
            -(submissionsDataSample.r_arr_date_min(submissionsDataSample.r_dep_date_max~=20061&isnan(submissionsDataSample.r_transplanted)==0&chips)));...
                mean((submissionsDataSample.r_dep_date_max(submissionsDataSample.r_dep_date_max~=20061&isnan(submissionsDataSample.r_transplanted)==0&altruistics))...
            -(submissionsDataSample.r_arr_date_min(submissionsDataSample.r_dep_date_max~=20061&isnan(submissionsDataSample.r_transplanted)==0&altruistics)));...
                mean((submissionsDataSample.r_dep_date_max(submissionsDataSample.r_dep_date_max~=20061&isnan(submissionsDataSample.r_transplanted)==0&underdemanded))...
            -(submissionsDataSample.r_arr_date_min(submissionsDataSample.r_dep_date_max~=20061&isnan(submissionsDataSample.r_transplanted)==0&underdemanded)));...
                mean((submissionsDataSample.r_dep_date_max(submissionsDataSample.r_dep_date_max~=20061&isnan(submissionsDataSample.r_transplanted)==0&overdemanded))...
            -(submissionsDataSample.r_arr_date_min(submissionsDataSample.r_dep_date_max~=20061&isnan(submissionsDataSample.r_transplanted)==0&overdemanded)));...
                mean((submissionsDataSample.r_dep_date_max(submissionsDataSample.r_dep_date_max~=20061&isnan(submissionsDataSample.r_transplanted)==0&normaldemanded))...
            -(submissionsDataSample.r_arr_date_min(submissionsDataSample.r_dep_date_max~=20061&isnan(submissionsDataSample.r_transplanted)==0&normaldemanded)))]);

        statTableVarSample(:,8) = array2table ([...
                mean((submissionsDataSample.r_dep_date_max(submissionsDataSample.r_dep_date_max~=20061&isnan(submissionsDataSample.r_transplanted)==1&pairs))...
            -(submissionsDataSample.r_arr_date_min(submissionsDataSample.r_dep_date_max~=20061&isnan(submissionsDataSample.r_transplanted)==1&pairs)));...
                mean((submissionsDataSample.r_dep_date_max(submissionsDataSample.r_dep_date_max~=20061&isnan(submissionsDataSample.r_transplanted)==1&chips))...
            -(submissionsDataSample.r_arr_date_min(submissionsDataSample.r_dep_date_max~=20061&isnan(submissionsDataSample.r_transplanted)==1&chips)));...
                mean((submissionsDataSample.r_dep_date_max(submissionsDataSample.r_dep_date_max~=20061&isnan(submissionsDataSample.r_transplanted)==1&altruistics))...
            -(submissionsDataSample.r_arr_date_min(submissionsDataSample.r_dep_date_max~=20061&isnan(submissionsDataSample.r_transplanted)==1&altruistics)));...
                mean((submissionsDataSample.r_dep_date_max(submissionsDataSample.r_dep_date_max~=20061&isnan(submissionsDataSample.r_transplanted)==1&underdemanded))...
            -(submissionsDataSample.r_arr_date_min(submissionsDataSample.r_dep_date_max~=20061&isnan(submissionsDataSample.r_transplanted)==1&underdemanded)));...
                mean((submissionsDataSample.r_dep_date_max(submissionsDataSample.r_dep_date_max~=20061&isnan(submissionsDataSample.r_transplanted)==1&overdemanded))...
            -(submissionsDataSample.r_arr_date_min(submissionsDataSample.r_dep_date_max~=20061&isnan(submissionsDataSample.r_transplanted)==1&overdemanded)));...
                mean((submissionsDataSample.r_dep_date_max(submissionsDataSample.r_dep_date_max~=20061&isnan(submissionsDataSample.r_transplanted)==1&normaldemanded))...
            -(submissionsDataSample.r_arr_date_min(submissionsDataSample.r_dep_date_max~=20061&isnan(submissionsDataSample.r_transplanted)==1&normaldemanded)))]);
            statTableVar{i} = statTableVarSample;


        overallTransPerRealVec(:,i) = [twocycleRatio  threecycleRatio chainRatio sum(chainObs)/sum(chainObs./chainLenuUnq') ];

end

real.statTable      =   statTable;
real.statTableVar   =   statTableVar;

real.poolSize       =   poolSize;
real.poolSizeVar    =   poolSizeVar;

real.matchType      =   overallTransPerReal;
real.matchTypeVar   =   overallTransPerRealVec;

directory = './analysis/calibration/moments-conditions/' ;
fileName = ['realMoments.mat'];
fileName = fullfile(directory, fileName);
save(fileName,'real');