%% Replication files for "Monetary Policy, Bounded Rationality, and Incomplete Markets"
% by Emmanuel Farhi and Ivan Werning
% 
% Written and prepared by Mikel Petri
% Sunday June 23, 2019

%% Add paths for source files and auxiliary packages
clear all
close all

addpath('./src/')
addpath('./export_fig/')

%% Calibration and discretization of income process
% Values from Floden and Linde (2001)
rho			= 0.966;
std			= sqrt(0.017);
Nstate		= 7; 

param		= calibrate_income_process(rho, std, Nstate);

%% Baseline calibration
param.sigma			= 1;			% rel. risk aversion NO MNS
param.beta_high		= 0.994;		% beta ceiling to find steady state (the asymptotic max value is 1/R with infinite liquidity)
param.R				= 1.02^.25;		% interest rate (2% annual)

param.delta			= 1.44*4*(param.R-1);	% capital share
param.gamma			= (2+1.44*4*(param.R-1))/(1-1.44*4*(param.R-1))*(1-param.delta)-param.delta;	% Inverse Frisch to preserve RE response for different delta
param.theta			= 1;			% weight disutility of labor
param.lambda		= 0.85;			% Calvo fraction NOT adjusting prices
param.epsilon		= 6;			% Elasticity of intermediates demand

param.infl			= 1;			% SS Inflation
param.taylor_inf	= 1.5;			% Taylor Rule inflation coefficient

% Asset grid parameters
param.agrid			= 500;			% points in the grid
param.alow			= 0;
param.ahigh			= param.yh*20;
param.grid_NL		= 1.5;			% linear case = 1

param.a_NL			= linspace(0,1,param.agrid)';
param.a				= param.a_NL.^param.grid_NL*(param.ahigh - param.alow) + param.alow;

clearvars -except param