set more 1

/*Enter below the directory where the file rawdata.dta is stored.*/


use "rawdata.dta", clear


/**Dictionary of Variables

id: ID of a participant. One ID by participant. Each participant only participated in one session of one treatment.
Session: Consecutive number for different sessions.
Subject: ID of a subject within a Session.
Treatment: 1: Game with fixed types, 2: Game with random types, 3: Game with random types (hypothetical), 4: Bandit with perfect correlation and fixed types, 5: Bandit with perfect correlation and random types, 6: Bandit with independent beliefs and fixed types, 7: Bandit with independent beliefs and random types, 8: Bandit with perfect correlation and random types using the One Deck description.
Period: Period within the session. From 1 to 120.
Role: 1-Player 1, 2-Player 2 [Only for Game treatments.] In Bandit treatments Role=1 for all participants.
Type: Type for player 1: 0-Blue 1-Red
Group: In game treatments in each period one player 1 and one player 2 are randomly matched. This variable indexes the pairs of participants that are matched.
Period_Autom: This variable is equal to -1 if the subject has not yet programmed the choices and is equal to the first period in which subjects were programmed from the moment that choices were programmed onwards
Automatic: 0: Choices are not programmed, 1: Choices are programmed
action1: Action selected by player 1. 0: Out. 1: In
action2: Action selected by player 2. 0: Triangle. 1: Square
action1R: For participants who programmed their choices this variable keeps track of what choice the computer is supposed to make if the type is Red.  0: Out. 1: In. -1: Choice not set.
action1B: For participants who programmed their choices this variable keeps track of what choice the computer is supposed to make if the type is Blue.  0: Out. 1: In. -1: Choice not set.
action2_obs: If action2 was not observed by player 1, then the variable is assigned -1. If it was observed, then the value is equal to action2.
OtherRIn: This variable is only computed for player 2s. Number of times so far that player 1 Reds they have interacted with selected In. A -1 entry indicates that at this period it is not possible to compute this variable due to lack of data.
OtherBIn: This variable is only computed for player 2s. Number of times so far that player 1 Blues they have interacted with selected In. A -1 entry indicates that at this period it is not possible to compute this variable due to lack of data.
OtherOut: This variable is only computed for player 2s. Number of times so far that player 1 Blues they have interacted with selected In. A -1 entry indicates that at this period it is not possible to compute this variable due to lack of data.
OtherNTriang: This variable is only computed for player 1s. Number of times so far that player 2s they have interacted with selected Triangles. A -1 entry indicates that at this period it is not possible to compute this variable due to lack of data.
OtherNSquare: This variable is only computed for player 1s. Number of times so far that player 2s they have interacted with selected Squares. A -1 entry indicates that at this period it is not possible to compute this variable due to lack of data.
bandit_sqR=Type of player 2 in bandit with independent beliefs treatment when player 1 is Red. 80: player 2 selects squares with probability 80 percent. 95: player 2 selects squares with probability 95 percent.
bandit_sqB=Type of player 2 in bandit with independent beliefs treatment when player 1 is Blue. 80: player 2 selects squares with probability 80 percent. 95: player 2 selects squares with probability 95 percent.
OtherNTriangR/OtherNSquareR/OtherNTriangB/OtherNSquareB: Variables similar to OtherNTriang and OTherNSquare but for random-types treatment with independent beliefs, where the tracking is done for each player 1 type given that player 2's behavior can be different depending on player 1's type.
**/

*PRELIMINARIES: Variables that will be used to generate tables and figures.

gen     IN_0 =. /*Will have a 1 if the player 1 Blue eventually settled for In*/
gen     IN_1 =. /*Will have a 1 if the player 1 Red eventually settled for In*/
gen     OUT_0=. /*Will have a 1 if the player 1 Blue eventually settled for Out*/
gen     OUT_1=. /*Will have a 1 if the player 1 Red eventually settled for Out*/
gen     min_IN_0 =. /*Will have the first period starting at which IN_0=1*/
gen     min_IN_1 =. /*Will have the first period starting at which IN_1=1*/
gen     min_OUT_0 =. /*Will have the first period starting at which OUT_0=1*/
gen     min_OUT_1 =. /*Will have the first period starting at which OUT_1=1*/
gen     min_SQ=.  /*Will have the first period starting at which player 2 settled for squares*/
gen     min_TRI=. /*Will have the first period starting at which player 2 settled for triangles*/


*Subjects in role of player 1
foreach i in 0 1 {

gen Junk_action1=action1 if Type==`i' & Role==1

sort id Period
qui by id: replace Junk_action1=Junk_action1[_n-1] if Junk_action1==. & Role==1

gen junk_In=(Junk_action1==1)


gsort id -Period
qui gen junk0 = 1
qui by id: gen junk1 = sum(junk_In)
qui by id: gen junk2 = sum(junk0)  

qui gen junk_soph_cum_ = (junk1>=junk2) 

qui sort id Period
qui by id: gen junk_in_ = Period if junk_soph_cum_==1  
qui by id: egen min_in_`i' = min(junk_in_) 
qui replace IN_`i' = 1 if (Period>=min_in_`i') & min_in_`i'!=. & min_in_`i'<=111 
qui replace IN_`i' = 0 if (Period< min_in_`i') & min_in_`i'!=. & min_in_`i'<=111

replace min_IN_`i'=min_in_`i' if min_in_`i'<=111
drop min_in_`i'

drop junk*


gen junk_Out=(Junk_action1==0)
gsort id -Period 
qui gen junk0 = 1
qui by id: gen junk1 = sum(junk_Out) 
qui by id: gen junk2 = sum(junk0) 

qui gen junk_soph_cum_ = (junk1>=junk2) 

qui sort id Period
qui by id: gen junk_out_ = Period if junk_soph_cum_==1 
qui by id: egen min_out_`i' = min(junk_out_) 
qui replace OUT_`i' = 1 if (Period>=min_out_`i') & min_out_`i'!=. & min_out_`i'<=111  
qui replace OUT_`i' = 0 if (Period< min_out_`i') & min_out_`i'!=. & min_out_`i'<=111

drop junk* Junk*

replace min_OUT_`i'=min_out_`i' if min_out_`i'<=111
drop min_out_`i'

}

gen     min_Stat_0=min_IN_0  if min_IN_0!=.
replace min_Stat_0=min_OUT_0 if min_OUT_0!=.
gen     min_Stat_1=min_IN_1  if min_IN_1!=.
replace min_Stat_1=min_OUT_1 if min_OUT_1!=.
replace IN_1=0 if OUT_1==1
replace IN_0=0 if OUT_0==1

*Subjects in role of player 2

gen junk_action2=action2 if Role==2
gen junk_Sq=(junk_action2==1)
replace junk_Sq=. if Role==1
gsort id -Period 
qui gen junk0 = 1
qui by id: gen junk1 = sum(junk_Sq) 
qui by id: gen junk2 = sum(junk0)

qui gen junk_soph_cum_ = (junk1>=junk2) 

qui sort id Period
qui by id: gen junk_Sq_ = Period if junk_soph_cum_==1  
qui by id: egen min_sq = min(junk_Sq_) 
qui gen SQ = (Period>=min_sq) & min_sq!=. & min_sq<=111 

replace min_SQ=min_sq if min_sq<=111

drop junk* min_sq*

gen junk_action2=action2 if Role==2
gen junk_Tri=(junk_action2==0)
replace junk_Tri=. if Role==1
gsort id -Period 
qui gen junk0 = 1
qui by id: gen junk1 = sum(junk_Tri) 
qui by id: gen junk2 = sum(junk0)  

qui gen junk_soph_cum_ = (junk1>=junk2) 

qui sort id Period
qui by id: gen junk_Tri_ = Period if junk_soph_cum_`z'==1 
qui by id: egen min_tri = min(junk_Tri_)
qui gen TRI = (Period>=min_tri) & min_tri!=. & min_tri<=111

replace min_TRI=min_tri if min_tri<=111

drop junk* min_tri*

*Definition of Stable subject: stationary = 1.

gen     stationary=1 if (Treatment==1|Treatment==4|Treatment==6) 				& Role==1 & (((min_OUT_0!=. | min_IN_0!=.) & Type==0) | ((min_OUT_1!=. | min_IN_1!=.) & Type==1))
replace stationary=0 if (Treatment==1|Treatment==4|Treatment==6) 				& Role==1 & (((min_OUT_0==. & min_IN_0==.) & Type==0) | ((min_OUT_1==. & min_IN_1==.) & Type==1))

replace stationary=1 if (Treatment==2|Treatment==3|Treatment==5|Treatment==7|Treatment==8) 	& Role==1 & ((min_OUT_0!=. & min_OUT_1!=.) |(min_OUT_0!=. & min_IN_1!=.) |(min_IN_0!=. & min_OUT_1!=.)  |(min_IN_0!=. & min_IN_1!=.))
replace stationary=0 if (Treatment==2|Treatment==3|Treatment==5|Treatment==7|Treatment==8) 	& Role==1 & ((min_OUT_0==. & min_IN_0==.) | (min_OUT_1==. & min_IN_1==.))

replace stationary=1 if Role==2 & (min_SQ!=. | min_TRI!=.)
replace stationary=0 if Role==2 & (min_SQ==. & min_TRI==.)

*Stationary Period is the first period where the subject is classified as a stable subject.

gen stationary_Period=.

gen     junk_0=min_OUT_0 if min_OUT_0!=. & (Treatment==2|Treatment==3|Treatment==5|Treatment==7|Treatment==8) & Role==1
replace junk_0=min_IN_0  if min_IN_0!=.  & (Treatment==2|Treatment==3|Treatment==5|Treatment==7|Treatment==8) & Role==1

gen     junk_1=min_OUT_1 if min_OUT_1!=. & (Treatment==2|Treatment==3|Treatment==5|Treatment==7|Treatment==8) & Role==1
replace junk_1=min_IN_1  if min_IN_1!=.  & (Treatment==2|Treatment==3|Treatment==5|Treatment==7|Treatment==8) & Role==1

egen junk_min= rowmax(junk_0 junk_1) 

foreach i in 0 1 {
replace stationary_Period = min_OUT_`i' if (Treatment==1|Treatment==4|Treatment==6) & Role==1 & Type==`i'  & min_OUT_`i'!=.
replace stationary_Period = min_IN_`i'  if (Treatment==1|Treatment==4|Treatment==6) & Role==1 & Type==`i'  & min_IN_`i'!=.
}
replace stationary_Period = junk_min    if (Treatment==2|Treatment==3|Treatment==5|Treatment==7|Treatment==8) & Role==1 & junk_min!=.
replace stationary_Period = min_SQ      if Role==2 & min_SQ!=.
replace stationary_Period = min_TRI     if Role==2 & min_TRI!=.


*Definition of locked participant. (NotAutom=0)

gen     did_notAutom=1 if Period_Autom==-1  & Period==120
replace did_notAutom=0 if Period_Autom>-1 & Period==120

gen    junk_PeriodAutom=Period_Autom if Period_Autom>-1

bysort id: egen NotAutom=mean(did_notAutom)
bysort id: egen PeriodAutomatic=mean(junk_PeriodAutom)


*Choices in the last 20 periods (proportion that are always In, always Out and mixes)
foreach k in 100 {
sort id

gen junk1Red=action1  	if Type==1 & Role==1  & Period>`k'
gen junkk1Red=1 	  	if Type==1 & Role==1  & Period>`k'
gen junk1Blue=action1 	if Type==0 & Role==1  & Period>`k'
gen junkk1Blue=1 	  	if Type==0 & Role==1  & Period>`k'
gen junk2_Role=action2 	if Role==2            & Period>`k'
gen junkk2_Role=1 	   	if Role==2            & Period>`k' 

by id: egen junk1R=sum(junk1Red)
by id: egen junk1B=sum(junk1Blue)
by id: egen junk2 =sum(junk2_Role)

by id: egen junkk1R=sum(junkk1Red)
by id: egen junkk1B=sum(junkk1Blue)
by id: egen junkk2 =sum(junkk2_Role)

gen act1R_L`k'=round(junk1R/junkk1R,0.01)
gen act1B_L`k'=round(junk1B/junkk1B,0.01)
gen act2_L`k' =round(junk2/junkk2,0.01)

gen     Act1R_L`k'=act1R_L`k' 	if act1R_L`k'<=0.0001 	| act1R_L`k'>=0.9999
replace Act1R_L`k'=2 			if (act1R_L`k'>0.0001 	& act1R_L`k'<0.9999) & Act1R_L`k'==.
gen 	Act1B_L`k'=act1B_L`k' 	if act1B_L`k'<=0.0001 	| act1B_L`k'>=0.9999
replace Act1B_L`k'=2 			if act1B_L`k'>0.0001 	& act1B_L`k'<0.9999  & Act1B_L`k'==.
gen 	Act2_L`k' =act2_L`k'  	if act2_L`k' <=0.0001  	| act2_L`k' >=0.9999
replace Act2_L`k' =2 			if act2_L`k' >0.0001 	& act2_L`k' <0.9999  & Act2_L`k'==.

drop junk*

}


*TABLE 1

*Last 20 Periods
tab Act1R_L100 Treatment if Period==120  & Treatment<=3, col
tab Act1B_L100 Treatment if Period==120  & Treatment<=3, col
tab Act2_L100  Treatment if Period==120  & Treatment<=3 ,col


*S participants
tab IN_1  Treatment if Period==120 & stationary==1 & (Role==1 & (Treatment==2|Treatment==3)| (Role==1 & Type==1 & (Treatment==1))), col
tab IN_0  Treatment if Period==120 & stationary==1 & (Role==1 & (Treatment==2|Treatment==3)| (Role==1 & Type==0 & (Treatment==1))), col
tab SQ    Treatment if Period==120 & stationary==1 & Role==2 , col

*S_L participants
tab action1R Treatment if Period==120 & NotAutom==0 & ((Role==1 & (Treatment==2|Treatment==3))| (Role==1 & Type==1 & (Treatment==1))), col
tab action1B Treatment if Period==120 & NotAutom==0 & ((Role==1 & (Treatment==2|Treatment==3))| (Role==1 & Type==0 & (Treatment==1))), col
tab action2  Treatment if Period==120 & NotAutom==0 & Role==2 , col



*FOOTNOTE 26
iis id
gen 	TreatmentGRGF=1 if Treatment==1
replace TreatmentGRGF=0 if Treatment==2 | Treatment==3
gen 	TreatmentGR=1 if Treatment==2
replace TreatmentGR=0 if Treatment==3
xtreg action2 TreatmentGRGF if Role==2 & Period>100 & Treatment<=2, cluster(Session)


*TABLE 2

xtreg action1  TreatmentGR   if Type==0 & Role==1 & Period>100 & (Treatment==3 |Treatment==2), cluster(Session)
reg   IN_0     TreatmentGR   if ((Treatment==2 | Treatment==3)) & Role==1 & Period==120 & stationary==1, cluster(Session)
reg   action1B TreatmentGR   if ((Treatment==2 | Treatment==3)) & Role==1 & Period==120 & NotAutom==0, cluster(Session)
xtreg action1  TreatmentGRGF if Type==0 & Role==1 & Period>100 & Treatment<=3, cluster(Session)
reg   IN_0     TreatmentGRGF if ((Type==0 & Treatment==1)|(Treatment==2 | Treatment==3)) & Role==1 & Period==120 & stationary==1, cluster(Session)
reg   action1B TreatmentGRGF if ((Type==0 & Treatment==1)|(Treatment==2 | Treatment==3)) & Role==1 & Period==120 & NotAutom==0, cluster(Session)



*FIGURE 3
preserve

keep if Role==1 & Type==0 & Treatment<=2

replace Treatment=2 if Treatment==3

bysort Treatment Period: egen action1_mean=mean(action1)

gen Bin=1 if Period<=5
replace Bin=2 if Period>5 & Period<=10
replace Bin=3 if Period>10 & Period<=15
replace Bin=4 if Period>15 & Period<=20
replace Bin=5 if Period>20 & Period<=25
replace Bin=6 if Period>25 & Period<=30
replace Bin=7 if Period>30 & Period<=35
replace Bin=8 if Period>35 & Period<=40
replace Bin=9 if Period>40 & Period<=45
replace Bin=10 if Period>45 & Period<=50
replace Bin=11 if Period>50 & Period<=55
replace Bin=12 if Period>55 & Period<=60
replace Bin=13 if Period>60 & Period<=65
replace Bin=14 if Period>65 & Period<=70
replace Bin=15 if Period>70 & Period<=75
replace Bin=16 if Period>75 & Period<=80
replace Bin=17 if Period>80 & Period<=85
replace Bin=18 if Period>85 & Period<=90
replace Bin=19 if Period>90 & Period<=95
replace Bin=20 if Period>95 & Period<=100
replace Bin=21 if Period>100 & Period<=105
replace Bin=22 if Period>105 & Period<=110
replace Bin=23 if Period>110 & Period<=115
replace Bin=24 if Period>115 & Period<=120

bysort Treatment Bin: egen action1_mean_bin=mean(action1)

collapse action1_mean action1_mean_bin, by (Treatment Period)

twoway (line action1_mean_bin Period if Treatment==2, lwidth(medthick) lpattern(dot)) ///
	   (line action1_mean Period if Treatment==1, lwidth(medthick) lpattern(solid)),  ///
	   xlabel(0(20)120) ytitle("Fraction of times player 1Bs go in") ///
	   legend(on cols(1) order(1 "GR" 2 "GF") ring(0) pos(4)) ylabel(0(0.2)0.8)   ///
	   legend(symplacement(default) nobox rowgap(tiny) colgap(minuscule) keygap(minuscule) region(margin(small) fcolor(none) lcolor(none))) ///
	   graphregion(color(white)) bgcolor(white) scheme(s2mono)  ///
  	   graphregion(color(white)) plotregion(fcolor(white))
	   
restore	   


*FIGURE 4
*GF
preserve

keep if Treatment==1 & Role==1 & Type==0 & stationary==1
keep Period id IN_0 OUT_0
collapse (sum) IN_0 OUT_0, by(Period)

replace IN_0=100*IN_0/43
replace OUT_0=100*OUT_0/43
gen NONStat=100-IN_0-OUT_0 if Period>110


twoway (connected IN Period,  msymbol(none) lpattern(solid) lcolor(blue) connect(J) lwidth(thick) ) ///
	   (connected OUT Period, msymbol(none) lpattern(dash) lcolor(red) connect(J) lwidth(thick) ) ///
	   /*(connected NONStat Period, msymbol(none) lpattern(dash_dot) lcolor(black) connect(J) lwidth(thick) )*/, ///
	   ytitle("Percentage of participants") ylabel(0(10)80, nogrid) xtitle(Period) ///
	   xlabel(0(10)120, valuelabel) legend(on cols(1) order(1 "Select In" 2 "Select Out") ring(0) pos(11)) ///
  	   legend(region(lcolor(none))) legend(size(medlarge)) ///
       legend(symplacement(default) nobox rowgap(tiny) colgap(minuscule) keygap(minuscule) region(margin(small) fcolor(none) lcolor(none))) ///
       graphregion(color(white)) bgcolor(white) scheme(s2mono)  ///
       graphregion(color(white)) plotregion(fcolor(white)) legend(off) 
   
restore

*GR
preserve

keep if Treatment==2 & Role==1 & stationary==1
keep Period id IN_0 OUT_0
collapse (sum) IN_0 OUT_0, by(Period)

replace IN_0=100*IN_0/44
replace OUT_0=100*OUT_0/44

twoway (connected IN Period,  msymbol(none) lpattern(solid) lcolor(blue) connect(J) lwidth(thick) ) ///
	   (connected OUT Period, msymbol(none) lpattern(dash) lcolor(red) connect(J) lwidth(thick) ), ///
	   ytitle("Percentage of participants") ylabel(0(10)80, nogrid) xtitle(Period) ///
	   xlabel(0(10)120, valuelabel) legend(on cols(1) order(1 "Select In" 2 "Select Out") ring(0) pos(11)) ///
  	   legend(region(lcolor(none))) legend(size(medlarge)) ///
       legend(symplacement(default) nobox rowgap(tiny) colgap(minuscule) keygap(minuscule) region(margin(small) fcolor(none) lcolor(none))) ///
       graphregion(color(white)) bgcolor(white) scheme(s2mono)  ///
       graphregion(color(white)) plotregion(fcolor(white)) /*legend(off)*/ 

restore


*FIGURE 5
preserve

keep if Role==2
replace Treatment=2 if Treatment==3

bysort Treatment Period: egen action2_mean=mean(action2)
collapse action2_mean, by (Treatment Period)
twoway (line action2_mean Period if Treatment==2, lwidth(medthick) lpattern(dot)) ///
	   (line action2_mean Period if Treatment==1, lwidth(medthick) lpattern(solid)),  ///
	   xlabel(0(20)120) ytitle("Fraction of Player 2s selecting Squares") ///
	   legend(on cols(1) order(1 "GR" 2 "GF") ring(0) pos(4))   ///
	   legend(symplacement(default) nobox rowgap(tiny) colgap(minuscule) keygap(minuscule) region(margin(small) fcolor(none) lcolor(none))) ///
	   graphregion(color(white)) bgcolor(white) scheme(s2mono)  ///
  	   graphregion(color(white)) plotregion(fcolor(white))
	   
restore	   
*/

*TABLE 3


*Constructs variables of observed data by player 1 and observed triangles and squares
gen    junk_Observed=1 if action2_obs!=-1 & Treatment>=6 & Type==0 & Period<=PeriodAutomatic
bysort id: egen junk_Observed2=sum(junk_Observed)

gen    junk_Triang=1 if action2_obs==0 & Treatment>=6 & Type==0 & Period<=PeriodAutomatic
bysort id: egen junk_Triang2=sum(junk_Triang)


gen observed=(OtherNTriang+OtherNSquare)

gen     junk_observed=observed       if Period==PeriodAutomatic & NotAutom==0 & Treatment<6
replace junk_observed=junk_Observed2 if Period==PeriodAutomatic & NotAutom==0 & Treatment>=6
bysort id: egen observed_stationary=mean(junk_observed)

gen     junk_triang=OtherNTriang   if Period==PeriodAutomatic & NotAutom==0 & Treatment<6
replace junk_triang=junk_Triang2 if Period==PeriodAutomatic & NotAutom==0 & Treatment>=6
bysort id: egen triang_stationary=mean(junk_triang)


*Table: t^S
sum min_Stat_0 if (Treatment==2|Treatment==3) & Role==1 & Period==120 & IN_0==1,d
sum min_Stat_0 if Treatment==1 & Type==0 & Role==1 & Period==120 & IN_0==1,d
sum min_Stat_0 if (Treatment==2|Treatment==3) & Role==1 & Period==120 & OUT_0==1,d
sum min_Stat_0 if Treatment==1 & Type==0 & Role==1 & Period==120 & OUT_0==1,d
*Table: t^S_L and others
foreach i in PeriodAutomatic  observed_stationary triang_stationary {
sum `i' if (Treatment==2|Treatment==3) & Role==1 & Period==120 & action1B==1,d
sum `i' if Treatment==1 & Type==0 & Role==1 & Period==120 & action1B==1,d
sum `i' if (Treatment==2|Treatment==3) & Role==1 & Period==120 & action1B==0,d
sum `i' if Treatment==1 & Type==0 & Role==1 & Period==120 & action1B==0,d
}


*DISCUSSION WITH RESPECT TO INITIAL AND FINAL OBSERVED TRIANGLES (in text).

*Constructs initial measure of observed triangles and final measure of observed triangles

gen OtherNTotal=OtherNTriang+OtherNSquare

gen First20=Period            if OtherNTotal==20
gen junkLast20=OtherNTotal-20 if Period==PeriodAutom-1
by id: egen JunkLast20=mean(junkLast20)

gen junkLast20per=Period       if OtherNTotal==JunkLast20  
gen junkLast20Tri=OtherNTriang if Period==junkLast20per
gen junkLast20Sq =OtherNSquare if Period==junkLast20per
gen junkLast20Trilast=OtherNTriang if Period==PeriodAutom-1
gen junkLast20Sqlast =OtherNSquare if Period==PeriodAutom-1

by id: egen JunkLast20Tri=mean(junkLast20Tri) 
by id: egen JunkLast20Sq=mean(junkLast20Sq) 
by id: egen JunkLast20Trilast=mean(junkLast20Trilast) 
by id: egen JunkLast20Sqlast=mean(junkLast20Sqlast) 

gen Last20Sq=JunkLast20Sqlast-JunkLast20Sq
gen Last20Tri=JunkLast20Trilast-JunkLast20Tri
gen Last20ObsTot=JunkLast20Sqlast+JunkLast20Trilast


drop junk*

gen junkFirst20Sq=OtherNSquare  if Period==First20
gen junkFirst20Tri=OtherNTriang if Period==First20

by id: egen First20Sq=mean(junkFirst20Sq)
by id: egen First20Tri=mean(junkFirst20Tri)

gen freqSqF20=First20Sq/20
gen freqSqL20=Last20Sq/20

gen     TriStatus=1 if (First20Tri/2>=Last20Tri)
replace TriStatus=-1 if (Last20Tri/2>=First20Tri)
replace TriStatus=0 if TriStatus==.

drop junk*

*Averages reported in the text:

sum First20Tri if (Treatment==2|Treatment==3) & Role==1 & Period==120 & observed_stationary>40 & (action1B==1)
sum Last20Tri if (Treatment==2|Treatment==3) & Role==1 & Period==120 & observed_stationary>40 & (action1B==1)

sum First20Tri if (Treatment==1) & Role==1 & Period==120 & observed_stationary>40 & (action1B==1), d
sum Last20Tri if (Treatment==1) & Role==1 & Period==120 & observed_stationary>40 & (action1B==1), d

*Testing for significance
preserve
keep if action1B!=-1 & Period==120 & Role==1 & observed_stationary>40
keep id First20Tri Last20Tri Treatment

ren First20Tri Tri0
ren Last20Tri Tri1

reshape long Tri,i(id) j(Within)

iis id
xtreg Tri Within if Treatment==2|Treatment==3
xtreg Tri Within if Treatment==1

restore

