(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     26199,        598]
NotebookOptionsPosition[     24442,        564]
NotebookOutlinePosition[     24812,        580]
CellTagsIndexPosition[     24769,        577]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"REPLICATION", " ", "OF", " ", "FIGURE", " ", "3", "a"}], "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Clear", "[", 
    RowBox[{"ro", ",", "sigma", ",", "eta"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Distribution", " ", "of", " ", "lying", " ", "costs"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F", "[", 
     RowBox[{"x_", ",", "sigma_"}], "]"}], ":=", 
    RowBox[{"CDF", "[", 
     RowBox[{
      RowBox[{"TruncatedDistribution", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "Infinity"}], "}"}], ",", 
        RowBox[{"NormalDistribution", "[", 
         RowBox[{"0", ",", "sigma"}], "]"}]}], "]"}], ",", "x"}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Highest", " ", "report", " ", 
     RowBox[{"(", 
      RowBox[{"see", " ", 
       RowBox[{"ReadMe", ".", "pdf"}]}], ")"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"K", ":=", "9"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"x_L", " ", "function"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xL", "[", "ro_", "]"}], ":=", 
     RowBox[{"Ceiling", "[", "ro", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Theta", " ", "function"}], ",", " ", 
     RowBox[{"see", " ", "equation", " ", 
      RowBox[{"(", "27", ")"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"theta", "[", 
     RowBox[{"ro_", ",", "eta_", ",", "sigma_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"F", "[", 
        RowBox[{
         RowBox[{"ro", "-", "y"}], ",", "sigma"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "0", ",", 
         RowBox[{
          RowBox[{"xL", "[", "ro", "]"}], "-", "1"}]}], "}"}]}], "]"}], "-", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "ro"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"eta", "-", "x", "+", "ro"}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"xL", "[", "ro", "]"}], ",", "K"}], "}"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "Probability", " ", "of", " ", "observing", " ", "report", " ", "x"}], 
     ",", " ", 
     RowBox[{"see", " ", "Proposition", " ", "2"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ProbRep", "[", 
      RowBox[{"x_", ",", "ro_", ",", "eta_", ",", "sigma_"}], "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"x", "\[GreaterEqual]", 
        RowBox[{"xL", "[", "ro", "]"}]}], ",", 
       RowBox[{"eta", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"K", "+", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"eta", "-", "x", "+", "ro"}], ")"}]}], ")"}]}], ",", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"K", "+", "1"}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"F", "[", 
           RowBox[{
            RowBox[{"ro", "-", "x"}], ",", "sigma"}], "]"}]}], ")"}]}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "Mean", " ", "squared", " ", "error", " ", "with", " ", "respect", " ", 
      "to", " ", "the", " ", "experimental", " ", "data", " ", "in", " ", 
      "Gneezy"}], ",", " ", 
     RowBox[{"Kajackaite", " ", "and", " ", "Sobel", " ", "2018"}], ",", " ", 
     RowBox[{"unobserved", " ", "treatment"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MeanSEforGKSa", "[", 
      RowBox[{"ro_", ",", "eta_", ",", "sigma_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRep", "[", 
             RowBox[{"0", ",", "ro", ",", "eta", ",", "sigma"}], "]"}], "*", 
            "100"}], "-", "1.94"}], ")"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRep", "[", 
             RowBox[{"1", ",", "ro", ",", "eta", ",", "sigma"}], "]"}], "*", 
            "100"}], "-", "3.88"}], ")"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRep", "[", 
             RowBox[{"2", ",", "ro", ",", "eta", ",", "sigma"}], "]"}], "*", 
            "100"}], "-", "2.91"}], ")"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRep", "[", 
             RowBox[{"3", ",", "ro", ",", "eta", ",", "sigma"}], "]"}], "*", 
            "100"}], "-", "7.77"}], ")"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRep", "[", 
             RowBox[{"4", ",", "ro", ",", "eta", ",", "sigma"}], "]"}], "*", 
            "100"}], "-", "5.83"}], ")"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRep", "[", 
             RowBox[{"5", ",", "ro", ",", "eta", ",", "sigma"}], "]"}], "*", 
            "100"}], "-", "4.85"}], ")"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRep", "[", 
             RowBox[{"6", ",", "ro", ",", "eta", ",", "sigma"}], "]"}], "*", 
            "100"}], "-", "5.83"}], ")"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRep", "[", 
             RowBox[{"7", ",", "ro", ",", "eta", ",", "sigma"}], "]"}], "*", 
            "100"}], "-", "7.77"}], ")"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRep", "[", 
             RowBox[{"8", ",", "ro", ",", "eta", ",", "sigma"}], "]"}], "*", 
            "100"}], "-", "22.33"}], ")"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRep", "[", 
             RowBox[{"9", ",", "ro", ",", "eta", ",", "sigma"}], "]"}], "*", 
            "100"}], "-", "36.89"}], ")"}], "^", "2"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"K", "+", "1"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Minimizing", " ", "the", " ", "mean", " ", "squared", " ", "error", " ", 
     "with", " ", "respect", " ", "to", " ", "eta", " ", "and", " ", "sigma", 
     " ", "subject", " ", "to", " ", "equilibrium", " ", "conditions"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"NMinimize", "[", 
    RowBox[{
     RowBox[{"{", " ", 
      RowBox[{
       RowBox[{"MeanSEforGKSa", "[", 
        RowBox[{"ro", ",", "eta", ",", "sigma"}], "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"theta", "[", 
          RowBox[{"ro", ",", "eta", ",", "sigma"}], "]"}], "\[Equal]", "0"}], 
        "  ", "&&", " ", 
        RowBox[{
         RowBox[{"Max", "[", 
          RowBox[{"0", ",", 
           RowBox[{"K", "-", "eta"}]}], "]"}], "<", "ro", "<", "K"}], "   ", "&&",
         " ", 
        RowBox[{"sigma", ">", "0"}], "  ", "&&", " ", 
        RowBox[{"eta", ">", "0"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"eta", ",", "sigma", ",", "ro"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.6653218905473633`*^9, 3.665322139759886*^9}, {
   3.6653221923859386`*^9, 3.6653223420429335`*^9}, {3.6653224318717318`*^9, 
   3.665322439081876*^9}, {3.6653225492410793`*^9, 3.665322566823431*^9}, {
   3.6653228446309905`*^9, 3.665322856452227*^9}, {3.6653229045491896`*^9, 
   3.665322911129321*^9}, {3.665322972730554*^9, 3.665323003834178*^9}, 
   3.6653230545081916`*^9, {3.6653233051012077`*^9, 3.6653233171284504`*^9}, {
   3.6653233587722836`*^9, 3.665323471444538*^9}, {3.665323555598222*^9, 
   3.665323673180974*^9}, {3.6653237116957445`*^9, 3.665323711755746*^9}, {
   3.665323753108573*^9, 3.665323759058692*^9}, {3.665377462360238*^9, 
   3.6653774794465294`*^9}, {3.6653776312023864`*^9, 
   3.6653776397899446`*^9}, {3.6653776759243307`*^9, 
   3.6653777443114915`*^9}, {3.665378141798388*^9, 3.665378222400388*^9}, {
   3.6653783273953876`*^9, 3.665378354386388*^9}, {3.6653783933073883`*^9, 
   3.665378448451388*^9}, {3.665378480010388*^9, 3.665378484632388*^9}, {
   3.665380030084114*^9, 3.665380082731315*^9}, {3.6653801250756083`*^9, 
   3.6653801405319695`*^9}, {3.6653801810509644`*^9, 
   3.6653801835837107`*^9}, {3.665381106544634*^9, 3.6653811099599752`*^9}, {
   3.665381864911468*^9, 3.6653818815171285`*^9}, {3.6653831080268097`*^9, 
   3.66538315496481*^9}, {3.66538319977281*^9, 3.66538319995581*^9}, {
   3.6653834216101365`*^9, 3.6653834485828333`*^9}, {3.665383487388714*^9, 
   3.6653834879157662`*^9}, {3.7269152108855906`*^9, 3.7269152734052167`*^9}, 
   3.7269154338478255`*^9, {3.726915495230441*^9, 3.72691554193091*^9}, {
   3.7571418437996626`*^9, 3.7571418453930397`*^9}, {3.757143098524267*^9, 
   3.757143102400547*^9}, {3.757143143075894*^9, 3.7571431722505655`*^9}, {
   3.757162414169341*^9, 3.757162636298018*^9}, {3.7571627657332444`*^9, 
   3.757162801683863*^9}, {3.757162859924965*^9, 3.7571628751046324`*^9}, {
   3.7571629091905046`*^9, 3.7571630511895733`*^9}, {3.7571630894856987`*^9, 
   3.757163128092335*^9}, {3.7571729628756495`*^9, 3.757172975582226*^9}, {
   3.757173125741542*^9, 3.7571731890252004`*^9}, {3.7571732330956135`*^9, 
   3.7571732845597677`*^9}, {3.757173315518761*^9, 3.7571733414899263`*^9}, {
   3.7571733916560197`*^9, 3.7571734382667556`*^9}, {3.757173473505392*^9, 
   3.7571734736617594`*^9}, {3.757176257456459*^9, 3.7571763519806366`*^9}, {
   3.757176469796834*^9, 3.7571767286633067`*^9}, {3.7571767843903694`*^9, 
   3.757176792609517*^9}, {3.75717689194084*^9, 3.757176966243521*^9}, {
   3.7571772873305397`*^9, 3.7571773276123066`*^9}, {3.75717737211786*^9, 
   3.7571774126881323`*^9}, 3.757177450617428*^9, {3.757177495179057*^9, 
   3.7571775654239745`*^9}, {3.7571778004932604`*^9, 
   3.7571778112767396`*^9}, {3.7571778608146286`*^9, 3.7571779479774895`*^9}, 
   3.7571779826864576`*^9, {3.757180185774725*^9, 3.757180225464513*^9}, {
   3.7571802730797462`*^9, 3.7571803420585346`*^9}, {3.757180589550248*^9, 
   3.757180625012718*^9}, 3.7571807723890305`*^9, {3.7571808655769444`*^9, 
   3.757180918225562*^9}, {3.7571809508652897`*^9, 3.757180978577965*^9}, {
   3.757228295186898*^9, 3.757228295288265*^9}, {3.757229519868849*^9, 
   3.757229549967732*^9}, {3.7572296374036164`*^9, 3.7572296402026987`*^9}, {
   3.757229683896452*^9, 3.7572297498898673`*^9}, 3.757229799203117*^9, {
   3.75723006807353*^9, 3.757230094787221*^9}, {3.757233286292882*^9, 
   3.757233302765727*^9}, {3.757233416124798*^9, 3.757233473579174*^9}, {
   3.7572340390290174`*^9, 3.757234088778042*^9}, {3.757234285639983*^9, 
   3.7572343036066685`*^9}, 3.757234412640359*^9, {3.7572344442575507`*^9, 
   3.757234453754656*^9}, {3.757234820352021*^9, 3.75723501060151*^9}, 
   3.7572350732985363`*^9, {3.7572352060461617`*^9, 3.7572352936930313`*^9}, {
   3.757235375310073*^9, 3.7572354879859223`*^9}, {3.7572359505881014`*^9, 
   3.7572359716373005`*^9}, {3.75724326298242*^9, 3.757243292874465*^9}, {
   3.7574271136210885`*^9, 3.7574271509211707`*^9}, {3.757427216686474*^9, 
   3.7574272829991426`*^9}, {3.7574273195314045`*^9, 
   3.7574273231401615`*^9}, {3.7574274786158543`*^9, 
   3.7574274807803307`*^9}, {3.7574279934433765`*^9, 
   3.7574280482010336`*^9}, {3.757428112683385*^9, 3.757428158565394*^9}, {
   3.757523942886593*^9, 3.7575239439799023`*^9}, {3.757681384846794*^9, 
   3.7576814617756815`*^9}, 3.7577014486419597`*^9, {3.7577025275032725`*^9, 
   3.7577025375203004`*^9}, {3.757702614509473*^9, 3.757702621667048*^9}, {
   3.757703371070364*^9, 3.7577034355085073`*^9}, {3.7577401731093893`*^9, 
   3.7577401738570595`*^9}, {3.757740255483855*^9, 3.7577403992169113`*^9}, {
   3.7577606370385838`*^9, 3.7577606627704782`*^9}, {3.7578348794779563`*^9, 
   3.757834881290004*^9}, 3.757834952452211*^9, {3.7578550961176095`*^9, 
   3.75785509655554*^9}, {3.757912802927619*^9, 3.7579128035212336`*^9}, 
   3.757913266894574*^9},ExpressionUUID->"8875ef62-0b15-4d8f-85fc-\
530c2e3af4c0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6.644109383248933`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"eta", "\[Rule]", "3.1797197408300706`"}], ",", 
     RowBox[{"sigma", "\[Rule]", "4.98422470963645`"}], ",", 
     RowBox[{"ro", "\[Rule]", "6.677094735103667`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.7577404444556108`*^9, 3.757760650043191*^9, 
  3.7578328665120983`*^9, 3.7579126642544575`*^9, 3.7579132744105096`*^9, 
  3.757913329332477*^9, 
  3.7579134136373825`*^9},ExpressionUUID->"3e665118-49aa-4548-be9f-\
830b8afd4bb2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Substituting", " ", "the", " ", "obtained", " ", "parameter", " ", 
    "values"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"K", "=", "9"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eta", "=", "3.17972"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sigma", "=", "4.98422"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ro", "=", "6.67709"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Predicted", " ", "value", " ", "of", " ", "xL", " ", "in", " ", "terms", 
     " ", "of", " ", "experimental", " ", "reports"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Predicted value of xL (in terms of experimental reports) is \>\"", 
     ",", 
     RowBox[{
      RowBox[{"xL", "[", "ro", "]"}], "+", "1"}], ",", "\"\<.\>\""}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Calculating", " ", "the", " ", "resulting", " ", "theoretical", " ", 
     "reporting", " ", "frequencies"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\"\<Predicted reporting frequencies:\>\"", "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"x", "=", "0"}], ",", 
     RowBox[{"x", "\[LessEqual]", "K"}], ",", 
     RowBox[{"x", "++"}], ",", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<x=\>\"", ",", 
       RowBox[{"x", "+", "1"}], ",", "\"\<: \>\"", ",", 
       RowBox[{"ProbRep", "[", 
        RowBox[{"x", ",", "ro", ",", "eta", ",", "sigma"}], "]"}]}], "]"}]}], 
    "]"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.757175960644486*^9, 3.757175969861082*^9}, {
   3.7571760047831745`*^9, 3.757176067687707*^9}, {3.7571761255251875`*^9, 
   3.7571761325435543`*^9}, {3.757177999174612*^9, 3.7571780556748457`*^9}, 
   3.7571811199408092`*^9, {3.7572335425948915`*^9, 3.7572335765610037`*^9}, {
   3.7572336507671895`*^9, 3.757233650923356*^9}, {3.7572337236561813`*^9, 
   3.7572337472649426`*^9}, {3.75723382238162*^9, 3.7572338340098124`*^9}, {
   3.7572344728477864`*^9, 3.7572345101247945`*^9}, {3.7572355271712418`*^9, 
   3.757235542829871*^9}, {3.757427369376009*^9, 3.7574274374622283`*^9}, {
   3.7576815650668306`*^9, 3.757681574027092*^9}, 3.757701732741351*^9, 
   3.7577034426065817`*^9, {3.757740471004182*^9, 3.757740502246937*^9}, {
   3.75774706341238*^9, 3.7577470688990383`*^9}, {3.757760801938689*^9, 
   3.757760808301343*^9}, 3.757835073714427*^9, {3.7579126380950336`*^9, 
   3.7579126513308887`*^9}, {3.7579126841147003`*^9, 
   3.7579126935530376`*^9}},ExpressionUUID->"9da8ce06-1e42-4383-89bd-\
7701615dadb5"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Predicted value of xL (in terms of experimental reports) is \"\
\>", "\[InvisibleSpace]", "8", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Predicted value of xL (in terms of experimental reports) is ", 8, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7572338348219686`*^9, 3.757234512407129*^9, 3.7572355438450055`*^9, 
   3.7574274382901864`*^9, 3.7577405030560627`*^9, 3.7577470695891123`*^9, 
   3.757760810887686*^9, 3.7578328765754595`*^9, 3.7578329349279027`*^9, {
   3.7579126520026016`*^9, 3.7579126940058665`*^9}, 3.7579133365358105`*^9, 
   3.7579134178949137`*^9},ExpressionUUID->"2cff7a20-1f60-4318-895e-\
097f9e70634c"],

Cell[BoxData["\<\"Predicted reporting frequencies:\"\>"], "Print",
 CellChangeTimes->{
  3.7572338348219686`*^9, 3.757234512407129*^9, 3.7572355438450055`*^9, 
   3.7574274382901864`*^9, 3.7577405030560627`*^9, 3.7577470695891123`*^9, 
   3.757760810887686*^9, 3.7578328765754595`*^9, 3.7578329349279027`*^9, {
   3.7579126520026016`*^9, 3.7579126940058665`*^9}, 3.7579133365358105`*^9, 
   3.7579134178949137`*^9},ExpressionUUID->"99d8e5b3-2701-47ab-bfe5-\
d716a0156507"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.01803604864044599`"}],
  SequenceForm["x=", 1, ": ", 0.01803604864044599],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7572338348219686`*^9, 3.757234512407129*^9, 3.7572355438450055`*^9, 
   3.7574274382901864`*^9, 3.7577405030560627`*^9, 3.7577470695891123`*^9, 
   3.757760810887686*^9, 3.7578328765754595`*^9, 3.7578329349279027`*^9, {
   3.7579126520026016`*^9, 3.7579126940058665`*^9}, 3.7579133365358105`*^9, 
   3.7579134178949137`*^9},ExpressionUUID->"cdb82a17-c3cb-4fc7-a3b8-\
a19b402dabbb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.02546978471095387`"}],
  SequenceForm["x=", 2, ": ", 0.02546978471095387],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7572338348219686`*^9, 3.757234512407129*^9, 3.7572355438450055`*^9, 
   3.7574274382901864`*^9, 3.7577405030560627`*^9, 3.7577470695891123`*^9, 
   3.757760810887686*^9, 3.7578328765754595`*^9, 3.7578329349279027`*^9, {
   3.7579126520026016`*^9, 3.7579126940058665`*^9}, 3.7579133365358105`*^9, 
   3.7579134178949137`*^9},ExpressionUUID->"fe13d1e4-1eca-4fd6-b56e-\
7541d777dd79"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.03480494039431933`"}],
  SequenceForm["x=", 3, ": ", 0.03480494039431933],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7572338348219686`*^9, 3.757234512407129*^9, 3.7572355438450055`*^9, 
   3.7574274382901864`*^9, 3.7577405030560627`*^9, 3.7577470695891123`*^9, 
   3.757760810887686*^9, 3.7578328765754595`*^9, 3.7578329349279027`*^9, {
   3.7579126520026016`*^9, 3.7579126940058665`*^9}, 3.7579133365358105`*^9, 
   3.7579134178949137`*^9},ExpressionUUID->"7c3133c1-5624-4d83-a161-\
5f8541f08841"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.04606686143164335`"}],
  SequenceForm["x=", 4, ": ", 0.04606686143164335],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7572338348219686`*^9, 3.757234512407129*^9, 3.7572355438450055`*^9, 
   3.7574274382901864`*^9, 3.7577405030560627`*^9, 3.7577470695891123`*^9, 
   3.757760810887686*^9, 3.7578328765754595`*^9, 3.7578329349279027`*^9, {
   3.7579126520026016`*^9, 3.7579126940058665`*^9}, 3.7579133365358105`*^9, 
   3.7579134178949137`*^9},ExpressionUUID->"08ce732b-4af2-451c-8342-\
0e302341dc9a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.05911894724320722`"}],
  SequenceForm["x=", 5, ": ", 0.05911894724320722],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7572338348219686`*^9, 3.757234512407129*^9, 3.7572355438450055`*^9, 
   3.7574274382901864`*^9, 3.7577405030560627`*^9, 3.7577470695891123`*^9, 
   3.757760810887686*^9, 3.7578328765754595`*^9, 3.7578329349279027`*^9, {
   3.7579126520026016`*^9, 3.7579126940058665`*^9}, 3.7579133365358105`*^9, 
   3.7579134179104996`*^9},ExpressionUUID->"6dc7b07d-8484-4272-8be1-\
daf5bef73265"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.07365089832323789`"}],
  SequenceForm["x=", 6, ": ", 0.07365089832323789],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7572338348219686`*^9, 3.757234512407129*^9, 3.7572355438450055`*^9, 
   3.7574274382901864`*^9, 3.7577405030560627`*^9, 3.7577470695891123`*^9, 
   3.757760810887686*^9, 3.7578328765754595`*^9, 3.7578329349279027`*^9, {
   3.7579126520026016`*^9, 3.7579126940058665`*^9}, 3.7579133365358105`*^9, 
   3.7579134179104996`*^9},ExpressionUUID->"89a448e7-cd6d-4d22-acf0-\
51090b05e6d4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.08919424464447963`"}],
  SequenceForm["x=", 7, ": ", 0.08919424464447963],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7572338348219686`*^9, 3.757234512407129*^9, 3.7572355438450055`*^9, 
   3.7574274382901864`*^9, 3.7577405030560627`*^9, 3.7577470695891123`*^9, 
   3.757760810887686*^9, 3.7578328765754595`*^9, 3.7578329349279027`*^9, {
   3.7579126520026016`*^9, 3.7579126940058665`*^9}, 3.7579133365358105`*^9, 
   3.7579134179104996`*^9},ExpressionUUID->"bc805a87-0afe-4c68-b439-\
c41e4a73d975"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.11130316681893442`"}],
  SequenceForm["x=", 8, ": ", 0.11130316681893442`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7572338348219686`*^9, 3.757234512407129*^9, 3.7572355438450055`*^9, 
   3.7574274382901864`*^9, 3.7577405030560627`*^9, 3.7577470695891123`*^9, 
   3.757760810887686*^9, 3.7578328765754595`*^9, 3.7578329349279027`*^9, {
   3.7579126520026016`*^9, 3.7579126940058665`*^9}, 3.7579133365358105`*^9, 
   3.7579134179104996`*^9},ExpressionUUID->"ca007711-0732-4210-900e-\
27841d4c80e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.17124638492899116`"}],
  SequenceForm["x=", 9, ": ", 0.17124638492899116`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7572338348219686`*^9, 3.757234512407129*^9, 3.7572355438450055`*^9, 
   3.7574274382901864`*^9, 3.7577405030560627`*^9, 3.7577470695891123`*^9, 
   3.757760810887686*^9, 3.7578328765754595`*^9, 3.7578329349279027`*^9, {
   3.7579126520026016`*^9, 3.7579126940058665`*^9}, 3.7579133365358105`*^9, 
   3.7579134179104996`*^9},ExpressionUUID->"4362e741-b30f-4fcd-9528-\
8dc362b24344"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.371111448279082`"}],
  SequenceForm["x=", 10, ": ", 0.371111448279082],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7572338348219686`*^9, 3.757234512407129*^9, 3.7572355438450055`*^9, 
   3.7574274382901864`*^9, 3.7577405030560627`*^9, 3.7577470695891123`*^9, 
   3.757760810887686*^9, 3.7578328765754595`*^9, 3.7578329349279027`*^9, {
   3.7579126520026016`*^9, 3.7579126940058665`*^9}, 3.7579133365358105`*^9, 
   3.7579134179104996`*^9},ExpressionUUID->"a60a3d78-dc1a-41ba-889b-\
126d7d01a246"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1646, 944},
WindowMargins->{{Automatic, 1046}, {352, Automatic}},
Magnification->2.,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 12669, 283, 1552, "Input",ExpressionUUID->"8875ef62-0b15-4d8f-85fc-530c2e3af4c0"],
Cell[13252, 307, 556, 13, 90, "Output",ExpressionUUID->"3e665118-49aa-4548-be9f-830b8afd4bb2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13845, 325, 2723, 59, 611, "Input",ExpressionUUID->"9da8ce06-1e42-4383-89bd-7701615dadb5"],
Cell[CellGroupData[{
Cell[16593, 388, 706, 13, 44, "Print",ExpressionUUID->"2cff7a20-1f60-4318-895e-097f9e70634c"],
Cell[17302, 403, 472, 7, 44, "Print",ExpressionUUID->"99d8e5b3-2701-47ab-bfe5-d716a0156507"],
Cell[17777, 412, 661, 13, 44, "Print",ExpressionUUID->"cdb82a17-c3cb-4fc7-a3b8-a19b402dabbb"],
Cell[18441, 427, 661, 13, 44, "Print",ExpressionUUID->"fe13d1e4-1eca-4fd6-b56e-7541d777dd79"],
Cell[19105, 442, 661, 13, 44, "Print",ExpressionUUID->"7c3133c1-5624-4d83-a161-5f8541f08841"],
Cell[19769, 457, 661, 13, 44, "Print",ExpressionUUID->"08ce732b-4af2-451c-8342-0e302341dc9a"],
Cell[20433, 472, 661, 13, 44, "Print",ExpressionUUID->"6dc7b07d-8484-4272-8be1-daf5bef73265"],
Cell[21097, 487, 661, 13, 44, "Print",ExpressionUUID->"89a448e7-cd6d-4d22-acf0-51090b05e6d4"],
Cell[21761, 502, 661, 13, 44, "Print",ExpressionUUID->"bc805a87-0afe-4c68-b439-c41e4a73d975"],
Cell[22425, 517, 662, 13, 44, "Print",ExpressionUUID->"ca007711-0732-4210-900e-27841d4c80e6"],
Cell[23090, 532, 662, 13, 44, "Print",ExpressionUUID->"4362e741-b30f-4fcd-9528-8dc362b24344"],
Cell[23755, 547, 659, 13, 44, "Print",ExpressionUUID->"a60a3d78-dc1a-41ba-889b-126d7d01a246"]
}, Open  ]]
}, Open  ]]
}
]
*)

