(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     32317,        734]
NotebookOptionsPosition[     28695,        682]
NotebookOutlinePosition[     29066,        698]
CellTagsIndexPosition[     29023,        695]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"REPLICATION", " ", "OF", " ", "FIGURE", " ", "4", "a"}], "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Clear", "[", 
    RowBox[{"ro", ",", "sigma", ",", "eta"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Distribution", " ", "of", " ", "lying", " ", "costs"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F", "[", 
     RowBox[{"x_", ",", "sigma_"}], "]"}], ":=", 
    RowBox[{"CDF", "[", 
     RowBox[{
      RowBox[{"TruncatedDistribution", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "Infinity"}], "}"}], ",", 
        RowBox[{"NormalDistribution", "[", 
         RowBox[{"0", ",", "sigma"}], "]"}]}], "]"}], ",", "x"}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Highest", " ", "report", " ", 
     RowBox[{"(", 
      RowBox[{"see", " ", 
       RowBox[{"Readme", ".", "pdf"}]}], ")"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"K", ":=", "9"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "Parameter", " ", "values", " ", "calibrated", " ", "to", " ", "the", 
      " ", "data", " ", "in", " ", "Gneezy"}], ",", 
     RowBox[{"Kajackaite", " ", "and", " ", "Sobel", " ", "2018"}], ",", " ", 
     RowBox[{"observed", " ", "treatment"}], ",", " ", 
     RowBox[{"see", " ", 
      RowBox[{"ReplicationFig3b", ".", "nb"}]}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eta", "=", "2.45374"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sigma", "=", "10.1827"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ro", "=", "7.37232"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"x_L", " ", "function"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xL", "[", "ro_", "]"}], ":=", 
     RowBox[{"Ceiling", "[", "ro", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "Probability", " ", "of", " ", "choosing", " ", "report", " ", "x", " ", 
      "by", " ", "lying", " ", "agents"}], ",", " ", 
     RowBox[{"see", " ", "Proposition", " ", "3"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"px", "[", 
      RowBox[{"ro_", ",", "x_", ",", "sigma_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{"F", "[", 
          RowBox[{
           RowBox[{"ro", "-", "z"}], ",", "sigma"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"z", ",", "0", ",", 
           RowBox[{
            RowBox[{"xL", "[", "ro", "]"}], "-", "1"}]}], "}"}]}], "]"}]}], 
      "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "ro"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"eta", "-", "x", "+", "ro"}], ")"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{
      "Probability", " ", "of", " ", "lying", " ", "given", " ", "drawn", " ",
        "number", " ", "y"}], "<", "xL"}], ",", " ", 
     RowBox[{"see", " ", "Proposition", " ", "3"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ProbLie", "[", 
      RowBox[{"ro_", ",", "y_", ",", "sigma_"}], "]"}], ":=", 
     RowBox[{"F", "[", 
      RowBox[{
       RowBox[{"ro", "-", "y"}], ",", "sigma"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\"\<Distribution of reports:\>\"", "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Generating", " ", "theoretical", " ", "distribution", " ", "of", " ", 
     "reports", " ", "conditional", " ", "on", " ", "drawing", " ", "number", 
     " ", "y"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"y", "=", "0"}], ",", 
     RowBox[{"y", "\[LessEqual]", 
      RowBox[{
       RowBox[{"xL", "[", "ro", "]"}], "-", "1"}]}], ",", 
     RowBox[{"y", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Print", "[", 
       RowBox[{"\"\<drawing y=\>\"", ",", 
        RowBox[{"y", "+", "1"}], ",", "\"\<:\>\""}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<x=\>\"", ",", 
        RowBox[{"y", "+", "1"}], ",", "\"\<: \>\"", ",", 
        RowBox[{"1", "-", 
         RowBox[{"ProbLie", "[", 
          RowBox[{"ro", ",", "y", ",", "sigma"}], "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"x", "=", 
         RowBox[{"xL", "[", "ro", "]"}]}], ",", 
        RowBox[{"x", "\[LessEqual]", "K"}], ",", 
        RowBox[{"x", "++"}], ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<x=\>\"", ",", 
          RowBox[{"x", "+", "1"}], ",", "\"\<: \>\"", ",", 
          RowBox[{
           RowBox[{"ProbLie", "[", 
            RowBox[{"ro", ",", "y", ",", "sigma"}], "]"}], "*", 
           RowBox[{"px", "[", 
            RowBox[{"ro", ",", "x", ",", "sigma"}], "]"}]}]}], "]"}]}], 
       "]"}]}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Note: Subjects drawing y>\>\"", ",", 
     RowBox[{"xL", "[", "ro", "]"}], ",", 
     "\"\< are predicted to report truthfully (see Proposition 2).\>\""}], 
    "]"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.6653218905473633`*^9, 3.665322139759886*^9}, {
   3.6653221923859386`*^9, 3.6653223420429335`*^9}, {3.6653224318717318`*^9, 
   3.665322439081876*^9}, {3.6653225492410793`*^9, 3.665322566823431*^9}, {
   3.6653228446309905`*^9, 3.665322856452227*^9}, {3.6653229045491896`*^9, 
   3.665322911129321*^9}, {3.665322972730554*^9, 3.665323003834178*^9}, 
   3.6653230545081916`*^9, {3.6653233051012077`*^9, 3.6653233171284504`*^9}, {
   3.6653233587722836`*^9, 3.665323471444538*^9}, {3.665323555598222*^9, 
   3.665323673180974*^9}, {3.6653237116957445`*^9, 3.665323711755746*^9}, {
   3.665323753108573*^9, 3.665323759058692*^9}, {3.665377462360238*^9, 
   3.6653774794465294`*^9}, {3.6653776312023864`*^9, 
   3.6653776397899446`*^9}, {3.6653776759243307`*^9, 
   3.6653777443114915`*^9}, {3.665378141798388*^9, 3.665378222400388*^9}, {
   3.6653783273953876`*^9, 3.665378354386388*^9}, {3.6653783933073883`*^9, 
   3.665378448451388*^9}, {3.665378480010388*^9, 3.665378484632388*^9}, {
   3.665380030084114*^9, 3.665380082731315*^9}, {3.6653801250756083`*^9, 
   3.6653801405319695`*^9}, {3.6653801810509644`*^9, 
   3.6653801835837107`*^9}, {3.665381106544634*^9, 3.6653811099599752`*^9}, {
   3.665381864911468*^9, 3.6653818815171285`*^9}, {3.6653831080268097`*^9, 
   3.66538315496481*^9}, {3.66538319977281*^9, 3.66538319995581*^9}, {
   3.6653834216101365`*^9, 3.6653834485828333`*^9}, {3.665383487388714*^9, 
   3.6653834879157662`*^9}, {3.7269152108855906`*^9, 3.7269152734052167`*^9}, 
   3.7269154338478255`*^9, {3.726915495230441*^9, 3.72691554193091*^9}, {
   3.7571418437996626`*^9, 3.7571418453930397`*^9}, {3.757143098524267*^9, 
   3.757143102400547*^9}, {3.757143143075894*^9, 3.7571431722505655`*^9}, {
   3.757162414169341*^9, 3.757162636298018*^9}, {3.7571627657332444`*^9, 
   3.757162801683863*^9}, {3.757162859924965*^9, 3.7571628751046324`*^9}, {
   3.7571629091905046`*^9, 3.7571630511895733`*^9}, {3.7571630894856987`*^9, 
   3.757163128092335*^9}, {3.7571729628756495`*^9, 3.757172975582226*^9}, {
   3.757173125741542*^9, 3.7571731890252004`*^9}, {3.7571732330956135`*^9, 
   3.7571732845597677`*^9}, {3.757173315518761*^9, 3.7571733414899263`*^9}, {
   3.7571733916560197`*^9, 3.7571734382667556`*^9}, {3.757173473505392*^9, 
   3.7571734736617594`*^9}, {3.757176257456459*^9, 3.7571763519806366`*^9}, {
   3.757176469796834*^9, 3.7571767286633067`*^9}, {3.7571767843903694`*^9, 
   3.757176792609517*^9}, {3.75717689194084*^9, 3.757176966243521*^9}, {
   3.7571772873305397`*^9, 3.7571773276123066`*^9}, {3.75717737211786*^9, 
   3.7571774126881323`*^9}, 3.757177450617428*^9, {3.757177495179057*^9, 
   3.7571775654239745`*^9}, {3.7571778004932604`*^9, 
   3.7571778112767396`*^9}, {3.7571778608146286`*^9, 3.7571779479774895`*^9}, 
   3.7571779826864576`*^9, {3.757180185774725*^9, 3.757180225464513*^9}, {
   3.7571802730797462`*^9, 3.7571803420585346`*^9}, {3.757180589550248*^9, 
   3.757180625012718*^9}, 3.7571807723890305`*^9, {3.7571808655769444`*^9, 
   3.757180918225562*^9}, {3.7571809508652897`*^9, 3.757180978577965*^9}, {
   3.757228295186898*^9, 3.757228295288265*^9}, {3.757229519868849*^9, 
   3.757229549967732*^9}, {3.7572296374036164`*^9, 3.7572296402026987`*^9}, {
   3.757229683896452*^9, 3.7572297498898673`*^9}, 3.757229799203117*^9, {
   3.75723006807353*^9, 3.757230094787221*^9}, {3.757233286292882*^9, 
   3.757233302765727*^9}, {3.757233416124798*^9, 3.757233473579174*^9}, {
   3.7572350689955006`*^9, 3.7572350913570952`*^9}, {3.757235126844516*^9, 
   3.757235129140854*^9}, {3.757235555498211*^9, 3.7572355555604997`*^9}, {
   3.7572359254057026`*^9, 3.757235937235803*^9}, {3.757237444603722*^9, 
   3.757237539273734*^9}, {3.757237604906041*^9, 3.757237621282263*^9}, {
   3.7572376521103373`*^9, 3.7572377400005426`*^9}, {3.757237777472391*^9, 
   3.757237816110652*^9}, {3.7572378535533886`*^9, 3.7572379226909256`*^9}, {
   3.757238286606121*^9, 3.7572383394230604`*^9}, {3.757238428215785*^9, 
   3.757238455843656*^9}, {3.7572385263077145`*^9, 3.757238563593519*^9}, {
   3.7572387147159944`*^9, 3.757238838984724*^9}, {3.7572389842351575`*^9, 
   3.757239175188613*^9}, {3.757239205574356*^9, 3.7572392684989777`*^9}, {
   3.7572393071309147`*^9, 3.7572394557332325`*^9}, {3.7574283775920796`*^9, 
   3.7574286143018837`*^9}, {3.757428675445779*^9, 3.757428733734454*^9}, {
   3.7574288428567543`*^9, 3.7574288581458664`*^9}, {3.75752398731228*^9, 
   3.75752398839423*^9}, {3.75752409847003*^9, 3.75752419557736*^9}, {
   3.757524253139902*^9, 3.7575242920528817`*^9}, {3.7577016925826235`*^9, 
   3.757701711766161*^9}, {3.7577017888096576`*^9, 3.7577017905600348`*^9}, {
   3.757702985037695*^9, 3.7577030045823345`*^9}, {3.7577030357763634`*^9, 
   3.7577030704968977`*^9}, {3.757740791814878*^9, 3.757740870125293*^9}, {
   3.7577409020440006`*^9, 3.757740916034284*^9}, {3.757741006310275*^9, 
   3.7577410851436815`*^9}, {3.7577411416609106`*^9, 
   3.7577411747791348`*^9}, {3.757741757511042*^9, 3.7577419236929483`*^9}, 
   3.757832762051053*^9, 3.7578330498822117`*^9, {3.75783309789077*^9, 
   3.7578331151013145`*^9}, {3.75783314999776*^9, 3.7578332030222673`*^9}, {
   3.7578353286544247`*^9, 3.757835390777291*^9}, {3.757835488827961*^9, 
   3.757835504636895*^9}, {3.757835697412402*^9, 3.7578357104750404`*^9}, {
   3.757855267422022*^9, 3.757855272385112*^9}, {3.7578553189885397`*^9, 
   3.7578553225166607`*^9}, {3.757855486325045*^9, 3.7578554886128993`*^9}, {
   3.757912924864708*^9, 3.7579129254580836`*^9}, {3.757912970012695*^9, 
   3.757913019565544*^9}},ExpressionUUID->"18f25248-8c3e-4953-97da-\
c88f3b7da330"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Distribution of reports:\"\>"], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.7579130208642015`*^9}},ExpressionUUID->"773fca6f-493f-42bc-aaea-\
a789378019a9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"drawing y=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\":\"\>"}],
  SequenceForm["drawing y=", 1, ":"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.7579130208642015`*^9}},ExpressionUUID->"efe74536-bf24-4359-a9b3-\
de7ad61795c1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.4690630099157491`"}],
  SequenceForm["x=", 1, ": ", 0.4690630099157491],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.7579130208642015`*^9}},ExpressionUUID->"ecacec46-153b-459c-90d7-\
c1424f0321f0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.07886319237852246`"}],
  SequenceForm["x=", 9, ": ", 0.07886319237852246],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.7579130208642015`*^9}},ExpressionUUID->"aaa44552-6b8b-43fc-8814-\
67b2a21bcdc9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.452072969171593`"}],
  SequenceForm["x=", 10, ": ", 0.452072969171593],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.7579130208642015`*^9}},ExpressionUUID->"041c36b3-b059-42cc-bc21-\
d8f84b050b78"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"drawing y=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\":\"\>"}],
  SequenceForm["drawing y=", 2, ":"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.7579130208642015`*^9}},ExpressionUUID->"685d72a3-f576-4e59-87f2-\
89c5657986b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.5314470118561367`"}],
  SequenceForm["x=", 2, ": ", 0.5314470118561367],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.7579130208642015`*^9}},ExpressionUUID->"d35644aa-7a09-4ee2-9ca1-\
c7ee75e2adec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.06959692983089656`"}],
  SequenceForm["x=", 9, ": ", 0.06959692983089656],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.7579130208642015`*^9}},ExpressionUUID->"ca424f68-6712-46ec-a6d4-\
dfbb5b681837"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.3989553271298843`"}],
  SequenceForm["x=", 10, ": ", 0.3989553271298843],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.7579130208642015`*^9}},ExpressionUUID->"4ba07213-94f2-4314-b588-\
b3195e0fb72d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"drawing y=\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\":\"\>"}],
  SequenceForm["drawing y=", 3, ":"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.7579130208642015`*^9}},ExpressionUUID->"6659fba7-5379-45f5-8995-\
51cf8f7dcb03"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.5977819371433146`"}],
  SequenceForm["x=", 3, ": ", 0.5977819371433146],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.75791302087984*^9}},ExpressionUUID->"aa6911c2-1815-4095-bd96-\
fe4d987d335e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.05974381341211497`"}],
  SequenceForm["x=", 9, ": ", 0.05974381341211497],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.75791302087984*^9}},ExpressionUUID->"4642739b-495f-4f91-8c15-\
70dc1c55e70c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.3424736217780089`"}],
  SequenceForm["x=", 10, ": ", 0.3424736217780089],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.75791302087984*^9}},ExpressionUUID->"993957b3-53c8-4c55-ac41-\
7b88e207e0d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"drawing y=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\":\"\>"}],
  SequenceForm["drawing y=", 4, ":"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.75791302087984*^9}},ExpressionUUID->"4a06b3d2-73d1-4207-9c0b-\
b61fd8e2c059"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.667641541705055`"}],
  SequenceForm["x=", 4, ": ", 0.667641541705055],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.75791302087984*^9}},ExpressionUUID->"142a47b5-4cda-4a00-b3c9-\
cd2ae8730592"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.04936715566000431`"}],
  SequenceForm["x=", 9, ": ", 0.04936715566000431],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.75791302087984*^9}},ExpressionUUID->"b70ab513-8782-49e0-9143-\
a156ee7bda07"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.28299078398520816`"}],
  SequenceForm["x=", 10, ": ", 0.28299078398520816`],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.75791302087984*^9}},ExpressionUUID->"50f5ffd6-7b26-4f8d-bed0-\
ebea7122572f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"drawing y=\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\":\"\>"}],
  SequenceForm["drawing y=", 5, ":"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.75791302087984*^9}},ExpressionUUID->"413f3ea7-251e-4536-9ce3-\
87b7534f1c69"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.7405075313131277`"}],
  SequenceForm["x=", 5, ": ", 0.7405075313131277],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.75791302087984*^9}},ExpressionUUID->"2275afc7-fe2b-498f-b626-\
be075000a5a3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.03854394186320143`"}],
  SequenceForm["x=", 9, ": ", 0.03854394186320143],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.7579130208954945`*^9}},ExpressionUUID->"6ca7797b-8742-4ea1-b1ed-\
571dbb4231c7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.2209481218822706`"}],
  SequenceForm["x=", 10, ": ", 0.2209481218822706],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.7579130208954945`*^9}},ExpressionUUID->"a3b75cc1-53f0-4914-bc2e-\
cc3256c26ab1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"drawing y=\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\":\"\>"}],
  SequenceForm["drawing y=", 6, ":"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.7579130208954945`*^9}},ExpressionUUID->"6c4f20ff-02b7-4371-a2b5-\
581e975a27e6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.8157804018212018`"}],
  SequenceForm["x=", 6, ": ", 0.8157804018212018],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.7579130208954945`*^9}},ExpressionUUID->"a218d624-4824-4856-960e-\
c0bb54f6ac87"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.027363219896890768`"}],
  SequenceForm["x=", 9, ": ", 0.027363219896890768`],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.7579130208954945`*^9}},ExpressionUUID->"27f0b314-53eb-44df-a274-\
a0ed3ec4f823"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.15685609080480875`"}],
  SequenceForm["x=", 10, ": ", 0.15685609080480875`],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.7579130208954945`*^9}},ExpressionUUID->"ea4d716b-989d-468a-8b14-\
325af8bc8873"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"drawing y=\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\":\"\>"}],
  SequenceForm["drawing y=", 7, ":"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.7579130208954945`*^9}},ExpressionUUID->"869393f7-8fa3-4661-9b0f-\
9e7d0061935e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.8927939184223558`"}],
  SequenceForm["x=", 7, ": ", 0.8927939184223558],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.7579130209110975`*^9}},ExpressionUUID->"db0a4332-4791-41a7-9692-\
290af59b4cb6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.015923949533566538`"}],
  SequenceForm["x=", 9, ": ", 0.015923949533566538`],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.7579130209110975`*^9}},ExpressionUUID->"80b2e226-079c-49a6-8e26-\
d100f108bd00"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.09128196474758153`"}],
  SequenceForm["x=", 10, ": ", 0.09128196474758153],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.7579130209110975`*^9}},ExpressionUUID->"da5ceef3-056e-4132-a492-\
b842ea0d1a8c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"drawing y=\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\":\"\>"}],
  SequenceForm["drawing y=", 8, ":"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.7579130209110975`*^9}},ExpressionUUID->"472b743c-f8ec-4aff-86a3-\
93fdba9d1c72"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.9708326671748736`"}],
  SequenceForm["x=", 8, ": ", 0.9708326671748736],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.7579130209110975`*^9}},ExpressionUUID->"d089edad-b6f0-4442-862a-\
e373a6ca482b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.004332395411725471`"}],
  SequenceForm["x=", 9, ": ", 0.004332395411725471],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.7579130209110975`*^9}},ExpressionUUID->"bdc978bd-22be-4c3c-a8a7-\
0b818ca549d0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.02483489189739562`"}],
  SequenceForm["x=", 10, ": ", 0.02483489189739562],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.7579130209110975`*^9}},ExpressionUUID->"ea9b8110-0176-4055-8447-\
23fcf449c7bc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Note: Subjects drawing y>\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" are predicted to report truthfully (see \
Proposition 2).\"\>"}],
  SequenceForm[
  "Note: Subjects drawing y>", 8, 
   " are predicted to report truthfully (see Proposition 2)."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7578331895992603`*^9, 3.7578332042719727`*^9}, 
   3.7578357341700716`*^9, 3.757855323765856*^9, 3.757855495788023*^9, {
   3.7579129719026737`*^9, 
   3.7579130209110975`*^9}},ExpressionUUID->"51258aa0-acbb-480e-a3d6-\
83b73cdb8447"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1898, 953},
WindowMargins->{{Automatic, -249}, {-151, Automatic}},
Magnification->2.,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 11136, 224, 1622, "Input",ExpressionUUID->"18f25248-8c3e-4953-97da-c88f3b7da330"],
Cell[CellGroupData[{
Cell[11741, 250, 315, 5, 44, "Print",ExpressionUUID->"773fca6f-493f-42bc-aaea-a789378019a9"],
Cell[12059, 257, 456, 10, 44, "Print",ExpressionUUID->"efe74536-bf24-4359-a9b3-de7ad61795c1"],
Cell[12518, 269, 510, 11, 44, "Print",ExpressionUUID->"ecacec46-153b-459c-90d7-c1424f0321f0"],
Cell[13031, 282, 512, 11, 44, "Print",ExpressionUUID->"aaa44552-6b8b-43fc-8814-67b2a21bcdc9"],
Cell[13546, 295, 510, 11, 44, "Print",ExpressionUUID->"041c36b3-b059-42cc-bc21-d8f84b050b78"],
Cell[14059, 308, 456, 10, 44, "Print",ExpressionUUID->"685d72a3-f576-4e59-87f2-89c5657986b7"],
Cell[14518, 320, 510, 11, 44, "Print",ExpressionUUID->"d35644aa-7a09-4ee2-9ca1-c7ee75e2adec"],
Cell[15031, 333, 512, 11, 44, "Print",ExpressionUUID->"ca424f68-6712-46ec-a6d4-dfbb5b681837"],
Cell[15546, 346, 512, 11, 44, "Print",ExpressionUUID->"4ba07213-94f2-4314-b588-b3195e0fb72d"],
Cell[16061, 359, 456, 10, 44, "Print",ExpressionUUID->"6659fba7-5379-45f5-8995-51cf8f7dcb03"],
Cell[16520, 371, 507, 11, 44, "Print",ExpressionUUID->"aa6911c2-1815-4095-bd96-fe4d987d335e"],
Cell[17030, 384, 509, 11, 44, "Print",ExpressionUUID->"4642739b-495f-4f91-8c15-70dc1c55e70c"],
Cell[17542, 397, 509, 11, 44, "Print",ExpressionUUID->"993957b3-53c8-4c55-ac41-7b88e207e0d9"],
Cell[18054, 410, 453, 10, 44, "Print",ExpressionUUID->"4a06b3d2-73d1-4207-9c0b-b61fd8e2c059"],
Cell[18510, 422, 505, 11, 44, "Print",ExpressionUUID->"142a47b5-4cda-4a00-b3c9-cd2ae8730592"],
Cell[19018, 435, 509, 11, 44, "Print",ExpressionUUID->"b70ab513-8782-49e0-9143-a156ee7bda07"],
Cell[19530, 448, 512, 11, 44, "Print",ExpressionUUID->"50f5ffd6-7b26-4f8d-bed0-ebea7122572f"],
Cell[20045, 461, 453, 10, 44, "Print",ExpressionUUID->"413f3ea7-251e-4536-9ce3-87b7534f1c69"],
Cell[20501, 473, 507, 11, 44, "Print",ExpressionUUID->"2275afc7-fe2b-498f-b626-be075000a5a3"],
Cell[21011, 486, 512, 11, 44, "Print",ExpressionUUID->"6ca7797b-8742-4ea1-b1ed-571dbb4231c7"],
Cell[21526, 499, 512, 11, 44, "Print",ExpressionUUID->"a3b75cc1-53f0-4914-bc2e-cc3256c26ab1"],
Cell[22041, 512, 456, 10, 44, "Print",ExpressionUUID->"6c4f20ff-02b7-4371-a2b5-581e975a27e6"],
Cell[22500, 524, 510, 11, 44, "Print",ExpressionUUID->"a218d624-4824-4856-960e-c0bb54f6ac87"],
Cell[23013, 537, 515, 11, 44, "Print",ExpressionUUID->"27f0b314-53eb-44df-a274-a0ed3ec4f823"],
Cell[23531, 550, 515, 11, 44, "Print",ExpressionUUID->"ea4d716b-989d-468a-8b14-325af8bc8873"],
Cell[24049, 563, 456, 10, 44, "Print",ExpressionUUID->"869393f7-8fa3-4661-9b0f-9e7d0061935e"],
Cell[24508, 575, 510, 11, 44, "Print",ExpressionUUID->"db0a4332-4791-41a7-9692-290af59b4cb6"],
Cell[25021, 588, 515, 11, 44, "Print",ExpressionUUID->"80b2e226-079c-49a6-8e26-d100f108bd00"],
Cell[25539, 601, 514, 11, 44, "Print",ExpressionUUID->"da5ceef3-056e-4132-a492-b842ea0d1a8c"],
Cell[26056, 614, 456, 10, 44, "Print",ExpressionUUID->"472b743c-f8ec-4aff-86a3-93fdba9d1c72"],
Cell[26515, 626, 510, 11, 44, "Print",ExpressionUUID->"d089edad-b6f0-4442-862a-e373a6ca482b"],
Cell[27028, 639, 514, 11, 44, "Print",ExpressionUUID->"bdc978bd-22be-4c3c-a8a7-0b818ca549d0"],
Cell[27545, 652, 514, 11, 44, "Print",ExpressionUUID->"ea9b8110-0176-4055-8447-23fcf449c7bc"],
Cell[28062, 665, 605, 13, 44, "Print",ExpressionUUID->"51258aa0-acbb-480e-a3d6-83b73cdb8447"]
}, Open  ]]
}, Open  ]]
}
]
*)

